#include "p100plib.h"
#include "ressdk.h"
#include "math.h"
#include "packet.h"

#include "Help.h"
#include "Numbers.h"

int VNumbers[20]={2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,25,50,100};

double Numbers[6];
double Target;

char Solution [5][16];
	
void mix ()
/* generate new set of available numbers */
{	int Mark[20];
	int i,j,h;
	for (i=0; i<20; i++)
		Mark[i]=(i<6);
	for (i=19; i>0; i--)
	{	j=random(i+1);
		if (i!=j)
		{	h=Mark[i];
			Mark[i]=Mark[j]; Mark[j]=h;
		}
	}
	for (i=0, j=0; i<20; i++)
		if (Mark[i]) Numbers[j++]=VNumbers[i];
}
	
void makeTarget ()
/* generate a new Target */
{	Target=100+random(900);
}

char * formatint (char *p, int n)
{	char s[16];
	int i,r;
	i=0;
	while (n>0)
	{	r=n%10;
		s[i++]='0'+r;
		n=(n-r)/10;
	}
	while (i>0)
	{	i--;
		*p++=s[i];
	}
	*p=0;
	return p;
}

void writesolution (int i, int h1, int h2, char c, int h)
{	char *p;
	p=Solution[i];
	p=formatint(p,h1);
	*p++=c;
	p=formatint(p,h2);
	*p++='=';
	p=formatint(p,h);
	*p=0;
}

int count;
int counter;
int aborted;

int solverek (int *z, int start, int k, int Target)
/*
Try to form the Target with numbers at z[start] to z[start+k].
Return, if a solution has been found.
Write out the solution in readable form into the
Solutions String array.
*/
{	int i,j,h,h1,h2;
	long hm;
	if (k==1)
	{	if (z[start]==Target) return 1;
		else
		{	count++;
			if (count>=1000)
			{	count=0;
				if (notify(counter++))
				{	aborted=1;
					return 2;
				}
			}
		}
	}
	h=z[start];
	while (1)
	{
		for (i=0; i<k-1; i++)
		{	h1=z[start+i];
			z[start+i]=h;
			if (h1==Target) return 1;
			for (j=i+1; j<k; j++)
			{	h2=z[start+j];
				z[start+j]=h1+h2;
				if (z[start+j]==Target || solverek(z,start+1,k-1,Target))
				{	writesolution(6-k,h1,h2,'+',h1+h2);
					goto found;
				}
				if (h2>h1)
				{	z[start+j]=h2-h1;
					if (z[start+j]==Target || solverek(z,start+1,k-1,Target))
					{	writesolution(6-k,h2,h1,'-',h2-h1);
						goto found;
					}
					if (h2%h1==0)
					{	z[start+j]=h2/h1;
						if (z[start+j]==Target || solverek(z,start+1,k-1,Target))
						{	writesolution(6-k,h2,h1,'/',h2/h1);
							goto found;
						}
					}
				}
				else if (h2>h1)
				{	z[start+j]=h1-h2;
					if (z[start+j]==Target || solverek(z,start+1,k-1,Target))
					{	writesolution(6-k,h1,h2,'-',h1-h2);
						goto found;
					}
					if (h1%h2==0)
					{	z[start+j]=h1/h2;
						if (z[start+j]==Target || solverek(z,start+1,k-1,Target))
						{	writesolution(6-k,h1,h2,'/',h1/h2);
							goto found;
						}
					}
				}
				else if (h2==h1)
				{	z[start+j]=1;
					if (z[start+j]==Target || solverek(z,start+1,k-1,Target))
					{	writesolution(6-k,h1,h2,'/',1);
						goto found;
					}
				}
				hm=(long)h1*h2;
				if (hm<30000l)
				{	z[start+j]=(int)hm;
					if (z[start+j]==Target || solverek(z,start+1,k-1,Target))
					{	writesolution(6-k,h1,h2,'*',h1*h2);
						goto found;
					}
				}
				z[start+j]=h2;
			}
			z[start+i]=h1;
		}
		return 0;
	}
	found: z[start+i]=h1; z[start+j]=h2;
	return 1;
}

void clear (void)
{	int i;
	for (i=0; i<5; i++) Solution[i][0]=0;
}

int solve (void)
{	int i;
	int z[6];
	clear();
	count=0; counter=0; aborted=0;
	for (i=0; i<6; i++) z[i]=(int)Numbers[i];
	if (!solverek(z,0,6,(int)Target))
	{	strcpy(Solution[0],"No solution!");
		return 0;
	}
	else if (aborted)
	{	clear(); strcpy(Solution[0],"Aborted!");
		return 0;
	}
	return 1;
}

