/* you have to include all those header files
*/

#include "p100plib.h"
#include "ressdk.h"
#include "math.h"
#include "packet.h"

#include "Help.h"
#include "Numbers.h"

int id=100;
int line1,line2;

/* you have to decleare a static string for the window
  title 
*/

unsigned char test_title[] = "Les Chiffres";

/* define the main menu structure
*/

const MENUITEM MainMenu[] =
{   {"Exit", cmCancel, 0},
    {"\0", 0, 0}
};

/* the command constants for the actions */

#define cmdNewProblem 1000
#define cmdNewTarget 1001
#define cmdSolve 1002
#define cmdPlus 1003
#define cmdMinus 1004
#define cmdDiv 1005
#define cmdMult 1006
#define cmdRetry 1007

PNUMBERFIELD * INumbers[6];
PNUMBERFIELD * ITarget;
PBUTTON * NewProblem;
PBUTTON * NewTarget;
PBUTTON * Solve;
PBUTTON * Retry;
PBUTTON * Plus;
PBUTTON * Minus;
PBUTTON * Div;
PBUTTON * Mult;
PLISTER * List;
PLABEL * Output[5];
PLABEL * New;

/* decleare the event handlers banked */

extern BANKED void test_draw (VOID_PTR view);
extern BANKED void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y);


/* this is the definition of the drawing routine,
which is inserted for the main window with the
help of the BankedAssign() function.
*/

void test_draw (VOID_PTR view)
{   /* the pointer is really a point to a DESKBOX */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    PDESKBOX_draw(view);  /* default, clears the view */

    DrawLine(0,line1,160,line1,DRAW_BLACK);
    DrawLine(0,line2,160,line2,DRAW_BLACK);
    DrawLine(80,line1,80,line2,DRAW_BLACK);
}

/* Some redraw and check functions */

int checknumbers ()
/* check numbers for validness */
{	int i,r;
	r=0;
	for (i=0; i<6; i++)
	{	if (Numbers[i]<0) { Numbers[i]=1; r=1; }
		else if (Numbers[i]>1000) { Numbers[i]=1000; r=1; }
	}
	return r;
}

void solution_draw ()
/* redraw the solution strings */
{	int i;
	for (i=0; i<5; i++)
	{	PVIEW *p;
		p=(PVIEW *)Output[i];
		FillRect(p->left,p->top,
			p->right,p->bottom,
			DRAW_WHITE);
		PLABEL_draw((VOID_PTR)Output[i]);
	}
}

void clearSolution ()
/* clear the solution area and redraw it */
{	clear();
	solution_draw();
}

void available_draw ()
/* redraw the available nubmers */
{	PLISTER_draw((VOID_PTR)List);
}

void numbers_draw ()
/* redraw the numbers */
{	int i;
	for (i=0; i<6; i++)
		PNUMBERFIELD_draw((VOID_PTR)INumbers[i]);
}

void target_draw ()
/* redraw the target number */
{	PNUMBERFIELD_draw((VOID_PTR)ITarget);
}

void clearNotify ()
/* clear the wandering dot area */
{	FillRect(2,line1+10,3,line1+60,DRAW_WHITE);
}

int notify (int n)
/* called every 1000 steps by the problem solver
n is the number of steps in thousands */
{	/* draw a wandering dot */
	clearNotify();
	FillRect(2,line1+10+(n%50),3,line1+11+(n%50),
		DRAW_BLACK);
	return 0;
}

/* List output of available numbers */

extern BANKED void list_writeItem (VOID_PTR view,
	unsigned char x, unsigned char y, unsigned short item);
extern BANKED void list_pen (VOID_PTR view,
	unsigned char x, unsigned char y);

int Available[6],Marked[6];
int NAvailable;

void setAvailable ()
{	int i;
	for (i=0; i<6; i++)
	{	Available[i]=Numbers[i];
		Marked[i]=0;
	}
	NAvailable=6;
}

int nmarked ()
{	int i,n=0;
	for (i=0; i<NAvailable; i++)
		if (Marked[i]) n++;
	return n;
}

void list_writeItem (VOID_PTR view, 
	unsigned char x, unsigned char y, unsigned short item)
{	char s[16];
	PLISTER *p; p=(PLISTER *)view;
	if (item>=NAvailable) return;
	NumericToStr((double)Available[item],s,DTINTEGER);
	SetFontType(PRPFONT11N);
	WriteString(x,y,s,Marked[item]);
}

void unmarkall ()
{	int i;
	for (i=0; i<NAvailable; i++) Marked[i]=0;
}

void list_pen (VOID_PTR view, unsigned char x, unsigned char y)
{	PLISTER *p; p=(PLISTER *)view;
	int i;
	x=0;
	i=(y-p->top)/((p->bottom-p->top)/6);
	if (i>=0 && i<NAvailable)
	{	if (nmarked()>=2)
		{	if (!Marked[i]) unmarkall();
		}
		Marked[i]=!Marked[i];
	}
	PLISTER_draw(view);
}

void availableremove (int j)
{	int i;
	if (j>=NAvailable) return;
	for (i=j; i<NAvailable-1; i++)
	{	Available[i]=Available[i+1];
		Marked[i]=Marked[i+1];
	}
	NAvailable--;
}

void availableappend (int h)
{	if (NAvailable>=6) return;
	Available[NAvailable]=h;
	Marked[NAvailable]=0;
	NAvailable++;
}

void available (int command)
{	if (nmarked()!=2) return;
	int h1,h2,i1,i2,f,i,h;
	long L;
	f=0;
	for (i=0; i<NAvailable; i++)
	{	if (Marked[i])
		{	if (f) i2=i;
			else i1=i;
			f++;
		}
	}
	h1=Available[i1]; h2=Available[i2];
	if (NAvailable==6) clear();
	switch (command)
	{	case cmdPlus :
			h=h1+h2;
			writesolution(6-NAvailable,h1,h2,'+',h);
			break;
		case cmdMinus :
			if (h1<h2)
			{	h=h2-h1;
				writesolution(6-NAvailable,h2,h1,'-',h);
			}
			else if (h1>h2)
			{	h=h1-h2;
				writesolution(6-NAvailable,h1,h2,'-',h);
  			}
			break;
		case cmdMult :
			L=h1*h2;
			if (L>30000l) return;
			h=h1*h2;
			writesolution(6-NAvailable,h1,h2,'*',h);
			break;
		case cmdDiv :
			if (h1>h2)
			{	if (h1%h2!=0) return;
				h=h1/h2;
				writesolution(6-NAvailable,h1,h2,'/',h);
			}
			else if (h1<h2)
			{	if (h2%h1!=0) return;
				h=h2/h1;
				writesolution(6-NAvailable,h2,h1,'/',h);
			}
			else if (h1==h2)
			{	h=1;
				writesolution(6-NAvailable,h2,h1,'/',h);
			}
			else return;
	}
	availableremove(i2);
	availableremove(i1);
	availableappend(h);
}

/* the event handler for the menu commands and for
 the main window
*/

void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y)
{   /* convert view to deskbox */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    /* call default handler (don't know why) */
    PDESKBOX_handleEvent(view,evType,x,y);

    /* switch events */
	if (*evType==evCommand)
    {   switch (TOWORD(x,y))
        {   case cmdNewProblem :
	      		ClearEvent(evType);
        		mix(); numbers_draw();
		        makeTarget(); target_draw();
		        clear(); solution_draw();
				setAvailable(); available_draw();
        		break;
            case cmdNewTarget :
        		ClearEvent(evType);
        		makeTarget(); target_draw();
		        clear(); solution_draw();
				setAvailable(); available_draw();
        		break;
        	case cmdSolve :
        		ClearEvent(evType);
        		if (checknumbers()) numbers_draw();
        		clear(); solution_draw();
		        setAvailable(); available_draw();
        		strcpy(Solution[0],"Please Wait!");
        		clearNotify();
        		solution_draw();
        		SetAutoPowerOff(FALSE,0);
        		solve();
        		SetAutoPowerOff(TRUE,0);
        		solution_draw();
        		clearNotify();
        		break;
        	case cmdPlus :
        		ClearEvent(evType);
        		available(cmdPlus);
        		solution_draw(view);
        		available_draw();
        		break;
        	case cmdMinus :
        		ClearEvent(evType);
        		available(cmdMinus);
        		solution_draw(view);
        		available_draw();
        		break;
        	case cmdMult :
        		ClearEvent(evType);
        		available(cmdMult);
        		solution_draw(view);
        		available_draw();
        		break;
        	case cmdDiv :
        		ClearEvent(evType);
        		available(cmdDiv);
        		solution_draw(view);
        		available_draw();
        		break;
        	case cmdRetry :
        		ClearEvent(evType);
        		if (checknumbers()) numbers_draw();
        		setAvailable(); available_draw();
        		clear(); solution_draw();
        		break;
        }
    }
}

/* main program */

short main (void)
{
    int i;

    PDESKBOX *dsk;
	
    /* init our Problem */
    mix();
    makeTarget();
    clear();
    setAvailable();

    /* create a window covering all of the screen
       with a menu, a title and a close box */
    dsk = (PDESKBOX *)CreateDeskBox(id++,0,0,159,239,
        MK_FAR_PTR(test_title),MK_FAR_PTR(MainMenu),0,
        bafClose|bafDotTitle);
    dsk->options &= ~ofFindable; /* no find in this application */

    /* assign the event handlers to this window */
    BankedAssign(dsk->handleEvent,test_handle_event);
    BankedAssign(dsk->draw,test_draw);

    int row=30;

	/* Generate six number labels at the top */

	for (i=0; i<6; i++)
	{ 	INumbers[i]=(PNUMBERFIELD *)CreateNumberField(
			id++, 5+25*i, row,
			(unsigned char *)(Numbers+i),
			DTINTEGER, MK_FAR_PTR("Input Number"));
		INumbers[i]->right=25+25*i;
		LoadBank(&(dsk->insert));
		dsk->insert((VOID_PTR)dsk,INumbers[i]);
	}

	/* Generate a target label centered below */

	row+=20;

	ITarget=(PNUMBERFIELD *)CreateNumberField(
		id++, 65, row,
		(unsigned char *)(&Target),
		DTINTEGER, MK_FAR_PTR("Input Target"));
	ITarget->right=95;
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,ITarget);

	/* Generate a label field in for the output */

	row+=25;
	line1=row-5;

  	for (i=0; i<5; i++)
  	{	Output[i]=(PLABEL *)CreateLabel(
  			id++, 10, row+15*i, 79, row+15*i+15,
  			MK_FAR_PTR(Solution[i]),
  			lbofAlignLeft,PRPFONT11N);
 		LoadBank(&(dsk->insert));
 		dsk->insert((VOID_PTR)dsk,Output[i]);
  	}

    List=(PLISTER *)CreateLister(
    	id++,95,row,120,row+5*15,6);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,List);
	BankedAssign(List->writeItem,list_writeItem);
	BankedAssign(List->penDownAct,list_pen);

	int brow=row;

	Plus=(PBUTTON *)CreateButton(
		id++, 130, brow, 155, MK_FAR_PTR("+"),
		cmdPlus, bttBasic);
	brow+=18;
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Plus);

	Minus=(PBUTTON *)CreateButton(
		id++, 130, brow, 155, MK_FAR_PTR("-"),
		cmdMinus, bttBasic);
	brow+=18;
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Minus);

	Mult=(PBUTTON *)CreateButton(
		id++, 130, brow, 155, MK_FAR_PTR("*"),
		cmdMult, bttBasic);
	brow+=18;
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Mult);

	Div=(PBUTTON *)CreateButton(
		id++, 130, brow, 155, MK_FAR_PTR("/"),
		cmdDiv, bttBasic);
	brow+=18;
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Div);

	row+=5*15;
	
	/* Generate buttons to solve and retry the problem */
	
	row+=15;

	Solve=(PBUTTON *)CreateButton(
		id++, 10, row, 75, MK_FAR_PTR("Solve"),
		cmdSolve, bttBasic);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Solve);

	Retry=(PBUTTON *)CreateButton(
		id++, 85, row, 150, MK_FAR_PTR("Retry"),
		cmdRetry, bttBasic);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Retry);

	/* Generate some buttons at the bottom */

	row+=30;
	line2=row-5;

	New=(PLABEL *)CreateLabel(
		id++, 10, row, 150, row+15, MK_FAR_PTR("New"),
		lbofAlignCenter,PRPFONT11N);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,New);

	row+=15;

	NewProblem=(PBUTTON *)CreateButton(
		id++, 10, row, 75, MK_FAR_PTR("Problem"),
		cmdNewProblem, bttBasic);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,NewProblem);

	NewTarget=(PBUTTON *)CreateButton(
		id++, 85, row, 150, MK_FAR_PTR("Target"),
		cmdNewTarget, bttBasic);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,NewTarget);

    /* seems to generate the main event loop */
    ExecView ((PGROUP *) dsk);

    /* destroy the window */
    Destroy ((VOID_PTR) dsk);
    
    return 0;
}

