/* Avigo Preference Code
 * For use with the Freeware SDK 0.91b
 * Version 0.91
 * Bill Baxter, Thomas Chapman
 *
 * Thanks:  Gerard Vermeulen, Hans Pufal, Thomas Chapman, 
 *          Randy Gill, David Ford.
 *
 * Bugs:  
 *    None Known
 */

#include "avpref.h"


/************************************************************
 * GetCurrentAppID
 *
 *  Returns the ID used to access the running app's pref record
 ************************************************************/
UCHAR GetCurrentAppID()
{
    int retval;

    _asm
    {
        call    0x000F
        ld      bc, #9
        call    0x3003
        ld      _retval+0(ix),a
        ld      _retval+1(ix),#0
    }

    return retval;
}

/************************************************************
 * ReadPref
 *
 *	Return Codes
 *	SUCCESS = Success
 *	FAILURE = Fail
 *
 * Will return fail if a write hasn't happened, in the past, for an appID
 ************************************************************/
int ReadPref(UCHAR appID, int offset, char *address, int length)
{
    int retval;

    _asm 
    {

        ld      e,_length+0(ix)
        ld      d,_length+1(ix)
        push    de             

        ld      e,_address+0(ix)
        ld      d,_address+1(ix) 
        push    de

        ld      e,_offset+0(ix)
        ld      d,_offset+1(ix) 

        ld      l,_appID+0(ix)     
        ld      h,_appID+1(ix)
				
        ld      bc, #0
        call    0x3003
        ld      _retval+0(ix),l
        ld      _retval+1(ix),h
        pop     bc
        pop     bc
    }

    return retval;
}


/************************************************************
 * WritePref
 *
 *	Return Codes
 *	 SUCCESS = Success
 *	 FAILURE = Fail
 *
 ************************************************************/
int WritePref(UCHAR appID, char *address, int length)
{
    int retval;

    _asm {
        ld      e,_length+0(ix) 
        ld      d,_length+1(ix) 
        push    de              

        ld      e,_address+0(ix) 
        ld      d,_address+1(ix) 

        ld      l,_appID+0(ix)       
        ld      h,_appID+1(ix)       
                                 
        ld      bc, #3
        call    0x3003
        ld      _retval+0(ix),l
        ld      _retval+1(ix),h
        pop     bc
    }

    return retval;
}



/************************************************************
 * DeletePref
 *
 *	Return Codes
 *	 SUCCESS = Success
 *	 FAILURE = Fail
 *
 ************************************************************/
int DeletePref(UCHAR appID)
{
    int retval;

    _asm {
        ld      l,_appID+0(ix)
        ld      h,_appID+1(ix)

        ld      bc, #6
        call    0x3003
        ld      _retval+0(ix),l
        ld      _retval+1(ix),h
    }

    return retval;
}

/************************************************************
 * GetPrefLength
 *
 ************************************************************/
UINT GetPrefLength(UCHAR appID)
{
    UINT retval;

    /* GetPrefLength is function 0x0390.
     * In decimal that's 
     */


    _asm {
        ld      l,_appID+0(ix)
        ld      h,_appID+1(ix)
                                 
        ld      bc, #0x0390
        call    0x3003
        ld      _retval+0(ix),l
        ld      _retval+1(ix),h
    }

    return retval;
}

