/**********************************************************************
* Project:	Drobos for Avigo
* Module:		Main
* File:		drobos.c
*
*	DRoboWHOids for Avigo Copyright (c) 1998 by Jouni Miettunen
*	DRoboWHOids for DOS Copyright (c) 1994 by Jouni Miettunen
*	which was based on unix robots by Allan Black (around 1984)
***********************************************************************
*
* Description:
*	DRoboWHOids (drobos) for Avigo. Avigo porting based on Sokoban
*	sample program from Freeware Avigo SDK made by G. Vermeulen
*
*	avapp -p1 -rdrobos.app
*	avapp -p1 -dDrobos
*	
* History:
*
* Version: Drobos 0.1         13 October 1998        Jouni Miettunen
*	JOM 280998 Started Drobos for Avigo based on Sokoban sample
*	JOM 111098 Basic functionality ok
*	JOM 131098 Cosmetics
*
* Version: Drobos 0.2         27 October 1998        Jouni Miettunen
*	JOM 271098 Some code cleanup with better GUI
*	JOM 281098 Buttons and highscore saving
*
* Version: Drobos 0.21        19 November1998        Jouni Miettunen
*	JOM 181198 Compiled with AfSDK 0.92b1 (16k application)
*	JOM 191198 New graphics by Greg Mills. Thanx!
**********************************************************************/

#include "drobos.h"

/**********************************************************************/
int main ()
{
int nResult = 0;

	init_screen();
	
	do
	{
		init_game();
		do
		{
			init_level();

			do
			{
				if (nResult = move_man())
					break;

				release_pen();
					
				if (!nResult)
					if (nResult = move_droids())
						break;

			} while (1);

		} while (gMode & (MODE_CRASH|MODE_STAND));
		exit_game();
		
	} while (gMode == MODE_NEW);

	exit_program();
	
	return nResult;

} /* End of main */

/***********************************************************************
*
* Function: init_screen
*
************************************************************************
*
* Description
*	Draw parts of screen that will not be changed
*
***********************************************************************/
void init_screen()
{
int
	x;
unsigned char
	buffer[9],
	penx,peny;

	/***** Start of general stuff *****/ 

	SetFontType(PRPFONT11B);
	x = GetStringLength(PROGRAM_TITLE,PRPFONT11B);

	SetToVirtualLCD(0);
	ClearLCD(0);

	/* Title bar and frame */
	DrawRect(0,11,LCD_WIDTH-1,LCD_HEIGHT-1,DRAW_BLACK);
	DrawSystemIcon(0,0,43,PUT);
	DrawSystemIcon(147,0,43,PUT);
	FillRect(9,0,150,8,DRAW_BLACK);
	FillRect(0,9,159,10,DRAW_BLACK);

	/* Exit and menu buttons */
	draw_button(&buttonExit);
	draw_button(&buttonMenu);
	
	/* Title */
	WriteString(14,0,PROGRAM_TITLE,DRAW_WHITE);
	DrawLine(x+15,8,143,8,DRAW_W3DOT);

	/***** End of general stuff *****/ 

	/* Play area */
	DrawRect(OFFSET_X-1,OFFSET_Y-1,OFFSET_X+MX*8+1,OFFSET_Y+MY*8+1,DRAW_BLACK);

	/* Command buttons */
	SetFontType(PRPFONT11B);

	draw_button(&buttonSonic);
	draw_button(&buttonTele);
	draw_button(&buttonLast);
	/*draw_button(&buttonOnes);*/

	/* Info */
	WriteString(OFFSET_LEVEL_X-35,OFFSET_SONIC_Y+1,"Best:",DRAW_BLACK);
	WriteString(OFFSET_LEVEL_X-35,OFFSET_LEVEL_Y+1,"Score:",DRAW_BLACK);
	
	/* Best score was saved into application preferencies */
	if (ReadPref(GetCurrentAppID(),0,buffer,9) == SUCCESS)
	{
		/* Verify it is our application data */
		if
		(
			buffer[0] == 'D' &&
			buffer[1] == 'r' &&
			buffer[2] == 'o' &&
			buffer[3] == 'B' &&
			buffer[4] == 'o'
		)
		{
			gBestLevel = (buffer[5]<<8) | buffer[6];
			gBestScore = (buffer[7]<<8) | buffer[8];
		}
		else
		{
			gBestLevel = 0;
			gBestScore = 0;
		}
	}
	else
	{
		gBestLevel = 0;
		gBestScore = 0;
	}
	
	SetToRealLCD(0);
	LCDCopy(VIRTTOREAL);
	
} /* End of init_screen */

/**********************************************************************/
void exit_program()
{
char buffer[9];

	/* If exit without dead */
	if (gPoints > gBestScore)
	{
		gBestLevel = gLevel;
		gBestScore = gPoints;
	}

	buffer[0] = 'D';
	buffer[1] = 'r';
	buffer[2] = 'o';
	buffer[3] = 'B';
	buffer[4] = 'o';

	buffer[5] = gBestLevel >> 8;
	buffer[6] = gBestLevel & 0xff;
	buffer[7] = gBestScore >> 8;
	buffer[8] = gBestScore & 0xff;

	WritePref(GetCurrentAppID(),buffer,9);
	
} /* End of exit_program */

/**********************************************************************/
void draw_button
(
	BUTTON*	button
)
{
	switch (button->type)
	{
	case BUTTON_SMALL:
		DrawRect
		(
			button->x1+9,
			button->y1,
			button->x2-9,
			button->y2,
			DRAW_BLACK
		);
		DrawSystemIcon(button->x1,button->y1,41,PUT);
		DrawSystemIcon(button->x2-9,button->y1,45,PUT);
		WriteString(button->x1+9,button->y1+1,button->title,DRAW_BLACK);
		break;
	case BUTTON_EXIT:
		DrawSystemIcon(144,2,126,PUT);
		break;
	case BUTTON_MENU:
		DrawSystemIcon(3,2,220,PUT);
		break;		
	}
	
} /* End of draw_button */

/**********************************************************************/
int handle_button
(
	BUTTON* button
)
{
unsigned char penx,peny;
int iButtonSelected = 0;

	GetKey(&penx,&peny);
	if
	(
		penx > button->x1 &&
		penx < button->x2 &&
		peny > button->y1 &&
		peny < button->y2
	)
	while (GetKey(&penx,&peny))
	{
		if
		(
			penx > button->x1 &&
			penx < button->x2 &&
			peny > button->y1 &&
			peny < button->y2
		)
		{
			if (iButtonSelected == 1)
				continue;
			/* Hilight Button icon */
			iButtonSelected = 1;
			switch (button->type)
			{
			case BUTTON_SMALL:
				InverseLCDArea(button->x1+9,button->y1+1,button->x2-9,button->y2-1);
				DrawSystemIcon(button->x1,button->y1,44,PUT);
				DrawSystemIcon(button->x2-9,button->y1,48,PUT);
				break;
			case BUTTON_EXIT:
				DrawSystemIcon(144,2,129,PUT);
				break;
			case BUTTON_MENU:
				DrawSystemIcon(3,2,315,PUT);
				break;
			}
		}
		else
		{
			if (iButtonSelected == 0)
				continue;
			/* Normal Button icon */
			iButtonSelected = 0;
			switch (button->type)
			{
			case BUTTON_SMALL:
				InverseLCDArea(button->x1+9,button->y1+1,button->x2-9,button->y2-1);
				DrawSystemIcon(button->x1,button->y1,41,PUT);
				DrawSystemIcon(button->x2-9,button->y1,45,PUT);
				break;
			case BUTTON_EXIT:
				DrawSystemIcon(144,2,126,PUT);
				break;
			case BUTTON_MENU:
				DrawSystemIcon(3,2,220,PUT);
				break;
			}
		}
	}

	if (iButtonSelected)
	{
		/* Normal Button icon */
		switch (button->type)
		{
		case BUTTON_SMALL:
			InverseLCDArea(button->x1+9,button->y1+1,button->x2-9,button->y2-1);
			DrawSystemIcon(button->x1,button->y1,41,PUT);
			DrawSystemIcon(button->x2-9,button->y1,45,PUT);
			break;
		case BUTTON_EXIT:
			DrawSystemIcon(144,2,126,PUT);
			break;
		case BUTTON_MENU:
			DrawSystemIcon(3,2,220,PUT);
			break;
		}
	}

	return (iButtonSelected);

} /* End of handle_button */

/**********************************************************************/
void init_game()
{
int i,j;

	randomize();

	/*memset(gMap,TILE_EMPTY,MX*MY);*/
	for (i=0; i<MX; i++)
		for (j=0; j<MY; j++)
			gMap[i][j] = TILE_EMPTY;
			
	gPoints = gLevel = gSonic = 0;
	gMode = MODE_CRASH;

} /* End of init_game */

/**********************************************************************/
void init_level()
{
int	i,j;

	/* 10 points per finished level - at start level == 0 */
	gPoints += gLevel * 100;

	/* increment level before counting new drobos */
	gLevel++; gSonic++; gTele=1; gMode=MODE_CRASH;
	/*memset(gMap,TILE_EMPTY,MX*MY);*/
	for (i=0; i<MX; i++)
		for (j=0; j<MY; j++)
			gMap[i][j] = TILE_EMPTY;

	SetToVirtualLCD(0);
	ClearLCDArea
	(
		OFFSET_X,
		OFFSET_Y,
		OFFSET_X + MX*8,
		OFFSET_Y + MY*8,
		0
	);
	SetToRealLCD(0);

	for (i = gDroids = 5 * gLevel; i>0; i--)
	{
		while (gMap[gManx = random(MX)][gMany = random(MY)]);
		gMap[gManx][gMany] = TILE_DROID;
	}
	while (gMap[gManx=random(MX)][gMany=random(MY)]);
	gMap[gManx][gMany] = TILE_MAN;

	/* draw_screen contains copying full screen */
	draw_level();
	draw_screen(UPDATE_ALL);
	
	release_pen();
	
} /* End of init_level */

/**********************************************************************/
int move_man ()
{
unsigned char penx,peny;
int key;

	if (gMode == MODE_STAND)
		return 0;

	while (-1)
	{
		key = GetKey(&penx,&peny);
		switch (key)
		{
		case 0:
		case PGDN:
		case PGUP:
			key = 0;
			break;
		case 255:
			if (key = handle_pen_press(penx,peny))
			{
				switch (key)
				{
				case 1:
					/* Man moved one step */
					return 0;
				case -1:
					/* Exit program */
					return APPLICATION;
				default:				
					return 0;
				}
			}
			break;
		default:
			return key;
		}
	}

} /* End of move_man */

/*********************************************************************
*
* Function: blit_sprite
*
**********************************************************************
* Arguments:
*	int x	:Absolute screen coordinate for top left corner
*	int y	:Absolute screen coordinate for top left corner
*	unsigned char* spr	:data to be drawn
*
* Return:
*	None
*
* Note:
*	gfx_blit() draws on virtual screen, no matter what is active
*	
*********************************************************************/
void blit_sprite(int x,int y,unsigned char* spr)
{
	gfx_blit(x+OFFSET_X,y+OFFSET_Y,1,8,SPR_MASK,GFX_BLIT_CLEAR);
	gfx_blit(x+OFFSET_X,y+OFFSET_Y,1,8,spr,GFX_BLIT_OR);

} /* End of blit_sprite */

/**********************************************************************/
void draw_tile(int x,int y)
{
	int c = gMap[x][y];

	blit_sprite(x*8,y*8,level_spr[c]);
	
} /* End of draw_tile */

/**********************************************************************/
void draw_level()
{
	int x,y;
	char lev[3];

	for (y = 0; y<MY; y++)
		for (x = 0; x<MX; x++)
			draw_tile(x,y);

	blit_sprite(gManx*8,gMany*8,SPR_MAN);

} /* End of draw_level */

/**********************************************************************/
void move_man_ok(int dx,int dy)
{
int
	x = gManx,
	y = gMany;

	gManx += dx;
	gMany += dy;
	
	gMap[x][y] = TILE_EMPTY;
	gMap[gManx][gMany] = TILE_MAN;

	blit_sprite(x<<3,y<<3,SPR_EMPTY);
	blit_sprite(gManx<<3,gMany<<3,SPR_MAN);
	LCDCopy(VIRTTOREAL);

	Delay_10ms();
	Delay_10ms();
	Delay_10ms();
	Delay_10ms();
	Delay_10ms();
	
} /* End of move_man_ok */

/**********************************************************************/
void move_mann (int dx,int dy)
{
int x,y;

	switch (gMap[gManx+dx][gMany+dy])
	{
	case TILE_EMPTY:
		/* Moving to empty place is allowed */
		move_man_ok(dx,dy);
		break;
	case TILE_SCRAP:
		/* Pushing scrap is allowed, if tile behind it is empty */
		x = gManx + 2*dx;
		y = gMany + 2*dy;
		if (y>=0 && y<MY && x>=0 && x<MX && (gMap[x][y] == TILE_EMPTY))
		{
			gMap[x-dx][y-dy] = TILE_EMPTY;
			gMap[x][y] = TILE_SCRAP;
			blit_sprite((x-dx)<<3,(y-dy)<<3,SPR_EMPTY);
			blit_sprite(x<<3,y<<3,SPR_SCRAP);
			move_man_ok(dx,dy);
		}
	}
	
} /* End of move_mann */

/**********************************************************************/
void release_pen()
{
	unsigned char penx,peny;

	while (GetKey(&penx,&peny));

} /* End of release_pen */

/**********************************************************************/
int handle_pen_press (int x,int y)
{
int dx,dy;
unsigned char penx,peny;

	/* Click on playing area */
	if
	(
		y >= OFFSET_Y &&
		y < OFFSET_Y + MY*8 &&
		x >= OFFSET_X &&
		x < OFFSET_X + MX*8
	)
	{
		while (GetKey(&x,&y));
		if
		(
			y < OFFSET_Y ||
			y > OFFSET_Y + MY*8 ||
			x < OFFSET_X ||
			x > OFFSET_X + MX*8
		)
		{
			return 0;
		}

		y -= OFFSET_Y;
		x -= OFFSET_X;
		/* (dx,dy) is pressed (8x8) tile */
		dx = (x>>3) - gManx;
		dy = (y>>3) - gMany;
		if (dx<0)
			dx = -1;
		else if (dx>0)
			dx = 1;
		else
			dx = 0;
		if (dy<0)
			dy = -1;
		else if (dy>0)
			dy = 1;
		else
			dy = 0;
		if (dx | dy)
		{
			move_mann(dx,dy);
		}
		return 1;
	}

	else if (gSonic && handle_button(&buttonSonic) == 1)
	{
		zap_around();
		draw_screen(UPDATE_SONIC);
		return 1;
	}
	
	else if (handle_button(&buttonTele) == 1)
	{
		do_teleport();
		return 1;
	}
	
	else if (handle_button(&buttonLast) == 1)
	{
		do_laststand();
		return 1;
	}
	
	else if (handle_button(&buttonExit) == 1)
	{
		gMode = MODE_EXIT;
		return -1;
	}

	else if (handle_button(&buttonMenu) == 1)
	{
		/* HACK: selecting menu resets highscore */
		DeletePref(GetCurrentAppID());
		gBestLevel = gBestScore = 0;
		draw_screen(UPDATE_BEST);
	}

	return 0;

} /* End of handle_pen_press */

/**********************************************************************/
void exit_game()
{
	int s,t;
	char buffer[2+1+5+1]; /* level slash points zero */
	unsigned char penx,peny;

	if (gMode != MODE_NEW)
		return;
	
	SetFontType(PRPFONT11B);
	s = GetStringLength("R.I.P.",PRPFONT11B);
	t = GetStringLength("Your score was",PRPFONT11B);

	if (gLevel < 10)
	{
		buffer[0] = '0';
		buffer[1] = gLevel + '0';
		buffer[2] = 0;
	}
	else
	{
		itoa(gLevel,buffer,10);
	}
	strncat(buffer,"/",1);
	itoa(gPoints,buffer+3,10);

	/* Check best highscore */
	if (gPoints > gBestScore)
	{
		gBestLevel = gLevel;
		gBestScore = gPoints;
	}
	
	/* Set real screen active, do not copy virtual screen contents */
	SetToRealLCD(0);
	/* Clear screen to white */
	/* ClearLCD(0); */
	ClearLCDArea
	(
		OFFSET_X,
		OFFSET_Y,
		OFFSET_X + MX*8,
		OFFSET_Y + MY*8,
		0
	);

	WriteString((160-s)/2,60,"R.I.P.",DRAW_BLACK);
	s = WriteString((160-t)/2,74,"Your score was",DRAW_BLACK);
	s = GetStringLength(buffer,PRPFONT11B);
	WriteString((160-s)/2,88,buffer,DRAW_BLACK);

	SetFontType(PRPFONT7N);
	s = GetStringLength("Tap screen to start",PRPFONT7N);
	s = (160 - s) / 2;

	t = 0;
	while (!GetKey(&penx,&peny))
	{
		WriteString(s,140,"Tap screen to continue",(t++&16)?DRAW_BLACK:DRAW_WHITE);
		Delay_10ms();
	}
	SetFontType(PRPFONT11B);

} /* End of exit_game */

/**********************************************************************/
int move_droids()
{
int
	nEnd,i,m,
	nCheck = 0,		/* count number of droids left to be moved */
	a = gManx-1,	/* left */
	b = gMany-1,	/* top */
	c = gManx+1,	/* right */
	d = gMany+1;	/* bottom */
int
	nResult = 0;
unsigned char
	*n;
	
	/* check death */
	{
		if (b>=0)
		{
			if (a>=0)
				nCheck |= gMap[a][b];
			nCheck |= gMap[gManx][b];
			if (c<MX)
				nCheck |= gMap[c][b];
		}
		if (a>=0)
			nCheck |= gMap[a][gMany];
		if (c<MX)
			nCheck |= gMap[c][gMany];
		if (d<MY)
		{
			if (a>=0)
				nCheck |= gMap[a][d];
			nCheck |= gMap[gManx][d];
			if (c<MX)
				nCheck |= gMap[c][d];
		}

		if (nCheck & TILE_DROID)
		{
			gMode = MODE_NEW;
			return 1;
		}
	}

	a = gManx-1;	/* left */
	b = gMany-1;	/* top */
	c = gManx+1;	/* right */
	d = gMany+1;	/* bottom */
	nCheck = gDroids;

	SetToRealLCD(0);

	do
	{
		--a;
		--b;
		++c;
		++d;

		/* top row right to left */
		if (b>=0)
		{
			nEnd = (a>=0 ? a+1 : 0);
			for (i=(c<MX?c:MX-1); i>=nEnd; i--)
				if (gMap[i][b] == TILE_DROID)
				{
					nCheck--;
					gMap[i][b] = TILE_EMPTY;
					blit_sprite(i<<3,b<<3,SPR_EMPTY);
					m = (i<gManx ? i+1 : i>gManx ? i-1 : i);
					n = &gMap[m][b+1];
					if (!*n)
					{
						*n = TILE_DROID;
						blit_sprite(m<<3,(b+1)<<3,SPR_DROID_D);
					}
					else if (*n == TILE_SCRAP)
					{
						points_update(1);
					}
					else
					{
						/* There was a DROID */
						*n = TILE_SCRAP;
						blit_sprite(m<<3,(b+1)<<3,SPR_SCRAP);
						points_update(2);
					}
				}
		}

		if (gDroids <= 0)
		{
			nResult = 1;
			break;
		}
		else if (nCheck <= 0)
		{
			nResult = 0;
			break;
		}

		/* Left column top to bottom */
		if (a>=0)
		{
			nEnd = (d<MY ? d-1 : MY-1);
			for (i=(b>=0?b:0); i<=nEnd; i++)
				if (gMap[a][i] == TILE_DROID)
				{
					nCheck--;
					gMap[a][i] = TILE_EMPTY;
					blit_sprite(a<<3,i<<3,SPR_EMPTY);
					m = (i<gMany ? i+1 : i>gMany ? i-1 : i);
					n = &gMap[a+1][m];
					if (!*n)
					{
						*n = TILE_DROID;
						blit_sprite((a+1)<<3,m<<3,SPR_DROID_R);
					}
					else if (*n == TILE_SCRAP)
					{
						points_update(1);
					}
					else
					{
						/* There was a DROID */
						*n = TILE_SCRAP;
						blit_sprite((a+1)<<3,m<<3,SPR_SCRAP);
						points_update(2);
					}
				}
		}

		if (gDroids <= 0)
		{
			nResult = 1;
			break;
		}
		else if (nCheck <= 0)
		{
			nResult = 0;
			break;
		}

		/* bottom row left to right */
		if (d<MY)
		{
			nEnd = (c<MX ? c-1 : MX-1);
			for (i=(a>=0?a:0); i<=nEnd; i++)
				if (gMap[i][d] == TILE_DROID)
				{
					nCheck--;
					gMap[i][d] = TILE_EMPTY;
					blit_sprite(i<<3,d<<3,SPR_EMPTY);
					m = (i<gManx ? i+1 : i>gManx ? i-1 : i);
					n = &gMap[m][d-1];
					if (!*n)
					{
						*n = TILE_DROID;
						blit_sprite(m<<3,(d-1)<<3,SPR_DROID_U);
					}
					else if (*n == TILE_SCRAP)
					{
						points_update(1);
					}
					else
					{
						/* There was a DROID */
						*n = TILE_SCRAP;
						blit_sprite(m<<3,(d-1)<<3,SPR_SCRAP);
						points_update(2);
					}
				}
		}

		if (gDroids <= 0)
		{
			nResult = 1;
			break;
		}
		else if (nCheck <= 0)
		{
			nResult = 0;
			break;
		}

		/* Right column bottom to top */
		if (c<MX)
		{
			nEnd = (b>=0 ? b+1 : 0);
			for (i=(d<MY?d:MY-1); i>=nEnd; i--)
				if (gMap[c][i] == TILE_DROID)
				{
					nCheck--;
					gMap[c][i] = TILE_EMPTY;
					blit_sprite(c<<3,i<<3,SPR_EMPTY);
					m = (i<gMany ? i+1 : i>gMany ? i-1 : i);
					n = &gMap[c-1][m];
					if (!*n)
					{
						*n = TILE_DROID;
						blit_sprite((c-1)<<3,m<<3,SPR_DROID_L);
					}
					else if (*n == TILE_SCRAP)
					{
						points_update(1);
					}
					else
					{
						/* There was a DROID */
						*n = TILE_SCRAP;
						blit_sprite((c-1)<<3,m<<3,SPR_SCRAP);
						points_update(2);
					}
				}
		}

		if (gDroids <= 0)
		{
			nResult = 1;
			break;
		}
		else if (nCheck <= 0)
		{
			nResult = 0;
			break;
		}

	} while (a>=0 || b>=0 || c<MX || d<MY);

	LCDCopy(VIRTTOREAL);
	SetToRealLCD(0);
	
	return (nResult);

} /* End of move_droids */

/**********************************************************************/
void points_update(int nCount)
{
	switch (gMode)
	{
	case MODE_CRASH:
		gPoints += nCount * CRASH_MULTIPLYER;
		break;
	case MODE_STAND:
		gPoints += nCount * STAND_MULTIPLYER;
		break;
	case MODE_SONIC:
		gPoints += nCount * SONIC_MULTIPLYER;
		break;
	}

	draw_screen(UPDATE_SCORE);
	gDroids -= nCount;
	
} /* End of points_update */

/**********************************************************************/
void draw_screen (int nUpdate)
{
unsigned char
	buffer[2+1+5+1], /* level slash points zero */
	penx,peny;

	if (nUpdate & (UPDATE_LEVEL|UPDATE_SCORE))
	{
		if (gLevel < 10)
		{
			buffer[0] = '0';
			buffer[1] = gLevel + '0';
			buffer[2] = 0;
		}
		else
		{
			itoa(gLevel,buffer,10);
		}
		strncat(buffer,"/",1);
		itoa(gPoints,buffer+3,10);
	
		SetToVirtualLCD(0);
		ClearLCDArea
		(
			OFFSET_LEVEL_X,
			OFFSET_LEVEL_Y+1,
			LCD_WIDTH-2,
			OFFSET_LEVEL_Y+10,
			0
		);
		SetFontType(PRPFONT11N);
		WriteString(OFFSET_LEVEL_X,OFFSET_LEVEL_Y+1,buffer,DRAW_BLACK);
		SetToRealLCD(0);
		SetFontType(PRPFONT11B);
	}

	if (nUpdate & UPDATE_SONIC)
	{
		buffer[0] = (gSonic/10) + '0';
		buffer[1] = (gSonic%10) + '0';
		buffer[2] = 0;

		SetToVirtualLCD(0);
		ClearLCDArea
		(
			OFFSET_SONIC_X + 45,
			OFFSET_SONIC_Y+1,
			OFFSET_SONIC_X + 55,
			OFFSET_SONIC_Y+10,
			0
		);
		WriteString(OFFSET_SONIC_X+45,OFFSET_SONIC_Y+1,buffer,DRAW_BLACK);
		SetToRealLCD(0);
	}

	if (nUpdate & UPDATE_BEST)
	{
		if (gBestLevel < 10)
		{
			buffer[0] = '0';
			buffer[1] = gBestLevel + '0';
			buffer[2] = 0;
		}
		else
		{
			itoa(gBestLevel,buffer,10);
		}
		strncat(buffer,"/",1);
		itoa(gBestScore,buffer+3,10);
	
		SetToVirtualLCD(0);
		ClearLCDArea
		(
			OFFSET_LEVEL_X,
			OFFSET_SONIC_Y+1,
			LCD_WIDTH-2,
			OFFSET_SONIC_Y+10,
			0
		);
		SetFontType(PRPFONT11N);
		WriteString(OFFSET_LEVEL_X,OFFSET_SONIC_Y+1,buffer,DRAW_BLACK);
		SetToRealLCD(0);
		SetFontType(PRPFONT11B);
	}
	
	LCDCopy(VIRTTOREAL);
	
} /* End of draw_screen */

/**********************************************************************/
void zap_around()
{
unsigned char
	*n;
int
	a = gManx-1,
	b = gMany-1,
	c = gManx+1,
	d = gMany+1,
	nCount = 0,
	nSave;

	if (!gSonic)
		return;	
	
	gSonic--;

	/* Zap around user */
	if (b>=0)
	{
		if (a>=0)
		{
			if (*(n=&gMap[a][b]) == TILE_DROID)
			{
				*n = TILE_EMPTY;
				nCount++;
			}
			blit_sprite(a<<3,b<<3,SPR_ZAP);
		}
		if (*(n=&gMap[gManx][b]) == TILE_DROID)
		{
			*n = TILE_EMPTY;
			nCount++;
		}
		blit_sprite(gManx<<3,b<<3,SPR_ZAP);
		if (c<MX)
		{
			if (*(n=&gMap[c][b]) == TILE_DROID)
			{
				*n = TILE_EMPTY;
				nCount++;
			}
			blit_sprite(c<<3,b<<3,SPR_ZAP);
		}
	}

	if (a>=0)
	{
		if (*(n=&gMap[a][gMany]) == TILE_DROID)
		{
			*n = TILE_EMPTY;
			nCount++;
		}
		blit_sprite(a<<3,gMany<<3,SPR_ZAP);
	}

	if (c<MX)
	{
		if (*(n=&gMap[c][gMany]) == TILE_DROID)
		{
			*n = TILE_EMPTY;
			nCount++;
		}
		blit_sprite(c<<3,gMany<<3,SPR_ZAP);
	}

	if (d<MY)
	{
		if (a>=0)
		{
			if (*(n=&gMap[a][d]) == TILE_DROID)
			{
				*n = TILE_EMPTY;
				nCount++;
			}
			blit_sprite(a<<3,d<<3,SPR_ZAP);
		}
		if (*(n=&gMap[gManx][d]) == TILE_DROID)
		{
			*n = TILE_EMPTY;
			nCount++;
		}
		blit_sprite(gManx<<3,d<<3,SPR_ZAP);
		if (c<MX)
		{
			if (*(n=&gMap[c][d]) == TILE_DROID)
			{
				*n = TILE_EMPTY;
				nCount++;
			}
			blit_sprite(c<<3,d<<3,SPR_ZAP);
		}
	}

	if (nCount)
	{
		nSave = gMode;
		gMode = MODE_SONIC;
		points_update(nCount);
		gMode = nSave;
	}

	LCDCopy(VIRTTOREAL);

	/* Delay to make ZAP visible in fast machine */
	for (nSave=0; nSave<5; nSave++)
		Delay_10ms();

	/* Restore screen after ZAP */
	if (b>=0)
	{
		if (a>=0)
			blit_sprite(a<<3,b<<3,level_spr[gMap[a][b]]);
		blit_sprite(gManx<<3,b<<3,level_spr[gMap[gManx][b]]);
		if (c<MX)
			blit_sprite(c<<3,b<<3,level_spr[gMap[c][b]]);
	}
	if (a>=0)
		blit_sprite(a<<3,gMany<<3,level_spr[gMap[a][gMany]]);
	if (c<MX)
		blit_sprite(c<<3,gMany<<3,level_spr[gMap[c][gMany]]);
	if (d<MY)
	{
		if (a>=0)
			blit_sprite(a<<3,d<<3,level_spr[gMap[a][d]]);
		blit_sprite(gManx<<3,d<<3,level_spr[gMap[gManx][d]]);
		if (c<MX)
			blit_sprite(c<<3,d<<3,level_spr[gMap[c][d]]);
	}

	LCDCopy(VIRTTOREAL);
		
} /* End of zap_around */

/**********************************************************************/
void do_teleport()
{
int
	x = gManx,
	y = gMany;

	/* Go somewhere else */
	gMap[x][y] == TILE_DROID;

	/* Find new place */
	while (gMap[gManx=random(MX)][gMany=random(MY)]);
	gMap[x][y] = TILE_EMPTY;
	gMap[gManx][gMany] = TILE_MAN;

	blit_sprite(x<<3,y<<3,SPR_EMPTY);
	blit_sprite(gManx<<3,gMany<<3,SPR_MAN);

	LCDCopy(VIRTTOREAL);
	
} /* End of do_teleport */

/**********************************************************************/
int do_laststand()
{
	gMode = MODE_STAND;
	return 1;

} /* End of do_laststand */

/**********************************************************************/
/*************************** A HAPPY END ******************************/
/**********************************************************************/
