#include <avsys.h>
#include "comPort.h"

char message[]="Click Screen to Send";

int main()
{
	int key;
	unsigned char penx,peny;
	int slen;
	int x;
	char sVal[6];
	int count;

	ClearLCD(0);

	InitComPort( PORT_IR, BAUD_9600);

	SetFontType(PRPFONT11B);

	slen=GetStringLength(message,PRPFONT11B);
	WriteString((LCD_WIDTH-slen)/2,10,message,DRAW_BLACK);

	DrawRect(90,90,110,110,DRAW_GRAY);
	WriteString(75,75,"Received Char",DRAW_BLACK);
	count = '0';

	while(-1){

		key=GetKey(&penx,&peny);
		if(key != PENDOWN && key != 0) break;

		if(key == PENDOWN){
			sVal[0] = count;
			sVal[1] = '\0';

			WriteString(penx,peny,sVal,DRAW_BLACK);
			PenBeep();
			SendChar(count++);
			while(GetKey(&penx,&peny));
			x = ReceiveChar();		/* receive Echoed Character */
		}

		x = ReceiveChar();
		if (x != 0) {
			sVal[0] = x;
			sVal[1] = '\0';
			
			FillRect(90,90,110,110,DRAW_WHITE);
			DrawRect(90,90,110,110,DRAW_GRAY);

			WriteString(95,95,sVal,DRAW_BLACK);

			PenBeep();
		}
	}
	PenBeep();

	CloseComPort();

	return key;
}
