
#include <avsys.h>

/* fill up bank */
#pragma codeseg
char buf1[10000];
#pragma defaultseg

int releasepen()
{
	int key;
	unsigned char penx,peny;

	while(!(key=GetKey(&penx,&peny)));
	PenBeep();
	while(GetKey(&penx,&peny));

	return key;
}

/* scheme will also work for functions in the same bank! */
int f1(int a,int b)
{
	WriteString(0,10,"function 1 called",DRAW_BLACK);
	return a+b;
}

/* you would normally do this from a header file, not in this sample */
extern int f1();
extern int f2();
extern int f3();

/* 'our' function pointer, 16-bit function pointer & bank no */
typedef struct
{
	unsigned int bankno;
	int (*f)();
} my_funcptr;

/* array of function pointers */
my_funcptr ptrarray[]=
{
 { 0 , f1 },
 { 0 , f2 },
 { 0 , f3 }
};

int main()
{
	int s,t;
	char buf[32];

	/* initialize function bank no's */
	AssignBankNo(f1,ptrarray[0].bankno);
	AssignBankNo(f2,ptrarray[1].bankno);
	AssignBankNo(f3,ptrarray[2].bankno);

	/* just call all the functions */
	/* just ignore 'too many actual parameters' warning for now */
	/* ellipses (...) will be fixed soon */
	ClearLCD(0);
	BankedFunctionCall(ptrarray[0].f,ptrarray[0].bankno,0,0);
	releasepen();
	ClearLCD(0);
	BankedFunctionCall(ptrarray[1].f,ptrarray[1].bankno,0,0);
	releasepen();
	ClearLCD(0);
	BankedFunctionCall(ptrarray[2].f,ptrarray[2].bankno,0,0);
	releasepen();

	ClearLCD(0);
	s=0;
	for(t=0;t<3;t++)
	{
		/* test parameters and result data */
		s+=BankedFunctionCall(ptrarray[t].f,ptrarray[t].bankno,t,100*t);
	}

	itoa(s,buf,10);
	strcat(buf," <- result");
	WriteString(0,50,buf,DRAW_BLACK);

	return releasepen();
}
