#include <avsys.h>
#include <avdata.h>
#include <avicons.h>

char title[17]="Weekview v1.1";
#define minrepeatweek -5
#define maxrepeatweek 10
#define recordcountmax 100
#define filtercountmax 25

_DATE currentdate;
int tmpscheduledateyear;
int currentyear;
int currentweek;
int startuplinepos;

#ifndef NULL
#define NULL '\0'
#endif

FIELD_INFO fi;
int fieldcount;

typedef struct tagREPEAT
{
	_DATE startdate;
	_DATE enddate;
	char flag;
	char data1;
	char data2;
} _REPEAT;

typedef struct tagRECORD
{
	int type;	/* 99: normal, 1: notime, 2:start of repeat, 3: end of repeat ,4: repeat*/
	_DATE date;
	_TIME time;
	char description[30];
	_REPEAT repeat;
	int daysfrom1st;
	int daysfrom1stmon;
	int week;
	int dayofweek;
	unsigned char category;
} _RECORD;
_RECORD records[recordcountmax];
_RECORD filterrecords[filtercountmax];
int recordcount;
int filtercount;

typedef struct tagLINE
{
	char time[6];
	char type[2];
	char description[30];
	char category[3];
} _LINE;

CATEGORY_INFO categoryinfo;


void Sleep (int msec)
{
	int i;
	for (i=0;i<msec/10;i++)
		Delay_10ms();
}


void DateToText (_DATE date, char* text)
{
	char buf[10];
	char buf1[10];
	char zero[2];

	itoa(0,zero,10);
	strcpy(buf,"");

	if (date.day < 10) strcat(buf,zero);
	itoa(date.day,buf1,10);
	strcat (buf,buf1);

	strcat (buf,"-");

	if (date.month < 10) strcat(buf,zero);
	itoa(date.month,buf1,10);
	strcat(buf,buf1);
	strcpy(text,buf);
}


void TimeToText (_TIME time, char* text)
{
	char buf[10];
	char buf1[10];
	char zero[2];

	itoa(0,zero,10);
	strcpy(buf,"");

	if (time.hour < 10) strcat(buf,zero);
	itoa(time.hour,buf1,10);
	strcat (buf,buf1);

	strcat (buf,":");

	if (time.minute < 10) strcat(buf,zero);
	itoa(time.minute,buf1,10);
	strcat(buf,buf1);
	strcpy(text,buf);
}


void ShowText (char* s)
{
	MessageBox(s,mfWarning|mfOKButton); 
}


void ShowInt (int i)
{
	char s[10];
	itoa(i,s,10);
	MessageBox(s,mfWarning|mfOKButton); 
}

void ShowByte (unsigned char i)
{
	char s[10];
	itoa(i,s,10);
	MessageBox(s,mfWarning|mfOKButton); 
}

void ShowInts (int i [4])
{
	char s[10];
	char buf [50];
	int x;
	strcpy(buf,"");
	for (x=1;x<5;x++)
	{
		itoa(i[x],s,10);
		strcat(buf,s);
		strcat(buf,", ");
	}
	MessageBox(buf,mfWarning|mfOKButton); 
}

void ShowDate (_DATE date)
{
	char s[20];
	DateToText (date, s);
	MessageBox(s,mfWarning|mfOKButton); 
}

void ShowRecord (_RECORD record)
{
	char s[150];
	char buf[150];
	strcpy(s,"CAT: ");
	itoa(record.category,buf,10);
	strcat(s,buf);
	strcpy(s,"; DATE: ");
	DateToText(record.date,buf);
	strcat(s,buf);
	strcat(s,"; TIME: ");
	TimeToText(record.time,buf);
	strcat(s,buf);
	strcat(s,"; R_DATE: ");
	DateToText(record.repeat.startdate,buf);
	strcat(s,buf);
	strcat(s,"; DOW: ");
	itoa(record.dayofweek,buf,10);
	strcat(s,buf);
	strcat(s,"; DESCR: ");
	strcat(s,record.description);
	ShowText(s);
}


void DrawSystemIcon(char x, char y, int icon_number, int mode)
{
    _asm
    {
        ld   l, _mode+0(ix)
        ld   h, _mode+1(ix)
        push hl
        ld   l, _icon_number+0(ix)
        ld   h, _icon_number+1(ix)
        push hl
        ld   e, _y(ix)
        ld   l, _x(ix)
        call 0x0168
        pop bc
        pop bc
    }
}

void ShowScheduleFields(int nMemo)
{
	FIELD_INFO fi;
	int fieldcount;
	int t;
	char buf [150];
	char buf1 [10];
	/* fetch memo field record info */
	fieldcount=ReadFieldInfo(TYPE_SCHEDULE,&fi);
	strcpy(buf,"");
	/* search through fields */
	for(t=0;t<fieldcount;t++)
	{
		strcat(buf,fi.field[t].name);
		strcat(buf," (");
		itoa(t,buf1,10);
		strcat(buf,buf1);
		strcat(buf,"), ");
	}
/*	MessageBox(buf,mfWarning|mfOKButton); */
}

int DateToDays (_DATE date)
{
	int tmpdays=0; /*bevat het aantal verstreken dagen vanaf 1 januari*/
	int year;
	int x;

	year=date.year + 1901;

	switch (date.month)
	{
		case 1: tmpdays=0; break;
		case 2: tmpdays=31; break;
		case 3: tmpdays=31+28; break;
		case 4: tmpdays=31+28+31; break;
		case 5: tmpdays=31+28+31+30; break;
		case 6: tmpdays=31+28+31+30+31; break;
		case 7: tmpdays=31+28+31+30+31+30; break;
		case 8: tmpdays=31+28+31+30+31+30+31; break;
		case 9: tmpdays=31+28+31+30+31+30+31+31; break;
		case 10: tmpdays=31+28+31+30+31+30+31+31+30; break;
		case 11: tmpdays=31+28+31+30+31+30+31+31+30+31; break;
		case 12: tmpdays=31+28+31+30+31+30+31+31+30+31+30; break;
	}

	if ((year%4 && !(year%100)) || year==2000)
	{
		tmpdays=tmpdays+1;
	}

	tmpdays=tmpdays+date.day; /* tel de huidige maanddagen */
	return (tmpdays);
}

_DATE DaysToDate (int days, int dateyear)
{
	_DATE tmpdate;
	int tmpdays, oldtmpdays;
	int month2;
	int year;
	int i;
	
	month2=28;
	year=dateyear + 1901;
	if ((year%4 && !(year%100)) || year==2000)
	{
		month2=29;
	}
	tmpdays=0;
	oldtmpdays=0;
	tmpdate.year=dateyear;
	tmpdate.month=0;
	for (i=1;i<=12;i++)
	{
		switch (i)
		{
			case 1: tmpdays=0; break;
			case 2: tmpdays=31; break;
			case 3: tmpdays=31+month2; break;
			case 4: tmpdays=31+month2+31; break;
			case 5: tmpdays=31+month2+31+30; break;
			case 6: tmpdays=31+month2+31+30+31; break;
			case 7: tmpdays=31+month2+31+30+31+30; break;
			case 8: tmpdays=31+month2+31+30+31+30+31; break;
			case 9: tmpdays=31+month2+31+30+31+30+31+31; break;
			case 10: tmpdays=31+month2+31+30+31+30+31+31+30; break;
			case 11: tmpdays=31+month2+31+30+31+30+31+31+30+31; break;
			case 12: tmpdays=31+month2+31+30+31+30+31+31+30+31+30; break;
		}
	
		if (days >= tmpdays)
		{
			if (days > tmpdays)
			{
				tmpdate.month++;
				tmpdate.day=days-tmpdays;
			}
			else
			{
				tmpdate.day = days-oldtmpdays;
				return (tmpdate);
			}
		}
		else break;
		oldtmpdays=tmpdays;
	}
	return (tmpdate);
}

int DaysFrom1stMonday (int days, int dateyear)
{
	int tmpdays=0; /*bevat het aantal verstreken dagen vanaf 1 januari*/
	int year;

	year=dateyear + 1901;

	tmpdays=days;	

	switch (year)
	{
		case 1999:  /* week 1 start op 4 januari */
		{
			if (tmpdays<4)
			{
				tmpscheduledateyear=97;
				tmpdays=364;
			}
			tmpdays=tmpdays+3;
		} break;
		case 2000:  /* week 1 start op 3 januari */
		{
			if (tmpdays<3)
			{
				tmpscheduledateyear=98;
				tmpdays=364;
			}
		tmpdays=tmpdays+4;
		} break;
		case 2001:  /* week 1 start op 1 januari */
		{
			if (tmpdays<1)
			{
				tmpscheduledateyear=99;
				tmpdays=364;
			}
			tmpdays=tmpdays+6;
		} break;
		case 2002:  /* week 1 start op 7 januari */
		{
			if (tmpdays<7)
			{
				tmpscheduledateyear=100;
				tmpdays=364;
			}
			tmpdays=tmpdays+7;
		} break;
	}

	return (tmpdays);
}

CalcRecordDateProperties (_RECORD *record)
{
	_RECORD tmp;
	tmp=*record;	
	tmp.daysfrom1st=DateToDays (tmp.date);
	tmp.daysfrom1stmon=DaysFrom1stMonday (tmp.daysfrom1st, tmp.date.year);
	tmp.dayofweek=((tmp.daysfrom1stmon) % 7) + 1;
	tmp.week=tmp.daysfrom1stmon / 7;
	*record = tmp;
}


/*------------------------------------------------------------------------------------------------------------------*/
/* C O L L E C T   R E C O R D S  */ 
/*------------------------------------------------------------------------------------------------------------------*/


int AnalyseRecord (_RECORD record)
{
	int week;

	tmpscheduledateyear=record.date.year;

	if (currentweek==record.week && currentyear==tmpscheduledateyear) 
		return (0);
	else
		return (1);
}


void CollectRecords () 
{
	_RECORD record;
	int t;

	t=0;

	while (t<recordcount)
	{
		record=records[t];

		if (AnalyseRecord(record)==0) 
		{
			if (filtercount<filtercountmax)
			{
				filterrecords[filtercount]=record;
				filtercount++;
			}
		}

		t++;
	}
}


/*------------------------------------------------------------------------------------------------------------------*/
/* S O R T   R E C O R D S  */ 
/*------------------------------------------------------------------------------------------------------------------*/


void SwapRecords (int i1, int i2)
{
	_RECORD tmprecord;
	tmprecord=filterrecords[i1];
	filterrecords[i1]=filterrecords[i2];
	filterrecords[i2]=tmprecord;
}

void SortRecords ()
{
	char buf [50];
	char buf1 [50];
	int t=0;
	int oldt=0;
	int watchdog=0;
	int swapped=0; /* 1=already swapped */
	int forced=0; /* 1=goto end of loop {} */
	_TIME time1,time2;
	int dow1,dow2;
	int code=0;

	if (filtercount<=1) return;

	while (t<filtercount-1 || watchdog>=3)
	{
		time1=filterrecords[t].time;
		time2=filterrecords[t+1].time;
		dow1=filterrecords[t].dayofweek;
		dow2=filterrecords[t+1].dayofweek;
		swapped=0;
		forced=0;
		if (dow1 > dow2)
		{
			/* first day is greater */
			SwapRecords (t,t+1);
			swapped=1;
			code=1;
		}
		if (swapped==0 && dow1==dow2 && time2.hour==255 && time1.hour==255)
		{
			/* both records have no time, force to next record */
			forced=1;
			code=2;
		}
		if (forced==0 && swapped==0 && dow1==dow2 && time2.hour==255 && time1.hour!=255)
		{
			/* second record has no time */
			SwapRecords (t,t+1);
			swapped=1;
			code=3;
		}
		if (forced==0 && swapped==0 && dow1==dow2 && time1.hour!=255 && 	(time1.hour>time2.hour || (time1.hour==time2.hour && time1.minute>time2.minute)))
		{
			SwapRecords(t,t+1);
			swapped=1;
			code=4;
		}
		if (swapped==0) t++;
			else t=0; /* begin again */
		if (oldt==t) watchdog++;
		oldt=t;
		if (watchdog > 3) return; /* too long stuck on the same records, no sort solve */
	}
}


/*------------------------------------------------------------------------------------------------------------------*/
/* W R I T E   R E C O R D S  */ 
/*------------------------------------------------------------------------------------------------------------------*/


void DayToScreen (int* pos, int dayofweek, _DATE date)
{
	char buf[50];
	char buf1[10];
	int slen;
	int toppos;
	toppos=*pos;
	strcpy(buf,"");
	if (dayofweek==1) {strcpy (buf,"monday");}
	else if (dayofweek==2) {strcpy (buf,"tuesday");}
	else if (dayofweek==3) {strcpy (buf,"wednesday");}
	else if (dayofweek==4) {strcpy (buf,"thursday");}
	else if (dayofweek==5) {strcpy (buf,"friday");}
	else if (dayofweek==6) {strcpy (buf,"saturday");}
	else if (dayofweek==7) {strcpy (buf,"sunday");}
	strcat(buf," (");
		
	DateToText (date,buf1);
		
	strcat (buf,buf1);
	strcat (buf,"):");

	SetFontType(PRPFONT11B); 
	toppos=toppos+3;
	WriteString(2,toppos,buf,DRAW_BLACK); 
	if (currentdate.year==date.year && currentdate.month==date.month && currentdate.day==date.day)
	{
		strcpy(buf,"--today--");
		slen=GetStringLength(buf,PRPFONT11B);
		WriteString(158-slen,toppos,buf,DRAW_BLACK); 
	}
	toppos=toppos+11+1;
	*pos=toppos;
}


int GetCategoryIndex (unsigned char category)
{
	int r;
	for (r=0;r<CATEGORY_MAXNUM;r++)
	{
		if (categoryinfo.cate[r].id==category)
			return (r);
	}
	return (-1);
}

void RecordToLine (_RECORD record, _LINE* line)
{
	_LINE tmpline;
	char zero[2];
	char buf[4];
	char tmp[3];
	int categoryindex;

	itoa(0,zero,10);
	strcpy(tmpline.time,"");
	strcpy(tmpline.type,"");
	strcpy(tmpline.description,"");
	strcpy(tmpline.category,"");

	if (record.time.hour < 255)
		TimeToText(record.time,tmpline.time);

	if (record.type==1) 
		strcpy(tmpline.type,""); 
	if (record.type==2) 
		strcpy(tmpline.type,"S"); 
	if (record.type==3) 
		strcpy(tmpline.type,"E"); 
	if (record.type==4) 
		strcpy(tmpline.type,"R"); 

	strcpy (tmpline.description,record.description);

	categoryindex=GetCategoryIndex (record.category);
	if (categoryindex < CATEGORY_MAXNUM && record.category >= 0)
	{
		tmpline.category[0] = categoryinfo.cate[categoryindex].name [0];
		tmpline.category[1] =NULL;
	}
	*line=tmpline;
}


void ShortenLine (char* line, int length)
{
	char tmp[40];
	char tmp2[40];
	char chr[2];
	int t;
	if (GetStringLength(line,PRPFONT7N)<length)
		return;
	strcpy(tmp,"");
	strcpy(chr,"0");
	for (t=0;t<strlen(line)-1;t++)
	{
		chr[0]=line[t];
		strcat(tmp,chr);
		strcpy(tmp2,tmp);
		if (strlen(tmp2)<36)
			strcat(tmp2,"...");
		if (GetStringLength(tmp2,PRPFONT7N)>length-5)
		{
			strcpy(line,tmp2);
			return;
		}
	}
}


void LineToScreen (int* pos, _LINE line)
{
	int toppos;
	toppos=*pos;
	SetFontType(PRPFONT7N);

	WriteString(7,toppos,line.category,DRAW_BLACK); 

	WriteString(15,toppos,line.time,DRAW_BLACK); 

	WriteString(39,toppos,line.type,DRAW_BLACK); 

	ShortenLine(line.description,156-47);
	WriteString(47,toppos,line.description,DRAW_BLACK); 

	toppos=toppos+7;
	*pos=toppos;
}


void ClearAndPrintTitle ()
{
	char buf [30];
	char displayweek[3];

	ClearLCD(0);

	DrawSystemIcon(0, 0, 21, PUT); 
	DrawSystemIcon(160-17, 0, 21, PUT); 
	FillRect(9,0,160-9,11,DRAW_BLACK); 
	FillRect(0,9,160,11,DRAW_BLACK); 
	DrawSystemIcon(160-16, 2, 126, PUT); /* close */
/*	DrawSystemIcon(4, 2, 220, PUT); *//* menu */
	DrawLine(0,9,0,240,DRAW_BLACK);
	DrawLine(159,9,159,240,DRAW_BLACK);
	DrawLine(0,239,159,239,DRAW_BLACK); 
	SetFontType(PRPFONT11B); 
	strcpy(buf,title);
	strcat(buf," (wk ");
	itoa(currentweek,displayweek,10);
	strcat(buf,displayweek);
	strcat(buf,")");
	WriteString(10,0,buf,DRAW_WHITE);
}


void WriteStartupLine (char* line)
{
	SetFontType(PRPFONT11B);
	WriteString(10,startuplinepos,line,DRAW_BLACK); 
	startuplinepos=startuplinepos+15;
}

void WriteProgress (int forcewrite)
{
	int x,y,w,h,xpos;
	char line [30];
	char buf [5];

	x=30;
	y=210;
	w=100;
	h=10;

	if (forcewrite==0 && recordcount % 20 != 0) return;
	if (forcewrite==1)
	{
		strcpy(line,"Loading records...");
		WriteString(x-2,y-15,line,DRAW_BLACK); 

		DrawRect(x-2,y-2,x+w+2,y+h+2,DRAW_BLACK); 
		FillRect(x,y,x+1,y+h,DRAW_BLACK); 
	}

	if (recordcount>0)
	{
		xpos=w*recordcount/recordcountmax;
		FillRect(x,y,x+xpos,y+h,DRAW_BLACK); 
	}
}

void WriteRecords ()
{
	int t;
	int dayofweek;
	int olddayofweek;
	int toppos=15;
	_LINE line;
	for (t=0;t<filtercount;t++)
	{
		dayofweek=filterrecords[t].dayofweek;
		if (t==0 || dayofweek!=olddayofweek)
		{
			DayToScreen (&toppos,dayofweek,filterrecords[t].date);
		}
		olddayofweek=dayofweek;
		RecordToLine (filterrecords[t],&line);
		LineToScreen (&toppos, line);
		if (toppos>240-15) return;
	}
}


/*------------------------------------------------------------------------------------------------------------------*/
/* R E F R E S H   S C R E E N  */ 
/*------------------------------------------------------------------------------------------------------------------*/


void RefreshScreen ()
{
	filtercount=0;

	CollectRecords();

	SortRecords(); 

	ClearAndPrintTitle();

	WriteRecords();

	if (filtercount==0)
	{
		SetFontType(PRPFONT11B);
		WriteString(10,50,"No items to display.",DRAW_BLACK); 
		WriteString(10,65,"Try another week...",DRAW_BLACK); 

		WriteString(10,95,"If this message keeps",DRAW_BLACK); 
		WriteString(10,110,"appearing, please note:",DRAW_BLACK); 
		WriteString(10,125,"Only this years repeated",DRAW_BLACK); 
		WriteString(10,140,"schedules (cur.wk. - 5,",DRAW_BLACK); 
		WriteString(10,155,"cur.wk + 10) and the last",DRAW_BLACK); 
		WriteString(10,170,"schedules (filled to 100",DRAW_BLACK); 
		WriteString(10,185,"records) will be searched.",DRAW_BLACK); 
	}

}


/*------------------------------------------------------------------------------------------------------------------*/
/* L O A D   R E C O R D S  */ 
/*------------------------------------------------------------------------------------------------------------------*/


void GetRecord (int nMemo, _RECORD* record)
{
	FIELD_INFO fi;
	int fieldcount;
	int t;
	int offset;
	_RECORD tmprecord;

	char recbuf[1024];
	PIMHEAD* pPIMHead=(PIMHEAD*)recbuf;

	/* the category info of a record is stored in the head */
	ReadRecord (TYPE_SCHEDULE,nMemo,0,pPIMHead,sizeof(PIMHEAD));
	tmprecord.category=pPIMHead->category;

/*	fieldcount=ReadFieldInfo(TYPE_SCHEDULE,&fi);*/

	/* search through fields */
	for(t=1;t<=4;t++)
	{
		ReadRecord(TYPE_SCHEDULE,nMemo,sizeof(PIMHEAD)+t*sizeof(RECHEAD),&offset,2);
		if (t==1) /* if (!stricmp(fi.field[t].name,"Date")) */
		{
			/* read first 3 chars of date */
			ReadRecord(TYPE_SCHEDULE,nMemo,offset,&tmprecord.date,3);
		}
		if (t==2) /* if (!stricmp(fi.field[t].name,"Time")) */
		{
			/* read first 3 chars of time */
			ReadRecord(TYPE_SCHEDULE,nMemo,offset,&tmprecord.time,3);
		}
		if (t==3) /* if (!stricmp(fi.field[t].name,"Description")) */
		{
			/* read first 3 chars of description */
			ReadRecord(TYPE_SCHEDULE,nMemo,offset,&tmprecord.description,30);
			tmprecord.description[29] = NULL;
		}
		if (t==4) /*if (!stricmp(fi.field[t].name,"Repeat")) */
		{
			ReadRecord(TYPE_SCHEDULE,nMemo,offset,&tmprecord.repeat,9);
		}
	}

	CalcRecordDateProperties (&tmprecord);
	tmprecord.type=99;
	if (tmprecord.time.hour==255)
		tmprecord.type=1;
	*record=tmprecord;
}


void AddRecord (_RECORD record)
{
	if (recordcount>=recordcountmax) return;

	records[recordcount]=record;
	recordcount++;
	WriteProgress(0);
}

void AddRepeatedRecord (_RECORD record)
{
/*	if (record.week >= currentweek - minrepeatweek && record.week <= currentweek + maxrepeatweek && record.date.year == currentyear)*/
	if (record.week >= currentweek - 5 && record.week <= currentweek + 10 && record.date.year == currentyear)
		AddRecord(record);
}

int CheckRepeatWeekly (int dayofweek, int data2)
{
	unsigned char dow, data;
	int tmp, tmp2;

	if (dayofweek==1) tmp=2;
	if (dayofweek==2) tmp=4;
	if (dayofweek==3) tmp=8;
	if (dayofweek==4) tmp=16;
	if (dayofweek==5) tmp=32;
	if (dayofweek==6) tmp=64;
	if (dayofweek==7) tmp=1;

	tmp2=data2 & tmp;
	if (tmp2==tmp) return (1);
	return (0);	
}

void HandleRepeatedRecords (_RECORD record)
{
	_RECORD tmprecord;
	int days,sdays,edays;

	/* repeated by year */
	if (record.repeat.flag==4)
	{
		record.date=record.repeat.startdate;
		record.date.year=currentyear;
		CalcRecordDateProperties (&record);
		AddRepeatedRecord (record);
		return;
	}
	
	/* only this year's repeats */
	if (record.repeat.startdate.year==currentyear)
	{
		/* repeated by day */
		if (record.repeat.flag==1 && record.repeat.data2>0)
		{
			sdays=DateToDays (record.repeat.startdate);
			edays=DateToDays (record.repeat.enddate);
			if (record.repeat.enddate.year>=currentyear+1)
				edays=edays+365;
			days=sdays;
			while (days<=edays && days<364)
			{		
				record.date=DaysToDate (days,currentyear);
				CalcRecordDateProperties (&record);
				AddRepeatedRecord (record);
				days+=record.repeat.data2;
			}
			return;
		}

		/* repeated by week */
		if (record.repeat.flag==2 && record.repeat.data2>0)
		{
			sdays=DateToDays (record.repeat.startdate);
			edays=DateToDays (record.repeat.enddate);
			if (record.repeat.enddate.year>=currentyear+1)
				edays=edays+365;
			days=sdays;
			while (days<=edays && days<364)
			{		
				record.date=DaysToDate (days,currentyear);
				CalcRecordDateProperties (&record);
				if (CheckRepeatWeekly(record.dayofweek, record.repeat.data2)==1)
					AddRepeatedRecord (record);	
				days+=1;
			}
			return;
		}
	}
}

void LoadRecords (int recordtype)
{
	unsigned int memocount,alivememocount;
	_RECORD record;
	int t;

	/* reads all the categories for the schedules */
	ReadCategoryInfo (TYPE_SCHEDULE, &categoryinfo);

	/* get number of memo's */
	GetRecordCount(TYPE_SCHEDULE,&memocount,&alivememocount);

	t=alivememocount-(recordcountmax - recordcount); /*maxrecords;*/
	if (t<0) t=0;

	if (recordtype==1)
		t=0;

	while (t<alivememocount)
	{
		GetRecord (t, &record);

		if (recordtype==1)
		{
			/* handle repeatable records for only the current year. */
			if (record.repeat.startdate.year != 0)
				HandleRepeatedRecords (record);
			else return;
		}
		else 
			AddRecord(record);

		t++;
	}
}


/*------------------------------------------------------------------------------------------------------------------*/
/* M A I N  */ 
/*------------------------------------------------------------------------------------------------------------------*/


int main()
{
	int key;
	int week;
	unsigned char penx,peny;
	unsigned char language;
	int slen;
	char buf[100];
	char buf1[20];

	GetDate(&currentdate);
	currentweek=DaysFrom1stMonday (DateToDays(currentdate), currentdate.year) / 7;
	currentyear=currentdate.year;

	ClearAndPrintTitle();
	startuplinepos=50;
	strcpy(buf,"Welkom by ");
	strcat(buf,title);
	WriteStartupLine(buf);
	WriteStartupLine("");
	WriteStartupLine("Please wait until the ");
	WriteStartupLine("following 100 schedule");
	WriteStartupLine("items are loaded:");
	WriteStartupLine(" This year's repeatable");
	WriteStartupLine("   schedules (cur.wk. - 5,");
	WriteStartupLine("   cur.wk. + 10).");
	WriteStartupLine(" The last of schedules.");

	SetFontType(PRPFONT11N);

	WriteProgress (1);

	recordcount=0;

	LoadIndexTable(TYPE_SCHEDULE);

	LoadRecords(1);
	LoadRecords(0);
	RefreshScreen();

	/* while(!(key=GetKey(&penx,&peny))); */
	while(1) 
	{
	        key=GetKey(&penx,&peny);
		if (key) 
		{
			if (key==PGUP) 
			{
				/* goto previous week */
				currentweek=currentweek-1;
				if (currentweek < 1) 
				{
					currentweek=52;
					currentyear=currentyear-1;
				}
				RefreshScreen();
			}  
			else if (key==PGDN) 
			{
				/* goto next week */
				currentweek=currentweek+1;
				if (currentweek > 52) 
				{
					currentweek=1;
					currentyear=currentyear+1;
				}
				RefreshScreen();
			}
			else if (key==PENDOWN) 
			{	
				if (penx >= 147 && penx <= 155 && peny >= 3 && peny <= 10) 
				{
					PenBeep();	/* Make a 'penclick' sound. */
					break;
				}
			}
			else if (key==ADDRESS || key==SCHEDULE || key==TASK || key==MEMO || key==CALENDAR || key==EXPENSES || key==CALCULATOR || key==FIND || key==TABLE || key==APPLICATION)
				break;
		}
	}
	return key; 
}


