/********************************************************
 * 
 * Title: Kralj
 *
 * Author: Jurica Jurjevic
 *
 * Timestamp: 2000/02/02 02:45:47
 *
 *
 * Alle chess calculations/algorithmics (not the engine)
 * are checked here
 *
 ********************************************************/

#ifndef _chess_h
#define _chess_h

#include "kralj.h"

/********************************************************
 * Prove if the selected move goes ok
 * If the move is Ok, the internal settings are set
 * in this function
 * Return TRUE if ok, else FALSE to prevent the move
 ********************************************************/
unsigned char chess_make_move();

/********************************************************
 * Returns the field position with its occupy.
 ********************************************************/
Field get_chessboard_field(unsigned char x, unsigned char y);

/********************************************************
 * Reset the board - setup the startup positions
 ********************************************************/
void reset_board();

/********************************************************
 * Now we capture the figure at the position (posx, posy)
 ********************************************************/
void capture(unsigned char posx, unsigned char posy );

/********************************************************
 * Check if the figure is able to make such a move
 * TRUE if ok, FALSE if not
 ********************************************************/
unsigned char check_figure_move(unsigned char f, Field s, Field d );

/********************************************************
 * Check if there are any figures between the to fields
 * Allowed destinations are - \ | /
 ********************************************************/
unsigned char check_figures_between( unsigned char f, Field s, Field d );


#endif