/********************************************************
 * 
 * Title: Kralj
 *
 * Module: Game
 *
 * Type: Header
 *
 * Author: Jurica Jurjevic
 *
 * Timestamp: 2000/02/22 20:29:54
 *
 *
 * Game operations like reseting or saving game are
 * performed in this modul
 *
 ********************************************************/

#ifndef _game_h
#define _game_h

/*
 * Gametypes
 */
#define GAMETYPE_UNLIMITED 0
#define GAMETYPE_TIMER 1
#define GAMETYPE_INCREMENT 2

/*
 * Playetypes
 */
#define PLAYERTYPE_HUMAN 0
#define PLAYERTYPE_AVIGO 1


/*
 * Definition of type "new game"
 */
typedef struct gametype
{
	unsigned char game_type;
	unsigned char white_player;
	unsigned char black_player;
	unsigned char level_white;
	unsigned char level_black;
	unsigned char timer_minute;
	unsigned char timer_second;	
	unsigned char increment_minute;
	unsigned char increment_second;
} GameType;


/*
 * Reset the complete game to a new game
 */
void reset_game( GameType gt );

/*
 * Reset the options
 */
void reset_options();


#endif