/* you have to include all those header files
*/

#include "p100plib.h"
#include "ressdk.h"
#include "math.h"
#include "packet.h"

#include "sun.h"

double Pi=3.1415926535897931;

double Julian (int Y, int M, int D, int h, int m, int s)
{	double a,T;
	int b;
	if (M<=2) { M+=12; Y--; }
	if ((Y<1582) || ((Y==1582)&&(M<10)) || ((Y==1582)&&(M==10)&&(D<=4)))
		b=(Y+4716)/4-1181;
	else b=Y/400-Y/100+Y/4;
	a=365.0*Y-679004.0;
	T=a+b+floor(30.6001*(M-1))+D+(h+(m+s/60.0)/60.0)/24.0;
	return T;	
}

double Epoche2000 (int y, int m, int d, int h, int mi, int s)
{	return Julian(y,m,d,h,mi,s)
		-Julian(2000,1,1,12,0,0);
}
	
double mod (double x, double y)
{	double h;
	if (x>0)
	{	h=x/y;
		return x-dint(&h)*y;
	}
	else if (x==0) return 0;
	else
	{	x=0-x;
		h=x/y;
		return y-(x-dint(&h)*y);
	}
}

double floor (double x)
{	if (x>0) return dint(&x);
	else if (x==0) return x;
	else
	{	x=0-x;
		return 0-dint(&x)-1;
	}
}

double sinprim (double x)
{	double res,h,s;
	int i=2;
	res=x;
	h=x;
	s=1;
	while (fabs(h)>1e-10)
	{	h*=x*x/i/(i+1);
		i+=2;
		s=0-s;
		res+=s*h;
	}
	return res;
}

double cosprim (double x)
{	double res,h,s;
	int i=1;
	res=1;
	h=1;
	s=1;
	while (fabs(h)>1e-10)
	{	h*=x*x/i/(i+1);
		i+=2;
		s=0-s;
		res+=s*h;
	}
	return res;
}

double sin (double x)
{	double sign;
	x=mod(x,2*Pi);
	sign=1.0;
	if (x>Pi)
	{	x=x-Pi; sign=-1.0;
	}
	if (x>Pi/2) x=Pi-x;
	if (x>Pi/4) return sign*cosprim(Pi/2-x);
	else return sign*sinprim(x);
}

double cos (double x)
{	return sin(x+Pi/2);
}

double acos (double x)
{	double res,resold;
	if (x>=1) return 0;
	if (x<=-1) return Pi;
	res=Pi/2;
	do
	{	resold=res;
		res=res+(cos(res)-x)/sin(res);
	}
	while (fabs(res-resold)>1e-8);
	return res;
}

double asin (double x)
{	double res,resold;
	if (x>=1) return Pi/2;
	if (x<=-1) return 0-Pi/2;
	res=0;
	do
	{	resold=res;
		res=res-(sin(res)-x)/cos(res);
	}
	while (fabs(res-resold)>1e-8);
	return res;
}

double sinDeg (double x)
{	return sin(x/180*Pi);
}

double cosDeg (double x)
{	return cos(x/180*Pi);
}

double asinDeg (double x)
{	return asin(x)/Pi*180;
}

double acosDeg (double x)
{	return acos(x)/Pi*180;
}

double computeSun (double T, double La, double Lo, double altitude, int sign)
{	static double utnew,utold,t,L,G,EC,Lambda,E,GHA,Obl,Delta,c,correction;
	int iter;
	utnew=180;
	utold=0;
	iter=0;
	while (fabs(utold-utnew)>0.1)
	{	utold=utnew;
		t=T+utold/(360.0*36525.0);
		L=280.46+36000.77*T;
		G=357.528+35999.05*T;
		EC=1.915*sinDeg(G)+0.02*sinDeg(2*G);
		Lambda=L+EC;
		E=0-EC+2.466*sinDeg(2*Lambda)-0.053*sinDeg(4*Lambda);
		GHA=utold-180+E;
		Obl=23.4393-0.0130*T;
		Delta=asinDeg(sinDeg(Obl)*sinDeg(Lambda));
		c=(sinDeg(altitude)-sinDeg(La)*sinDeg(Delta))
			/(cosDeg(La)*cosDeg(Delta));
		if (c>1) correction=0;
		else if (c<-1) correction=180;
		else correction=acosDeg(c);
		utnew=utold-(GHA+Lo-sign*correction);
		iter++;
		if (iter>=5) break;
	}
	if (iter>=5) return -100;
	else return utnew;
}

double computePhase (double T)
{	double D,M,Mprime,T2,T3,T4;
	T2=T*T;
	T3=T2*T;
	T4=T3*T;
	D = 297.8502042
	     + 445267.1115168 * T
	     - 0.0016300 * T2
	     + T3 / 545868
	     + T4 / 113065000;
	M = 357.5291092
	     + 35999.0502909 * T
	     - 0.0001536 * T2
	     + T3 / 24490000;
	Mprime = 134.9634114
	     + 477198.8676313 * T
	     + 0.0089970 * T2
	     - T3 / 3536000
	     + T4 / 14712000;

	return mod(180 - D
			- 6.289 * sinDeg(Mprime)
			+ 2.100 * sinDeg(M)
			- 1.274 * sinDeg(2*D - Mprime)
			- 0.658 * sinDeg(2*D)
			- 0.214 * sinDeg(2*Mprime)
			- 0.110 * sinDeg(D),360);
}
