#include <avsys.h>
#include "avicons.h"

#define maxe1 62
#define maxe2 70
#define maxe3 83
#define maxc1 19
#define maxc2 20
#define maxc3 24

char appname[]="BuzzGen 0.3";
char about_text[]="Written by Mark Roedel\nroedelm@letu.edu\n\nPorted from code by\nDavid McLeod";

unsigned char penx,peny;
int exit,option,slen,x;
char * print_message;
char * p_menu;
int (*MenuHandler) ();

static char word1[maxe1][maxc1] = {
  	"Exclusive", "Total", "Fundamental", "Phased", "Integrated", 
	"Object-based", "Devolved", "Distributed", "Right-sized",
	"Decentralized", "Centralized", "Ameliorated", "Digitized",
	"Networked", "Focused", "Synergized", "Polarized", "Advanced",
	"Assimilated", "Optional", "Synchronized", "Compatible", 
	"Function-based", "Future-proofed", "Managed", "Organized",
	"Up-sized", "Down-sized", "Mandatory", "Customer-focused",
	"Business-focused", "Profit-focused", "Standalone", "Organic",
	"Quality-focused", "Secured", "Extended", "Cloned", "Balanced",
	"Reverse-engineered", "Synergistic", "Vision-oriented",
	"Enterprise-wide", "De-engineered", "Cross-group", 
	"Re-engineered", "Open-architected", "Front-line", "Optimized",
	"Grass-roots", "Horizontal", "Multi-tiered", "Team-oriented",
	"Face-to-face", "Versatile", "Progressive", "Persevering", 
	"Diverse", "Automated", "Proactive", "Reactive", "Realigned"
};

static char word2[maxe2][maxc2] = {
	"client-server", "didactic", "radial", "user-facing", "eco-centric",
	"uniform", "composite", "holistic", "stable", "coherent", "discrete",
	"heuristic", "hybrid", "modular", "optimal", "homogeneous",
	"incremental", "logistical", "mobile", "dynamic", "executive",
	"RAD/JAD", "human-resource", "empowering", "vertical", "cohesive",
	"systematic", "responsive", "reciprocal", "transitional",
	"2nd generation", "3rd generation", "4th generation", "5th generation",
	"scalable", "fault-tolerant", "WYSIWYG", "local", "national", 
	"global", "regional", "neural", "24-hour", "value-added", 
	"multimedia", "systematic", "maximized", "clear-thinking",
	"optimizing", "motivating", "well-modulated", "fresh-thinking",
	"keen", "even-keeled", "upward-trending", "methodical", "tangible",
	"bottom-line", "actuating", "analyzing", "encompassing", "exuding",
	"solution-oriented", "attitude-oriented", "client-driven",
	"needs-based", "zero-administration", "zero-tolerance",
	"zero-defect", "just-in-time"
};

static char word3[maxe3][maxc3] = {
	"hub", "paradigm", "concept", "contingency", "flexibility", 
	"methodology", "project", "definition", "projection", "task-force",
	"moderator", "implementation", "structure", "ability", "scenario",
	"challenge", "solution", "installation", "knowledgebase", 
	"inheritance", "throughput", "approach", "alliance",
	"implementation", "data-warehouse", "migration", "interface",
	"moratorium", "parallelism", "monitoring", "policy", "capability",
	"middleware", "hardware", "software", "GUI", "LAN/WAN", "intranet",
	"toolset", "product", "support", "helpdesk", "groupware",
	"hit-squad", "model", "orchestration", "emulation", "collaboration",
	"focus group", "success", "conglomeration", "attitude",
	"pricing structure", "workforce flexibility", "synergy",
	"system engine", "alliance", "utilization", "GUI",
	"open architecture", "open system", "initiative", 
	"knowledge user", "superstructure", "frame",
	"customer loyalty", "productivity", "flex-time", "framework",
	"complexity", "protocol", "matrix", "matrices", "core",
	"website", "process improvement", "business partner", "leverage",
	"executive solution", "secured line", "artificial intelligence",
	"budgetary management", "forecast"
};

int buzzword1() { char* message; FillRect(16,80,144,90,DRAW_WHITE); message=word1[random(maxe1)]; WriteString((160-GetStringLength(message,PRPFONT11B))/2,80,message,DRAW_BLACK); }
int buzzword2() { char* message; FillRect(16,95,144,105,DRAW_WHITE); message=word2[random(maxe2)]; WriteString((160-GetStringLength(message,PRPFONT11B))/2,95,message,DRAW_BLACK); }
int buzzword3() { char* message; FillRect(16,110,144,120,DRAW_WHITE); message=word3[random(maxe3)]; WriteString((160-GetStringLength(message,PRPFONT11B))/2,110,message,DRAW_BLACK); }

int AboutHandler() {
	MessageBox(about_text,cmOK);
	return 0;
}


int RerollHandler() {
	SetFontType(PRPFONT11B);
        DrawRect(15,79,145,91,DRAW_BLACK); buzzword1();
	DrawRect(15,94,145,106,DRAW_BLACK); buzzword2();
	DrawRect(15,109,145,121,DRAW_BLACK); buzzword3();
	return 0;
}

int ExitHandler() {
	return 1;
}

char *menu_options[]={"About","Reroll","Exit"};
int m_items=3,(*MenuPTR[3])()={AboutHandler,RerollHandler,ExitHandler};

int menu() {
	while(GetKey(&penx,&peny)) {
		if(peny>9) {
			DrawSystemIcon(3, 2, 220, PUT);      
		} else {
			DrawSystemIcon(3, 2, 315, PUT);
		}
	}

	if(peny<9) {
		DrawLine(79,12,79,m_items*14+9,DRAW_B1DOT);
		DrawLine(80,10,80,m_items*14+8,DRAW_BLACK);
		DrawLine(1,m_items*14+9,79,m_items*14+9,DRAW_B1DOT);
		DrawLine(2,m_items*14+10,77,m_items*14+10,DRAW_BLACK);

		/* Write menu choices on screen */
		for(x=0;x<m_items;x++) {
			WriteString(2,13*(x+1),menu_options[x],DRAW_BLACK);
		}

		/* Wait for a pen click and process */
		while(!(GetKey(&penx,&peny)));

		/* Find area clicked and call corresponding handler */
		if(peny>11&&penx<80&&peny<m_items*14+9) {
			FillRect(1,12,80,m_items*14+10,DRAW_WHITE);
			DrawSystemIcon(3, 2, 220, PUT);

			/* "formula" to derive choice clicked */
			x=(peny-9-((peny-9)%14))/14;

			MenuHandler=MenuPTR[x];
			option=MenuHandler();
		} else {
			DrawSystemIcon(3, 2, 220, PUT);
			FillRect(1,12,80,m_items*14+10,DRAW_WHITE);
		}
	} else {
		DrawSystemIcon(3, 2, 220, PUT);
	}
	return option;
}


int exitbutton(int exit) {
    	DrawSystemIcon(144, 2, 129, PUT);
    	while(GetKey(&penx,&peny)) {
       		if(!(penx>145&&penx<157&&peny<12&&peny>2)) {
        		DrawSystemIcon(144, 2, 126, PUT);       
       		} else {
        		DrawSystemIcon(144, 2, 129, PUT);       
       		}
      	}
        exit=0;
       	if(penx>145&&penx<157&&peny<12&&peny>2) {
        	DrawSystemIcon(144, 2, 126, PUT);       
        	exit=1;
       	}
	DrawSystemIcon(144, 2, 126, PUT);
     	return exit;
}

int main()
{
	int key;
	unsigned char penx,peny;
	int slen;

	randomize();

	ClearLCD(0);

	/* Draw the menu bar */
    	SetFontType(PRPFONT11B);
    	DrawRect(0,11,159,239,DRAW_BLACK);
    	DrawSystemIcon(0, 0, 43, PUT);
    	DrawSystemIcon(147, 0, 43, PUT);
    	FillRect(0,9,160,10,DRAW_BLACK);
    	FillRect(9,0,150,9,DRAW_BLACK);
    	DrawSystemIcon(144, 2, 126, PUT);
    	DrawSystemIcon(3, 2, 220, PUT);

	/* add white dots... =) */
    	slen=GetStringLength(appname,PRPFONT11N);
    	DrawLine(slen+21,8,143,8,DRAW_W3DOT);

	/* add the titlebar text */
	WriteString(14,0,appname,DRAW_WHITE);

	SetFontType(PRPFONT11B);

        DrawRect(15,79,145,91,DRAW_BLACK); buzzword1();
	DrawRect(15,94,145,106,DRAW_BLACK); buzzword2();
	DrawRect(15,109,145,121,DRAW_BLACK); buzzword3();

	SetFontType(PRPFONT11N);

	print_message="Touch one of the boxes";
	WriteString((160-GetStringLength(print_message,PRPFONT11N))/2,150,print_message,DRAW_BLACK);
	print_message="to re-select that word";
	WriteString((160-GetStringLength(print_message,PRPFONT11N))/2,160,print_message,DRAW_BLACK);
	print_message="or pick 'Reroll' from";
	WriteString((160-GetStringLength(print_message,PRPFONT11N))/2,170,print_message,DRAW_BLACK);
	print_message="the menu to re-select";
	WriteString((160-GetStringLength(print_message,PRPFONT11N))/2,180,print_message,DRAW_BLACK);
	print_message="them all";
	WriteString((160-GetStringLength(print_message,PRPFONT11N))/2,190,print_message,DRAW_BLACK);

	while(!exit) {
		while (!(key=GetKey(&penx,&peny)));
		/* Check for exit button click */
     		if(penx>145&&penx<157&&peny<12&&peny>2) {
			exit=exitbutton(exit);
		}

		/* Check for and handle menu click */
		if(penx>2&&penx<14&&peny>1&&peny<9) {
			exit=menu();
		}

		/* Check for clicks on individual words */
		if(penx>20&&penx<140&&peny>79&&peny<91) buzzword1();
		if(penx>20&&penx<140&&peny>94&&peny<106) buzzword2();
		if(penx>20&&penx<140&&peny>109&&peny<121) buzzword3();
	}
	return key;
}
