/**********************************************************************
Project:    Maze for Avigo
Module:     Main
File:       amazea.h

    A Mazing Avigo Copyright (c) 1998 by Jouni Miettunen
**********************************************************************/

#ifndef __AMAZEA_H
#define __AMAZEA_H

/***** Include files *****/
#include <avsys.h>
#include "avicons.h"

/***** Defines *****/

#define PROGRAM_TITLE "A Mazing Avigo"

/* Playing area offset from top of the screen */
#define OFFSET_Y 16
#define OFFSET_X 3
#define MX 19
#define MY 27

#define MODE_EXIT	0
#define MODE_NEW	1

#define FLAG_OPEN_UP	0x1
#define FLAG_OPEN_LEFT	0x2
#define FLAG_OPEN_DOWN	0x4
#define FLAG_OPEN_RIGHT	0x8
#define FLAG_TILE_DOT	0x10

/***** Global variables *****/
int
	gManx = 0,
	gMany = 0;
int
	gMode = MODE_EXIT;	/* Current game mode */

char gMap[MX][MY] = {{0}};

/***** Command button definitions *****/
#define EXIT_X1 145
#define EXIT_Y1 2
#define EXIT_X2 157
#define EXIT_Y2 12

#define MENU_X1 3
#define MENU_Y1 2
#define MENU_X2 15
#define MENU_Y2 12

/*
typedef struct
{
	unsigned char	title[16];
	unsigned char	x1;
	unsigned char	y1;
	unsigned char	x2;
	unsigned char	y2;
	unsigned char	left_normal;
	unsigned char	left_hilight;
	unsigned char	right_normal;
	unsigned char	right_hilight;
} Button;

Button button_new =
{
	"New Maze",
	20,215,
	81,231,
	19,22,
	23,26
};
*/

#define STR_NEW_GAME	"New Maze"
#define NEW_X1	16
#define NEW_Y1	220
#define NEW_X2	77
#define NEW_Y2	236

/***** Function prototypes */
int main();
void init_screen();
void generate_maze();
void draw_maze();
int move_in_maze();

int CountOpenings(int x, int y);
int CanWalk(int x, int y);
int GetLocation(int* x, int* y);
void MakeMaze(int begx, int begy);

void draw_tile(int x,int y);
int move_man(int dx,int dy);
int handle_pen_press (int x,int y);
int handle_exit_button();
int handle_menu_button();
int handle_big_button(int x1,int y1,int x2, int y2);

#endif /* __AMAZEA_H */

/**********************************************************************/
/*************************** A HAPPY END ******************************/
/**********************************************************************/
