/* you have to include all those header files
*/

#include "p100plib.h"
#include "ressdk.h"
#include "math.h"
#include "packet.h"

/* you have to decleare a static string for the window
  title 
*/

unsigned char test_title[] = "Test Title";

/* you have to declere the event handlers BANKED and extern
*/

extern BANKED void test_draw (VOID_PTR view);
extern BANKED void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y);

/* define the command constants (belongs to a header file)
*/

#define cmdNew 1000

/* define the main menu structure
*/

const MENUITEM MainMenu[] =
{   {"New Numbers", cmdNew, 0},
    {"Exit", cmCancel, 0},
    {"\0", 0, 0}
};

/* those are the routines to generate Lotto numbers
*/

#define Ntotal 49
#define Nchosen 6
int Numbers[Ntotal];

void init_numbers ()
/* initialize the first 6 as chosen
*/
{   int i;
    for (i=0; i<Ntotal; i++) Numbers[i]=0;
    for (i=0; i<Nchosen; i++) Numbers[i]=1;
}

void mix_numbers ()
/* randomly mix them (thanks to the random() function)
*/
{   int i,j,h;
    for (i=Ntotal-1; i>0; i--)
    {   j=random(i+1);
        if (j!=i)
        {   h=Numbers[j]; Numbers[j]=Numbers[i]; Numbers[i]=h;
        }
    }
}

/* this is the definition of the drawing routine,
which is inserted for the main window with the
help of the BankedAssign() function.
*/

void test_draw (VOID_PTR view)
{   /* the pointer is really a point to a DESKBOX */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    int i,y; /* C++ like (variables need not be at function start) */

    PDESKBOX_draw(view); /* default, clears the view */

    SetFontType (PRPFONT14B); /* biggest font available */

    unsigned char s[256]; /* for forming the string */
    y=dsk->top+40; /* the row of the first string */

    for (i=0; i<Ntotal; i++) /* draw all chosen numbers */
        if (Numbers[i])
        {   /* convert to string and draw */
            NumericToStr((double)(i+1),s,DTINTEGER);
            WriteString(dsk->left+20,y,s,0);
            y+=20; /* increment row */
        }
}

/* the event handler for the menu commands and for
 the main window
*/

void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y)
{   /* convert view to deskbox */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    /* call default handler (don't know why) */
    PDESKBOX_handleEvent(view,evType,x,y);

    /* switch events */
    if (*evType==evCommand)
    {   switch (TOWORD(x,y))
        {   case cmdNew : /* user wants other numbers */
                ClearEvent(evType); /* event taken */
                mix_numbers(); /* shuffle */
                dsk->draw(view); /* redraw window */
                break;
        }
    }
}

short main (void)
{
    /* pointer to the main window (properly destroy it at end) */
    PDESKBOX *dsk;

    /* init our Lotto numbers */
    init_numbers();
    randomize();
    mix_numbers();

    /* create a window covering all of the screen
       with a menu, a title and a close box */
    dsk = (PDESKBOX *)CreateDeskBox('A',0,0,159,239,
        MK_FAR_PTR(test_title),MK_FAR_PTR(MainMenu),0,
        bafClose|bafDotTitle);
    dsk->options &= ~ofFindable; /* no find in this application */

    /* assign the event handlers to this window */
    BankedAssign(dsk->handleEvent,test_handle_event);
    BankedAssign(dsk->draw,test_draw);

    /* seems to generate the main event loop */
    ExecView ((PGROUP *) dsk);

    /* destroy the window */
    Destroy ((VOID_PTR) dsk);
    
    return 0;
}
