XTOP    .EQU    $8010
YTOP    .EQU    $8011
XBOT    .EQU    $8012
YBOT    .EQU    $8013
POINTER .EQU    $801A

LAT     .equ    $8020
LONG    .equ    $8022
VARH    .equ    $8024
VARM    .equ    $8026
VARN    .equ    $8028
VARL    .equ    $8029
VARO    .equ    $802B
VARE    .equ    $802D
VARU    .equ    $802F
VARW    .equ    $8031
VARX    .equ    $8033
VARY    .equ    $8034
VARXX   .equ    $8035
VARYY   .equ    $8036
SM1     .equ    $8037
SM2     .equ    $8038
RES1    .equ    $8039
SRES1   .equ    $803D
RES2    .equ    $803E
SRES2   .equ    $8042
GRID    .equ    $8043
MS10    .equ    $8044

        .ORG    $4000                   ;Start at $4000H
        JP      START                   ;Go to the starting code

        .ORG    $4003
        .byte   0A9H," M. LORANG 1998"  ;16 Bytes of copyright information

	.ORG    $4013
        .byte   "PDE 2.00        "      ;16 Bytes of OTHER information

	.ORG    $4023
        .byte   02H                     ;Access program from apps screen
                                        ;Change to 01 for menu access

	.ORG    $4024
        .byte   0B0H,55H               ;Data for something?

	.ORG    $4026
        .byte   97,4,26                 ;** Creation date
                                        ; 97 = 1998
                                        ;  4 = Month of APRIL
                                        ; 26 = Date of 26th

        .ORG    $4029
        .byte   0DH,20H,38H             ;Data for something?

        .ORG    $402C
        .byte   "Hello world",0,0,0,0,0 ;16 Bytes for Application Name

        .ORG    $403C
        .byte   01H,04H                 ;Version Number MSB.LSB
                                        ;eg: ver 1.4
 
        .ORG    $403E
        .byte   10H,00H                 ;Data for something?

        .ORG    $4040
        .byte   10H                     ;Amount of data to transmit
                                        ; 10H = 1x16 = 16k of data
                                        ; 50H = 5x16 = 80k of data

        .ORG    $4041
        .byte   00H,50H,0AAH            ;Data for something?

        .ORG    $4044
        .byte   34H,32H                 ;ICON dimensions MSB x LSB (52x50)
        .byte   00H                     ;Terminator

	.ORG    $4047
        ; ICON Data 350 bytes
        ; 7 bytes x 50 lines  (Icon is 52x50)
ICON:
.byte 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
.byte 00000000b,00000000b,00000111b,11111100b,00000000b,00000000b,00000000b
.byte 00000000b,00000000b,00111111b,01011111b,10000000b,00000000b,00000000b
.byte 00000000b,00000000b,11010010b,01001001b,01100000b,00000000b,00000000b
.byte 00000000b,00000001b,00100100b,01000100b,10010000b,00000000b,00000000b
.byte 00000000b,00000110b,01000100b,01000100b,01001100b,00000000b,00000000b
.byte 00000000b,00001000b,10001000b,01000010b,00100010b,00000000b,00000000b
.byte 00000000b,00010000b,10001000b,01000010b,00100001b,00000000b,00000000b
.byte 00000000b,00101001b,00001000b,01000010b,00010010b,10000000b,00000000b
.byte 00000000b,00100110b,00010000b,01000001b,00001100b,10000000b,00000000b
.byte 00000000b,01000011b,00010000b,01000001b,00011000b,01000000b,00000000b
.byte 00000000b,10000010b,11110000b,01000001b,11101000b,00100000b,00000000b
.byte 00000000b,10000100b,00011100b,01000111b,00000100b,00100000b,00000000b
.byte 00000001b,00000100b,00100011b,11111000b,10000100b,00010000b,00000000b
.byte 00000001b,00000100b,00100000b,01000000b,10000100b,00010000b,00000000b
.byte 00000001b,00001000b,00100000b,01000000b,10000010b,00010000b,00000000b
.byte 00000010b,00001000b,00100000b,01000000b,10000010b,00001000b,00000000b
.byte 00000010b,00001000b,00100000b,01000000b,10000010b,00001000b,00000000b
.byte 00000010b,00001000b,00100000b,01000000b,10000010b,00001000b,00000000b
.byte 00000010b,00001000b,00100000b,01000000b,10000010b,00001000b,00000000b
.byte 00000011b,11111111b,11111111b,11111111b,11111111b,11111000b,00000000b
.byte 00000010b,00001000b,00100000b,01000000b,10000010b,00001000b,00000000b
.byte 00000010b,00001000b,00100000b,01000000b,10000010b,00001000b,00000000b
.byte 00000010b,00001000b,00100000b,01000000b,10000010b,00001000b,00000000b
.byte 00000010b,00001000b,00100000b,01000000b,10000010b,00001000b,00000000b
.byte 00000001b,00001000b,00100000b,01000000b,10000010b,00010000b,00000000b
.byte 00000001b,00000100b,00100000b,01000000b,10000100b,00010000b,00000000b
.byte 00000001b,00000100b,00100011b,11111000b,10000100b,00010000b,00000000b
.byte 00000000b,10000100b,00011100b,01000111b,00000100b,00100000b,00000000b
.byte 00000000b,10000010b,11110000b,01000001b,11101000b,00100000b,00000000b
.byte 00000000b,01000011b,00010000b,01000001b,00011000b,01000000b,00000000b
.byte 00000000b,00100110b,00010000b,01000001b,00001100b,10000000b,00000000b
.byte 00000000b,00101001b,00001000b,01000010b,00010010b,10000000b,00000000b
.byte 00000000b,00010000b,10001000b,01000010b,00100001b,00000000b,00000000b
.byte 00000000b,00001000b,10001000b,01000010b,00100010b,00000000b,00000000b
.byte 00000000b,00000110b,01000100b,01000100b,01001100b,00000000b,00000000b
.byte 00000000b,00000001b,00100100b,01000100b,10010000b,00001000b,10100000b
.byte 00000000b,00000000b,11010010b,01001001b,01100000b,00001000b,10100000b
.byte 00000000b,00000000b,00111111b,01011111b,10000001b,01001000b,11100000b
.byte 00000000b,00000000b,00000111b,11111100b,00000001b,01001000b,00100000b
.byte 00000000b,00000000b,00000000b,00000000b,00000000b,10001010b,00100000b
.byte 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
.byte 01000100b,00000100b,10000000b,00100010b,00000000b,00010000b,00100000b
.byte 01000100b,00000100b,10000000b,00100010b,00000000b,00010000b,00100000b
.byte 01000100b,11100100b,10001110b,00100010b,01110010b,11010001b,10100000b
.byte 01111101b,00010100b,10010001b,00101010b,10001011b,00010010b,01100000b
.byte 01000101b,11110100b,10010001b,00101010b,10001010b,00010010b,00100000b
.byte 01000101b,00000100b,10010001b,00110110b,10001010b,00010010b,00100000b
.byte 01000100b,11100010b,01001110b,00100010b,01110010b,00001001b,11100000b
.byte 00000000b,00000000b,00000000b,00000000b,00000000b,00000000b,00000000b
;
	.byte	0FFH,0FFH,0FFH,0FFH		;Blank space?
	.byte	0FFH,0FFH,0FFH,0FFH
	.byte	0FFH,0FFH,0FFH,0FFH
	.byte	0FFH,0FFH,0FFH,0FFH
;
;
;This is the start of the program code...
;
START:  CALL    CLRSCN
        LD      A,13                    ;SET INVERSE LINE AT THE TOP
        LD      (YBOT),A                ;16 PIXELS HIGH
        LD      A,160                   ;160 PIXELS ACROSS
        LD      (XBOT),A
        LD      A,1                     ;2ND PIXEL LINE
        LD      (YTOP),A
        XOR     A                       ;FOR THE WHOLE LINE
        LD      (XTOP),A
        LD      A,$01                   ;TURN PIXELS ON
        CALL    CLRP0

        LD      L,1                     ;SET BOLD TYPE
        CALL    $00D5
        LD      HL,TITLE                ;SHOW THE TITLE
        LD      (POINTER),HL
        LD      A,2
        LD      (YTOP),A
        LD      A,3
        LD      (XTOP),A
        LD      A,1                     ;SET INVERSE TYPE
        CALL    PUTS0

        LD      HL,MS01                 ;SHOW LINE AT BOTTOM
        LD      (POINTER),HL
        LD      A,196
        LD      (YTOP),A
        XOR     A
        LD      (XTOP),A
        CALL    PUTSCR

        LD      HL,MS02                 ;SHOW LINE AT BOTTOM
        LD      (POINTER),HL
        LD      A,207
        LD      (YTOP),A
        XOR     A
        LD      (XTOP),A
        CALL    PUTSCR

        LD      HL,MS03                 ;SHOW LINE AT BOTTOM
        LD      (POINTER),HL
        LD      A,218
        LD      (YTOP),A
        XOR     A
        LD      (XTOP),A
        CALL    PUTSCR

        LD      HL,MS04                 ;SHOW LINE AT BOTTOM
        LD      (POINTER),HL
        LD      A,229
        LD      (YTOP),A
        LD      A,16
        LD      (XTOP),A
        CALL    PUTSCR

        ld      HL,MS08
        ld      (POINTER),HL
        ld      A,174
        ld      (YTOP),A
        ld      A,6
        ld      (XTOP),A
        call    PUTSCR

        ld      HL,MS09
        ld      (POINTER),HL
        ld      A,185
        ld      (YTOP),A
        xor     A
        ld      (XTOP),A
        call    PUTSCR

        LD      A,229                   ;SET INVERSE LINE AT THE BOTTOM
        LD      (YBOT),A                ;1 PIXEL HIGH
        LD      A,160                   ;160 PIXELS ACROSS
        LD      (XBOT),A
        LD      A,229
        LD      (YTOP),A
        XOR     A                       ;FOR THE WHOLE LINE
        LD      (XTOP),A
        LD      A,1                     ;TURN PIXELS ON
        CALL    CLRP0

PLOT1:  ld      HL,0            ; center latitude  = 0 (Equator)
        ld      (LAT),HL        ;        longitude = 0 (Greenwich)
        ld      (LONG),HL
        xor     A
        ld      (GRID),A        ; no meridians & parallels

PLOT:   LD      A,0             ; erase the plot array
        LD      (XTOP),A
        LD      A,16
        LD      (YTOP),A
        LD      A,159
        LD      (XBOT),A
        LD      A,172
        LD      (YBOT),A
        CALL    CLRPIX
        LD      A,79            ; Set the circle
        LD      (XBOT),A
        LD      A,94
        LD      (YTOP),A
        LD      A,80
        LD      (XTOP),A
        CALL    DRAW_CIRCLE

; here starts the continent drawing
        ld      HL,(LAT)
        call    CALCSIN         ; h = sin(LAT)
        ld      (VARH),BC

        ld      HL,(LAT)
        call    CALCCOS         ; m = cos(LAT)
        ld      (VARM),BC

        ld      HL,WORLD        ; init world pointer

        ld      A,(HL)          ; 1st sequence of coordinates
        ld      (VARN),A

BCLSC:  inc     HL              ; 1st latitude of sequence
        ld      E,(HL)
        inc     HL
        ld      D,(HL)
        ld      (VARL),DE
        inc     HL              ; 1st longitude of sequence
        ld      C,(HL)
        inc     HL
        ld      B,(HL)
        ld      (VARO),BC

        push    HL              ; save world pointer

        ld      H,B             ; q = sin(BC - LONG)
        ld      L,C
        ld      BC,(LONG)
        xor     A               ; reset carry
        sbc     HL,BC
        push    HL              ; save BC - LONG
        call    CALCSIN
        push    BC
        exx                     ; use 2nd set
        pop     HL
        exx                     ; use 1st set

        pop     HL              ; restore BC - LONG
        call    CALCCOS         ; e = cos(BC - LONG)
        ld      (VARE),BC

        ld      H,D             ; u = cos(DE)
        ld      L,E
        call    CALCCOS
        ld      (VARU),BC

        ld      H,D             ; w = sin(DE)
        ld      L,E
        call    CALCSIN
        ld      (VARW),BC

        call    CALCXY          ; x = u*q*79 + 80
                                ; y = (u*e*h - w*m)*79 + 94

        ld      A,(VARX)        ; xx = x
        ld      (VARXX),A
        ld      A,(VARY)        ; yy = y
        ld      (VARYY),A
        ld      A,(VARN)
        dec     A
        ld      (VARN),A
        pop     HL              ; restore world pointer

BCLSQ:  inc     HL              ; next latitude
        ld      E,(HL)
        inc     HL
        ld      D,(HL)
        ld      (VARL),DE
        inc     HL              ; next longitude
        ld      C,(HL)
        inc     HL
        ld      B,(HL)
        ld      (VARO),BC

        push    HL              ; save world pointer

        ld      H,B             ; q = sin(BC - LONG)
        ld      L,C
        ld      BC,(LONG)
        xor     A               ; reset carry
        sbc     HL,BC
        push    HL              ; save BC - LONG
        call    CALCSIN
        push    BC
        exx                     ; use 2nd set
        pop     HL
        exx                     ; use 1st set

        pop     HL              ; restore BC - LONG
        call    CALCCOS         ; e = cos(BC - LONG)
        ld      (VARE),BC

        ld      H,D             ; u = cos(DE)
        ld      L,E
        call    CALCCOS
        ld      (VARU),BC

        ld      H,D             ; w = sin(DE)
        ld      L,E
        call    CALCSIN
        ld      (VARW),BC

        call    CALCXY          ; x = u*q*79 + 80
                                ; y = (u*e*h - w*m)*79 + 94

                                ; v = u*e*m + w*h
        exx                     ; reg set for RES
        xor     A
        ld      B,A             ; RES = 0
        ld      C,A
        ld      D,A
        ld      E,A
        ld      (SM2),A         ; SM2 = 0
        exx                     ; reg set for M1 and M2

        ld      BC,(RES2+2)     ; M1 = RES2
        ld      DE,(RES2)
        ld      A,(SRES2)
        ld      (SM1),A

        ld      HL,(VARM)       ; M2 = VARM
        bit     7,H
        jp      Z,MUEM1         ; if negative : complement
        ld      A,-1
        ld      (SM2),A
        xor     A
        sbc     A,L
        ld      L,A
        ld      A,0
        sbc     A,H
        ld      H,A

MUEM1:  ld      A,11
MUEM2:  bit     0,L
        jp      Z,MUEM3         ; if LSB of M2 = 1 add M1 in RES
        push    BC
        push    DE
        exx                     ; reg set for RES
        pop     HL
        add     HL,DE
        ld      E,L
        ld      D,H
        pop     HL
        adc     HL,BC
        ld      C,L
        ld      B,H
        exx                     ; reg set for M1 and M2

MUEM3:  sla     E               ; left shift of M1
        rl      D
        rl      C
        rl      B
        srl     H               ; right shift of M2
        rr      L
        dec     A
        JP      NZ,MUEM2

        ld      A,(SM1)         ; calc RES sign
        ld      HL,SM2
        xor     (HL)
        ld      (SRES1),A

        exx                     ; reg set for RES
        ld      E,D             ; RES1 = RES / 1024
        ld      D,C
        ld      C,B
        ld      B,0
        srl     C
        rr      D
        rr      E
        srl     C
        rr      D
        rr      E
        ld      (RES1+2),BC
        ld      (RES1),DE

        xor     A               ; RES = 0
        ld      B,A
        ld      C,A
        ld      D,A
        ld      E,A
        ld      (SM1),DE        ; SM1 = SM2 = 0
        exx                     ; reg set for M1 and M2

        ld      B,A             ; M1 = VARW
        ld      C,A
        ld      DE,(VARW)
        bit     7,D
        jp      Z,MWH1          ; if negative : complement
        ld      A,-1
        ld      (SM1),A
        xor     A
        sbc     A,E
        ld      E,A
        ld      A,0
        sbc     A,D
        ld      D,A

MWH1:   ld      HL,(VARH)       ; M2 = VARH
        bit     7,H
        jp      Z,MWH2          ; if negative : complement
        ld      A,-1
        ld      (SM2),A
        xor     A
        sbc     A,L
        ld      L,A
        ld      A,0
        sbc     A,H
        ld      H,A

MWH2:   ld      A,11
MWH3:   bit     0,L
        jp      Z,MWH4          ; if LSB of M2 = 1 add M1 in RES
        push    BC
        push    DE
        exx                     ; reg set for RES
        pop     HL
        add     HL,DE
        ld      E,L
        ld      D,H
        pop     HL
        adc     HL,BC
        ld      C,L
        ld      B,H
        exx                     ; reg set for M1 and M2

MWH4:   sla     E               ; left shift of M1
        rl      D
        rl      C
        srl     H               ; right shift of M2
        rr      L
        dec     A
        jp      NZ,MWH3

        ld      A,(SM1)         ; Calc RES sign
        ld      HL,SM2
        xor     (HL)

        jp      Z,AHM1          ; complement RES if neg
        exx                     ; reg set for RES
        xor     A
        ld      H,A
        ld      L,A
        sbc     HL,DE
        ld      D,H
        ld      E,L
        ld      H,A
        ld      L,A
        sbc     HL,BC
        ld      B,H
        ld      C,L
        exx                     ; reg set for M1 and M2

AHM1:   ld      A,(SRES1)       ; complement RES1 if neg
        or      A
        jp      Z,AHM2
        ld      DE,(RES1)
        xor     A
        ld      H,A
        ld      L,A
        sbc     HL,DE
        ld      (RES1),HL
        ld      BC,(RES1+2)
        ld      H,A
        ld      L,A
        sbc     HL,BC
        ld      (RES1+2),HL

AHM2:   exx                     ; reg set for RES
        ld      HL,(RES1)       ; RES = RES + RES1
        xor     A               ; carry = 0
        adc     HL,DE
        ld      D,H
        ld      E,L
        ld      HL,(RES1+2)
        adc     HL,BC
        ld      A,H
        exx                     ; reg set for M1 and M2
        or      A
        jp      M,SUITE         ; if vi < 0 it's a hidden line

        LD      HL,0            ; Draw the line
        PUSH    HL
        LD      A,(VARY)
        LD      L,A
        PUSH    HL
        LD      A,(VARX)
        LD      L,A
        PUSH    HL
        LD      A,(VARYY)
        LD      E,A
        LD      A,(VARXX)
        LD      L,A
        CALL    $00B1
        POP     BC
        POP     BC
        POP     BC

SUITE:  ld      A,(VARX)
        ld      (VARXX),A
        ld      A,(VARY)
        ld      (VARYY),A
        pop     HL              ; restore world pointer
        ld      A,(VARN)
        dec     A
        ld      (VARN),A
        jp      NZ,BCLSQ        ; last of a sequence ?
        inc     HL              ; next sequence of coordinates
        ld      A,(HL)
        ld      (VARN),A
        or      A
        jp      Z,DSPLL
        cp      -1
        jp      NZ,BCLSC
        ld      A,(GRID)
        or      A
        jp      Z,DSPLL
        inc     HL              ; next sequence of coordinates
        ld      A,(HL)
        ld      (VARN),A
        jp      BCLSC

DSPLL:  ld      HL,(LAT)        ; Latitude in ASCII
        ld      BC,1800         ; 180
        xor     A               ; carry = 0
        sbc     HL,BC
        jp      C,LAT0
        ld      BC,-1800        ; -180
LAT0:   add     HL,BC
        ld      IX,MS10
        ld      (IX),'+'
        bit     7,H
        jp      Z,LAT1
        xor     A
        sbc     A,L
        ld      L,A
        ld      A,0
        sbc     A,H
        ld      H,A
        ld      (IX),'-'
LAT1:   inc     IX
        ld      BC,900          ; 90
        xor     A
        sbc     HL,BC
        jp      C,LAT2
        xor     A
        sbc     A,L
        ld      L,A
        ld      A,0
        sbc     A,H
        ld      H,A
LAT2:   add     HL,BC
        ld      BC,100          ; 10
        xor     A               ; carry = 0, A = 0
LAT3:   inc     A
        sbc     HL,BC
        jp      NC,LAT3
        dec     A
        add     HL,BC
        jp      Z,LAT4
        add     a,'0'
        ld      (IX),A
        inc     IX
LAT4:   ld      (IX),'0'
        ld      (IX+1),176
        ld      (IX+2),' '
        ld      (IX+3),' '
        ld      (IX+4),0

        ld      L,1
        call    $00D5
        ld      HL,MS10
        ld      (POINTER),HL
        ld      A,174
        ld      (YTOP),A
        ld      A,50
        ld      (XTOP),A
        call    PUTSCR

        ld      HL,(LONG)       ; Latitude in ASCII
        ld      BC,1800         ; 180
        xor     A               ; carry = 0
        sbc     HL,BC
        jp      C,LONG0
        ld      BC,-1800        ; -180
LONG0:  add     HL,BC
        ld      IX,MS10
        ld      (IX),'+'
        bit     7,H
        jp      Z,LONG1
        xor     A
        sbc     A,L
        ld      L,A
        ld      A,0
        sbc     A,H
        ld      H,A
        ld      (IX),'-'
LONG1:  inc     IX
        ld      BC,1000         ; 100
        xor     A               ; carry = 0, A = 0
LONG2:  inc     A
        sbc     HL,BC
        jp      NC,LONG2
        dec     A
        add     HL,BC
        jp      Z,LONG3
        add     a,'0'
        ld      (IX),A
        inc     IX
LONG3:  ld      BC,100          ; 10
        xor     A               ; carry = 0, A = 0
LONG4:  inc     A
        sbc     HL,BC
        jp      NC,LONG4
        dec     A
        add     HL,BC
        jp      NZ,LONG5
        ld      E,A
        ld      A,(IX-1)
        cp      '+'
        jp      Z,LONG6
        cp      '-'
        jp      Z,LONG6
        ld      A,E
LONG5:  add     A,'0'
        ld      (IX),A
        inc     IX
LONG6:  ld      (IX),'0'
        ld      (IX+1),176
        ld      (IX+2),' '
        ld      (IX+3),' '
        ld      (IX+4),0

        ld      L,1
        call    $00D5
        ld      HL,MS10
        ld      (POINTER),HL
        ld      A,185
        ld      (YTOP),A
        ld      A,50
        ld      (XTOP),A
        call    PUTSCR

WAIT:   CALL    GETKEY
        CP      $FF             ; click
	JP	Z,THE_END
        CP      $02             ; address
	JP	Z,THE_END
        CP      $03             ; schedule
        JP      Z,ADDLONG
        CP      $05             ; memo
        JP      Z,SUBLONG
        CP      $06             ; up
        JP      Z,SUBLAT
        CP      $07             ; down
        JP      Z,ADDLAT
        CP      $04             ; to do
        JP      Z,TOGGRID
        JP      WAIT

ADDLONG:ld      HL,(LONG)
        ld      BC,100          ; 10
        add     HL,BC
        ld      (LONG),HL
        ld      BC,3600         ; 360
        xor     A               ; reset carry
        sbc     HL,BC
        jp      C,PLOT
        ld      (LONG),HL
        jp      PLOT

SUBLONG:ld      HL,(LONG)
        ld      BC,100          ; 10
        xor     A               ; reset carry
        sbc     HL,BC
        ld      (LONG),HL
        jp      NC,PLOT
        ld      BC,3600         ; 360
        add     HL,BC
        ld      (LONG),HL
        jp      PLOT

ADDLAT: ld      HL,(LAT)
        ld      BC,100          ; 10
        add     HL,BC
        ld      (LAT),HL
        ld      BC,3600         ; 360
        xor     A               ; reset carry
        sbc     HL,BC
        jp      C,PLOT
        ld      (LAT),HL
        jp      PLOT

SUBLAT: ld      HL,(LAT)
        ld      BC,100          ; 10
        xor     A               ; reset carry
        sbc     HL,BC
        ld      (LAT),HL
        jp      NC,PLOT
        ld      BC,3600         ; 360
        add     HL,BC
        ld      (LAT),HL
        jp      PLOT

TOGGRID:ld      HL,GRID
        ld      A,(HL)
        xor     -1
        ld      (HL),A
        jp      PLOT

THE_END:CALL    PUTBOX
	LD	L,$20
	CALL	$00D5
	LD	HL,MS05
	LD	(POINTER),HL
        LD      A,$57
	LD	(YTOP),A
        LD      A,$2F
	LD	(XTOP),A
	CALL	PUTSCR
	LD	L,$20
	CALL	$00D5

	LD	L,$20
	CALL	$00D5
	LD	HL,MS06
	LD	(POINTER),HL
        LD      A,$65
	LD	(YTOP),A
        LD      A,$27
	LD	(XTOP),A
	CALL	PUTSCR

        LD      L,1
        CALL    $00D5
        LD      HL,MS07
        LD      (POINTER),HL
        LD      A,$72
        LD      (YTOP),A
        LD      A,9
        LD      (XTOP),A
        CALL    PUTSCR

END1:	CALL	CHECK_OK
	CP	$00
	JR	Z,END1
	RET

                                ; x = u*q*79 + 80
CALCXY: exx                     ; reg set for RES
        push    HL              ; save q
        exx                     ; reg set for M1 and M2
        pop     HL              ; M2 = q
        exx                     ; reg set for RES
        xor     A
        ld      B,A             ; RES = 0
        ld      C,A
        ld      D,A
        ld      E,A
        ld      (SM1),DE        ; SM1 = SM2 = 0
        exx                     ; reg set for M1 and M2

        ld      B,A             ; M1 = VARU
        ld      C,A
        ld      DE,(VARU)
        bit     7,D
        jp      Z,MUQ1          ; if negative : complement
        ld      A,-1
        ld      (SM1),A
        xor     A
        sbc     A,E
        ld      E,A
        ld      A,0
        sbc     A,D
        ld      D,A

MUQ1:   bit     7,H
        jp      Z,MUQ2          ; if negative : complement
        ld      A,-1
        ld      (SM2),A
        xor     A
        sbc     A,L
        ld      L,A
        ld      A,0
        sbc     A,H
        ld      H,A

MUQ2:   ld      A,11
MUQ3:   bit     0,L
        jp      Z,MUQ4          ; if LSB of M2 = 1 add M1 in RES
        push    BC
        push    DE
        exx                     ; reg set for RES
        pop     HL
        add     HL,DE
        ld      E,L
        ld      D,H
        pop     HL
        adc     HL,BC
        ld      C,L
        ld      B,H
        exx                     ; reg set for M1 and M2

MUQ4:   sla     E               ; left shift of M1
        rl      D
        rl      C
        srl     H               ; right shift of M2
        rr      L
        dec     A
        jp      NZ,MUQ3

        ld      A,(SM2)         ; SM1 = SRES
        ld      HL,SM1
        xor     (HL)
        ld      (HL),A

        exx                     ; reg set for RES
        push    BC              ; M1 = RES
        push    DE
        ld      BC,0            ; RES = 0
        ld      DE,0
        exx                     ; reg set for M1 and M2
        pop     DE
        pop     BC

        ld      HL,79           ; M2 = 79

        ld      A,7
MUQ791: bit     0,L
        jp      Z,MUQ792        ; if LSB of M2 = 1 add M1 in RES
        push    BC
        push    DE
        exx                     ; reg set for RES
        pop     HL
        add     HL,DE
        ld      E,L
        ld      D,H
        pop     HL
        adc     HL,BC
        ld      C,L
        ld      B,H
        exx                     ; reg set for M1 and M2

MUQ792: sla     E               ; left shift of M1
        rl      D
        rl      C
        rl      B
        srl     L               ; right shift of M2
        dec     A
        jp      NZ,MUQ791

        exx                     ; reg set for RES
        srl     B               ; 20 bit RES left shift
        rr      C
        srl     B
        rr      C
        srl     B
        rr      C
        srl     C

        ld      A,(SM1)         ; calc RES and RES sign
        or      A
        ld      A,C
        jp      Z,MUQ793
        neg
MUQ793: add     A,80
        ld      (VARX),A

                                ; y = (u*e*h - w*m)*79 + 94
        xor     A
        ld      B,A             ; RES = 0
        ld      C,A
        ld      D,A
        ld      E,A
        ld      (SM1),DE        ; SM1 = SM2 = 0
        exx                     ; reg set for M1 and M2

        ld      B,A             ; M1 = VARU
        ld      C,A
        ld      DE,(VARU)
        bit     7,D
        jp      Z,MUE1          ; if negative : complement
        ld      A,-1
        ld      (SM1),A
        xor     A
        sbc     A,E
        ld      E,A
        ld      A,0
        sbc     A,D
        ld      D,A

MUE1:   ld      HL,(VARE)       ; M2 = VARE
        bit     7,H
        jp      Z,MUE2          ; if negative : complement
        ld      A,-1
        ld      (SM2),A
        xor     A
        sbc     A,L
        ld      L,A
        ld      A,0
        sbc     A,H
        ld      H,A

MUE2:   ld      A,11
MUE3:   bit     0,L
        jp      Z,MUE4          ; if LSB of M2 = 1 add M1 in RES
        push    BC
        push    DE
        exx                     ; reg set for RES
        pop     HL
        add     HL,DE
        ld      E,L
        ld      D,H
        pop     HL
        adc     HL,BC
        ld      C,L
        ld      B,H
        exx                     ; reg set for M1 and M2

MUE4:   sla     E               ; left shift of M1
        rl      D
        rl      C
        srl     H               ; right shift of M2
        rr      L
        dec     A
        jp      NZ,MUE3

        ld      A,(SM2)         ; calc RES sign
        ld      HL,SM1
        xor     (HL)
        ld      (HL),A          ; SM1 = SRES
        ld      (SRES2),A       ; SRES2 = SRES

        exx                     ; reg set for RES
        push    BC              ; M1 = RES
        push    DE
        ld      BC,0            ; RES = 0
        ld      DE,0
        exx                     ; reg set for M1 and M2
        pop     DE
        pop     BC

        ld      (RES2),DE       ; RES2 = M1
        ld      (RES2+2),BC

        xor     A
        ld      (SM2),A
        ld      HL,(VARH)       ; M2 = VARH
        bit     7,H
        jp      Z,MUEH1         ; if negative : complement
        sbc     A,L
        ld      L,A
        ld      A,0
        sbc     A,H
        ld      H,A
        ld      A,-1
        ld      (SM2),A

MUEH1:  ld      A,11
MUEH2:  bit     0,L
        jp      Z,MUEH3         ; if LSB of M2 = 1 add M1 in RES
        push    BC
        push    DE
        exx                     ; reg set for RES
        pop     HL
        add     HL,DE
        ld      E,L
        ld      D,H
        pop     HL
        adc     HL,BC
        ld      C,L
        ld      B,H
        exx                     ; reg set for M1 and M2

MUEH3:  sla     E               ; left shift of M1
        rl      D
        rl      C
        rl      B
        srl     H               ; right shift of M2
        rr      L
        dec     A
        jp      NZ,MUEH2

        ld      A,(SM1)         ; calc RES sign
        ld      HL,SM2
        xor     (HL)
        ld      (SRES1),A

        exx                     ; reg set for RES
        ld      E,D             ; RES1 = RES / 1024
        ld      D,C
        ld      C,B
        ld      B,0
        srl     C
        rr      D
        rr      E
        srl     C
        rr      D
        rr      E
        ld      (RES1+2),BC
        ld      (RES1),DE

        xor     A               ; RES = 0
        ld      C,A
        ld      D,A
        ld      E,A
        ld      (SM1),DE        ; SM1 = SM2 = 0
        exx                     ; reg set for M1 and M2

        ld      B,A             ; M1 = VARW
        ld      C,A
        ld      DE,(VARW)
        bit     7,D
        jp      Z,MWM1          ; if negative : complement
        ld      A,-1
        ld      (SM1),A
        xor     A
        sbc     A,E
        ld      E,A
        ld      A,0
        sbc     A,D
        ld      D,A

MWM1:   ld      HL,(VARM)       ; M2 = VARM
        bit     7,H
        jp      Z,MWM2          ; if negative : complement
        ld      A,-1
        ld      (SM2),A
        xor     A
        sbc     A,L
        ld      L,A
        ld      A,0
        sbc     A,H
        ld      H,A

MWM2:   ld      A,11
MWM3:   bit     0,L
        jp      Z,MWM4          ; if LSB of M2 = 1 add M1 in RES
        push    BC
        push    DE
        exx                     ; reg set for RES
        pop     HL
        add     HL,DE
        ld      E,L
        ld      D,H
        pop     HL
        adc     HL,BC
        ld      C,L
        ld      B,H
        exx                     ; reg set for M1 and M2

MWM4:   sla     E               ; left shift of M1
        rl      D
        rl      C
        srl     H               ; right shift of M2
        rr      L
        dec     A
        jp      NZ,MWM3

        ld      A,(SM1)         ; calc -RES sign
        ld      HL,SM2
        xor     (HL)
        xor     -1

        jp      Z,AUW1          ; complement RES if neg
        exx                     ; reg set for RES
        xor     A
        ld      H,A
        ld      L,A
        sbc     HL,DE
        ld      D,H
        ld      E,L
        ld      H,A
        ld      L,A
        sbc     HL,BC
        ld      B,H
        ld      C,L
        exx                     ; reg set for M1 and M2

AUW1:   ld      A,(SRES1)       ; complement RES1 if neg
        or      A
        jp      Z,AUW2
        ld      DE,(RES1)
        xor     A
        ld      H,A
        ld      L,A
        sbc     HL,DE
        ld      (RES1),HL
        ld      BC,(RES1+2)
        ld      H,A
        ld      L,A
        sbc     HL,BC
        ld      (RES1+2),HL

AUW2:   exx                     ; reg set for RES
        ld      HL,(RES1)       ; RES = RES + RES1
        xor     A               ; carry = 0
        ld      (SM1),A         ; M1 sign = +
        adc     HL,DE
        ld      D,H
        ld      E,L
        ld      HL,(RES1+2)
        adc     HL,BC
        ld      B,H
        ld      C,L

        bit     7,B
        jp      Z,MUW790        ; complement RES if neg
        ld      A,-1            ; M1 sign = -
        ld      (SM1),A
        xor     A
        ld      H,A
        ld      L,A
        sbc     HL,DE
        ld      D,H
        ld      E,L
        ld      H,A
        ld      L,A
        sbc     HL,BC
        ld      B,H
        ld      C,L

MUW790: push    BC              ; M1 = RES
        push    DE
        ld      BC,0            ; RES = 0
        ld      DE,0
        exx                     ; reg set for M1 and M2
        pop     DE
        pop     BC

        ld      HL,79           ; M2 = 79

        ld      A,7
MUW791: bit     0,L
        jp      Z,MUW792        ; if LSB of M2 = 1 add M1 in RES
        push    BC
        push    DE
        exx                     ; reg set for RES
        pop     HL
        add     HL,DE
        ld      E,L
        ld      D,H
        pop     HL
        adc     HL,BC
        ld      C,L
        ld      B,H
        exx                     ; reg set for M1 and M2

MUW792: sla     E               ; left shift of M1
        rl      D
        rl      C
        rl      B
        srl     L               ; right shift of M2
        dec     A
        jp      NZ,MUW791

        exx                     ; reg set for RES
        srl     B               ; 20 bit RES left shift
        rr      C
        srl     B
        rr      C
        srl     B
        rr      C
        srl     C

        ld      A,(SM1)         ; calc RES and RES sign
        or      A
        ld      A,C
        jp      Z,MUW793
        neg
MUW793: add     A,94
        ld      (VARY),A
        exx                     ; reg set for M1 and M2
        ret

;
; CALCCOS entry angle HL    out BC
;          the angle must be in tenths of 
CALCCOS:ld      A,H             ; if angle < 0 add 360
        or      A
        jp      P,CC
        ld      BC,3600         ; the value returned
        add     HL,BC           ; is from -1024 to 1024
        jp      CALCCOS         ; it represents from -1 to 1
CC:     ld      BC,COS
        add     HL,HL           ; each COS is a word
        add     HL,BC
        ld      C,(HL)
        inc     HL
        ld      B,(HL)
        ret

;
; CALCSIN entry angle HL    out BC
;          the angle must be in tenths of 
CALCSIN:ld      A,H             ; if angle < 0 add 360
        or      A
        jp      P,CS
        ld      BC,3600         ; the value returned
        add     HL,BC           ; is from -1024 to 1024
        jp      CALCSIN         ; it represents from -1 to 1
CS:     ld      BC,SIN
        add     HL,HL           ; each SIN is a word
        add     HL,BC
        ld      C,(HL)
        inc     HL
        ld      B,(HL)
        ret

;********************************************
;  -----------------------------------------
;  A V I G O - System routines Identified!!!
;  -----------------------------------------
;********************************************

;------------------------------------------------------------------------------------
;	This routine will clear the avigo screen
;------------------------------------------------------------------------------------
CLRSCN: LD      L,$00
CLRS0:  CALL    $0093
	RET

;------------------------------------------------------------------------------------
;	This routine will clear/set a single
;	pixel on the Avigo screen
;------------------------------------------------------------------------------------
SET1PIX:LD     A,$00                   ;TURN PIXEL ON = $00
        LD     L,A                     ;TURN PIXEL OFF = $01
        LD     H,$00
        PUSH   HL
        LD     A,(YTOP)
        LD     E,A                     ;Y POSITION OF PIXEL
        LD     A,(XTOP)
        LD     L,A                     ;X POSITION OF PIXEL
        CALL   $00B4
        POP    HL
        RET

;------------------------------------------------------------------------------------
;	This routine will clear a certain area
;	of pixels within the Avigo screen
;------------------------------------------------------------------------------------
CLRPIX: LD      A,$00                   ; 06FF 3E00     >.	;TURN PIXELS OFF = 00
CLRP0:  LD      L,A                     ; 0701 6F       o	;TURN PIXELS ON = 01
        LD      H,$00                   ; 0702 2600     &.
        PUSH    HL                      ; 0704 E5       .
        LD      A,(YBOT)                ; 0705 3E0C     >.	;Y POSITION OF LOWER RH PIXEL?
        LD      L,A                     ; 0707 6F       o
        LD      H,$00                   ; 0708 2600     &.
        PUSH    HL                      ; 070A E5       .
        LD      A,(XBOT)                ; 070E 7D       }	;X POSITION OF LOWER RH PIXEL?
        LD      L,A                     ; 070F 6F       o
        LD      H,$00                   ; 0710 2600     &.
        PUSH    HL                      ; 0712 E5       .
	LD	A,(YTOP)
        LD      E,A                     ; 0713 1E00     ..	;Y POSITION OF UPPER LH PIXEL?
	LD	A,(XTOP)
        LD      L,A                     ; 0715 2E00     ..	;X POSITION OF UPPER LH PIXEL?
        CALL    $0096                   ; 0717 CD9600   ...
        POP     BC                      ; 071A C1       .
        POP     BC                      ; 071B C1       .
        POP     BC                      ; 071C C1       .
	RET

;------------------------------------------------------------------------------------
DRAW_GREY:
	LD      A,$01                   ; 06FF 3E00     >.	;TURN PIXELS OFF = 00
 	LD      L,A                     ; 0701 6F       o	;TURN PIXELS ON = 01
        LD      H,$00                   ; 0702 2600     &.
        PUSH    HL                      ; 0704 E5       .
        LD      A,(YBOT)                ; 0705 3E0C     >.	;Y POSITION OF LOWER RH PIXEL?
        LD      L,A                     ; 0707 6F       o
        LD      H,$00                   ; 0708 2600     &.
        PUSH    HL                      ; 070A E5       .
        LD      A,(XBOT)                ; 070E 7D       }	;X POSITION OF LOWER RH PIXEL?
        LD      L,A                     ; 070F 6F       o
        LD      H,$00                   ; 0710 2600     &.
        PUSH    HL                      ; 0712 E5       .
	LD	A,(YTOP)
        LD      E,A                     ; 0713 1E00     ..	;Y POSITION OF UPPER LH PIXEL?
	LD	A,(XTOP)
        LD      L,A                     ; 0715 2E00     ..	;X POSITION OF UPPER LH PIXEL?
        CALL    $00AE                   ; 0717 CD9600   ...
        POP     BC                      ; 071A C1       .
        POP     BC                      ; 071B C1       .
        POP     BC                      ; 071C C1       .
	RET

;------------------------------------------------------------------------------------
;	This routine will DRAW a line from X,Y (Upper LH)
;	to X,Y (Lower RH) pixels on the Avigo screen
;
;       CALL    $0099           ;INVERT a square field of pixels
;       CALL    $00AB           ;DRAW DOTTED SQUARE
;       CALL    $00AE           ;DRAW DOTTED FILLED (CHECKERBOARD) SQUARE
;       CALL    $00B1           ;DRAW LINE FROM X1,Y1 TO X2,Y2
;       CALL    $00B7   	;Draw a circle from ceter to radius
;       CALL    $00E1   	;Draw a filled circle from center to radius
;       CALL    $00BD           ;Sets security lock to the unit
;       CALL    $0021  		;Turn on/off the backlight (LD A,$00 or $01)
;       CALL    $002D  		;Go into POWER DOWN mode
;       CALL    $0041       	;SET TIME ???
;       CALL    $0044       	;SET DATE ???
;------------------------------------------------------------------------------------
INVERT_PIX:
	LD      A,$00                   ; 06FF 3E00     >.	;TURN PIXELS OFF = 00
 	LD      L,A                     ; 0701 6F       o	;TURN PIXELS ON = 01
        LD      H,$00                   ; 0702 2600     &.
        PUSH    HL                      ; 0704 E5       .
        LD      A,(YBOT)                ; 0705 3E0C     >.	;Y POSITION OF LOWER RH PIXEL?
        LD      L,A                     ; 0707 6F       o
        LD      H,$00                   ; 0708 2600     &.
        PUSH    HL                      ; 070A E5       .
        LD      A,(XBOT)                ; 070E 7D       }	;X POSITION OF LOWER RH PIXEL?
        LD      L,A                     ; 070F 6F       o
        LD      H,$00                   ; 0710 2600     &.
        PUSH    HL                      ; 0712 E5       .
	LD	A,(YTOP)
        LD      E,A                     ; 0713 1E00     ..	;Y POSITION OF UPPER LH PIXEL?
	LD	A,(XTOP)
        LD      L,A                     ; 0715 2E00     ..	;X POSITION OF UPPER LH PIXEL?
        CALL    $0099                   ; 0717 CD9600   ...
        POP     BC                      ; 071A C1       .
        POP     BC                      ; 071B C1       .
        POP     BC                      ; 071C C1       .
	RET

DRAWLINE:
	LD      A,$00                   ; 06FF 3E00     >.	;TURN PIXELS OFF = 00
DL0:    LD      L,A                     ; 0701 6F       o	;TURN PIXELS ON = 01
        LD      H,$00                   ; 0702 2600     &.
        PUSH    HL                      ; 0704 E5       .
        LD      A,(YBOT)                ; 0705 3E0C     >.	;Y POSITION OF LOWER RH PIXEL?
        LD      L,A                     ; 0707 6F       o
        LD      H,$00                   ; 0708 2600     &.
        PUSH    HL                      ; 070A E5       .
        LD      A,(XBOT)                ; 070E 7D       }	;X POSITION OF LOWER RH PIXEL?
        LD      L,A                     ; 070F 6F       o
        LD      H,$00                   ; 0710 2600     &.
        PUSH    HL                      ; 0712 E5       .
	LD	A,(YTOP)
        LD      E,A                     ; 0713 1E00     ..	;Y POSITION OF UPPER LH PIXEL?
	LD	A,(XTOP)
        LD      L,A                     ; 0715 2E00     ..	;X POSITION OF UPPER LH PIXEL?
        CALL    $00B1                   ; 0717 CD9600   ...
        POP     BC                      ; 071A C1       .
        POP     BC                      ; 071B C1       .
        POP     BC                      ; 071C C1       .
	RET

;------------------------------------------------------------------------------------
;	This routine will DRAW an unfilled circle from X,Y (Center) out
;	to a given radius of pixels on the Avigo screen
;------------------------------------------------------------------------------------
DRAW_CIRCLE:
        LD      A,$00                   ; 0705 3E0C     >.	;LINE TYPE $00 = FULL LINE
        LD      L,A                     ; 0707 6F       o	;	   $01 = DOTTED
        LD      H,$00                   ; 0708 2600     &.
        PUSH    HL                      ; 070A E5       .
        LD      A,(XBOT)                ; 070E 7D       }	;RADIUS OF THE CIRCLE
        LD      L,A                     ; 070F 6F       o
        LD      H,$00                   ; 0710 2600     &.
        PUSH    HL                      ; 0712 E5       .
	LD	A,(YTOP)
        LD      E,A                     ; 0713 1E00     ..	;Y POSITION OF CENTER?
	LD	A,(XTOP)
        LD      L,A                     ; 0715 2E00     ..	;X POSITION OF CENTER?
        CALL    $00B7                   ; 0717 CD9600   ...
        POP     BC                      ; 071A C1       .
        POP     BC                      ; 071B C1       .
	RET

;------------------------------------------------------------------------------------
;	This routine will DRAW a filled circle from X,Y (Center) out
;	to a given radius of pixels on the Avigo screen
;------------------------------------------------------------------------------------
SOLID_CIRCLE:
        LD      A,(YBOT)                ; 0705 3E0C     >.	;LINE TYPE $00 = FILL SOLID
        LD      L,A                     ; 0707 6F       o	;	   $01 = FILL PATERN
        LD      H,$00                   ; 0708 2600     &.
        PUSH    HL                      ; 070A E5       .
        LD      A,(XBOT)                ; 070E 7D       }	;RADIUS OF THE CIRCLE
        LD      L,A                     ; 070F 6F       o
        LD      H,$00                   ; 0710 2600     &.
        PUSH    HL                      ; 0712 E5       .
	LD	A,(YTOP)
        LD      E,A                     ; 0713 1E00     ..	;Y POSITION OF CENTER?
	LD	A,(XTOP)
        LD      L,A                     ; 0715 2E00     ..	;X POSITION OF CENTER?
        CALL    $00E1                   ; 0717 CD9600   ...
        POP     BC                      ; 071A C1       .
        POP     BC                      ; 071B C1       .
	RET

;------------------------------------------------------------------------------------
;	This routine will DISPLAY an ASCII message
;	to the Avigo screen
;
;	LD	L,$00
;	CALL	$00D5		;SETS TEXT MODE
;				;LD  L,$00 = NORMAL TEXT
;				;LD  L,$01 = BOLD TEXT
;				;LD  L,$20 = BIG TEXT
;				;LD  L,$21 = BOLD/BIG TEXT
;
;------------------------------------------------------------------------------------
PUTSCR: LD      A,$00                   ; 072A 3E00     >.	;TURN PIXELS OFF = 00
PUTS0:  LD      L,A                     ; 072C 6F       o	;TURN PIXELS ON = 01
        LD      H,$00                   ; 072D 2600     &.
        PUSH    HL                      ; 072F E5       .
	LD      HL,(POINTER)            ; 0730 21F174   !.t	;POINTER TO MESSAGE
        PUSH    HL                      ; 0733 E5       .
	LD	A,(YTOP)
        LD      E,A                     ; 0734 1E00     ..	;Y POSITION OF STARTING PIXEL
	LD	A,(XTOP)
        LD      L,A                     ; 0736 2E0E     ..	;X POSITION OF STARTING PIXEL
        CALL    $00CF                   ; 0738 CDCF00   ...
        POP     BC                      ; 073B C1       .
        POP     BC                      ; 073B C1       .
        LD      L,$00                   ; 07B5 2E00     ..
        CALL    $00D5                   ; 07B7 CDD500   ...
	RET

;------------------------------------------------------------------------------------
;	This routine will wait for a KEYPRESS/PENPRESS
;
;		02 = ADDRESS KEY
;		03 = SCHEDULE KEY
;		04 = TODO KEY
;		05 = MEMO KEY
;		06 = PAGEUP KEY
;		07 = PAGEDN KEY
;		08 = CALENDAR KEY
;		0A = CALC KEY
;		09 = EXPENSE KEY
;		0B = DATA KEY
;		0C = APPS KEY
;		0D = FIND KEY
;
;		FF = SCREEN PRESS (Now REG BC is valid)
;
;			REG B = X POSITION OF PEN
;			REG C = Y POSITION OF PEN
;
;------------------------------------------------------------------------------------
GETKEY: CALL    $00E7                   ; 3ED1 CDE700   ...
        OR      A                       ; 3ED4 B7       .
        JR      Z,GETKEY                ; 3ED5 28FA     (.
        RET                             ; 3ED7 C9       .

;------------------------------------------------------------------------------------
;	P U T    B O X
;
;  This is the first of my own routines. This routine will clear an area and
;  then put up a dialog box with an OK button in it. The size and location
;  are fixed as is the location of the button.
;
;------------------------------------------------------------------------------------
PUTBOX:
        LD      A,$0B-4
	LD	(XTOP),A
	LD	A,$1F
	LD	(YTOP),A
        LD      A,$95+4
	LD	(XBOT),A
	LD	A,$99
	LD	(YBOT),A
	CALL	CLRPIX

        LD      A,$04           ;Set the four corner radius' for the box
	LD	(XBOT),A
	LD	A,$24
	LD	(YTOP),A
        LD      A,$10-4
        LD      (XTOP),A
	CALL	DRAW_CIRCLE
	LD	A,$24
	LD	(YTOP),A
        LD      A,$90+4
	LD	(XTOP),A
	CALL	DRAW_CIRCLE
        LD      A,$94
	LD	(YTOP),A
        LD      A,$10-4
	LD	(XTOP),A
	CALL	DRAW_CIRCLE
	LD	A,$94
	LD	(YTOP),A
        LD      A,$90+4
	LD	(XTOP),A
	CALL	DRAW_CIRCLE

        LD      A,$12-4                 ;Clear out 3 rectangles for the box
	LD	(XTOP),A
	LD	A,$90
	LD	(YTOP),A
        LD      A,$8E+4
	LD	(XBOT),A
	LD	A,$98
	LD	(YBOT),A
	CALL	CLRPIX
        LD      A,$12-4
	LD	(XTOP),A
	LD	A,$20
	LD	(YTOP),A
        LD      A,$8E+4
	LD	(XBOT),A
	LD	A,$28
	LD	(YBOT),A
	CALL	CLRPIX
        LD      A,$0C-4
	LD	(XTOP),A
	LD	A,$26
	LD	(YTOP),A
        LD      A,$94+4
	LD	(XBOT),A
	LD	A,$92
	LD	(YBOT),A
	CALL	CLRPIX

        LD      A,$10-4                 ;Setup the 4 lines that make the box
	LD	(XTOP),A
	LD	A,$20
	LD	(YTOP),A
        LD      A,$90+4
	LD	(XBOT),A
	LD	A,$20
	LD	(YBOT),A
	CALL	DRAWLINE
        LD      A,$94+4
	LD	(XTOP),A
	LD	A,$24
	LD	(YTOP),A
        LD      A,$94+4
	LD	(XBOT),A
	LD	A,$94
	LD	(YBOT),A
	CALL	DRAWLINE
        LD      A,$8E+4
	LD	(XTOP),A
	LD	A,$98
	LD	(YTOP),A
        LD      A,$12-4
	LD	(XBOT),A
	LD	A,$98
	LD	(YBOT),A
	CALL	DRAWLINE
        LD      A,$0C-4
	LD	(XTOP),A
	LD	A,$92
	LD	(YTOP),A
        LD      A,$0C-4
	LD	(XBOT),A
	LD	A,$26
	LD	(YBOT),A
	CALL	DRAWLINE

        LD      A,$10-4                 ;Setup the grey boarders
	LD	(XTOP),A
	LD	A,$96
	LD	(YTOP),A
        LD      A,$90+4
	LD	(XBOT),A
	LD	A,$97
	LD	(YBOT),A
	CALL	DRAW_GREY
        LD      A,$92+4
	LD	(XTOP),A
	LD	A,$26
	LD	(YTOP),A
        LD      A,$93+4
	LD	(XBOT),A
	LD	A,$96
	LD	(YBOT),A
	CALL	DRAW_GREY

        LD      HL,ICON                 ;Set the icon
        LD      DE,$3622                ; D=x  E=y

BCLBYTE:LD      C,(HL)
        LD      B,8

BCLBIT: RL      C
        JR      NC,NEXTBIT              ; is pixel set ?

        LD      A,E                     ;Set one pixel
	LD	(YTOP),A
        LD      A,D
	LD	(XTOP),A
        PUSH    HL
        PUSH    DE
        PUSH    BC
        CALL    SET1PIX
        POP     BC
        POP     DE
        POP     HL

NEXTBIT:INC     D
        DJNZ    BCLBIT                  ; last pixel in byte

        INC     HL
        LD      A,D
        CP      $36+56
        JR      NZ,BCLBYTE              ; last byte in line ?
        LD      D,$36
        INC     E
        LD      A,E
        CP      $22+50
        JR      NZ,BCLBYTE              ; last line ?

        LD	A,$07			;Setup OK circles
       	LD	(XBOT),A
       	LD	A,$88
       	LD	(YTOP),A
       	LD	A,$3C
       	LD	(XTOP),A
       	CALL	DRAW_CIRCLE
        LD      A,$88
        LD      (YTOP),A
        LD      A,$65
       	LD	(XTOP),A
	CALL	DRAW_CIRCLE

	LD	A,$3C			;Clear area between OK circles
	LD	(XTOP),A
	LD	A,$80
	LD	(YTOP),A
	LD	A,$65
	LD	(XBOT),A
	LD	A,$8F
	LD	(YBOT),A
	CALL	CLRPIX

	LD	A,$3C			;Draw lines for OK Button
	LD	(XTOP),A
	LD	A,$80
	LD	(YTOP),A
	LD	A,$65
	LD	(XBOT),A
	LD	A,$80
	LD	(YBOT),A
	CALL	DRAWLINE
	LD	A,$3C
	LD	(XTOP),A
	LD	A,$90
	LD	(YTOP),A
	LD	A,$65
	LD	(XBOT),A
	LD	A,$90
	LD	(YBOT),A
	CALL	DRAWLINE

	LD	L,$01
	CALL	$00D5
        LD      HL,SY1                  ;Setup the OK text
	LD	(POINTER),HL
	LD	A,$83
	LD	(YTOP),A
	LD	A,$48
	LD	(XTOP),A
	CALL	PUTSCR
	RET
;
SY1:   .BYTE "OK",0

;------------------------------------------------------------------------------------
;	C H E C K   O K
;
;------------------------------------------------------------------------------------
CHECK_OK:
	CALL	$00E7
	CP	$FF
	JR	NZ,CHK1
	LD	A,B		;X POSITION OF PEN
	CP	$3C
	JR	C,CHK1
	CP	$65
	JR	NC,CHK1
	LD	A,C		;Y POSITION OF PEN
	CP	$80
	JR	C,CHK1
	CP	$90
	JR	NC,CHK1

	LD	A,$3C		;Setup INVERT of OK field
	LD	(XTOP),A
	LD	A,$81
	LD	(YTOP),A
	LD	A,$65
	LD	(XBOT),A
	LD	A,$8F
	LD	(YBOT),A
	CALL	INVERT_PIX
	LD	A,$07		;Setup INVERT of OK circles
	LD	(XBOT),A
	LD	A,$00
	LD	(YBOT),A
	LD	A,$88
	LD	(YTOP),A
	LD	A,$3C
	LD	(XTOP),A
	CALL	SOLID_CIRCLE
	LD	A,$88
	LD	(YTOP),A
	LD	A,$65
	LD	(XTOP),A
	CALL	SOLID_CIRCLE
CHK2:	CALL	$00E7
	CP	$FF
	JR	Z,CHK2
	LD	A,$FF
	JR	CHK3
CHK1:	LD	A,$00
CHK3:	LD	(XTOP),A
	LD	L,$00
	CALL	$00D5
	LD	A,(XTOP)
	RET
;------------------------------------------------------------------------------------
;This is the end of the program code...

TITLE:  .byte "Hello World v1.4",0
MS01:   .byte "With schedule, memo, up & down",0
MS02:   .byte "you can move the world.",0
MS03:   .byte "The to do key toggles the grid."
        .byte 0
MS04:   .byte "Press ADDRESS key to exit",0
MS05:   .byte "program by:",0
MS06:	.byte "Martin LORANG",0
MS07:   .byte "martin.lorang@wanadoo.fr",0
MS08:   .byte "Latitude :",0
MS09:   .byte "Longitude :",0

SIN:
.word 0,2,4,5,7,9,11,13,14,16,18,20,21,23,25,27,29,30,32,34,36,38,39
.word 41,43,45,46,48,50,52,54,55,57,59,61,63,64,66,68,70,71,73,75,77,79,80,82,84
.word 86,87,89,91,93,95,96,98,100,102,103,105,107,109,111,112,114,116,118,119,121
.word 123,125,127,128,130,132,134,135,137,139,141,143,144,146,148,150,151,153,155
.word 157,158,160,162,164,165,167,169,171,173,174,176,178,180,181,183,185,187,188
.word 190,192,194,195,197,199,201,202,204,206,208,209,211,213,215,216,218,220,222
.word 223,225,227,229,230,232,234,236,237,239,241,243,244,246,248,249,251,253,255
.word 256,258,260,262,263,265,267,268,270,272,274,275,277,279,281,282,284,286,287
.word 289,291,293,294,296,298,299,301,303,305,306,308,310,311,313,315,316,318,320
.word 322,323,325,327,328,330,332,333,335,337,338,340,342,344,345,347,349,350,352
.word 354,355,357,359,360,362,364,365,367,369,370,372,374,375,377,379,380,382,384
.word 385,387,389,390,392,394,395,397,398,400,402,403,405,407,408,410,412,413,415
.word 416,418,420,421,423,425,426,428,430,431,433,434,436,438,439,441,442,444,446
.word 447,449,450,452,454,455,457,459,460,462,463,465,466,468,470,471,473,474,476
.word 478,479,481,482,484,485,487,489,490,492,493,495,496,498,500,501,503,504,506
.word 507,509,510,512,514,515,517,518,520,521,523,524,526,527,529,530,532,534,535
.word 537,538,540,541,543,544,546,547,549,550,552,553,555,556,558,559,561,562,564
.word 565,567,568,570,571,573,574,576,577,579,580,581,583,584,586,587,589,590,592
.word 593,595,596,598,599,600,602,603,605,606,608,609,611,612,613,615,616,618,619
.word 621,622,623,625,626,628,629,630,632,633,635,636,637,639,640,642,643,644,646
.word 647,649,650,651,653,654,655,657,658,660,661,662,664,665,666,668,669,670,672
.word 673,674,676,677,679,680,681,683,684,685,687,688,689,690,692,693,694,696,697
.word 698,700,701,702,704,705,706,707,709,710,711,713,714,715,716,718,719,720,722
.word 723,724,725,727,728,729,730,732,733,734,735,737,738,739,740,742,743,744,745
.word 746,748,749,750,751,753,754,755,756,757,759,760,761,762,763,765,766,767,768
.word 769,770,772,773,774,775,776,777,779,780,781,782,783,784,786,787,788,789,790
.word 791,792,794,795,796,797,798,799,800,801,803,804,805,806,807,808,809,810,811
.word 812,813,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,831,832
.word 833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851
.word 852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,867,868,869
.word 870,871,872,873,874,875,876,877,878,879,880,880,881,882,883,884,885,886,887
.word 888,889,889,890,891,892,893,894,895,896,896,897,898,899,900,901,902,902,903
.word 904,905,906,907,907,908,909,910,911,912,912,913,914,915,916,916,917,918,919
.word 920,920,921,922,923,923,924,925,926,927,927,928,929,930,930,931,932,933,933
.word 934,935,935,936,937,938,938,939,940,940,941,942,943,943,944,945,945,946,947
.word 947,948,949,949,950,951,951,952,953,953,954,955,955,956,957,957,958,959,959
.word 960,960,961,962,962,963,963,964,965,965,966,966,967,968,968,969,969,970,971
.word 971,972,972,973,973,974,974,975,976,976,977,977,978,978,979,979,980,980,981
.word 981,982,982,983,983,984,984,985,985,986,986,987,987,988,988,989,989,990,990
.word 990,991,991,992,992,993,993,994,994,994,995,995,996,996,997,997,997,998,998
.word 999,999,999,1000,1000,1000,1001,1001,1002,1002,1002,1003,1003,1003,1004,1004
.word 1004,1005,1005,1006,1006,1006,1007,1007,1007,1007,1008,1008,1008,1009,1009
.word 1009,1010,1010,1010,1011,1011,1011,1011,1012,1012,1012,1012,1013,1013,1013
.word 1014,1014,1014,1014,1015,1015,1015,1015,1015,1016,1016,1016,1016,1017,1017
.word 1017,1017,1017,1018,1018,1018,1018,1018,1019,1019,1019,1019,1019,1019,1020
.word 1020,1020,1020,1020,1020,1021,1021,1021,1021,1021,1021,1021,1022,1022,1022
.word 1022,1022,1022,1022,1022,1022,1023,1023,1023,1023,1023,1023,1023,1023,1023
.word 1023,1023,1023,1023,1023,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024
.word 1024,1024,1024,1024,1024,1024,1024
COS:
.word 1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024
.word 1024,1024,1024,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023
.word 1023,1023,1022,1022,1022,1022,1022,1022,1022,1022,1022,1021,1021,1021,1021
.word 1021,1021,1021,1020,1020,1020,1020,1020,1020,1019,1019,1019,1019,1019,1019
.word 1018,1018,1018,1018,1018,1017,1017,1017,1017,1017,1016,1016,1016,1016,1015
.word 1015,1015,1015,1015,1014,1014,1014,1014,1013,1013,1013,1012,1012,1012,1012
.word 1011,1011,1011,1011,1010,1010,1010,1009,1009,1009,1008,1008,1008,1007,1007
.word 1007,1007,1006,1006,1006,1005,1005,1004,1004,1004,1003,1003,1003,1002,1002
.word 1002,1001,1001,1000,1000,1000,999,999,999,998,998,997,997,997,996,996,995
.word 995,994,994,994,993,993,992,992,991,991,990,990,990,989,989,988,988,987,987
.word 986,986,985,985,984,984,983,983,982,982,981,981,980,980,979,979,978,978,977
.word 977,976,976,975,974,974,973,973,972,972,971,971,970,969,969,968,968,967,966
.word 966,965,965,964,963,963,962,962,961,960,960,959,959,958,957,957,956,955,955
.word 954,953,953,952,951,951,950,949,949,948,947,947,946,945,945,944,943,943,942
.word 941,940,940,939,938,938,937,936,935,935,934,933,933,932,931,930,930,929,928
.word 927,927,926,925,924,923,923,922,921,920,920,919,918,917,916,916,915,914,913
.word 912,912,911,910,909,908,907,907,906,905,904,903,902,902,901,900,899,898,897
.word 896,896,895,894,893,892,891,890,889,889,888,887,886,885,884,883,882,881,880
.word 880,879,878,877,876,875,874,873,872,871,870,869,868,867,867,866,865,864,863
.word 862,861,860,859,858,857,856,855,854,853,852,851,850,849,848,847,846,845,844
.word 843,842,841,840,839,838,837,836,835,834,833,832,831,829,828,827,826,825,824
.word 823,822,821,820,819,818,817,816,815,813,812,811,810,809,808,807,806,805,804
.word 803,801,800,799,798,797,796,795,794,792,791,790,789,788,787,786,784,783,782
.word 781,780,779,777,776,775,774,773,772,770,769,768,767,766,765,763,762,761,760
.word 759,757,756,755,754,753,751,750,749,748,746,745,744,743,742,740,739,738,737
.word 735,734,733,732,730,729,728,727,725,724,723,722,720,719,718,716,715,714,713
.word 711,710,709,707,706,705,704,702,701,700,698,697,696,694,693,692,690,689,688
.word 687,685,684,683,681,680,679,677,676,674,673,672,670,669,668,666,665,664,662
.word 661,660,658,657,655,654,653,651,650,649,647,646,644,643,642,640,639,637,636
.word 635,633,632,630,629,628,626,625,623,622,621,619,618,616,615,613,612,611,609
.word 608,606,605,603,602,600,599,598,596,595,593,592,590,589,587,586,584,583,581
.word 580,579,577,576,574,573,571,570,568,567,565,564,562,561,559,558,556,555,553
.word 552,550,549,547,546,544,543,541,540,538,537,535,534,532,530,529,527,526,524
.word 523,521,520,518,517,515,514,512,510,509,507,506,504,503,501,500,498,496,495
.word 493,492,490,489,487,485,484,482,481,479,478,476,474,473,471,470,468,466,465
.word 463,462,460,459,457,455,454,452,450,449,447,446,444,442,441,439,438,436,434
.word 433,431,430,428,426,425,423,421,420,418,416,415,413,412,410,408,407,405,403
.word 402,400,398,397,395,394,392,390,389,387,385,384,382,380,379,377,375,374,372
.word 370,369,367,365,364,362,360,359,357,355,354,352,350,349,347,345,344,342,340
.word 338,337,335,333,332,330,328,327,325,323,322,320,318,316,315,313,311,310,308
.word 306,305,303,301,299,298,296,294,293,291,289,287,286,284,282,281,279,277,275
.word 274,272,270,268,267,265,263,262,260,258,256,255,253,251,249,248,246,244,243
.word 241,239,237,236,234,232,230,229,227,225,223,222,220,218,216,215,213,211,209
.word 208,206,204,202,201,199,197,195,194,192,190,188,187,185,183,181,180,178,176
.word 174,173,171,169,167,165,164,162,160,158,157,155,153,151,150,148,146,144,143
.word 141,139,137,135,134,132,130,128,127,125,123,121,119,118,116,114,112,111,109
.word 107,105,103,102,100,98,96,95,93,91,89,87,86,84,82,80,79,77,75,73,71,70,68,66
.word 64,63,61,59,57,55,54,52,50,48,46,45,43,41,39,38,36,34,32,30,29,27,25,23,21,20
.word 18,16,14,13,11,9,7,5,4,2,0,-2,-4,-5,-7,-9,-11,-13,-14,-16,-18,-20,-21,-23,-25
.word -27,-29,-30,-32,-34,-36,-38,-39,-41,-43,-45,-46,-48,-50,-52,-54,-55,-57,-59
.word -61,-63,-64,-66,-68,-70,-71,-73,-75,-77,-79,-80,-82,-84,-86,-87,-89,-91,-93
.word -95,-96,-98,-100,-102,-103,-105,-107,-109,-111,-112,-114,-116,-118,-119,-121
.word -123,-125,-127,-128,-130,-132,-134,-135,-137,-139,-141,-143,-144,-146,-148
.word -150,-151,-153,-155,-157,-158,-160,-162,-164,-165,-167,-169,-171,-173,-174
.word -176,-178,-180,-181,-183,-185,-187,-188,-190,-192,-194,-195,-197,-199,-201
.word -202,-204,-206,-208,-209,-211,-213,-215,-216,-218,-220,-222,-223,-225,-227
.word -229,-230,-232,-234,-236,-237,-239,-241,-243,-244,-246,-248,-249,-251,-253
.word -255,-256,-258,-260,-262,-263,-265,-267,-268,-270,-272,-274,-275,-277,-279
.word -281,-282,-284,-286,-287,-289,-291,-293,-294,-296,-298,-299,-301,-303,-305
.word -306,-308,-310,-311,-313,-315,-316,-318,-320,-322,-323,-325,-327,-328,-330
.word -332,-333,-335,-337,-338,-340,-342,-344,-345,-347,-349,-350,-352,-354,-355
.word -357,-359,-360,-362,-364,-365,-367,-369,-370,-372,-374,-375,-377,-379,-380
.word -382,-384,-385,-387,-389,-390,-392,-394,-395,-397,-398,-400,-402,-403,-405
.word -407,-408,-410,-412,-413,-415,-416,-418,-420,-421,-423,-425,-426,-428,-430
.word -431,-433,-434,-436,-438,-439,-441,-442,-444,-446,-447,-449,-450,-452,-454
.word -455,-457,-459,-460,-462,-463,-465,-466,-468,-470,-471,-473,-474,-476,-478
.word -479,-481,-482,-484,-485,-487,-489,-490,-492,-493,-495,-496,-498,-500,-501
.word -503,-504,-506,-507,-509,-510,-512,-514,-515,-517,-518,-520,-521,-523,-524
.word -526,-527,-529,-530,-532,-534,-535,-537,-538,-540,-541,-543,-544,-546,-547
.word -549,-550,-552,-553,-555,-556,-558,-559,-561,-562,-564,-565,-567,-568,-570
.word -571,-573,-574,-576,-577,-579,-580,-581,-583,-584,-586,-587,-589,-590,-592
.word -593,-595,-596,-598,-599,-600,-602,-603,-605,-606,-608,-609,-611,-612,-613
.word -615,-616,-618,-619,-621,-622,-623,-625,-626,-628,-629,-630,-632,-633,-635
.word -636,-637,-639,-640,-642,-643,-644,-646,-647,-649,-650,-651,-653,-654,-655
.word -657,-658,-660,-661,-662,-664,-665,-666,-668,-669,-670,-672,-673,-674,-676
.word -677,-679,-680,-681,-683,-684,-685,-687,-688,-689,-690,-692,-693,-694,-696
.word -697,-698,-700,-701,-702,-704,-705,-706,-707,-709,-710,-711,-713,-714,-715
.word -716,-718,-719,-720,-722,-723,-724,-725,-727,-728,-729,-730,-732,-733,-734
.word -735,-737,-738,-739,-740,-742,-743,-744,-745,-746,-748,-749,-750,-751,-753
.word -754,-755,-756,-757,-759,-760,-761,-762,-763,-765,-766,-767,-768,-769,-770
.word -772,-773,-774,-775,-776,-777,-779,-780,-781,-782,-783,-784,-786,-787,-788
.word -789,-790,-791,-792,-794,-795,-796,-797,-798,-799,-800,-801,-803,-804,-805
.word -806,-807,-808,-809,-810,-811,-812,-813,-815,-816,-817,-818,-819,-820,-821
.word -822,-823,-824,-825,-826,-827,-828,-829,-831,-832,-833,-834,-835,-836,-837
.word -838,-839,-840,-841,-842,-843,-844,-845,-846,-847,-848,-849,-850,-851,-852
.word -853,-854,-855,-856,-857,-858,-859,-860,-861,-862,-863,-864,-865,-866,-867
.word -867,-868,-869,-870,-871,-872,-873,-874,-875,-876,-877,-878,-879,-880,-880
.word -881,-882,-883,-884,-885,-886,-887,-888,-889,-889,-890,-891,-892,-893,-894
.word -895,-896,-896,-897,-898,-899,-900,-901,-902,-902,-903,-904,-905,-906,-907
.word -907,-908,-909,-910,-911,-912,-912,-913,-914,-915,-916,-916,-917,-918,-919
.word -920,-920,-921,-922,-923,-923,-924,-925,-926,-927,-927,-928,-929,-930,-930
.word -931,-932,-933,-933,-934,-935,-935,-936,-937,-938,-938,-939,-940,-940,-941
.word -942,-943,-943,-944,-945,-945,-946,-947,-947,-948,-949,-949,-950,-951,-951
.word -952,-953,-953,-954,-955,-955,-956,-957,-957,-958,-959,-959,-960,-960,-961
.word -962,-962,-963,-963,-964,-965,-965,-966,-966,-967,-968,-968,-969,-969,-970
.word -971,-971,-972,-972,-973,-973,-974,-974,-975,-976,-976,-977,-977,-978,-978
.word -979,-979,-980,-980,-981,-981,-982,-982,-983,-983,-984,-984,-985,-985,-986
.word -986,-987,-987,-988,-988,-989,-989,-990,-990,-990,-991,-991,-992,-992,-993
.word -993,-994,-994,-994,-995,-995,-996,-996,-997,-997,-997,-998,-998,-999,-999
.word -999,-1000,-1000,-1000,-1001,-1001,-1002,-1002,-1002,-1003,-1003,-1003,-1004
.word -1004,-1004,-1005,-1005,-1006,-1006,-1006,-1007,-1007,-1007,-1007,-1008,-1008
.word -1008,-1009,-1009,-1009,-1010,-1010,-1010,-1011,-1011,-1011,-1011,-1012,-1012
.word -1012,-1012,-1013,-1013,-1013,-1014,-1014,-1014,-1014,-1015,-1015,-1015,-1015
.word -1015,-1016,-1016,-1016,-1016,-1017,-1017,-1017,-1017,-1017,-1018,-1018,-1018
.word -1018,-1018,-1019,-1019,-1019,-1019,-1019,-1019,-1020,-1020,-1020,-1020,-1020
.word -1020,-1021,-1021,-1021,-1021,-1021,-1021,-1021,-1022,-1022,-1022,-1022,-1022
.word -1022,-1022,-1022,-1022,-1023,-1023,-1023,-1023,-1023,-1023,-1023,-1023,-1023
.word -1023,-1023,-1023,-1023,-1023,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024
.word -1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024
.word -1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024,-1024
.word -1024,-1023,-1023,-1023,-1023,-1023,-1023,-1023,-1023,-1023,-1023,-1023,-1023
.word -1023,-1023,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1021,-1021
.word -1021,-1021,-1021,-1021,-1021,-1020,-1020,-1020,-1020,-1020,-1020,-1019,-1019
.word -1019,-1019,-1019,-1019,-1018,-1018,-1018,-1018,-1018,-1017,-1017,-1017,-1017
.word -1017,-1016,-1016,-1016,-1016,-1015,-1015,-1015,-1015,-1015,-1014,-1014,-1014
.word -1014,-1013,-1013,-1013,-1012,-1012,-1012,-1012,-1011,-1011,-1011,-1011,-1010
.word -1010,-1010,-1009,-1009,-1009,-1008,-1008,-1008,-1007,-1007,-1007,-1007,-1006
.word -1006,-1006,-1005,-1005,-1004,-1004,-1004,-1003,-1003,-1003,-1002,-1002,-1002
.word -1001,-1001,-1000,-1000,-1000,-999,-999,-999,-998,-998,-997,-997,-997,-996
.word -996,-995,-995,-994,-994,-994,-993,-993,-992,-992,-991,-991,-990,-990,-990
.word -989,-989,-988,-988,-987,-987,-986,-986,-985,-985,-984,-984,-983,-983,-982
.word -982,-981,-981,-980,-980,-979,-979,-978,-978,-977,-977,-976,-976,-975,-974
.word -974,-973,-973,-972,-972,-971,-971,-970,-969,-969,-968,-968,-967,-966,-966
.word -965,-965,-964,-963,-963,-962,-962,-961,-960,-960,-959,-959,-958,-957,-957
.word -956,-955,-955,-954,-953,-953,-952,-951,-951,-950,-949,-949,-948,-947,-947
.word -946,-945,-945,-944,-943,-943,-942,-941,-940,-940,-939,-938,-938,-937,-936
.word -935,-935,-934,-933,-933,-932,-931,-930,-930,-929,-928,-927,-927,-926,-925
.word -924,-923,-923,-922,-921,-920,-920,-919,-918,-917,-916,-916,-915,-914,-913
.word -912,-912,-911,-910,-909,-908,-907,-907,-906,-905,-904,-903,-902,-902,-901
.word -900,-899,-898,-897,-896,-896,-895,-894,-893,-892,-891,-890,-889,-889,-888
.word -887,-886,-885,-884,-883,-882,-881,-880,-880,-879,-878,-877,-876,-875,-874
.word -873,-872,-871,-870,-869,-868,-867,-867,-866,-865,-864,-863,-862,-861,-860
.word -859,-858,-857,-856,-855,-854,-853,-852,-851,-850,-849,-848,-847,-846,-845
.word -844,-843,-842,-841,-840,-839,-838,-837,-836,-835,-834,-833,-832,-831,-829
.word -828,-827,-826,-825,-824,-823,-822,-821,-820,-819,-818,-817,-816,-815,-813
.word -812,-811,-810,-809,-808,-807,-806,-805,-804,-803,-801,-800,-799,-798,-797
.word -796,-795,-794,-792,-791,-790,-789,-788,-787,-786,-784,-783,-782,-781,-780
.word -779,-777,-776,-775,-774,-773,-772,-770,-769,-768,-767,-766,-765,-763,-762
.word -761,-760,-759,-757,-756,-755,-754,-753,-751,-750,-749,-748,-746,-745,-744
.word -743,-742,-740,-739,-738,-737,-735,-734,-733,-732,-730,-729,-728,-727,-725
.word -724,-723,-722,-720,-719,-718,-716,-715,-714,-713,-711,-710,-709,-707,-706
.word -705,-704,-702,-701,-700,-698,-697,-696,-694,-693,-692,-690,-689,-688,-687
.word -685,-684,-683,-681,-680,-679,-677,-676,-674,-673,-672,-670,-669,-668,-666
.word -665,-664,-662,-661,-660,-658,-657,-655,-654,-653,-651,-650,-649,-647,-646
.word -644,-643,-642,-640,-639,-637,-636,-635,-633,-632,-630,-629,-628,-626,-625
.word -623,-622,-621,-619,-618,-616,-615,-613,-612,-611,-609,-608,-606,-605,-603
.word -602,-600,-599,-598,-596,-595,-593,-592,-590,-589,-587,-586,-584,-583,-581
.word -580,-579,-577,-576,-574,-573,-571,-570,-568,-567,-565,-564,-562,-561,-559
.word -558,-556,-555,-553,-552,-550,-549,-547,-546,-544,-543,-541,-540,-538,-537
.word -535,-534,-532,-530,-529,-527,-526,-524,-523,-521,-520,-518,-517,-515,-514
.word -512,-510,-509,-507,-506,-504,-503,-501,-500,-498,-496,-495,-493,-492,-490
.word -489,-487,-485,-484,-482,-481,-479,-478,-476,-474,-473,-471,-470,-468,-466
.word -465,-463,-462,-460,-459,-457,-455,-454,-452,-450,-449,-447,-446,-444,-442
.word -441,-439,-438,-436,-434,-433,-431,-430,-428,-426,-425,-423,-421,-420,-418
.word -416,-415,-413,-412,-410,-408,-407,-405,-403,-402,-400,-398,-397,-395,-394
.word -392,-390,-389,-387,-385,-384,-382,-380,-379,-377,-375,-374,-372,-370,-369
.word -367,-365,-364,-362,-360,-359,-357,-355,-354,-352,-350,-349,-347,-345,-344
.word -342,-340,-338,-337,-335,-333,-332,-330,-328,-327,-325,-323,-322,-320,-318
.word -316,-315,-313,-311,-310,-308,-306,-305,-303,-301,-299,-298,-296,-294,-293
.word -291,-289,-287,-286,-284,-282,-281,-279,-277,-275,-274,-272,-270,-268,-267
.word -265,-263,-262,-260,-258,-256,-255,-253,-251,-249,-248,-246,-244,-243,-241
.word -239,-237,-236,-234,-232,-230,-229,-227,-225,-223,-222,-220,-218,-216,-215
.word -213,-211,-209,-208,-206,-204,-202,-201,-199,-197,-195,-194,-192,-190,-188
.word -187,-185,-183,-181,-180,-178,-176,-174,-173,-171,-169,-167,-165,-164,-162
.word -160,-158,-157,-155,-153,-151,-150,-148,-146,-144,-143,-141,-139,-137,-135
.word -134,-132,-130,-128,-127,-125,-123,-121,-119,-118,-116,-114,-112,-111,-109
.word -107,-105,-103,-102,-100,-98,-96,-95,-93,-91,-89,-87,-86,-84,-82,-80,-79,-77
.word -75,-73,-71,-70,-68,-66,-64,-63,-61,-59,-57,-55,-54,-52,-50,-48,-46,-45,-43
.word -41,-39,-38,-36,-34,-32,-30,-29,-27,-25,-23,-21,-20,-18,-16,-14,-13,-11,-9
.word -7,-5,-4,-2,0,2,4,5,7,9,11,13,14,16,18,20,21,23,25,27,29,30,32,34,36,38,39
.word 41,43,45,46,48,50,52,54,55,57,59,61,63,64,66,68,70,71,73,75,77,79,80,82,84
.word 86,87,89,91,93,95,96,98,100,102,103,105,107,109,111,112,114,116,118,119,121
.word 123,125,127,128,130,132,134,135,137,139,141,143,144,146,148,150,151,153,155
.word 157,158,160,162,164,165,167,169,171,173,174,176,178,180,181,183,185,187,188
.word 190,192,194,195,197,199,201,202,204,206,208,209,211,213,215,216,218,220,222
.word 223,225,227,229,230,232,234,236,237,239,241,243,244,246,248,249,251,253,255
.word 256,258,260,262,263,265,267,268,270,272,274,275,277,279,281,282,284,286,287
.word 289,291,293,294,296,298,299,301,303,305,306,308,310,311,313,315,316,318,320
.word 322,323,325,327,328,330,332,333,335,337,338,340,342,344,345,347,349,350,352
.word 354,355,357,359,360,362,364,365,367,369,370,372,374,375,377,379,380,382,384
.word 385,387,389,390,392,394,395,397,398,400,402,403,405,407,408,410,412,413,415
.word 416,418,420,421,423,425,426,428,430,431,433,434,436,438,439,441,442,444,446
.word 447,449,450,452,454,455,457,459,460,462,463,465,466,468,470,471,473,474,476
.word 478,479,481,482,484,485,487,489,490,492,493,495,496,498,500,501,503,504,506
.word 507,509,510,512,514,515,517,518,520,521,523,524,526,527,529,530,532,534,535
.word 537,538,540,541,543,544,546,547,549,550,552,553,555,556,558,559,561,562,564
.word 565,567,568,570,571,573,574,576,577,579,580,581,583,584,586,587,589,590,592
.word 593,595,596,598,599,600,602,603,605,606,608,609,611,612,613,615,616,618,619
.word 621,622,623,625,626,628,629,630,632,633,635,636,637,639,640,642,643,644,646
.word 647,649,650,651,653,654,655,657,658,660,661,662,664,665,666,668,669,670,672
.word 673,674,676,677,679,680,681,683,684,685,687,688,689,690,692,693,694,696,697
.word 698,700,701,702,704,705,706,707,709,710,711,713,714,715,716,718,719,720,722
.word 723,724,725,727,728,729,730,732,733,734,735,737,738,739,740,742,743,744,745
.word 746,748,749,750,751,753,754,755,756,757,759,760,761,762,763,765,766,767,768
.word 769,770,772,773,774,775,776,777,779,780,781,782,783,784,786,787,788,789,790
.word 791,792,794,795,796,797,798,799,800,801,803,804,805,806,807,808,809,810,811
.word 812,813,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,831,832
.word 833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851
.word 852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,867,868,869
.word 870,871,872,873,874,875,876,877,878,879,880,880,881,882,883,884,885,886,887
.word 888,889,889,890,891,892,893,894,895,896,896,897,898,899,900,901,902,902,903
.word 904,905,906,907,907,908,909,910,911,912,912,913,914,915,916,916,917,918,919
.word 920,920,921,922,923,923,924,925,926,927,927,928,929,930,930,931,932,933,933
.word 934,935,935,936,937,938,938,939,940,940,941,942,943,943,944,945,945,946,947
.word 947,948,949,949,950,951,951,952,953,953,954,955,955,956,957,957,958,959,959
.word 960,960,961,962,962,963,963,964,965,965,966,966,967,968,968,969,969,970,971
.word 971,972,972,973,973,974,974,975,976,976,977,977,978,978,979,979,980,980,981
.word 981,982,982,983,983,984,984,985,985,986,986,987,987,988,988,989,989,990,990
.word 990,991,991,992,992,993,993,994,994,994,995,995,996,996,997,997,997,998,998
.word 999,999,999,1000,1000,1000,1001,1001,1002,1002,1002,1003,1003,1003,1004,1004
.word 1004,1005,1005,1006,1006,1006,1007,1007,1007,1007,1008,1008,1008,1009,1009
.word 1009,1010,1010,1010,1011,1011,1011,1011,1012,1012,1012,1012,1013,1013,1013
.word 1014,1014,1014,1014,1015,1015,1015,1015,1015,1016,1016,1016,1016,1017,1017
.word 1017,1017,1017,1018,1018,1018,1018,1018,1019,1019,1019,1019,1019,1019,1020
.word 1020,1020,1020,1020,1020,1021,1021,1021,1021,1021,1021,1021,1022,1022,1022
.word 1022,1022,1022,1022,1022,1022,1023,1023,1023,1023,1023,1023,1023,1023,1023
.word 1023,1023,1023,1023,1023,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024
.word 1024,1024,1024,1024,1024,1024,1024,1024

WORLD:

;Europe, Asia & Africa
.byte 218
.word 410,290,420,350,410,380,425,423,460,370,480,380,465,350,460,370,443,340
.word 455,320,462,335,470,310,425,270,410,290,408,230,380,240,365,228,405,195
.word 420,195,457,137,455,123,444,123,436,136,425,141,400,185,405,170,397,165
.word 390,172,380,156,380,125,366,150,389,161,400,157,413,130,430,105,443,89
.word 432,62,435,40,427,30,418,33,395,-4,387,3,366,-21,365,-48,360,-54
.word 371,-67,370,-88,386,-88,386,-94,412,-86,431,-93,437,-77,433,-15,461,-12
.word 473,-25,480,-47,486,-47,488,-31,487,-17,498,-20,498,-13,494,-11,493,-1
.word 497,2,502,15,509,16,514,36,533,47,540,83,570,81,576,107,564,119
.word 545,100,540,142,550,200,590,220,600,300,606,280,600,220,630,210,656,260
.word 660,220,610,170,600,160,560,160,554,130,590,103,580,76,585,60,625,55
.word 640,100,703,190,712,270,678,415,665,390,672,330,645,350,640,400,682,440
.word 690,670,720,700,770,1120,740,1100,720,1300,700,1750,670,1900,660,1770
.word 630,1800,600,1700,600,1630,550,1620,510,1570,570,1560,620,1630,620,1570
.word 590,1530,590,1430,550,1350,540,1410,480,1400,390,1280,350,1295,340,1260
.word 390,1255,410,1210,385,1180,300,1220,230,1170,210,1100,220,1080,190,1055
.word 145,1090,115,1090,80,1050,130,1005,90,990,50,1035,10,1040,40,1010,90,980
.word 170,970,230,920,150,800,100,800,80,770,120,745,210,720,250,670,250,560
.word 300,500,295,490,240,530,250,560,240,560,230,600,170,560,125,440,280,350
.word 280,330,150,400,105,450,120,514,40,477,-50,390,-160,410,-200,350,-250,350
.word -260,330,-290,320,-340,260,-350,200,-180,120,-110,140,-10,90,30,100,46,84
.word 43,59,65,43,48,-20,46,-77,78,-129,96,-134,124,-167,149,-176,172,-161
.word 213,-172,280,-129,303,-95,310,-98,320,-98,333,-83,339,-69,358,-60,359,-54
.word 352,-47,350,-20,364,10,373,102,367,104,370,110,361,105,352,111,340,100
.word 328,125,329,132,324,153,315,156,300,190,310,200,320,197,330,220,310,290
.word 316,310,312,335,370,360,370,280,400,260,410,290
;UK
.byte 19
.word 585,-50,582,-18,560,-33,560,-20,530,5,530,16,522,17,513,8,513,15,509,10
.word 500,-58,514,-37,517,-50,533,-45,533,-30,550,-35,547,-50,575,-65,585,-50

;Ireland
.byte 5
.word 553,-65,543,-100,514,-100,522,-63,553,-65

;Island
.byte 7
.word 665,-225,654,-245,666,-160,650,-135,630,-190,640,-220,665,-225

;Corsica & Sardinia
.byte 10
.word 430,94,424,85,415,88,409,98,391,97,389,84,408,84,413,92,421,96,430,94

; Madagascar
.byte 6
.word -130,490,-170,440,-250,440,-250,470,-150,505,-130,490

; Greenland
.byte 12
.word 600,-440,650,-400,700,-220,820,-150,836,-300,785,-730
.word 760,-680,756,-590,700,-510,660,-535,610,-480,600,-440

;North & South America
.byte 84
.word 630,-770,520,-560,500,-650,460,-640,437,-704,415,-707,406,-740,370,-760
.word 352,-757,310,-816,270,-800,250,-805,280,-827,290,-825,300,-840,303,-890
.word 290,-900,297,-940,270,-975,220,-977,190,-960,184,-940,190,-910,210,-900
.word 216,-870,160,-890,156,-830,105,-835,90,-815,97,-790,80,-770,110,-750
.word 120,-710,106,-630,40,-520,0,-500,-60,-340,-120,-390,-220,-410,-250,-480
.word -280,-480,-410,-630,-510,-690,-550,-650,-550,-700,-500,-760,-370,-740
.word -180,-700,-60,-810,0,-810,66,-775,90,-790,70,-810,95,-850,130,-880
.word 140,-915,162,-950,157,-966,196,-1060,220,-1057,290,-1124,313,-1130
.word 316,-1150,300,-1146,230,-1095,250,-1123,300,-1159,340,-1185,345,-1207
.word 390,-1240,430,-1245,485,-1245,590,-1380,610,-1480,540,-1650,590,-1580
.word 620,-1660,680,-1670,710,-1570,680,-1100,700,-820,600,-950,540,-800,630,-770

;Australia
.byte 32
.word -105,1424,-175,1410,-150,1355,-120,1370,-110,1320,-150,1290,-140,1270
.word -200,1200,-220,1140,-260,1130,-320,1160,-345,1150,-352,1180,-315,1300
.word -325,1335,-350,1355,-330,1378,-352,1375,-380,1404,-390,1434,-378,1450
.word -392,1460,-375,1500,-340,1510,-327,1527,-290,1536,-256,1530,-200,1484
.word -188,1463,-145,1447,-147,1440,-105,1424

; Antartic
.byte 29
.word -630,-560,-640,-600,-660,-650,-730,-750,-730,-850,-730,-1000,-750,-1000
.word -730,-1250,-750,-1370,-780,-1650,-776,1640,-720,1700,-680,1550,-660,1350
.word -660,1150,-660,900,-695,750,-680,700,-660,550,-690,400,-700,200,-700,0
.word -710,-100,-740,-200,-780,-350,-750,-600,-670,-610,-643,-590,-630,-550

;
.byte 7
.word 97,800,70,820,65,818,63,805,64,800,80,797,97,800

; Japan
.byte 22
.word 455,1418,433,1457,420,1430,426,1416,406,1400,382,1396,370,1369,356,1357
.word 356,1330,340,1309,329,1320,314,1313,312,1302,333,1297,340,1309,345,1350
.word 335,1357,360,1406,398,1420,425,1397,435,1414,455,1418

; Sumatra & Java
.byte 11
.word 60,950,17,989,-32,1016,-59,1057,-66,1142,-86,1145,-71,1056,-29,1059
.word 4,1036,50,975,60,950

; Borneo
.byte 6
.word 19,1093,70,1169,50,1193,-40,1160,-29,1103,19,1093

; Melanesia
.byte 11
.word 0,1300,-25,1410,-65,1480,-68,1468,-107,1510,-77,1443,-93,1430,-80,1384
.word -54,1381,-40,1331,0,1300

; New Zeland
.byte 14
.word -345,1727,-367,1759,-375,1760,-380,1773,-374,1785,-416,1755,-406,1725
.word -428,1710,-460,1662,-467,1694,-402,1753,-393,1740,-377,1748,-345,1727

.byte -1

; Meridians
.byte 19
.word 900,0,800,0,700,0,600,0,500,0,400,0,300,0,200,0,100,0,0,0
.word -100,0,-200,0,-300,0,-400,0,-500,0,-600,0,-700,0,-800,0,-900,0
.byte 19
.word 900,300,800,300,700,300,600,300,500,300,400,300,300,300,200,300,100,300,0,300
.word -100,300,-200,300,-300,300,-400,300,-500,300,-600,300,-700,300,-800,300,-900,300
.byte 19
.word 900,600,800,600,700,600,600,600,500,600,400,600,300,600,200,600,100,600,0,600
.word -100,600,-200,600,-300,600,-400,600,-500,600,-600,600,-700,600,-800,600,-900,600
.byte 19
.word 900,900,800,900,700,900,600,900,500,900,400,900,300,900,200,900,100,900,0,900
.word -100,900,-200,900,-300,900,-400,900,-500,900,-600,900,-700,900,-800,900,-900,900
.byte 19
.word 900,1200,800,1200,700,1200,600,1200,500,1200,400,1200,300,1200,200,1200,100,1200,0,1200
.word -100,1200,-200,1200,-300,1200,-400,1200,-500,1200,-600,1200,-700,1200,-800,1200,-900,1200
.byte 19
.word 900,1500,800,1500,700,1500,600,1500,500,1500,400,1500,300,1500,200,1500,100,1500,0,1500
.word -100,1500,-200,1500,-300,1500,-400,1500,-500,1500,-600,1500,-700,1500,-800,1500,-900,1500
.byte 19
.word 900,1800,800,1800,700,1800,600,1800,500,1800,400,1800,300,1800,200,1800,100,1800,0,1800
.word -100,1800,-200,1800,-300,1800,-400,1800,-500,1800,-600,1800,-700,1800,-800,1800,-900,1800
.byte 19
.word 900,2100,800,2100,700,2100,600,2100,500,2100,400,2100,300,2100,200,2100,100,2100,0,2100
.word -100,2100,-200,2100,-300,2100,-400,2100,-500,2100,-600,2100,-700,2100,-800,2100,-900,2100
.byte 19
.word 900,2400,800,2400,700,2400,600,2400,500,2400,400,2400,300,2400,200,2400,100,2400,0,2400
.word -100,2400,-200,2400,-300,2400,-400,2400,-500,2400,-600,2400,-700,2400,-800,2400,-900,2400
.byte 19
.word 900,2700,800,2700,700,2700,600,2700,500,2700,400,2700,300,2700,200,2700,100,2700,0,2700
.word -100,2700,-200,2700,-300,2700,-400,2700,-500,2700,-600,2700,-700,2700,-800,2700,-900,2700
.byte 19
.word 900,3000,800,3000,700,3000,600,3000,500,3000,400,3000,300,3000,200,3000,100,3000,0,3000
.word -100,3000,-200,3000,-300,3000,-400,3000,-500,3000,-600,3000,-700,3000,-800,3000,-900,3000
.byte 19
.word 900,3300,800,3300,700,3300,600,3300,500,3300,400,3300,300,3300,200,3300,100,3300,0,3300
.word -100,3300,-200,3300,-300,3300,-400,3300,-500,3300,-600,3300,-700,3300,-800,3300,-900,3300

; Parallels
.byte 37
.word -600,0,-600,100,-600,200,-600,300,-600,400,-600,500,-600,600,-600,700,-600,800,-600,900
.word -600,1000,-600,1100,-600,1200,-600,1300,-600,1400,-600,1500,-600,1600,-600,1700,-600,1800
.word -600,1900,-600,2000,-600,2100,-600,2200,-600,2300,-600,2400,-600,2400,-600,2600,-600,2700
.word -600,2800,-600,2900,-600,3000,-600,3100,-600,3200,-600,3300,-600,3400,-600,3500,-600,3600
.byte 37
.word -300,0,-300,100,-300,200,-300,300,-300,400,-300,500,-300,600,-300,700,-300,800,-300,900
.word -300,1000,-300,1100,-300,1200,-300,1300,-300,1400,-300,1500,-300,1600,-300,1700,-300,1800
.word -300,1900,-300,2000,-300,2100,-300,2200,-300,2300,-300,2400,-300,2400,-300,2600,-300,2700
.word -300,2800,-300,2900,-300,3000,-300,3100,-300,3200,-300,3300,-300,3400,-300,3500,-300,3600
.byte 37
.word 0,0,0,100,0,200,0,300,0,400,0,500,0,600,0,700,0,800,0,900
.word 0,1000,0,1100,0,1200,0,1300,0,1400,0,1500,0,1600,0,1700,0,1800
.word 0,1900,0,2000,0,2100,0,2200,0,2300,0,2400,0,2400,0,2600,0,2700
.word 0,2800,0,2900,0,3000,0,3100,0,3200,0,3300,0,3400,0,3500,0,3600
.byte 37
.word 300,0,300,100,300,200,300,300,300,400,300,500,300,600,300,700,300,800,300,900
.word 300,1000,300,1100,300,1200,300,1300,300,1400,300,1500,300,1600,300,1700,300,1800
.word 300,1900,300,2000,300,2100,300,2200,300,2300,300,2400,300,2400,300,2600,300,2700
.word 300,2800,300,2900,300,3000,300,3100,300,3200,300,3300,300,3400,300,3500,300,3600
.byte 37
.word 600,0,600,100,600,200,600,300,600,400,600,500,600,600,600,700,600,800,600,900
.word 600,1000,600,1100,600,1200,600,1300,600,1400,600,1500,600,1600,600,1700,600,1800
.word 600,1900,600,2000,600,2100,600,2200,600,2300,600,2400,600,2400,600,2600,600,2700
.word 600,2800,600,2900,600,3000,600,3100,600,3200,600,3300,600,3400,600,3500,600,3600

;The end
.byte 0

.ORG    $7FFF
.byte   0FFH
.end					;End of program
