/*------------------------------------------------------------------*/
/*                          URC-Recorder                            */
/*------------------------------------------------------------------*/


#include "URCRec.h"

char         glb_RecBuffer[4000];
int          glb_RecId;

char         glb_Memo[3584];
char         glb_Memo_Title[256];

char         glb_FlashFlag;

/* Declare pointers for our DeskBox and each of our controls */

PDESKBOX     *dsk;
PBUTTON      *ReadyButton;
PBUTTON      *LearnButton;
PBUTTON      *SendButton;

char         ReadyLabel[]="Exit";
char         LearnLabel[]="Learn";
char         SendLabel[]="Send";
char         WindowTitle[]="URC Recorder";


#include "irport.c"

/*********************************************************************/
int ReadMemoRecord(int par_RecId,char* par_Memo_Title,char* par_Memo)
{

/*
	Funtion : Read a Memo-Record  
		  Private-Bit and Category wil be ignored
*/

  unsigned int  Compare_RecOffset; 
 
  char*         pFieldPtr;
  PIMHEAD*      pPIMHead;
  RECHEAD*      pRECHead;

  par_Memo_Title[0]=0;
  par_Memo[0]=0;
 
  pPIMHead=(PIMHEAD*)glb_RecBuffer;
  pRECHead=(RECHEAD*)(glb_RecBuffer+sizeof(PIMHEAD));
	
  if(IsAliveRecord(TYPE_MEMO,par_RecId))
  {
	ReadRecord(TYPE_MEMO,par_RecId,0,&glb_RecBuffer,sizeof(glb_RecBuffer));

	Compare_RecOffset=(pPIMHead->fieldCount>3) ? pRECHead[3].offset:pPIMHead->synKeyOffset;
	if(pPIMHead->fieldCount>2 && pRECHead[2].offset!=Compare_RecOffset)
	{
		pFieldPtr=(char*)glb_RecBuffer;
		pFieldPtr=pFieldPtr+pRECHead[2].offset;
		strcpy(par_Memo_Title,pFieldPtr);
	}

	Compare_RecOffset=(pPIMHead->fieldCount>4) ? pRECHead[4].offset:pPIMHead->synKeyOffset;
	if(pPIMHead->fieldCount>3 && pRECHead[3].offset!=Compare_RecOffset)
	{
		pFieldPtr=(char*)glb_RecBuffer;
		pFieldPtr=pFieldPtr+pRECHead[3].offset;
		strcpy(par_Memo,pFieldPtr);
	}

	return SUCCESS;
		 
  }
  else
  {
	return FAIL;
  }
}
/*------------------------------------------------------------------------------*/
void PutMemoRecord(int par_RecId,char* par_Memo_Title,char* par_Memo)
{

/* 
	Funtion : Create or Change a memo-Record  
		  Private-Bit and Category are set to 0 

*/
#define NUMBER_OF_FIELDS 4

  char*       pFieldPtr;
  char*       pField0_private_bit;
  char*       pField1_categorie;
  char*       pField2_Memo_Title;
  char*       pField3_Memo;
  char*       precbuf;
  PIMHEAD*    pPIMHead;
  RECHEAD*    pRECHead;

  pPIMHead=(PIMHEAD*)glb_RecBuffer;
  pRECHead=(RECHEAD*)(glb_RecBuffer + sizeof(PIMHEAD));
  pFieldPtr=(char*)pRECHead + NUMBER_OF_FIELDS * sizeof(RECHEAD);
  precbuf=(char*)glb_RecBuffer;

  pField0_private_bit=pFieldPtr;
  pFieldPtr+=0;                 /* private is in PIMHead! */

  pField1_categorie=pFieldPtr;
  pFieldPtr+=0;                 /* Categorie is in PIMHead! */

  pField2_Memo_Title=pFieldPtr;
  pFieldPtr=pFieldPtr + strlen(par_Memo_Title) + 1;  /* Title */

  pField3_Memo=pFieldPtr;
  pFieldPtr=pFieldPtr + strlen(par_Memo) + 1;  /* Memo text */

  memset(pPIMHead,0,sizeof(PIMHEAD));

  pPIMHead->typeID=TYPE_MEMO;
  pPIMHead->fieldCount=NUMBER_OF_FIELDS;
  pPIMHead->recLength=pFieldPtr - precbuf;
  pPIMHead->synKeyOffset=pFieldPtr - precbuf;

  pRECHead[0].offset=pField0_private_bit - precbuf;
  pRECHead[1].offset=pField1_categorie - precbuf;
  pRECHead[2].offset=pField2_Memo_Title - precbuf;
  pRECHead[3].offset=pField3_Memo - precbuf;

  strcpy(pField2_Memo_Title,par_Memo_Title);
  strcpy(pField3_Memo ,par_Memo);

  if (par_RecId==FAIL) /* FAIL means a Record is to be created */
  {
  	if (AllocPIMRecordSpace(TYPE_MEMO,pPIMHead->recLength)==SUCCESS)
  	{
		  if (CreateRecord(TYPE_MEMO,glb_RecBuffer,pPIMHead->recLength)==FAIL)
			MessageBox("Error at CreateRecord",mfWarning|mfOKButton);	
  	}
  	else
  	{
		MessageBox("Error at AllocateRecordSpace",mfWarning|mfOKButton);	
  	}
  }
  else
  {
	if (ChangeRecord(TYPE_MEMO,par_RecId,glb_RecBuffer,pPIMHead->recLength)==FAIL)
			MessageBox("Error at ChangeRecord",mfWarning|mfOKButton);	
  }
}
/*-----------------------------------------------------------------*/
int GetRecId(void)
{
/*
	Funtion : Search for the Memo-Record with 
		  Title = "Remote Control Record\n"  
*/

  int          loc_RecId;
  unsigned int loc_RecCount;
  unsigned int loc_aliveRecCount;


  GetRecordCount(TYPE_MEMO,&loc_RecCount,&loc_aliveRecCount);

  for(loc_RecId=0;loc_RecId<loc_RecCount;loc_RecId++)
  {
	if (ReadMemoRecord(loc_RecId,glb_Memo_Title,glb_Memo)==SUCCESS)
	{ 
		if(!strcmp(glb_Memo_Title,"Remote Control Record\n"))
		{
			return loc_RecId;
		}
  	}
  }

  return FAIL;
}

/*------------------------------------------------------------------*/
int htoi(unsigned char x)
{
/*  Function : Convert ca Character into Hex-Value */

  return (x>='A') ? x-'A'+10 : x-'0';
}
/*------------------------------------------------------------------*/
void put_text()
{
/*  Function : Converts HexByte-Field glb_Memo into Byte-Array IrByte */
  int i;
  NumberOfEntries=0;

  for(i=0;i<strlen(glb_Memo);i+=2)
  {
	if (glb_Memo[i]>' ') /* skip blanks and line feeds */
	{
		IrByte[NumberOfEntries++]=16*htoi(glb_Memo[i]) + htoi(glb_Memo[i+1]);
	}
	else
	{
		i--;
	}
  }

}

/*-------------------------------------------------------------*/

void get_text()
{
/*  Function : Converts Byte-Array IrByte into a HexByte-Field glb_Memo */

  char buf[10];
  int i,zz=0;
  glb_FlashFlag=FALSE;

  glb_Memo[0]=0;

  for (i=0;i<=MAXIRBYTES;i++)
  {
	if (IrByte[i]>127) glb_FlashFlag=TRUE;
	itoa(IrByte[i],buf,16);
	if (strlen(buf)==1)strcat(glb_Memo,"0");
	strcat(glb_Memo,buf);
	zz++;
	if (zz==10)
	{
		zz=0;
		strcat(glb_Memo," ");  /* insert a blank for better reading */ 
	}
  }
   
}

/*-----------------------------------------------------------*/
void dsk_draw(VOID_PTR view)
{ 
  PDESKBOX_draw(view); 

  SetLineSize(0);
  SetFontType(PRPFONT11B);
  if (glb_RecId>=0)
  {
	WriteString(4,  18, "Click Learn again or Send",DRAW_BLACK);
  }
  else
  {
	WriteString(4,  18, "Click Learn to Start ",DRAW_BLACK);
	WriteString(84,  30, "Recording",DRAW_BLACK);
  }
}

/*-------------------------------------------------------*/
void dsk_handleEvent(VOID_PTR view, unsigned int *evType, unsigned char x,unsigned char y)
{  
 
   PDESKBOX_handleEvent(view,evType,x,y); 
 
   if (*evType == evCommand)
   {

      switch(TOWORD(x,y)) /* TOWORD combines the 8-bit 'x' and 'y' into one
                             16-bit value, the 'command'. */
      {
         case cmReady :  /* Exit screen */
                PutEvent(evCommand, HIGBYTE(cmQuit),LOWBYTE(cmQuit));
                break;
         case cmLearn :  /* Learn */
		WriteString(4,  48, "Press SendKey on your",DRAW_BLACK);
		WriteString(25,  60, "Original Remote Control",DRAW_BLACK);

		NumberOfEntries=MAXIRBYTES;
		learn();
		WriteString(4,  80, "Thank you - Formating ...",DRAW_BLACK);
		LoadIndexTable(TYPE_MEMO);
		glb_RecId=GetRecId();
		get_text();
		if (glb_FlashFlag)
		{
			WriteString(4,  100, "Saving ...",DRAW_BLACK);
			strcat(glb_Memo,"\n");
			PutMemoRecord(glb_RecId,"Remote Control Record\n",glb_Memo);
		 	SaveIndexTable(TYPE_MEMO);
			glb_RecId=GetRecId();
			WriteString(4,  120, "Ready.",DRAW_BLACK);
			MessageBox("IR-Signal saved.",mfWarning|mfOKButton); 	
		}
		else
		{
			MessageBox("No IR-Signal received.",mfWarning|mfOKButton); 	
		}
		PutEvent(evCommand, HIGBYTE(cmRedraw),LOWBYTE(cmRedraw));
                break;
         case cmSend :  /* Send */
		WriteString(4,  48, "Reading Memo ...",DRAW_BLACK);
		LoadIndexTable(TYPE_MEMO);
		glb_RecId=GetRecId();
		if (glb_RecId>=0)
		{
			WriteString(4,  68, "Formating ...",DRAW_BLACK);
			put_text();
			WriteString(4,  88, "Sending ...",DRAW_BLACK);
			sende();
			WriteString(4,  108, "Ready.",DRAW_BLACK);
		}
		else
		{
			MessageBox("Memo-Record for Remote Control not found",mfWarning|mfOKButton); 	
		}
		PutEvent(evCommand, HIGBYTE(cmRedraw),LOWBYTE(cmRedraw));
                break;
         default:
           	break;
      }
   }
}

/*----------------------------------------------------------------*/

void guiscreen()
{
   int  id=100;

   dsk = (PDESKBOX *)CreateDeskBox(id++, 0, 0, 159, 239, MK_FAR_PTR(WindowTitle),NULL_FP, NULL_FP,bafClose ); 
   dsk->options &= ~ofHardKeyable; 

   ReadyButton = (PBUTTON *)CreateButton(id++,   4, 220,  50, 236, MK_FAR_PTR(ReadyLabel), (unsigned short) cmReady, bttBasic);
   LearnButton = (PBUTTON *)CreateButton(id++,  56, 220, 102, 236, MK_FAR_PTR(LearnLabel) ,      (unsigned short) cmLearn, bttBasic);
   SendButton  = (PBUTTON *)CreateButton(id++, 108, 220, 154, 236, MK_FAR_PTR(SendLabel)  ,      (unsigned short) cmSend,  bttBasic);
 
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) ReadyButton);
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) LearnButton);
   PGROUP_insert((VOID_PTR) dsk, (PVIEW *) SendButton);
  
   BankedAssign1(dsk->draw,dsk_draw); 
   BankedAssign2(dsk->handleEvent,dsk_handleEvent);
   
   ExecView((PGROUP_PTR) dsk);
   Destroy((VOID_PTR) dsk);
}

/*------------------------------------------------------------------*/
int main() 
{
  ClearLCD(0);
  LoadIndexTable(TYPE_MEMO);
  glb_RecId=GetRecId();

  guiscreen();
  return APPLICATION;
}