
ANALYSIS LIBRARY FILENAME:   libanal.a

INIT_ANAL   Initializes hardware and loads analysis software.
            int  init_anal(port, protocol, par)
            int port, protocol;
            union PARBLOCK *par;

             Port   0   Port A
                    1   Port B
                    2   Port A and B
             Protocol   1   BOP
                        2   ISDN
                        7   ASYNC
                        8   BSC
             Par: 
             union PARBLOCK   {  /* BOP parameter block */
                struct {
                    unsigned short encode;
                } pbop;

                struct    {   /* Bisync parameter block */
                    unsigned short  table;
                    unsigned short  bcc;
                    char   sync1;
                    char   sync2; 
                    unsigned short  parity;
                }pbisync;

                struct  {      /* Async parameter block */
                    unsigned short  baud;
                    unsigned short  parity;
                    unsigned short  databit;
                }pasync;
             };

           BOP
           ISDN  If Protocol = 1 (BOP) or 2 (ISDN), 
                  initialize:
                  par->pbop.encode   0   NRZ
                                    1   NRZI

           ASYNC  If Protocol = 7 (Async), initialize:
                  par->pasync.baud   2   75    baud rate
                                     3   110 
                                     5   300
                                     6   600
                                     7   1200
                                     8   2400
                                     9   4800
                                    10   9600
                                    11   19200

                  par->pasync.parity   0   None
                                       1   Odd
                                       2   Even

                  par->pasync.databit   5   5 data bit
                                        6   6 data bits
                                        7   7 data bits
                                        8   8 data bits

            BSC   If Protocol=8 (BSC), initialize:
                  par->pbsync.table   0   ASCII
                                      1   EBCDIC
                  par->pbsync.bcc   0   CRC16
                                    1   LRC
                                    2   CCITT
                  par->pbsync.sync1   Range:   0 - 0xff
                  par->pbsync.sync2   Range:   0 - 0xff

      AND if par->pbsync.table is initialized to ASCII the 
       following parameter must also be initialized:
          par->pbsync.parity   0   None
                               1   Odd
                               2   Even

      Returns    0   Successful
       -1   Parameter error
       -2   Dual ports not available
       -3   Cannot load analysis files.
       -4   Simulation is running
       -5   Port is busy


GETEVENT   This function gets an event from the line.  Event 
         is a special data type definition which is defined in 
           a:\include\cham.h.  It is defined as follows:

           typedef struct {
              unsigned short type;  /*event.type (see below)*/
              unsigned short length;    /*event.length */
              unsigned short buflen;    /*event.buflen */
              unsigned char  *pdata;    /*event.pdata */
              long seconds;             /*event.seconds */
              long ms20;                /*event.ms20   */
              unsigned short special;   /*event.special */
              unsigned short crc;       /*event.crc */
              unsigned short flags;     /*event.flags */
           }  event;

           #include <cham.h>
           int getevent(pevent)
           event  *pevent

           Returns    0   Successful
                     -1   No new events
                     -2   Data overwitten (buffer wrapped)
                     -3   Wrong port selected for data

           event.type  is 16-bits, as follows:

               Bit 15 - FCS:   0=Good
                               1=Bad
               Bit 14 - Abort:   0 = Good
                                 1=Abort
               Bit 13 - DCE/DTE: 0 = DTE
                                 1=DCE
               Bit 12,11,10 - Binary   Meaning
                               000     Reserved
                               001     Lead Transition
                               010     Async character
                               011     Baud Rate
                               100     BOP Data
                               101     Reserved
                               110     Bisync Data
                               111     Reserved
               Bits 9 - 2   Reserved
               Bit 1 - Port:  0 = Port A
                              1=Port B
               Bit 0 - AM/PM




RESET_ANAL   Resets the acquisition processor.  
             int  reset_anal()

