MULTI-LINK HDLC C LIBRARY (libmhdlc.a)

The Multi-Link HDLC C Library contains the following 
functions:

flush     Clears the receive buffer of the currently 
          selected port.  
          flush ()
          Returns:     None


flush_all     Clears the reception buffer of both ports.
              flush_all()
              Returns:     None


init_a     Initializes Port A according to the passed 
           parameters. 
           int init_a (interface, sta, encode, bitrt)
           int     interface, sta, encode;
           long     bitrt;
           interface     0     DCE
                         1     DTE
                         2     ISDN
           sta           0     Network
                         1     Subscriber
           encode        0     NRZ
                         1     NRZI
           bitrt         50 to 64000 bps
           Returns:      0     Successful
                         -1    Parameter error


init_b     Initializes Port B according to the passed 
           parameters.  
           int init_b (interface, sta, encode, bitrt)
           int     interface, sta, encode;
           long     bitrt;
           interface     0     DCE
                         1     DTE
                         2     ISDN
           sta           0     Network
                         1     Subscriber
           encode        0     NRZ
                         1     NRZI
           bitrt         50 to 64000 bps
           Returns:      0     Successful
                         -1     Parameter error


initp1     Initializes both Ports A and B according to the 
           passed parameters.
           int initp1 (interface, sta, encode, bitrt)
           int   interface, sta, encode;
           long   bitrt;
           interface     0     DCE
                         1     DTE
                         2     ISDN
           sta           0     Network
                         1     Subscriber
           encode        0     NRZ
                         1     NRZI
           bitrt         50 to 64000 bps
           Returns:      0     Successful
                         -1    Parameter error


mlh_flush      Clears the receive buffer of the specified 
               port.
               mlh_flush (port)
               int port;
               port      0     Port A
                         1     Port B


mlh_receive    Causes the Chameleon to check for a 
               received packet.   
               int mlh_receive (loc)
               char *loc;
               loc     A pointer to the user defined 
                       buffer.
               It sets the global variable rec_port, as 
               follows:
                         0     No packet was received
                         1     Packet received from Port A
                         2     Packet received from Port B
               Returns:  0     No packet in buffer
                         2     FEP not initialized
                         128   Packet received


mlh_set_n1     Sets the N1 value for the specified port.  
               int mlh_set_n1 (port,val)
               int port,val;
               port      0     Port A
                         1     Port B
               val       N1 value in the range 1 to 512.
               Returns:      0     Successful
                         -1     Parameter error


mlh_set_n2     Sets the N2 value for the specified port.  
               int mlh_set_n2 (port,val)
               int port,val;
               port      0     Port A
                         1     Port B
               val       N2 value in the range 1 -512
               Returns:   0     Successful
                         -1     Parameter error


mlh_set_net    Sets the specified port to act as a 
               network.  
               int mlh_set_net (port)
               int port,val;
               port      0     Port A
                         1     Port B
               Returns:  0     Successful


mlh_set_t1     Sets the T1 timer value for the specified 
               port.  
               int mlh_set_t1 (port,val)
               int port,val;
               port      0     Port A
                         1     Port B
               val       T1 value, 1 - 255 seconds
               Returns:  0     Successful
                         -1     Parameter error


mlh_set_t2     Sets the T2 timer value for the specified 
               port.  
               int mlh_set_t2 (port,val)
               int port,val;
               port      0     Port A
                         1     Port B
               val    T2 value, range 1 to 255 seconds
               Returns:     0    Successful
                           -1    Parameter error


mlh_slof       Disconnects the link on the specified port.
               int mlh_slof (port)
               int port;
               port          0     Port A
                         1     Port B


mlh_slon     Attempts to establish a link on the specified 
             port.  
             int mlh_slon (port)
             int port;
             port     0     Port A
                      1     Port B


mlh_status     Returns the link status of the specified 
               port.
               int mlh_status (port)
               int port;
               port      0     Port A
                         1     Port B
               Returns:  0     Disconnected
                         1     Link connection req
                         2     Frame reject state
                         3     Link disconnection req
                         4     Info transfer state
                         5     Local station busy
                         6     Remote station busy
                         7     Local & remote stn busy


mlh_set_sub    Sets the specified port to act as a 
               subscriber.
               int mlh_set_sub (port)
               int port;
               port      0     Port A
                         1     Port B
               Returns:  0     Successful


mlh_set_window     Sets the window size for the specified 
                   port.
                   int mlh_set_window (port,val)
                   int     port,val;
                   port     0     Port A
                            1     Port B
                    val       Window size, 1 - 7 frames
                    Returns:     0     Successful
                                -1    Parameter error


mlh_trans      Transmits a data packet on Port A or B as 
               determined by the distribution pattern 
               set by a call to the set_pat or the 
               set_ratio function.
               int mlh_trans (xloc,xlen)
               char *xloc;
               int   xlen;
               xloc      Pointer to the packet
               xlen      Length of the packet
               Returns:     0     Successful


receive     Checks the reception buffer of the specified 
            port for a received packet.
            int receive (port,loc)
            char *loc;
            int   port;
            port    0     Receive from Port A
                    1     Receive from Port B
            loc           Pointer to destination buffer
            Returns:    0   No packet in the buffer
                        2   FEP not initialized
                      128   Packet received


set_n1     Sets the N1 value for both ports.
           int set_n1 (val)
           int val;
           val     N1 value, range 1 to 512
           Returns:   0     Successful
                     -1     Parameter error


set_n2     Sets the N2 value for both ports.
           int set_n2 (val)
           int val;
           val      N2 value, range 1 to 512
           Returns:   0     Successful
                     -1     Parameter error


set_net     Configures both ports to act as networks.
            int set_net
            Returns:     0     Successful

set_pat      Specifies a user defined distribution pattern 
             for transmitting packets using mlh_trans().  
             int set_pat (pat_ptr)
             char *pat_ptr;
             pat_ptr     A pointer to a user defined 
                         table
             The distribution pattern is defined in a 
             table which contains the following values:

                    0     End of table
                    1     Send on Port A
                    2     Send on Port B


set_ratio    Selects a distribution pattern for 
             transmitting packets using mlh_trans().  It 
             specifies the % of packets to be transmitted 
             over Port A.
             int set_ratio (pct_a)
             int pct_a;
             pct_a     The percentage of packets to be 
                       transmitted over Port A.  Valid 
                       values are 0 to 100 in increments 
                       of 10, and -1.  For example:  

                      -1   All packets are transmitted 
                           over both Ports A and B.
                       0   0% of the packets are 
                           transmitted over Port A.
                       10  10% of the packets are 
                           transmitted over Port A.
              Returns:   0     Successful
                        -1     Parameter error


set_sub     Configures both ports to act as subscribers.
            int set_sub ()
            Returns:      0      Successful


set_t1     Sets the T1 timer to an identical value for 
           both ports.
           int set_t1 (val)
           int val;
           val      T1 value, range 1-255 seconds.
           Returns:    0     Successful
                       -1    Parameter error


set_t2     Sets the T2 timer to an identical value for 
           both ports.
           int set_t2 (val)
           int val;
           val     T2 value, range 1 - 255 sec
           Returns:      0     Successful
                        -1     Parameter error

set_window     Sets the window size to an identical value 
               for both ports.
               int set_window (val)
               int val;
               val     Window size, 1 to 7 frames.
               Returns:      0     Successful
                            -1     Parameter error


slof     Disconnects the link on both ports.
         int slof ()


slon     Attempts to establish a link on both ports.
         int slon ()


status     Returns the link status of the currently 
           selected port.
           int status ()
           Returns:    0     Disconnected
                       1     Link connection requested
                       2     Frame reject state
                       3     Link disconnection req
                       4     Information transfer state
                       5     Local station busy
                       6     Remote station busy
                       7     Local and remote stns busy


transmit       Transmits a packet over the specified port.
               int transmit (port,xloc,xlen)
               char   port,*xloc;
               int    xlen;
               port      0     Port A
                         1     Port B
               xloc      Pointer to the packet
               xlen      Length of the packet
               Returns:  0    Successful

