/* @(#)bertlib.h	1.1 3/25/92 */
/************************************************
*		File - bertlib.h		*
* This file must be included in programs 	*
* using the bert library. It contains necessary *
* type and structure declarations and useful	*
* defined values.				*
************************************************/

/**********************************************
* multipliers for setting timed test timeout  *
* example:				      *
* timed_test(2*RN_HOURS + 5*RN_MINUTES + 10); *
**********************************************/

#define RN_HOURS 3600
#define RN_MINUTES 60


/*****************************
* storage for test data from *
*  P1 data collector	     *
*****************************/

struct tes_data{
unsigned long tx_bits;
unsigned long rx_bits;
unsigned long rx_blerrs;
unsigned long tx_bterrs;
unsigned long rx_bterrs;
unsigned long run_seconds;
unsigned long err_seconds;
unsigned long serr_seconds;
unsigned long unav_seconds;
unsigned long sync_loss;
};

extern struct tes_data *test_vals;

/*******************************
* declarations of functions    *
* that return long or floating *
* point values		       *
*******************************/

long get_tbits();
long get_rbiterrs();
long get_rbits();
long get_blkerrs();
long get_tbiterrs();
long get_runtime();
long get_errsec();
long get_syncloss();
long get_secbts();
long get_sec_errs();
double get_er_rt();
long get_serrsec();


