(in-package '*lisp)

;;; This file constitutes ~/run-main.lisp in the following
;;; example.

;;; The following sequence submits a starlisp batch job
;;; to the batch queue called FOO_1.  Output is directed
;;; to the file ~/starlisp-output.text.  Mail is sent to
;;; user 'massar' when the job begins and when the job
;;; ends.  

;;; The starlisp executable /usr/local/starlisp
;;; is invoked, and told to load the file ~/run-main.lisp
;;; when it starts up via the -l flag.  The -n flag 
;;; says not to load user 'massar's lisp-init.lisp file,
;;; and the -q file says to terminate the Lisp process
;;; one the ~/run-main.lisp file has been loaded.

;;; The ^D (CONTROL-D) tells qsub to submit the job
;;; and exit.

;;; massar% qsub -q foo_1 -me -mb -o ~/starlisp-output.text
;;; /usr/local/starlisp -l ~/run-main.lisp -n -q
;;; ^D
;;;

;;; Sample output from a run is shown below the code.



;;; BEGIN LISP EXECUTION.
;;; (LOAD YOUR OWN LISP-INIT.LISP FILE HERE IF YOU WISH)

;;; (load "/u/massar/lisp-init.lisp")

(format t "~%;;; Lisp batch system beginning execution.")
(format t "~%;;; Beginning attach/cold-boot sequence.")
(finish-output)

(defun attach-parameters-from-batch-environment ()
  (flet 
      ((oops (&rest strings)
	 (dolist (string strings) (format t "~%*** ~A" string))
	 (format t "~%*** Fatal error.  Lisp batch system terminating.")
	 (lcl:quit)
	 ))
    (let ((sequencer-environment-string (lcl:environment-variable "CMSEQUENCERS"))
	  (interface-environment-string (lcl:environment-variable "CMINTERFACE"))
	  (cmname (lcl:environment-variable "CMNAME"))
	  )
      (when (null sequencer-environment-string)
	(oops "Batch system is apparently not attached to a CM!!!"
	      "CMSEQUENCERS environment variable is not bound."
	      ))
      (when (null interface-environment-string)
	(oops "Batch system did not set CMINTERFACE environment variable!!!")
	)
      (let ((sequencer
	     (cond ((string-equal "0" sequencer-environment-string) :ucc0)
		   ((string-equal "1" sequencer-environment-string) :ucc1)
		   ((string-equal "2" sequencer-environment-string) :ucc2)
		   ((string-equal "3" sequencer-environment-string) :ucc3)
		   ((string-equal "0-1" sequencer-environment-string) :ucc0-1)
		   ((string-equal "2-3" sequencer-environment-string) :ucc2-3)
		   ((string-equal "0-3" sequencer-environment-string) :ucc0-3)
		   (t (oops "CMSEQUENCERS environment variable value, ~S, is not valid!!!"))
		   ))
	    (interface 
	     (cond ((string-equal "0" interface-environment-string) 0)
		   ((string-equal "1" interface-environment-string) 1)
		   ((string-equal "2" interface-environment-string) 2)
		   ((string-equal "3" interface-environment-string) 3)
		   (t (oops "CMINTERFACE environment variable value, ~S, is not valid!!!"))
		   )))
	(values sequencer interface cmname)
	))))


;;; ATTACH AND COLD BOOT.


(multiple-value-bind (sequencer interface cmname)
    (attach-parameters-from-batch-environment)
  (format t "~%;;; Attaching to sequencer(s) ~S, interface ~D" sequencer interface)
  (finish-output)
  (cm:attach sequencer :interface interface)
  (format t "~%;;; Cold-booting Connection Machine ~A" cmname)
  (finish-output)
  (*cold-boot)
  )


;;; EXECUTE USER CODE HERE
;;; (LOAD ALL YOUR FILES AND CALL YOUR MAIN ROUTINE)

(progn
  (format t "~%;;; Beginning execution of user code")
  (finish-output)
  (dfs:load-n "/cm/starlisp/interpreter/f6001/text-processing-example")
  (*lisp::do-text-processing "This is some text to process")
  )


;;; ALL DONE


(finish-output)
(format t "~%;;; Lisp batch system execution terminating.")
(finish-output)
(terpri)


#|


Warning: no access to tty; thus no job control in this shell...
limit: stacksize: Can't set limit
;;; 
;;; Sun Common Lisp, Development Environment 3.0.5 (Rev 01), 30-Aug-90
;;; Sun-4 Version for SunOS 4.0 
;;;
;;; Copyright (c) 1985, 1986, 1987, 1988 by Sun Microsystems, Inc., All Rights Reserved
;;; Copyright (c) 1985, 1986, 1987, 1988 by Lucid, Inc., All Rights Reserved
;;;
;;; This software product contains confidential and trade secret
;;; information belonging to Sun Microsystems.  It may not be copied
;;; for any reason other than for archival and backup purposes.

;;; Loading source file "/cm/patch/initializations.lisp"
;;; *Lisp Patch Level 0
;;; Loading source file "/cm/patch/tmc-initializations.lisp"

;;; Connection Machine Software, Release 6.0
;;; 
;;; Copyright (C) 1990 by Thinking Machines Corporation.  All rights reserved.
;;; 
;;; Loading source file "/u7/massar/run-main.lisp"

;;; Lisp batch system beginning execution.
;;; Beginning attach/cold-boot sequence.
;;; Attaching to sequencer(s) :UCC1, interface 1
;;; Loading source file "/cm/configuration/configuration.lisp"

;;; Cold-booting Connection Machine FOO
;;; Beginning execution of user code
;;; Loading binary file "/cm/starlisp/interpreter/f6001/text-processing-example.sbin3"

Processor 0. Length: 4.  Word: This                            
Processor 1. Length: 2.  Word: is                              
Processor 2. Length: 4.  Word: some                            
Processor 3. Length: 4.  Word: text                            
Processor 4. Length: 2.  Word: to                              
Processor 5. Length: 7.  Word: process                         
;;; Lisp batch system execution terminating.
logout


|#
