(in-package 'cmi)

;;; Patch for send-to-shared-queue.  Fake the presence of a eunuch chip to limit the code
;;; to using 4 ejectors.  This uses a different cube control value for the swap in the
;;; index computation which seems to avoid parity problems.  The right fix is to make the
;;; values be swapped from processor 0, which is a nop parity control.

(defmacro def-sprint-send-shared-queue-interface (name)
  (let* ((min-mic-name (intern (concatenate 'string (symbol-name name) "-INTERNAL") (find-package "CMI")))
	 (trace-name (intern (concatenate 'string (symbol-name name) "-TRACE") (find-package "CMI")))
	 (parameters-before-trace-flag (butlast *sprint-delivery-arglist*))
	 (parameters-after-trace-flag nil)
	 (arguments-before-trace-flag parameters-before-trace-flag)
	 (arguments-after-trace-flag nil)
	 (function-arglist (append parameters-before-trace-flag parameters-after-trace-flag))
	 (trace-arglist	  (append function-arglist '(trace-address trace-limit))))
    `(progn

       (defun ,name ,function-arglist
	 (let ((saved-eunuch-mask (physical-read-slice-16 0 #.*router-eunuch-mask-slice*)))
	   (physical-write-slice-16 0 #.*router-eunuch-mask-slice* #xffff)
	   (,min-mic-name ,@arguments-before-trace-flag 0 ,@arguments-after-trace-flag)
	   (physical-write-slice-16 0 #.*router-eunuch-mask-slice* saved-eunuch-mask)))

       (defun ,trace-name ,trace-arglist
	 (write-to-uc-scratch-ram
	   #.(uc-scratch-address (uc-scratch-entry-struct 'performance-monitor-info-low))
	   trace-address)
	 (write-to-uc-scratch-ram
	   #.(uc-scratch-address (uc-scratch-entry-struct 'performance-monitor-info-high))
	   trace-limit)
	 (let ((saved-eunuch-mask (physical-read-slice-16 0 #.*router-eunuch-mask-slice*)))
	   (physical-write-slice-16 0 #.*router-eunuch-mask-slice* #xffff)
	   (,min-mic-name ,@arguments-before-trace-flag 1 ,@arguments-after-trace-flag)
	   (physical-write-slice-16 0 #.*router-eunuch-mask-slice* saved-eunuch-mask))))))

(def-sprint-send-shared-queue-interface sprint-send-to-shared-queue)

(def-sprint-send-shared-queue-interface sprint-send-to-shared-aref32-queue)

(cmi::increment-patch-level 16)
