/*****************************************************************************
* 	  (c) Copyright 1990 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#if !defined(lint) && !defined(cstar) && !defined(c_star) && !defined(__SABER__) && !defined(LC)
static char rcsid_cm_error[] = "$Id: cm-errors.h,v 1.4 1991/11/21 03:36:39 dm Exp $";
#endif

/*
 * Error return values from the C/Paris CM error handler
 */

#define CM_NO_ERROR 0
#define CM_FEBI_DETACHED 1
#define CM_UCC_DETACHED 2
#define CM_HBUS_TIMEOUT 3
#define CM_HBUS_PARITY_ERROR 4
#define CM_INTERFACE_ERROR 5
#define CM_FEBI_TIMEOUT 6
#define CM_ERROR_IF_LOCATION 7
#define CM_SOFTWARE_TRAP 8
#define CM_IO_ERROR 9
#define CM_CS_PARITY_ERROR 10
#define CM_MADDR_BOUNDS 11
#define CM_RDATA_PARITY_ERROR 12
#define CM_SRAM_OVFL 13
#define CM_SYNC_ERROR 14
#define CM_IFIFO_PARITY_ERROR 15
#define CM_SEQ_STACK_OVFL 16
#define CM_BETA_CHIP_ERROR 17
#define CM_SPRINT_CHIP_ERROR 18
#define CM_MEMORY_ERROR 19
#define CM_ILLEGAL_RUG_OP 20
#define CM_MATRIX_BOARD_ERROR 21
#define CM_FPU_ERROR 22
#define CM_BREAKPOINT 23
#define CM_SRAM_PARITY_ERROR 24
#define CM_UCC_ERROR 25
#define CM_FEBI_ERROR 26

/*
 * Definate software errors, these don't get logged
 */
#define CM_SOFTWARE_ERROR(err) \
    (((err) == CM_SOFTWARE_TRAP) || \
     ((err) == CM_MADDR_BOUNDS) || \
     ((err) == CM_ERROR_IF_LOCATION) || \
     ((err) == CM_BREAKPOINT) || \
     ((err) == CM_ILLEGAL_RUG_OP))

/*
 * Errors which need at least a cold-boot to recover, maybe a re-attach 
 */
#define CM_FATAL_ERROR(err) \
    (((err) == CM_FEBI_DETACHED) || \
     ((err) == CM_UCC_DETACHED) || \
     ((err) == CM_HBUS_TIMEOUT) || \
     ((err) == CM_HBUS_PARITY_ERROR) || \
     ((err) == CM_INTERFACE_ERROR) || \
     ((err) == CM_IO_ERROR) || \
     ((err) == CM_CS_PARITY_ERROR) || \
     ((err) == CM_RDATA_PARITY_ERROR) || \
     ((err) == CM_IFIFO_PARITY_ERROR) || \
     ((err) == CM_MATRIX_BOARD_ERROR) || \
     ((err) == CM_SYNC_ERROR))


/*
 * Other errors are indeterminate, may be software or hardware errors
 */
