;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CMI; Base: 10 -*-


(in-package 'cmi)


(defvar *paris-patch-level* 0)
(defvar *paris-patch-level-list* nil)

;;;
;;; This could be smarter, it should check the list for holes.
;;; We can't count on DFS not reloading things, so we have to
;;; be smart about when we complain.

(defun increment-patch-level (n)
;  (when (not (eql *paris-patch-level* (1- n)))
  (when (< *paris-patch-level* (1- n))
    (warn "All the available patch files have not been loaded in order.~@
           You are currently loading patch ~D, but the current patch level is only ~D.~@
           You should figure out why you are apparently missing patches!~@
           The patches which have been loaded are ~S"
	  n *paris-patch-level* (sort 
				     (append (list n)
					     *paris-patch-level-list*) '<)
	  ))
  (if (member n *paris-patch-level-list*)
      (format t ";;; Paris: Note: reloaded patch level ~d." n)
      (progn
	(setq *paris-patch-level-list*
	      (append *paris-patch-level-list* (list n)))
	(setq *paris-patch-level* (first
				       (sort *paris-patch-level-list* '>))))
      ))

(defun paris-patch-level ()
  *paris-patch-level*
  )

;;; Initialize *need-to-relink*
(proclaim '(special *need-to-relink*))
(setq *need-to-relink* nil)
