;;; -*- Mode: LISP; Syntax: Common-lisp; Package: (*LISP-I COMMON-LISP-GLOBAL); Base: 10; Patch-File: Yes -*-

(in-package :*lisp-i)

;;; This fix was installed after the Sun4 band was built.

#+sun4
(*defun *sideways-array (array-pvar)
  (safety-check (new-vp-pvar-check array-pvar '*sideways-array))
  (when (not (array-pvar-p array-pvar))
    (error "The object ~S is not an array pvar." array-pvar))
  (when (not (allowable-size-for-transposing-p (array-pvar-total-size array-pvar) (pvar-array-element-size array-pvar)))
    (error "An array pvar with an element size of ~D bits and ~D elements is not transposable."
	   (pvar-array-element-size array-pvar) (array-pvar-total-size array-pvar)))
  (cm:transpose32-1-1l (pvar-location array-pvar) (pvar-length array-pvar))
  (setf (pvar-array-stored-slicewise array-pvar) (not (pvar-array-stored-slicewise array-pvar)))
  t)

(*lisp-i::increment-patch-level 1)
