#!/bin/sh
# $Id: notify-user.sh,v 1.10 1992/03/06 17:22:10 nesheim Exp $
# This is a shell script intended to be used by the CM kernel to notify 
# users of exceptional conditions.

case $# in
3)
	;;
*)
	echo "Usage: $0 <ownername> <tty> <message>";
	echo $0 argcount: $#, args are:
	for i in $*; do
		echo -n \"$i\"
	done
	echo 
	exit 1
	;;
esac

OWNER=$1
TERM=$2
MSG="$3"

# if the process is stopped send a message to the programmer.

if [ "$TERM" = "/dev/null" ]; then
  
 echo "$MSG" | /usr/ucb/mail $OWNER -s 'Msg from the {CM}* daemon' 

else

 ( 
 echo "             *** Message from the {CM}* daemon *** "
 echo ""
 echo "$MSG"
 echo ""
 ) >> $TERM &


# if the user has logged out (what are they doing, running a 
# background job?) clean up the process that is hanging trying
# to open the pty.

 lastpid=$!
 (sleep 30; kill -9 $lastpid) >/dev/null 2>&1 &

fi


