/*****************************************************************************/
/*			COMPANY CONFIDENTIAL			             */
/* 								             */
/*	Copyright 1990 Thinking Machines Corporation		             */
/*								             */
/*  The information contained in this document is confidential and           */
/*  proprietary to Thinking Machines Corporation.  It is the property of     */
/*  Thinking Machines Corporation and shall not be disclosed to persons      */
/*  outside the company or distributed generally within the company.	     */
/*									     */
/*  The contents of this document is subject to change without notice	     */
/*  and should not be construed as a commitment by Thinking Machines	     */
/*  Corporation.  Thinking Machines Corporation assumes no responsibility    */
/*  for any errors that may be contained in this document.	             */
/*									     */
/*  This document does not describe any product which is currently           */
/*  available from Thinking Machines Corporation.  Nor does Thinking         */
/*  Machines Corporation commit to implement the contents of this document   */
/*  in any product.  Thinking Machines Corporation makes no commitment that  */
/*  this document accurately describes any product it might ever make.	     */
/*****************************************************************************/

/*  File:  cmrt.h   */

/* --------------------------------------------------------------------


Author:  Ken Crouch & David Gingold			Date: 6 June 1990

Purpose: 

        External/global header file for the CMRT module.

Functions:  none

Revision History:

$Log: cmrt.h,v $
 * Revision 1.6  1991/12/12  13:45:02  lordi
 * Fix ANSI decl syntax errors
 *
 * Revision 1.5  91/12/12  13:04:17  lordi
 * Fixed prototype for CMRT_intern_detailed_array_geometry (added SUBGRID_LENGTHS arg)
 * 
 * Revision 1.4  91/11/25  21:21:48  amm
 * Fixed return value from CMRT_desc_get_increment
 * 
 * Revision 1.3  91/11/25  20:55:49  amm
 * All includes from <cm/mumble.h> now
 * 
 * Revision 1.2  91/11/14  15:12:10  sean
 * Add function prototypes for accessors to increment field in array
 * descriptor, and some prototypes for various unsigned4 array ops.
 * 
 * Revision 1.1  91/08/26  08:23:41  amm
 * Initial revision
 * 
 * Revision 1.40  91/03/20  11:41:59  amm
 * Added conditional function declaration for CMRT_initialize_random_wolfram
 * 
 * Revision 1.39  91/02/15  20:10:59  haroldh
 * added definition for CMRT_check_coord_wrt_array
 * 
 * 
 * Revision 1.38  91/02/11  17:13:54  haroldh
 * Modified entry for CMRT_check_saddrs_wrt_array to return void.
 * 
 * Revision 1.37  91/01/23  13:35:15  ken
 * Added CMRT_check_saddrs_wrt_array function prototype.
 * 
 * Revision 1.36  90/12/14  12:00:09  ken
 * Added safety code.
 * 
 * Revision 1.35  90/12/03  16:30:45  ken
 * Changed PE interface function prototypes.
 * 
 * Revision 1.34  90/11/29  17:22:16  ken
 * *** empty log message ***
 * 
 * Revision 1.33  90/11/28  15:02:33  ken
 * Fixed return type for CMRT_desc_get_number_of_elements.
 * 
 * Revision 1.32  90/11/09  10:27:29  ken
 * Added fp safety function prototypes.
 * 
 * Revision 1.31  90/11/08  17:06:59  ken
 * Added CMRT_rank function prototype.
 * 
 * Revision 1.30  90/11/05  15:09:57  ken
 * Entered random function interface.
 * 
 * Revision 1.29  90/11/01  15:26:47  ken
 * Fixed scan prototypes.
 * 
 * Revision 1.28  90/10/30  20:28:38  ken
 * Added CMRT_print_array_geometry function prototype.
 * 
 * Revision 1.27  90/10/30  20:24:43  ken
 * Added CMRT_initialized function prototype.
 * 
 * Revision 1.26  90/10/29  13:40:18  gingold
 * Added CMRT_write_array_element_from_buffer declaration.
 * 
 * Revision 1.25  90/10/29  10:52:58  ken
 * Fixed send with combiner prototypes.
 * 
 * Revision 1.24  90/10/29  09:28:39  ken
 * Added send and my_send_address functions.
 * 
 * Revision 1.23  90/10/28  11:05:49  ken
 * Made headers after adding intrinsics and paris interface.
 * 
 * Revision 1.22  90/10/11  20:13:00  ken
 * Added scratch space for compiler.
 * 
 * Revision 1.21  90/10/10  16:22:01  ken
 * Added scan function prototypes.
 * 
 * Revision 1.20  90/09/18  17:12:19  ken
 * Modified axes argument of CMRT_multispread_copy to axes_mask.
 * 
 * Revision 1.19  90/09/18  17:08:45  ken
 * I don't remember.
 * 
 * Revision 1.18  90/09/18  13:49:07  ken
 * Added is_serial argument CMRT_intern_detailed_array_geometry function.
 * 
 * Revision 1.17  90/09/14  15:34:22  ken
 * Changed return value of CMRT_global_count to int8.
 * 
 * Revision 1.16  90/09/12  10:13:26  alex
 * Corrected declarations of CMRT_push_cmpx{8,16}.
 * 
 * Revision 1.15  90/09/07  09:51:11  ken
 * Added prototypes for CM deposit functions, but ifdef'ed them
 * out until scalar simulator is changed.
 * 
 * Revision 1.14  90/08/29  17:18:21  ken
 * Added mask argument for CMRT_news function.
 * 
 * Revision 1.13  90/08/29  17:15:39  ken
 * Took out "return_value" version and put in
 * "scalar_deposit_grid_coordinate_zero" version.
 * 
 * Revision 1.12  90/08/27  11:08:50  ken
 * Removed alot of extra type specific functions that shouldn't have been
 * here in the first place.
 * 
 * Revision 1.11  90/08/22  10:34:38  ken
 * Remove extra transfer functions and rename transfer functions to
 * CMRT_read_array and CMRT_write_array.
 * 
 * Revision 1.10  90/08/17  14:58:00  ken
 * Changed name of CMRT_scalar_deposit_grid_coordinate_internal
 * to CMRT_scalar_deposit_grid_coordinate_return_value.
 * 
 * Revision 1.9  90/08/03  12:37:10  ken
 * Added PE interface and geometry function prototypes.
 * 
 * Revision 1.8  90/08/03  09:56:07  ken
 * Fixed RCS log.
 * 

---------------------------------------------------------------------------*/

/* Only include if not already seen. */
#ifndef CMRT_ALREADY_INCLUDED
#define CMRT_ALREADY_INCLUDED

#include <cm/cmrt_types.h>

#ifndef _AP
#ifdef _ansi_prototypes
#define _AP(args)	args
#else
#define _AP(args)	()
#endif
#endif /* _AP */

/*** Function definitions.***/
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:08 1990
 * from /u18/ken/rts/cmrt/src/cmrt_addresses.c
 */
extern void CMRT_make_send_address _AP((CMRT_desc_t send_address));
extern void CMRT_my_send_address _AP((CMRT_desc_t dest,
				      CMRT_desc_t mask));
extern void CMRT_deposit_grid_coordinate
  _AP((CMRT_array_geometry_t grid_geometry, 
       CMRT_desc_t dest_send_address, 
       CMRT_desc_t source_send_address, 
       int4 axis, 
       CMRT_desc_t coordinate, 
       CMRT_desc_t mask));
extern void CMRT_deposit_grid_coordinate_zero
  _AP((CMRT_array_geometry_t grid_geometry, 
       CMRT_desc_t dest_send_address, 
       CMRT_desc_t source_send_address, 
       int4 axis, 
       CMRT_desc_t coordinate, 
       CMRT_desc_t mask));
extern void CMRT_extract_grid_coordinate
  _AP((CMRT_array_geometry_t grid_geometry, 
       CMRT_desc_t dest, 
       CMRT_desc_t send_address, 
       int4 axis, 
       CMRT_desc_t mask));
extern void CMRT_my_grid_coordinate _AP((CMRT_desc_t dest, int4 axis, 
					 CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:09 1990
 * from /u18/ken/rts/cmrt/src/cmrt_array.c
 */
extern CMRT_cm_location_t CMRT_desc_get_cm_location
  _AP((CMRT_desc_t descriptor));
extern int4 CMRT_desc_get_rank _AP((CMRT_desc_t descriptor));
extern int8 CMRT_desc_get_lower_bound _AP((CMRT_desc_t descriptor, 
					   int4 axis));
extern int8 CMRT_desc_get_upper_bound _AP((CMRT_desc_t descriptor, 
					   int4 axis));
extern int4 CMRT_desc_get_subgrid_size _AP((CMRT_desc_t descriptor));
extern int4 CMRT_desc_get_subgrid_dimension _AP((CMRT_desc_t descriptor, 
						 int4 axis));
extern log4 CMRT_desc_axis_is_serial _AP((CMRT_desc_t descriptor, 
					  int4 axis));
extern CMRT_element_type_t CMRT_desc_get_element_type
  _AP((CMRT_desc_t descriptor));
extern int4 CMRT_desc_get_increment
  _AP((CMRT_desc_t descriptor));
extern log4 CMRT_desc_get_is_modified _AP((CMRT_desc_t descriptor));
extern CMRT_home_t CMRT_desc_get_home _AP((CMRT_desc_t descriptor));
extern int8 CMRT_desc_get_number_of_elements _AP((CMRT_desc_t descriptor));
extern unsigned4 CMRT_desc_get_offchip_mask _AP((CMRT_desc_t descriptor, 
						 int4 axis));
extern int4 CMRT_desc_get_offchip_position _AP((CMRT_desc_t descriptor, 
						int4 axis));
extern int4 CMRT_desc_get_offchip_length _AP((CMRT_desc_t descriptor, 
					      int4 axis));
#ifdef CM2
extern CMCOM_order_t CMRT_desc_get_order _AP((CMRT_desc_t descriptor, 
					      int4 axis));
#endif
extern CMRT_array_geometry_t CMRT_desc_get_geometry
  _AP((CMRT_desc_t descriptor));
extern int4 CMRT_desc_get_element_size _AP((CMRT_desc_t descriptor));
extern CMRT_desc_t CMRT_allocate_descriptor _AP(());
extern void CMRT_deallocate_descriptor _AP((CMRT_desc_t descriptor));
extern void CMRT_desc_set_cm_location _AP((CMRT_desc_t descriptor, 
					   CMRT_cm_location_t location));
extern void CMRT_desc_set_element_type _AP((CMRT_desc_t descriptor, 
					    CMRT_element_type_t type));
extern void CMRT_desc_set_increment _AP((CMRT_desc_t descriptor, 
					    CMRT_increment_t type));
extern void CMRT_desc_set_geometry _AP((CMRT_desc_t descriptor, 
					CMRT_array_geometry_t geometry));
extern void CMRT_desc_set_is_modified _AP((CMRT_desc_t descriptor, 
					   log4 is_modified));
extern void CMRT_desc_set_element_size _AP((CMRT_desc_t descriptor, 
					    int4 element_size));
extern CMRT_desc_t CMRT_allocate_heap_array
  _AP((CMRT_array_geometry_t geometry, 
       CMRT_element_type_t element_type));
extern void CMRT_deallocate_heap_array _AP((CMRT_desc_t array));
extern CMRT_desc_t CMRT_allocate_stack_array
  _AP((CMRT_array_geometry_t geometry, 
       CMRT_element_type_t element_type));
extern void CMRT_deallocate_stack_array _AP((CMRT_desc_t array));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:14 1990
 * from /u18/ken/rts/cmrt/src/cmrt_axis_location.c
 */
extern void CMRT_firstloc_axis _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				    int4 axis));
extern void CMRT_lastloc_axis _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				   int4 axis));
extern void CMRT_project _AP((CMRT_desc_t dest, CMRT_desc_t fill, 
			      CMRT_desc_t source, 
			      int4 axis, 
			      int8 coordinate, 
			      CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:14 1990
 * from /u18/ken/rts/cmrt/src/cmrt_broadcast.c
 */
extern void CMRT_broadcast_log4 _AP((CMRT_desc_t dest, CMRT_desc_t mask, 
				     log4 value));
extern void CMRT_broadcast_int4 _AP((CMRT_desc_t dest, CMRT_desc_t mask, 
				     int4 value));
extern void CMRT_broadcast_int8 _AP((CMRT_desc_t dest, CMRT_desc_t mask, 
				     int8 value));
extern void CMRT_broadcast_real4 _AP((CMRT_desc_t dest, CMRT_desc_t mask, 
				      real4 value));
extern void CMRT_broadcast_real8 _AP((CMRT_desc_t dest, CMRT_desc_t mask, 
				      real8 value));
extern void CMRT_broadcast_cmpx8 _AP((CMRT_desc_t dest, CMRT_desc_t mask, 
				      cmpx8 value));
extern void CMRT_broadcast_cmpx16 _AP((CMRT_desc_t dest, CMRT_desc_t mask, 
				       cmpx16 value));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:16 1990
 * from /u18/ken/rts/cmrt/src/cmrt_cross_geometry_move.c
 */
extern void CMRT_cross_geometry_move _AP((CMRT_desc_t dest, 
					  CMRT_desc_t source, 
					  int4*axis_mapping, 
					  int8*source_axis_coords, 
					  int8*dest_axis_coords, 
					  CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:16 1990
 * from /u18/ken/rts/cmrt/src/cmrt_fields.c
 */
extern CMRT_cm_location_t CMRT_get_stack_pointer _AP(());
extern CMRT_cm_location_t CMRT_allocate_physical_stack_field
  _AP((int4 num_bytes));
extern void CMRT_deallocate_physical_stack_through
  _AP((CMRT_cm_location_t field, 
       int4 num_bytes));
extern CMRT_cm_location_t CMRT_allocate_stack_field
  _AP((CMRT_array_geometry_t geometry, 
       int4 num_bytes));
extern void CMRT_deallocate_stack_field_through
  _AP((CMRT_cm_location_t field, 
       CMRT_array_geometry_t geometry, 
       int4 num_bytes));
extern CMRT_cm_location_t CMRT_allocate_physical_heap_field
  _AP((int4 num_bytes));
extern void CMRT_deallocate_physical_heap_field _AP((CMRT_cm_location_t field, 
						     int4 num_bytes));
extern CMRT_cm_location_t CMRT_allocate_heap_field
  _AP((CMRT_array_geometry_t geometry, 
       int4 num_bytes));
extern void CMRT_deallocate_heap_field _AP((CMRT_cm_location_t field, 
					    CMRT_array_geometry_t geometry, 
					    int4 num_bytes));
extern CMRT_cm_location_t CMRT_add_offset_to_cm_location
  _AP((CMRT_cm_location_t field, 
       int4 num_bytes));
extern CMCOM_cm_address_t CMRT_absolute_address_from_cm_location
  _AP((CMRT_cm_location_t field));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:18 1990
 * from /u18/ken/rts/cmrt/src/cmrt_geometry.c
 */;
extern CMRT_array_geometry_t 
  CMRT_intern_detailed_array_geometry _AP((int4 rank, 
					   int8*lower_bounds, 
					   int8*upper_bounds, 
					   CMCOM_order_t*orders, 
					   int4*off_chip_positions, 
					   int4*off_chip_lengths,
					   int4*subgrid_lengths,
					   log4*is_serial, 
					   log4 highest_axis_varies_fastest));
extern CMRT_array_geometry_t CMRT_intern_array_geometry
  _AP((int4 rank, 
       int8*lower_bounds, 
       int8*upper_bounds, 
       CMCOM_order_t*orders, 
       int4*weights, 
       log4*is_serial, 
       log4 highest_axis_varies_fastest));
extern int CMRT_pe_length _AP(());
extern int CMRT_pe_limit _AP(());
extern CMRT_geometry_ptr_t CMRT_intern_geometry _AP((int4 extents[], 
						     int4 rank, 
						     int4 size));
extern CMRT_geometry_ptr_t CMRT_intern_detailed_geometry
 _AP((int4 extents[], int4 weights[], CM_axis_order_t	orders_in[], 
      int4 rank, 
      int4 size));
extern void CMRT_print_array_geometry _AP((CMRT_geometry_t *g));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:20 1990
 * from /u18/ken/rts/cmrt/src/cmrt_global.c
 */
extern log4 CMRT_global_logior _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern log4 CMRT_global_logand _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern int8 CMRT_global_count _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern int4 CMRT_global_max_int4 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern int8 CMRT_global_max_int8 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern real4 CMRT_global_max_real4 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern real8 CMRT_global_max_real8 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern int4 CMRT_global_min_int4 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern int8 CMRT_global_min_int8 _AP((CMRT_desc_t source, CMRT_desc_t,mask));
extern real4 CMRT_global_min_real4 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern real8 CMRT_global_min_real8 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern int4 CMRT_global_product_int4 _AP((CMRT_desc_t source, 
					  CMRT_desc_t mask));
extern real4 CMRT_global_product_real4 _AP((CMRT_desc_t source, 
					    CMRT_desc_t mask));
extern real8 CMRT_global_product_real8 _AP((CMRT_desc_t source, 
					    CMRT_desc_t mask));
extern cmpx8 CMRT_global_product_cmpx8 _AP((CMRT_desc_t source, 
					    CMRT_desc_t mask));
extern cmpx16 CMRT_global_product_cmpx16 _AP((CMRT_desc_t source, 
					      CMRT_desc_t mask));
extern int4 CMRT_global_sum_int4 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern int8 CMRT_global_sum_int8 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern real4 CMRT_global_sum_real4 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern real8 CMRT_global_sum_real8 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern cmpx8 CMRT_global_sum_cmpx8 _AP((CMRT_desc_t source, CMRT_desc_t mask));
extern cmpx16 CMRT_global_sum_cmpx16 _AP((CMRT_desc_t source, 
					  CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:23 1990
 * from /u18/ken/rts/cmrt/src/cmrt_global_location.c
 */
extern void CMRT_firstloc _AP((CMRT_desc_t dest, CMRT_desc_t source));
extern void CMRT_lastloc _AP((CMRT_desc_t dest, CMRT_desc_t source));
extern void CMRT_minloc _AP((int8*dest, CMRT_desc_t source, CMRT_desc_t mask));
extern void CMRT_maxloc _AP((int8*dest, CMRT_desc_t source, CMRT_desc_t mask));
extern int4 CMRT_global_project_int4 _AP((CMRT_desc_t source, 
					  int4 fill, 
					  CMRT_desc_t mask));
extern int8 CMRT_global_project_int8 _AP((CMRT_desc_t source, 
					  int8 fill, 
					  CMRT_desc_t mask));
extern real4 CMRT_global_project_real4 _AP((CMRT_desc_t source, 
					    real4 fill, 
					    CMRT_desc_t mask));
extern real8 CMRT_global_project_real8 _AP((CMRT_desc_t source, 
					    real8 fill, 
					    CMRT_desc_t mask));
extern cmpx8 CMRT_global_project_cmpx8 _AP((CMRT_desc_t source, 
					    cmpx8 fill, 
					    CMRT_desc_t mask));
extern cmpx16 CMRT_global_project_cmpx16 _AP((CMRT_desc_t source, 
					      cmpx16 fill, 
					      CMRT_desc_t mask));
extern log4 CMRT_global_project_log4 _AP((CMRT_desc_t source, 
					  log4 fill, 
					  CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:25 1990
 * from /u18/ken/rts/cmrt/src/cmrt_init.c
 */
extern void CMRT_init _AP(());
extern int4 CMRT_initialized _AP(());
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:26 1990
 * from /u18/ken/rts/cmrt/src/cmrt_intrinsic_utils.c
 */
extern void CMRT_scan_copy_slow _AP((CMRT_desc_t dest, 
				     CMRT_desc_t source, 
				     CMRT_desc_t segment, 
				     int4 axis, 
				     CMCOM_direction_t direction, 
				     log4 inclusion, 
				     int4 segment_mode, 
				     CMRT_desc_t mask));
extern void CMRT_enumerate _AP((CMRT_desc_t destination, 
				CMRT_desc_t mask));
/*
 * Generated by hand Fri Nov 9 1990
 * from /u18/ken/rts/cmrt/src/cmrt_fp_safety.c
 */
extern void CMRT_fp_check_safety_pre _AP((CMRT_desc_t array,
					  char *varname,
					  CMRT_desc_t mask));
extern void CMRT_fp_check_safety_post _AP((CMRT_desc_t array, 
					   char*varname,
					   CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:28 1990
 * from /u18/ken/rts/cmrt/src/cmrt_matmul.c
 */
extern void CMRT_matrix_multiply _AP((CMRT_desc_t dest, CMRT_desc_t source1, 
				      CMRT_desc_t source2));
extern void CMRT_vector_matrix_multiply _AP((CMRT_desc_t dest, 
					     CMRT_desc_t source_vector, 
					     CMRT_desc_t source_matrix));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:30 1990
 * from /u18/ken/rts/cmrt/src/cmrt_memory.c
 */
extern CMCOM_cm_address_t cmrt_allocate_heap_memory _AP((unsigned num_bytes));
extern CMCOM_cm_address_t cmrt_allocate_stack_memory _AP((int num_bytes));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:31 1990
 * from /u18/ken/rts/cmrt/src/cmrt_news.c
 */
extern void CMRT_news _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			   int8 distance, 
			   int4 axis, 
			   CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:31 1990
 * from /u18/ken/rts/cmrt/src/cmrt_pack.c
 */
extern void CMRT_pack _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			   CMRT_desc_t mask));
 
extern void CMRT_unpack _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			     CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sun Oct 28 11:02:19 1990
 * from /u18/ken/rts/cmrt/src/cmrt_paris_interface.c
 */
#ifdef CM2
extern void CMCOM_copy_to_paris_field();
extern void CMCOM_copy_from_paris_field();
extern void CMRT_copy_to_paris_field _AP((CM_field_id_t paris_field, 
					  CMRT_desc_t source, 
					  int*paris_axis_mappings));
extern void CMRT_copy_from_paris_field _AP((CMRT_desc_t dest, 
					    CM_field_id_t paris_field, 
					    int*paris_axis_mappings));
#endif
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:33 1990
 * from /u18/ken/rts/cmrt/src/cmrt_pe_code_interface.c
 */
#ifdef CM2
extern void CMRT_load_code _AP((IMP_imp_descriptor_ptr_t code_ptr));
#endif
#ifdef CM2
extern void CMRT_funcall _AP((IMP_imp_descriptor_ptr_t code_ptr, 
			      CMCOM_argblock_ptr_t argblock_ptr));
#else
extern void CMRT_funcall _AP((void (*code_ptr)(),
			      CMCOM_argblock_ptr_t argblock_ptr));
#endif

/* Not used. */
#ifdef CM2
extern void CMRT_execute _AP((IMP_imp_descriptor_ptr_t code_ptr, 
			      CMRT_geometry_ptr_t geom_ptr));
#endif
extern void CMRT_push_address _AP((int4	addr));
extern void CMRT_push_int4 _AP((int4 ival));
extern void CMRT_push_real4 _AP((real4 rval));
extern void CMRT_push_real8 _AP((real8 dval));
extern void CMRT_push_cmpx8 _AP((cmpx8 cval));
extern void CMRT_push_cmpx16 _AP((cmpx16 zval));
/*
 * Generated by hand Mon Nov 5 1990
 * from /u18/ken/rts/cmrt/src/cmrt_random.c
 */
#ifndef CM2
extern void CMRT_initialize_random_wolfram _AP((int4 seed));
#endif
extern void CMRT_initialize_random _AP((CMRT_desc_t dest,
					CMRT_desc_t mask,
					int8 *seed64));
extern void CMRT_random _AP((CMRT_desc_t dest,
			     CMRT_desc_t mask,
			     int4 limit));
extern void CMRT_initialize_physical_random _AP((int8 *seed64));
extern void CMRT_physical_random _AP((CMRT_desc_t dest,
				      CMRT_desc_t mask,
				      int4 limit));
extern void CMRT_deallocate_rng _AP(());
extern void CMRT_deallocate_physical_rng _AP(());
/*
 * Generated by hand Thur Nov 8 1990
 * from /u18/ken/rts/cmrt/src/cmrt_rank.c
 */
extern void CMRT_rank _AP((CMRT_desc_t dest,
			   CMRT_desc_t source,
			   int4 axis,
			   CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:34 1990
 * from /u18/ken/rts/cmrt/src/cmrt_read_write.c
 */
extern int4 CMRT_read_array_element_int4
  _AP((CMRT_desc_t source, 
       CMCOM_send_address_t send_address));
extern unsigned4 CMRT_read_array_element_unsigned4
  _AP((CMRT_desc_t source, 
       CMCOM_send_address_t send_address));
extern log4 CMRT_read_array_element_log4
  _AP((CMRT_desc_t source, 
       CMCOM_send_address_t send_address));
extern real4 CMRT_read_array_element_real4
  _AP((CMRT_desc_t source, 
       CMCOM_send_address_t send_address));
extern real8 CMRT_read_array_element_real8
  _AP((CMRT_desc_t source, 
       CMCOM_send_address_t send_address));
extern cmpx8 CMRT_read_array_element_cmpx8
  _AP((CMRT_desc_t source, 
       CMCOM_send_address_t send_address));
extern cmpx16 CMRT_read_array_element_cmpx16
  _AP((CMRT_desc_t source, 
       CMCOM_send_address_t send_address));
extern void CMRT_read_array_element_into_buffer
 _AP((CMRT_desc_t source, CMCOM_send_address_t send_address, 
      int*buffer, 
      int element_size));
extern void CMRT_write_array_element_int4
  _AP((CMRT_desc_t dest, 
       CMCOM_send_address_t send_address, 
       int4 value));
extern void CMRT_write_array_element_unsigned4
  _AP((CMRT_desc_t dest, 
       CMCOM_send_address_t send_address, 
       unsigned4 value));
extern void CMRT_write_array_element_log4
  _AP((CMRT_desc_t dest, 
       CMCOM_send_address_t send_address, 
       log4 value));
extern void CMRT_write_array_element_real4
  _AP((CMRT_desc_t dest, 
       CMCOM_send_address_t send_address, 
       real4 value));
extern void CMRT_write_array_element_real8
  _AP((CMRT_desc_t dest, 
       CMCOM_send_address_t send_address, 
       real8 value));
extern void CMRT_write_array_element_cmpx8
  _AP((CMRT_desc_t dest, 
       CMCOM_send_address_t send_address, 
       cmpx8 value));
extern void CMRT_write_array_element_cmpx16
  _AP((CMRT_desc_t dest, 
       CMCOM_send_address_t send_address, 
       cmpx16 value));
extern void CMRT_write_array_element_from_buffer
 _AP((CMRT_desc_t dest, CMCOM_send_address_t send_address, 
      int*buffer, 
      int element_size));
extern void CMRT_read_array _AP((int4*dest, CMRT_desc_t source));
extern void CMRT_write_array _AP((CMRT_desc_t dest, int4*source));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:37 1990
 * from /u18/ken/rts/cmrt/src/cmrt_reduce.c
 */
extern void CMRT_reduce_logior _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				    int4 axis, 
				    int8 coordinate, 
				    CMRT_desc_t mask));
extern void CMRT_reduce_logand _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				    int4 axis, 
				    int8 coordinate, 
				    CMRT_desc_t mask));
extern void CMRT_reduce_count _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				   int4 axis, 
				   int8 coordinate, 
				   CMRT_desc_t mask));
extern void CMRT_reduce_max _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				 int4 axis, 
				 int8 coordinate, 
				 CMRT_desc_t mask));
extern void CMRT_reduce_min _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				 int4 axis, 
				 int8 coordinate, 
				 CMRT_desc_t mask));
extern void CMRT_reduce_product _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				     int4 axis, 
				     int8 coordinate, 
				     CMRT_desc_t mask));
extern void CMRT_reduce_sum _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				 int4 axis, 
				 int8 coordinate, 
				 CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:39 1990
 * from /u18/ken/rts/cmrt/src/cmrt_reshape.c
 */
extern void CMRT_reshape _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			      CMRT_desc_t pad, 
			      int4*order));
/*
 * Generated by hand Wed Jan 23 12:23:49 1991
 * from /u18/ken/rts/cmrt/src/cmrt_saddr_safety.c
 */
extern  
  void CMRT_check_saddrs_wrt_array
  _AP((CMRT_desc_t array,
       CMRT_desc_t saddr,
       CMRT_desc_t mask));

/*
 * Generated by hand Fri Feb 15 19:42 1991
 * from ~haroldh/rts/cmrt/src/cmrt_saddr_safety.c
 */
extern
  void CMRT_check_coord_wrt_array
  _AP((CMRT_desc_t saddr,
       int4 axis,
       CMRT_desc_t coordinate,
       CMRT_desc_t mask));

/*
 * Generated by hand Fri Nov 9 1990
 * from /u18/ken/rts/cmrt/src/cmrt_safety.c
 */
extern void CMRT_enable_safety _AP(());
extern void CMRT_disable_safety _AP(());
extern int4 CMRT_safety_enabled _AP(());

/*
 * Generated by c-declarify-source Sat Oct 27 12:23:39 1990
 * from /u18/ken/rts/cmrt/src/cmrt_scalar_addresses.c
 */
extern CMCOM_send_address_t CMRT_scalar_make_send_address _AP(());
extern void CMRT_scalar_deposit_grid_coordinate
  _AP((CMRT_array_geometry_t geometry, 
       CMCOM_send_address_t*send_address, 
       int4 axis, 
       int8 coordinate));
extern void CMRT_scalar_deposit_grid_coordinate_zero
  _AP((CMRT_array_geometry_t geometry, 
       CMCOM_send_address_t*send_address, 
       int4 axis, 
       int8 coordinate));
extern int8 CMRT_scalar_extract_grid_coordinate
  _AP((CMRT_array_geometry_t geometry, 
       CMCOM_send_address_t send_address, 
       int4 axis));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:41 1990
 * from /u18/ken/rts/cmrt/src/cmrt_scan.c
 */
extern void CMRT_scan_add _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			       CMRT_desc_t segment, 
			       int4 axis, 
			       CMCOM_direction_t direction, 
			       CMCOM_inclusion_t inclusion, 
			       CMCOM_segment_mode_t mode, 
			       CMRT_desc_t mask));
extern void CMRT_scan_product _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				   CMRT_desc_t segment, 
				   int4 axis, 
				   CMCOM_direction_t direction, 
				   CMCOM_inclusion_t inclusion, 
				   CMCOM_segment_mode_t mode, 
				   CMRT_desc_t mask));
extern void CMRT_scan_max _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			       CMRT_desc_t segment, 
			       int4 axis, 
			       CMCOM_direction_t direction, 
			       CMCOM_inclusion_t inclusion, 
			       CMCOM_segment_mode_t mode, 
			       CMRT_desc_t mask));
extern void CMRT_scan_min _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			       CMRT_desc_t segment, 
			       int4 axis, 
			       CMCOM_direction_t direction, 
			       CMCOM_inclusion_t inclusion, 
			       CMCOM_segment_mode_t mode, 
			       CMRT_desc_t mask));
extern void CMRT_scan_copy _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				CMRT_desc_t segment, 
				int4 axis, 
				CMCOM_direction_t direction, 
				CMCOM_inclusion_t inclusion, 
				CMCOM_segment_mode_t mode, 
				CMRT_desc_t mask));
extern void CMRT_scan_logior _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				  CMRT_desc_t segment, 
				  int4 axis, 
				  CMCOM_direction_t direction, 
				  CMCOM_inclusion_t inclusion, 
				  CMCOM_segment_mode_t mode, 
				  CMRT_desc_t mask));
extern void CMRT_scan_logand _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				  CMRT_desc_t segment, 
				  int4 axis, 
				  CMCOM_direction_t direction, 
				  CMCOM_inclusion_t inclusion, 
				  CMCOM_segment_mode_t mode, 
				  CMRT_desc_t mask));
extern void CMRT_scan_logxor _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				  CMRT_desc_t segment, 
				  int4 axis, 
				  CMCOM_direction_t direction, 
				  CMCOM_inclusion_t inclusion, 
				  CMCOM_segment_mode_t mode, 
				  CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:46 1990
 * from /u18/ken/rts/cmrt/src/cmrt_send_get.c
 */
extern void CMRT_enable_send_verification _AP(());
extern void CMRT_disable_send_verification _AP(());
extern void CMRT_send _AP((CMRT_desc_t dest, CMRT_desc_t send_address, 
			   CMRT_desc_t source, 
			   CMRT_desc_t mask));
extern void CMRT_send_logior _AP((CMRT_desc_t dest, CMRT_desc_t send_address, 
				  CMRT_desc_t source, 
				  CMRT_desc_t mask));
extern void CMRT_send_logxor _AP((CMRT_desc_t dest, CMRT_desc_t send_address, 
				  CMRT_desc_t source, 
				  CMRT_desc_t mask));
extern void CMRT_send_logand _AP((CMRT_desc_t dest, CMRT_desc_t send_address, 
				  CMRT_desc_t source, 
				  CMRT_desc_t mask));
extern void CMRT_send_add _AP((CMRT_desc_t dest, CMRT_desc_t send_address, 
				 CMRT_desc_t source, 
				 CMRT_desc_t mask));
extern void CMRT_send_max _AP((CMRT_desc_t dest, CMRT_desc_t send_address, 
				 CMRT_desc_t source, 
				 CMRT_desc_t mask));
extern void CMRT_send_min _AP((CMRT_desc_t dest, CMRT_desc_t send_address, 
				 CMRT_desc_t source, 
				 CMRT_desc_t mask));
extern void CMRT_get _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			  CMRT_desc_t send_address, 
			  CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:47 1990
 * from /u18/ken/rts/cmrt/src/cmrt_shift.c
 */
extern void CMRT_cshift _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			     int8 distance, 
			     int4 axis, 
			     int8 extent));
extern void CMRT_cshift_vector _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				    CMRT_desc_t distance, 
				    int4 axis, 
				    int8 extent));
extern void CMRT_eoshift _AP((CMRT_desc_t dest, CMRT_desc_t source, 
			      int8 distance, 
			      int4 axis, 
			      int8 extent));
extern void CMRT_eoshift_vector _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				     CMRT_desc_t distance, 
				     int4 axis, 
				     int8 extent));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:48 1990
 * from /u18/ken/rts/cmrt/src/cmrt_spread.c
 */
extern void CMRT_spread_copy _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				  int4 axis, 
				  int8 coordinate, 
				  CMRT_desc_t mask));
extern void CMRT_multispread_copy _AP((CMRT_desc_t dest, CMRT_desc_t source, 
				       unsigned4 axes_mask, 
				       int8*coordinate, 
				       CMRT_desc_t mask));
/*
 * Generated by c-declarify-source Sat Oct 27 12:23:49 1990
 * from /u18/ken/rts/cmrt/src/cmrt_variables.c
 */
extern CMRT_cm_location_t CMRT_scratch_location;

#endif
