#ifndef CM_IMPCTL_H
#define CM_IMPCTL_H
#if !defined(lint) && !defined(__SABER__) && !defined(LC)
static char impctl_rcsid[] = "$Id: impctl.h,v 1.10 1991/11/21 03:36:59 dm Exp $";
#endif
/*****************************************************************************
* 	  Copyright (c) 1988 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/


/* This file is to be included by modules which link with the "impctl"
   facility */


/* include internal PARIS stuff */

#include "paris-internal.h"     /* also includes field-decoding.h, paris.h */

#define MAX_VERIFY_TRIES 3	/* number of times to try verify */

#define P_IMP_NAME_SIZE 63	/* Length of mi_names (rest ignored) */
				/* use multiple of 4 less 1 for efficiency */
typedef char imp_name[P_IMP_NAME_SIZE+1]; /* IMP_NAME with room for null */

/* declare routine return types */

#define MAP_SIZE 4000		/* max number of loaded imps + holes */

typedef unsigned int IMP_impid_t;	/* cutesy name for an IMP id */

/* Following is error code used in the NOLINKAGE IMP's call to IMP-ERROR */

#define NOLINKAGE_ERROR_CODE 1

/* Error codes return by the IMPCTL interface - do not change */

#define IMPERR_OK 			0
#define IMPERR_NOT_OPEN			1
#define IMPERR_ALREADY_EXISTS		2
#define IMPERR_CANNOT_OPEN_FILE         3
#define IMPERR_IMP_NOT_FOUND_IN_FILE 	4
#define IMPERR_OUT_OF_SRAM 		5
#define IMPERR_BAD_FILE_FORMAT		6
#define IMPERR_LOADED			7
#define IMPERR_NOT_LOADED		8
#define IMPERR_UNRESOLVED_LINKAGES      9 /* unresolved refs exist */
#define IMPERR_TOO_MANY_LIBRARIES      10 /* out of space for libfile names */
#define IMPERR_IMPS_LOADED	       11 /* IMPS are loaded */
#define IMPERR_VERIFY_FAILURE	       12 /* IMP verification failure */
#define IMPERR_INVALID_IMPID           13 /* impid isn't one */
#define IMPERR_MI_NOT_IN_CS            14 /* macroinst not in this CS */
#define IMPERR_IMI_WRONG_MACHINE_TYPE  15 /* .imi file compiled for wrong hw */
#define IMPERR_IMI_OLD_MICROCODE       16 /* .imi file cimpiled for old uC */
/* IMPGEN */
#define IMPERR_NO_SUCH_MI              100 /* IMPGEN: no such MI */
#define IMPERR_BAD_ARG_COUNT           101 /* IMPGEN: Bad arg count for MI */
#define IMPERR_COUNTER_ARG_TOO_LOW     102 /* IMPGEN: Counter below min */

/* error status globals */

int impctl_status;			/* status return from last call */
char impctl_err_string_1[100];
char impctl_err_string_2[100];

/* IMP DESCRIPTOR as used by IMP_open_imps_from_descriptor_list */

struct imp_descriptor {
  int unused;
  IMP_impid_t imp_id;	/* The id returned from OPEN-IMP-FROM-DESCRIPTOR */
  char *name;		/* an asciz string */
  struct imp_descriptor *next_imp_ptr;  /* next desc in list or 0 */
  unsigned int body_length;
  unsigned int num_calls;
  int calls_and_body[1];  /* entensible */
};

typedef struct imp_descriptor IMP_imp_descriptor_t;
typedef struct imp_descriptor *IMP_imp_descriptor_ptr_t;

/* Following variable is global and may be set by the application if desired.
   If set to 1, IMPCTL will not require a CM but will trace its activity to
   the terminal. This only works of IMPCTL has been compiled with it feature
   select "debug_code" set to 1 */

int impctl_debug;

/* Dynamic SRAM metering variables */

int impass_meter_load_count;		/* number of imps loaded */
int impass_meter_load_word_count;	/* total number of SRAM words loaded */
int impass_meter_execute_count;		/* number of calls to execute_imp_id */
int impass_meter_flush_count;		/* number of times all imps removed to make room for load */
int impass_meter_flush_word_count;	/* number of SRAM words reclaimed by flushes */
int impass_meter_compress_word_count;   /* number of SRAM words reclaimed in compress_imps */

/* symbolic arguments values */

#define IMP_LIBRARIES 0		/* arg to open_imp and search_for_imps */
#define ALL_IMPS 0		/* arg to open_imp */
#define LOAD_IMPS 1		/* arg to open_imp and search_for_imps */
#define NO_LOAD_IMPS 0		/*   "   */
#define INDEFINITE 0		/* indef search repeat in search_for_imps */

/* Codes for modes and their values */

#define DISPLAY_ERROR_MODE 1    /* display errors (1=yes, 0=no) */
#define EXIT_ON_ERROR_MODE 2	/* exit on error (1=yes, 0no) */
#define VERIFY_LOADS_MODE 3     /* readback all loaded IMPS to verify them */
#define VERBOSE_LIB_SEARCH_MODE 4  /* trace library searches to tty */
#define AUTO_SEARCH_MODE 5        /* On all loads, auto open/load req'd imps */
#define DYNAMIC_LOAD_MODE 6   /* In auto load mode, move/remove imps to
				      make room */

#define SET_MODE 1		/* set */
#define RESET_MODE 0		/* clear */
#define NO_CHANGE -1		/* no change */

/* Macros to pretty up (and make official) the method for sending and
   receiving values via the FIFOs */

#define IMP_send_imp_data(x) \
     { register int _data_; _data_ = x; _CMI_write_fifo_32(_data_); }
#define IMP_send_imp_data_float(x) \
     { register double _data_; _data_ = x; _CMI_write_fifo_32(_CMI_number_to_ieee_single_float(_data_, 23, 8)); }
#define IMP_receive_imp_data() _CMI_read_fifo_32()          /* returns a long */
#define IMP_receive_imp_data_float() \
     _CMI_ieee_f_to_number(_CMI_read_fifo_32(), 23, 8)  /* returns a double */

/* Macros to pretty up and make official, the built-in front-end
   callable macroinstructions */

#define IMP_push_flag_bases() _CMI_imp_push_flag_bases()
#define IMP_pop_flag_bases() _CMI_imp_pop_flag_bases()

/* register numbering */

#define IMP_REG_R0 0
#define IMP_REG_R1 1
#define IMP_REG_R2 2
#define IMP_REG_R3 3
#define IMP_REG_R4 4
#define IMP_REG_R5 5
#define IMP_REG_R6 6
#define IMP_REG_R7 7
#define IMP_REG_R8 8
#define IMP_REG_R9 9
#define IMP_REG_R10 10
#define IMP_REG_R11 11
#define IMP_REG_R12 12
#define IMP_REG_R13 13
#define IMP_REG_R14 14
#define IMP_REG_R15 15
#define IMP_REG_R16 16
#define IMP_REG_R17 17
#define IMP_REG_R18 18
#define IMP_REG_R19 19
#define IMP_REG_R20 20
#define IMP_REG_R21 21
#define IMP_REG_R22 22
#define IMP_REG_R23 23
#define IMP_REG_R24 24
#define IMP_REG_R25 25
#define IMP_REG_R26 26
#define IMP_REG_R27 27
#define IMP_REG_R28 28
#define IMP_REG_R29 29
#define IMP_REG_R30 30
#define IMP_REG_R31 31
#define IMP_REG_R32 32
#define IMP_REG_R33 33
#define IMP_REG_R34 34
#define IMP_REG_R35 35
#define IMP_REG_R36 36
#define IMP_REG_R37 37
#define IMP_REG_R38 38
#define IMP_REG_R39 39
#define IMP_REG_R40 40
#define IMP_REG_R41 41
#define IMP_REG_R42 42
#define IMP_REG_R43 43
#define IMP_REG_R44 44
#define IMP_REG_R45 45
#define IMP_REG_R46 46
#define IMP_REG_R47 47
#define IMP_REG_R48 48
#define IMP_REG_R49 49
#define IMP_REG_R50 50
#define IMP_REG_R51 51
#define IMP_REG_R52 52
#define IMP_REG_R53 53
#define IMP_REG_R54 54
#define IMP_REG_R55 55
#define IMP_REG_R56 56
#define IMP_REG_R57 57
#define IMP_REG_R58 58
#define IMP_REG_R59 59
#define IMP_REG_R60 60
#define IMP_REG_R61 61
#define IMP_REG_R62 62
#define IMP_REG_R63 63

#define IMP_REG_A1 1		/* %A1-%A12 (General/Argument registers) */
#define IMP_REG_A2 2
#define IMP_REG_A3 3
#define IMP_REG_A4 4
#define IMP_REG_A5 5
#define IMP_REG_A6 6
#define IMP_REG_A7 7
#define IMP_REG_A8 8
#define IMP_REG_A9 9
#define IMP_REG_A10 10
#define IMP_REG_A11 11
#define IMP_REG_A12 12

#define IMP_REG_C1 17		/* %C1-%C4 (counter registers) */
#define IMP_REG_C2 18
#define IMP_REG_C3 19
#define IMP_REG_C4 20
#define IMP_REG_P1 21
#define IMP_REG_P2 22
#define IMP_REG_P3 23
#define IMP_REG_P4 24
#define IMP_REG_N1 25
#define IMP_REG_N2 26
#define IMP_REG_N3 27
#define IMP_REG_V 41	
#define IMP_REG_I1 42
#define IMP_REG_I2 43
#define IMP_REG_I3 44
#define IMP_REG_I4 45
#define IMP_REG_CTX_BASE 46
#define IMP_REG_CTX_INC 47
#define IMP_REG_TST_BASE 48
#define IMP_REG_FLAG_INC 49
#define IMP_REG_CAR_BASE 50
#define IMP_REG_OFL_BASE 52
#define IMP_REG_IO_REG 57
#define IMP_REG_IMP_SP 58	/* %IMP-SP (Control Stack pointer) */

/* Bit masks for the register mask fields using in SEND/RECEIVE-REGS-x */

#define REG_MASK_A_P1 (1 << 0)
#define REG_MASK_A_P2 (1 << 1)
#define REG_MASK_A_P3 (1 << 2)
#define REG_MASK_A_P4 (1 << 3)
#define REG_MASK_A_I1 (1 << 4)
#define REG_MASK_A_I2 (1 << 5)
#define REG_MASK_A_I3 (1 << 6)
#define REG_MASK_A_I4 (1 << 7)
#define REG_MASK_A_C1 (1 << 8)
#define REG_MASK_A_C2 (1 << 9)
#define REG_MASK_A_C3 (1 << 10)
#define REG_MASK_A_C4 (1 << 11)
#define REG_MASK_A_N1 (1 << 12)		/* missing, patched */
#define REG_MASK_A_N2 (1 << 13)		/* missing, patched */
#define REG_MASK_A_N3 (1 << 14)		/* missing, patched */
#define REG_MASK_A_V  (1 << 15)		/* wrong, patched */

#define REG_MASK_B_A1 (1 << 0)		/* wrong, patched */
#define REG_MASK_B_A2 (1 << 1)		/* wrong, patched */
#define REG_MASK_B_A3 (1 << 2)		/* wrong, patched */
#define REG_MASK_B_A4 (1 << 3)		/* wrong, patched */
#define REG_MASK_B_A5 (1 << 4)		/* wrong, patched */
#define REG_MASK_B_A6 (1 << 5)		/* wrong, patched */
#define REG_MASK_B_A7 (1 << 6)		/* wrong, patched */
#define REG_MASK_B_A8 (1 << 7)		/* wrong, patched */
#define REG_MASK_B_A9 (1 << 8)		/* wrong, patched */
#define REG_MASK_B_A10 (1 << 9)		/* wrong, patched */
#define REG_MASK_B_A11 (1 << 10)	/* wrong, patched */
#define REG_MASK_B_A12 (1 << 11)	/* wrong, patched */
#define REG_MASK_B_R13 (1 << 12)	/* wrong, patched */
#define REG_MASK_B_R14 (1 << 13)	/* wrong, patched */
#define REG_MASK_B_R15 (1 << 14)	/* wrong, patched */
#define REG_MASK_B_R16 (1 << 14)	/* wrong, patched */

#define REG_MASK_C_R39 (1 << 0)
#define REG_MASK_C_R38 (1 << 1)
#define REG_MASK_C_R37 (1 << 2)
#define REG_MASK_C_R36 (1 << 3)
#define REG_MASK_C_R35 (1 << 4)
#define REG_MASK_C_R34 (1 << 5)
#define REG_MASK_C_R33 (1 << 6)
#define REG_MASK_C_R32 (1 << 7)
#define REG_MASK_C_R31 (1 << 8)
#define REG_MASK_C_R30 (1 << 9)
#define REG_MASK_C_R29 (1 << 10)
#define REG_MASK_C_R28 (1 << 11)
#define REG_MASK_C_R53 (1 << 12)	/* patched, do not use */
#define REG_MASK_C_R54 (1 << 13)	/* patched, do not use */
#define REG_MASK_C_R55 (1 << 14)	/* patched, do not use */
#define REG_MASK_C_R56 (1 << 15)	/* patched, do not use */

#define REG_MASK_D_R0 (1 << 0)		/* patched, do not use */
#define REG_MASK_D_40 (1 << 1)		/* patched, do not use */
#define REG_MASK_D_CTX_BASE (1 << 2)
#define REG_MASK_D_CTX_INC (1 << 3)
#define REG_MASK_D_TST_BASE (1 << 4)
#define REG_MASK_D_FLAG_INC (1 << 5)
#define REG_MASK_D_CAR_BASE (1 << 6)
#define REG_MASK_D_R51 (1 << 7)		/* patched, do not use */
#define REG_MASK_D_OFL_BASE (1 << 8)
#define REG_MASK_D_IO_REG (1 << 9)	/* missing, patched */
#define REG_MASK_D_IMP_SP (1 << 10)
#define REG_MASK_D_R59 (1 << 11)
#define REG_MASK_D_R60 (1 << 12)
#define REG_MASK_D_R61 (1 << 13)
#define REG_MASK_D_R62 (1 << 14)
#define REG_MASK_D_R63 (1 << 15)

#define IMP_set_imp_reg_flag_inc(value) \
     { _CMI_imp_receive__flag_inc(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_ofl_base(value) \
     { _CMI_imp_receive__ofl_base(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_car_base(value) \
     { _CMI_imp_receive__car_base(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_tst_base(value) \
     { _CMI_imp_receive__tst_base(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_ctx_inc(value) \
     { _CMI_imp_receive__ctx_inc(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_ctx_base(value) \
     { _CMI_imp_receive__ctx_base(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_v(value) \
     { _CMI_imp_receive__v(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_i4(value) \
     { _CMI_imp_receive__i4(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_i3(value) \
     { _CMI_imp_receive__i3(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_i2(value) \
     { _CMI_imp_receive__i2(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_i1(value) \
     { _CMI_imp_receive__i1(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_c4(value) \
     { _CMI_imp_receive__c4(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_c3(value) \
     { _CMI_imp_receive__c3(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_c2(value) \
     { _CMI_imp_receive__c2(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_c1(value) \
     { _CMI_imp_receive__c1(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_n1(value) \
     { _CMI_imp_receive__n1(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_n2(value) \
     { _CMI_imp_receive__n2(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_n3(value) \
     { _CMI_imp_receive__n3(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_p4(value) \
     { _CMI_imp_receive__p4(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_p3(value) \
     { _CMI_imp_receive__p3(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_p2(value) \
     { _CMI_imp_receive__p2(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_p1(value) \
     { _CMI_imp_receive__p1(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a12(value) \
     { _CMI_imp_receive__a12(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a11(value) \
     { _CMI_imp_receive__a11(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a10(value) \
     { _CMI_imp_receive__a10(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a9(value) \
     { _CMI_imp_receive__a9(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a8(value) \
     { _CMI_imp_receive__a8(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a7(value) \
     { _CMI_imp_receive__a7(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a6(value) \
     { _CMI_imp_receive__a6(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a5(value) \
     { _CMI_imp_receive__a5(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a4(value) \
     { _CMI_imp_receive__a4(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a3(value) \
     { _CMI_imp_receive__a3(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a2(value) \
     { _CMI_imp_receive__a2(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_a1(value) \
     { _CMI_imp_receive__a1(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r13(value) \
     { _CMI_imp_receive__r13(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r14(value) \
     { _CMI_imp_receive__r14(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r15(value) \
     { _CMI_imp_receive__r15(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r16(value) \
     { _CMI_imp_receive__r16(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r39(value) \
     { _CMI_imp_receive__r39(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r38(value) \
     { _CMI_imp_receive__r38(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r37(value) \
     { _CMI_imp_receive__r37(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r36(value) \
     { _CMI_imp_receive__r36(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r35(value) \
     { _CMI_imp_receive__r35(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r34(value) \
     { _CMI_imp_receive__r34(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r33(value) \
     { _CMI_imp_receive__r33(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r32(value) \
     { _CMI_imp_receive__r32(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r31(value) \
     { _CMI_imp_receive__r31(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r30(value) \
     { _CMI_imp_receive__r30(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r29(value) \
     { _CMI_imp_receive__r29(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r28(value) \
     { _CMI_imp_receive__r28(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r53(value) \
     { _CMI_imp_receive__r53(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r54(value) \
     { _CMI_imp_receive__r54(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r55(value) \
     { _CMI_imp_receive__r55(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r56(value) \
     { _CMI_imp_receive__r56(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r0(value) \
     { _CMI_imp_receive__r0(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r40(value) \
     { _CMI_imp_receive__r40(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r51(value) \
     { _CMI_imp_receive__r51(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_io_reg(value) \
     { _CMI_imp_receive__io_reg(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_imp_sp(value) \
     { _CMI_imp_receive__imp_sp(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r59(value) \
     { _CMI_imp_receive__r59(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r60(value) \
     { _CMI_imp_receive__r60(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r61(value) \
     { _CMI_imp_receive__r61(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r62(value) \
     { _CMI_imp_receive__r62(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_r63(value) \
     { _CMI_imp_receive__r63(); _CMI_write_fifo_32(value); }
#define IMP_set_imp_reg_sr(value) \
     { _CMI_receive_sr(); _CMI_write_fifo_32(value); }


#define IMP_send_imp_regs_d(mask) _CMI_imp_send_regs_d(mask)
#define IMP_send_imp_regs_c(mask) _CMI_imp_send_regs_c(mask)
#define IMP_send_imp_regs_b(mask) _CMI_imp_send_regs_b(mask)
#define IMP_send_imp_regs_a(mask) _CMI_imp_send_regs_a(mask)

#define IMP_receive_imp_regs_d(mask) _CMI_imp_receive_regs_d(mask)
#define IMP_receive_imp_regs_c(mask) _CMI_imp_receive_regs_c(mask)
#define IMP_receive_imp_regs_b(mask) _CMI_imp_receive_regs_b(mask)
#define IMP_receive_imp_regs_a(mask) _CMI_imp_receive_regs_a(mask)


/* ====================================================================== */
/* VP decoding macros */

#define IMP_translate_vp_field(field,field_loc,field_inc)		\
{									\
   extern int _CMI_some_safety;						\
   if (_CMI_some_safety) {						\
         _CMI_check_field_safety(field, -1);				\
   }									\
   _CMI_decode_location_increment(field, field_loc, field_inc);		\
}

#define IMP_translate_vp_field_loc(field,field_loc)			\
{									\
   extern int _CMI_some_safety;						\
   if (_CMI_some_safety) {						\
         _CMI_check_field_safety(field, -1);				\
   }									\
   _CMI_decode_location(field, field_loc);				\
}

#define IMP_load_one_cached_increment_register(incr1)			\
  if(_CMI_check_one_vp_increment(incr1))				\
    {									\
      _CMI_load_one_vp_register(incr1);					\
      _CMI_cache_increment_0 = incr1;					\
    }

#define IMP_load_two_cached_increment_registers(incr1,incr2)		\
  if(_CMI_check_two_vp_increments(incr1, incr2))			\
    {									\
      _CMI_load_two_vp_registers(incr1,incr2);				\
      _CMI_cache_increment_0 = incr1;					\
      _CMI_cache_increment_1 = incr2;					\
    }

#define IMP_load_three_cached_increment_registers(incr1,incr2,incr3)	\
  if(_CMI_check_three_vp_increments(incr1,incr2,incr3))			\
    { 									\
      _CMI_load_three_vp_registers(incr1,incr2,incr3);			\
      _CMI_cache_increment_0 = incr1; 					\
      _CMI_cache_increment_1 = incr2; 					\
      _CMI_cache_increment_2 = incr3; 					\
    }

#define IMP_load_four_cached_increment_registers(incr1,incr2,incr3,incr4)	\
  if(_CMI_check_four_vp_increments(incr1,incr2,incr3,incr4))		\
    {									\
      _CMI_load_four_vp_registers(incr1,incr2,incr3,incr4);		\
      _CMI_cache_increment_0 = incr1;					\
      _CMI_cache_increment_1 = incr2;					\
      _CMI_cache_increment_2 = incr3;					\
      _CMI_cache_increment_3 = incr4;					\
    }

#define IMP_decache_vp_increments()					\
    {									\
      _CMI_cache_increment_0 = 0xFFFFFFFF;				\
      _CMI_cache_increment_1 = 0xFFFFFFFF;				\
      _CMI_cache_increment_2 = 0xFFFFFFFF;				\
      _CMI_cache_increment_3 = 0xFFFFFFFF;				\
    }


/* ====================================================================== */
/* Macros to calculate absolute section numbers */

extern int _CMI_physical_number_of_chips_offset;

#define IMP_abs_cm_section(relsect)						\
    (relsect + (_CMI_physical_number_of_chips_offset / 2))

/* ====================================================================== */
/* IMPGEN stuff */

struct jump_linkage {
  unsigned int offset_arg_offset;	/* Imp loc of OFFSEt arg */
  unsigned int next_mi_offset;		/* Imp loc of next MI */
};

typedef struct jump_linkage jlink;
#endif
