;;; -*- Base: 10; Syntax: Common-Lisp; Package: cmi; Patch-File: Yes; -*- 

;; 
;; Patch for cmfb:available-displays and cmfb:monitor-location
;; Original code didn't deal with C Null terminated strings quite right.
;; 11/5/91 08:33:10 nesheim
;;

(in-package 'cmi)
(defun cmfb:available-displays (&optional vector-of-names)
  (let ((vector-provided (not (null vector-of-names))))
    (when (not vector-provided)
      (setq vector-of-names (make-array 16))
      )
    (with-c-string (c-string 128)
      (dotimes (j 16)
	(if (zerop (c::available-display c-string j))
	    (setf (aref vector-of-names j) nil)
	    (let ((lisp-string (lcl::foreign-string-value c-string)))
	      ;; Trim NULLs
	      (setq lisp-string (subseq lisp-string 0 
					(position #\Null lisp-string)))
	      (setf (aref vector-of-names j) (copy-seq lisp-string)))))))
  vector-of-names
  )

(defun cmfb:monitor-location (display-id &optional (location-string nil))
  (with-c-string (c-string 128)
    (c::monitor-location display-id c-string)
    (let ((lisp-string (lcl::foreign-string-value c-string)))
      ;; Trim NULLs
      (setq lisp-string (subseq lisp-string 0 (position #\Null lisp-string)))
      (if location-string
	  (let ((len (min (length lisp-string) (length location-string))))
	    (loop for j below len
		  do
	       (setf (aref location-string j) (aref lisp-string j)))
	    (setf (aref location-string len) #\Null)
	    location-string)
	  lisp-string))))

(eval-when (load eval)
  (cmi::increment-patch-level 2))
