
(in-package '*lisp-i)

;;; INTERNAL-ARRAY-TO-PVAR, which was defined in an FLET inside of ARRAY-TO-PVAR,  was losing
;;; the default binding of the :array-offset argument, due to a bug in the Lucid compiler.
;;; It is here defined as a real function (LABELS didn't work either).

;;; AJW 1/6/92 

#+:lucid
(defun internal-array-to-pvar (source-array &optional (dest-pvar nil)
					    &key (array-offset 0) (cube-address-start nil) 
					    (cube-address-end nil cube-address-end-provided)
					    (start nil start-provided) (end nil end-provided))
  ;; check the arguments.

  (when (and (not start-provided) (not cube-address-start)) (setq cube-address-start 0))
  (when (and (not end-provided)
	     (not cube-address-end-provided))
    (setq cube-address-end *number-of-processors-limit*))
  (parse-array-to-pvar-arguments dest-pvar source-array array-offset cube-address-start cube-address-end start end)
  (when start-provided (setq cube-address-start start))
  (when end-provided (setq cube-address-end end))
  
  ;; Select exactly those processors being written to.
  (*all
    (*when (<=!! (!! (the fixnum cube-address-start)) (self-address!!) (!! (the fixnum (1- cube-address-end))))
      ;; Do the transfer.
      (actual-array-to-pvar source-array dest-pvar array-offset cube-address-start cube-address-end)))
  )

#:lucid
(*defun array-to-pvar (&rest args)
  (*compile ()
    ;; Select the vp set of the destination pvar.
    ;; If it's not provided use the currently active vp set.
    (if (second args)
	(*with-vp-set (pvar-vp-set (second args))
	  (apply #'internal-array-to-pvar args))
	(apply #'internal-array-to-pvar args))))

(*lisp-i::increment-patch-level 14)
