;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CMI; Base: 10 -*-


;;; *********************** CHANGE LOG *******************
;;; 
;;; 6/29/92 02:38 Barmar:  Created.
;;; 
#| *************** END OF CHANGE LOG ***************|#

(in-package "CMI")

(defvar *cmfs-patch-write-date* 0)

(system::def-foreign-callable (CM_attached (:language :c)
					   (:name "_CM_attached")
					   (:return-type :unsigned-32bit))
    nil
  (if (cm:attached) 1 0))

(cmfs-lisp::def-c-to-lisp-nil cm:make-news-coordinate-1l cmfs-lisp::CM_make_news_coordinate_1l "_CM_make_news_coordinate_1L"
  ((geometry-id :signed-32bit)
   (dest :signed-32bit)
   (axis :signed-32bit)
   (news-coordinate :signed-32bit)
   (slen :signed-32bit))
  (geometry-id dest axis news-coordinate slen))

(sys::define-c-callable (cmfs-i::set__CMI_next_available_stack_maddr "_set__CMI_next_available_stack_maddr")
    ((value :integer))
  (setq cmi::*next-available-stack-maddr* value))

(let* ((patch-path (dfs::ready-file (dfs::cmfs-patch)))
       (write-date (file-write-date patch-path)))
  (when (> write-date *cmfs-patch-write-date*)
    (lucid::load-foreign-files patch-path)
    (setq *cmfs-patch-write-date* write-date)))
