/* $Id: cm_conf.h,v 1.17 1992/06/09 21:26:01 taylor Exp $ */
/*****************************************************************************
* 	  (c) Copyright  1989 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

/*
 * CM Character device switch.
 */
struct cm_cdevsw {
	int	(*d_open)();		/* dev_t dev, int flags */
	int	(*d_close)();		/* dev_t dev, int flags */
	int	(*d_read)();		/* dev_t dev, struct cm_uio *uio */
	int	(*d_readsize)();	/* u_long count */
	int	(*d_write)();		/* dev_t dev, struct cm_uio *uio */
	int	(*d_ioctl)();		/* dev_t dev, int cmd, caddr_t data, 
					                  int need_to_swap */
	int	(*d_reset)();		/* dev_t dev, int flags */
	int	(*d_select)();		/* dev_t dev, int rw */
};

struct cm_uio {
    int		uio_resid;		/* amount of data requested */
    int		uio_min;		/* minimum transfer size */
    int		uio_max;		/* maximum transfer size */
    char *	uio_buf;		/* buffer available for driver use */
    int		uio_bufsz;		/* size of the above in bytes */
    int		(*uio_xfr)();		/* routine to do the transfer */

    /* the following are new with 6.1 */
    u_long	uio_lo_offset;		/* file offset (low 32 bits) */
    long	uio_hi_offset;		/* byte offset (high 32 bits) */
    u_short	uio_logical_io_flags;	/* first or last op of user's write */
    /* the following is new with 6.1.2 */
    IOBUSID	uio_cmioc_busid;	/* bus&station id of remote end */
};
/*
 * bit definitions for cm_uio.uio_logical_io_flags same as reqrdwr.ioflags in
 * cm_fsmsg.h
 */

/* 
 * the arguments to the uio_xfr routine are
 * (*uio_xfr) (addr, length);
 */


#ifdef FILE_SERVER
extern struct cm_cdevsw cm_cdevsw[];
extern int nchrdev;
#endif
