;;; -*- Base: 10; Syntax: Common-Lisp; Package: cmi; Patch-File: Yes; -*- 

;;;
;;; fixes bug in cm:cross-vp-move-1l
;;; 11/19/91 13:42:17 heller
;;;

(in-package 'cmi)


(defparameter CVPM-MAX-PHYSICAL-BITS   16)

(defvar *cvpm-verbosity* 0)
(defun cvpm-set-verbosity (v) (setq *cvpm-verbosity* v))

(defun cvpm-deposit-physical-bits (physical-bits axis-coords axes num-axes)
   #+lc(declare (type (simple-array fixnum (*)) physical-bits axis-coords)
		(type (simple-array cm:axis-descriptor (*)) axes))		
  (dotimes (i num-axes)
    (let* ((axis (aref axes i)) 
	   (coord (aref axis-coords i))
	   (indexed-p (not (minusp coord)))
	   )
      (if (and (cvpm-axis-part-physical-p axis)
	       indexed-p)
	  (let* ((on-pos   (axis-descriptor-on-chip-pos   axis))
		 (on-bits  (axis-descriptor-on-chip-bits  axis))
		 (off-bits (axis-descriptor-off-chip-bits axis))
		 (off-pos  (axis-descriptor-off-chip-pos  axis))

		 (virtual-index  (aref axis-coords i))
		 (physical-index (truncate virtual-index (cvpm-axis-virtual-length axis)))
		 (on-index  (logand physical-index (1- (ash 1 on-bits))))
		 (off-index (ash physical-index (- on-bits)))
		 )
	    (when (>= *cvpm-verbosity* 2)
	      (format t "~% virtual-index  ~d" virtual-index)
	      (format t "~% physical-index ~d" physical-index)
	      (format t "~% on-index       ~d" on-index)
	      (format t "~% off-index      ~d" off-index)
	      )
	    (loop for j from on-pos below (+ on-pos on-bits) do
	      (let ((index-bit (logand on-index #x1)))
		(setf (aref physical-bits j) index-bit)
		(setq on-index (ash on-index -1))
		(when (>= *cvpm-verbosity* 2)
		  (format t "~%(on [~d]=~d)" j index-bit))
		))
	    (loop for j from (+ 4 off-pos) below (+ 4 off-pos off-bits) do
	      (let ((index-bit (logand off-index #x1)))
		(setf (aref physical-bits j) index-bit)
		(setq off-index (ash off-index -1))
		(when (>= *cvpm-verbosity* 2)
		  (format t "~%(off [~d]=~d)" j index-bit))
		))
	    )))))

(cmi::increment-patch-level 11)
