;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CMI; Base: 10; Patch-File: Yes -*-

(in-package 'cmi)

;;
;; Patch for /cm/paris/hardware/io/f6102/fb-ucode-new.lisp
;;

;; value is the 16 bit mask for the register that is being waited on
;; uses the length register as a temp register
(defucmacro FB-WAIT-FOR-VSYNC (high-low-keyword)
  `(ucblock ()
     ;; the register is the status register
     (setreg register (constant #xf))
     ;; the vertical bit is #x40
     (setreg value (constant #x40))
     ;; anopther temp - used for timeout
     ;;
     ;; >>> Changed constant to #xf000 (was #x3000) per salem
     ;; >>> nesheim 11/4/91 10:29:34
     ;;
     (setreg processor-mask (constant #xf000))  ;; arbitrary number

     (label try-again-for-vsync)
     (setreg processor-mask (- processor-mask (constant 1)))
     ;; test for timeout
     (ui (jump no-timeout not-addr-zero))
     (uc-ferror "CM Framebuffer timeout waiting for vertical sync.~@
Perhaps your framebuffer is not properly initialized or is broken.")
     (label no-timeout)
     (fb-io-read-inner register)
     ;; read back data in length (temp), and'ing it with the mask
     (ui (alu-simp (and value rdata) (length $exp)))
     ;; now, spread it around all the micros
     (fb-global-or-bits length 16)
     ;; now test for vertical sync (zero means no vertical sync yet)
     (ui (jump try-again-for-vsync ,(ecase high-low-keyword
				      (:low 'not-addr-zero)
				      (:high 'addr-zero))))
     ))


;;
;; Callers of the above macro (unchanged, just here so they get recompiled)
;;

(def-io-min-mic FB-WAIT-UNTIL-STATUS
		(backplane-mask-and-io-board)
  (min-mic-declare (:default-mm-regs *default-fb-ucode-registers*)
		   (:argument-types (backplane-mask-and-io-board 16)))
  (load-backplane-mask-and-io-board backplane-mask-and-io-board)
  (load-chip-select-for-io-read backplane-mask-and-io-board)

  ;; Wait for it to go Low
  (fb-wait-for-vsync :low)

  ;; Wait for it to go High
  (fb-wait-for-vsync :high)
  )

(def-io-min-mic FB-UPDATE-HARDWARE
		(backplane-mask-and-io-board start-ptr wait-p syscntl)
  (min-mic-declare (:argument-types (backplane-mask-and-io-board 16)
				    (start-ptr 16) (wait-p 16) (syscntl 16)))
  (load-backplane-mask-and-io-board backplane-mask-and-io-board)
  (load-chip-select-for-io-read backplane-mask-and-io-board)
  
  (with-mm-reg (register value length processor-mask);;vsync use these

    ;; Test if we should update the start pointer
    (setreg start-ptr start-ptr)
    (ui (jump end-load-start-ptr addr-zero))

    ;; Wait for vsync low
    (fb-wait-for-vsync :low)
    ;; Write the start point
    (setreg register (constant #x06));; *fbreg-load-start-pointer*
    (fb-io-write-inner register start-ptr)
    (label end-load-start-ptr)

    ;; Wait for vsync high if wait-p
    (setreg wait-p wait-p)
    (ui (jump end-wait addr-zero))
    (fb-wait-for-vsync :high)
    (label end-wait)

    ;; Write syscntl if non-zero
    (setreg syscntl syscntl)
    (ui (jump end-syscntl addr-zero))
    (setreg register (constant #x00));; *fbreg-syscntl*
    (fb-io-write-inner register syscntl)
    (label end-syscntl)
    ))


(eval-when (load eval)
  ;(warn "You must do a (cmi::link-paris) to apply the fb wait-for-vsync patch") 
  (cmi::increment-patch-level 6))
