;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CMI; Base: 10; Patch-File: Yes -*-

(in-package 'cmi)

(defun news-u-rank-internal (destination key destination-length key-length axis direction
			   &optional (send #'cm:send-1l))
  (declare (type (function (&rest t) (values)) send))
  (let* ((number-of-dims (integer-length (1- (cm:geometry-axis-length cmi::*current-geometry-id* axis))))
	 (cond-key-length (+ 1 key-length))
	 (msg-length (+ cm:*cube-address-length* cond-key-length))
	 (chunk-size (if (< *current-vp-ratio* *rank-secondary-chunk-size-start*)
			 *rank-primary-chunk-size*
			 *rank-secondary-chunk-size*
			 )))
    (with-stack-fields ((key-source msg-length)
			(key-destination msg-length)
			(dest-address number-of-dims)
			(temp-field msg-length)
			(temp-dest-address msg-length)
			(context-store-bit 1)
			)
      ;; Scratch is organized as follows
      ;;                         Start Relative to Scratch Bottom           Length
      ;;   key-source                        0                            msg-length
      ;;   key-dest               msg-length                              msg-length     \
      ;;   temp-bit               msg-length                                  1          -- overlap
      ;;   temp-address           (+ msg-length cond-key-length)         number-of-dims  /
      ;;   dest-address           (* 2 msg-length)                       number-of-dims
      ;;   context-store-bit      (+ (* 2 msg-length) number-of-dims)         1
      
      (if (> number-of-dims destination-length)
	  (ferror "For sort-internal the ~d bit destination field is not large enough: ~d bits are required."
		  destination-length number-of-dims))
      
      ;; store away context and clear the destination space
      (cm:move-always context-store-bit cm:context-flag 1)
      (cm:move-constant destination 0 destination-length)
      (cm:set-context)
      
      ;; Move the key and self address next to each other in the key-source field
      (cm:move key-source key key-length)

      (cm:my-news-coordinate-1l (+ key-source cond-key-length) axis number-of-dims)
      ;; If any processors are not set, move the context in to the highest bit of the key
      ;; otherwise shorten cond-key-length by 1
      (if (eq direction :upward)
	  (cm:lognot-always (+ key-source key-length) context-store-bit 1)
	  (cm:move-always (+ key-source key-length) context-store-bit 1))
      
      (let ((iterations (truncate cond-key-length chunk-size))
	    (left-over (mod cond-key-length chunk-size)))
	
	;; The following is repeated for each chunk of bits of the key
	(dotimes (i iterations)
	  (news-sort-bits chunk-size
			  (+ key-source (* i chunk-size))
			  (+ key-destination (* i chunk-size))
			  dest-address
			  (- msg-length (* i chunk-size))
			  number-of-dims
			  axis direction temp-field
			  send))
	
	;; this does the odd left over bits
      	(news-sort-bits left-over
			(+ key-source (- cond-key-length left-over))
			(+ key-destination (- cond-key-length left-over))
			dest-address
			(- msg-length (- cond-key-length left-over))
			number-of-dims
			axis direction temp-field
			send))
      
      ;; Send pointer back to original source of the key
      (cm:move dest-address (+ key-source cond-key-length) number-of-dims)
      (cm:set-context)
      (cm:my-send-address-1l temp-field)
      (cm:u-move-1l temp-dest-address temp-field cm:*cube-address-length*)
      (cm:deposit-news-coordinate-1l cmi::*current-geometry-id* temp-field axis dest-address number-of-dims)
      (funcall send key-destination temp-field temp-dest-address msg-length cm:*no-field*)
      ;; Conditionally move result to the final dest field
      (cm:move-always cm:context-flag context-store-bit 1)
      (cm:extract-news-coordinate-1l cmi::*current-geometry-id* destination axis key-destination number-of-dims)
      )))

(cmi::increment-patch-level 15)
