;;; -*- Mode: Lisp; Package: *LISP-I ; Base: 10.; Syntax: Common-lisp; Patch-File: T -*-

(in-package '*lisp-i)

;; *Graphics function *lisp-i::create-x-display-window patched by hlv on 26 Feb 92.
;; Prints an error message instead of a bus error when it can't connect to host. 

(defun create-x-display-window (&key host desired-width desired-height name display-padding)

  ;; Default args
  (unless host (setq host (default-x-host)))
  (unless desired-width (setq desired-width 256))
  (unless desired-height (setq desired-height 256))

  ;; Check arg values
  (assert (stringp host) () "Host is not a string specifying a machine name")

  (if name
      (assert (stringp name) () "Name, ~A, is not a string" name)
      (setq name (default-generic-display-name)))

  (let ((cmsr-host (cmsr::get-x-display host)))
    (when (null cmsr-host)
      (error "Could not connect to server ~s." host))
    (let ((cmsr-display
	   (let ((cmsr::*x-default-title* name))
	     (cmsr:create-init-x-display
	       cmsr-host
	       desired-width
	       desired-height
	       ))))
      (when (not (generic-x-display-p cmsr-display))
	(error "cmsr:create-init-cmfb-display failed to create an X Display Device")
	)
      (make-display-window
	:name name
	:cmsr-display cmsr-display
	:type :XWINDOW
	:deleted-p nil
	:display-padding (or display-padding *display-padding*)
	))))

(*lisp-i::increment-patch-level 10)
