
(in-package '*lisp-i)

;;; This function is called by PPP-CSS, and was taking 
;;; *NUMBER-OF-PROCESSORS-LIMIT* as the default for the :end
;;; argument instead of *PPP-DEFAULT-END*, as is implied by
;;; the *Lisp Dictionary.

;;; Andy Wilson 9/6/92

(defun display-active-processor-values

       (
	pvar
	&key
	(format "~S ")
	(start *ppp-default-start*)
	(end *ppp-default-end*)
	(title *ppp-default-title*)
	(mode *ppp-default-mode*)
	)
  (declare (ignore mode))
  (pvar-argument!! pvar legal-pvar-value)
  (when (not (stringp format))
    (error "Format key value is not a string: ~S" format))
  (when (or (not (integerp start))
	    (not (integerp end))
	    (< end start)
	    (< start 0)
	    (> end *number-of-processors-limit*))
    (error "Start or End keyword value invalid"))
  (terpri *standard-output*)
  (when (not (*or t!!))
    (format *standard-output* "No active processors...~%")
    (return-from display-active-processor-values nil))
  (if (stringp title) (format *standard-output* "~A: " title))
  (let ((active-processors (vector-of-active-processors))
	(count 0)
	(format-string (format nil "~A: ~A " "~5@S" format)))
    (dotimes (i (length active-processors))
      (let ((p (aref active-processors i)))
	(when (and (>= p start) (< p end))
	  (ppp-format *standard-output* format-string p (pref-or-junk pvar p))
	  (incf count)
	  (when (eql count 8) (setq count 0) (terpri *standard-output*))))))
  (values))

(*lisp-i::increment-patch-level 17)
