#ifndef _CMSOFT_
#define _CMSOFT_
/*****************************************************************************
*         Copyright 1989 Thinking Machines Corporation, Inc.		     *
*	      of Cambridge, Mass.  All rights reserved.			     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#if !defined(lint) && !defined(c_star) && !defined(__SABER__) && !defined(LC)
static char rcsid_cmsoft[] = 
    "$Id: cmsoft.h,v 1.20 1992/02/28 16:58:59 nesheim Exp $";
#endif

#define IFIFO_READY	0x01
#define OFIFO_READY	0x02
#define EXCEPTION	0x04
#define INTERRUPT	0x08
#define TIMEOUT		0x10
#define XFERCOMPLETE	0x20

#define SELWAIT		0x80	/* or this into cmp_events if in select */
#define ACCTWAIT	0x100	/* accting daemon is selecting for an */
				/* accounting record */


#define MAXPROCS	(32*NCM) /* max number of clients */

/*
 * Output FIFO data queues
 */

#define FDSIZE 512
#define FDPOOLSIZE (MAXPROCS*4)

typedef struct fifodata {
    struct fifodata *fd_next;
    int fd_start;
    int fd_end;
    long fd_data[FDSIZE];
} FIFODATA;

typedef struct fifoqueue {
    FIFODATA *fq_head;
    FIFODATA *fq_tail;
    int fq_length;
} FIFOQUEUE;


/*
 * Internal data structure that records the state of the CM Interface.
 * One of these structures is defined for each interface configured into
 * the kernel (as defined by the manifest constant NCM).
 */

#define NULLPROC	((CM_PROC *)0)

typedef struct cm_proc {
    struct cm_proc *cmp_sibling; 	/* pointer to next process tree */
    struct cm_proc *cmp_next;		/* pointer to next process in this list */
    struct cm_proc *cmp_owner;		/* pointer to base of the list */
    struct cm_state *cmp_interface; 	/* pointer to interface structure */
    struct proc	*cmp_procp;		/* pointer to Unix proc structure */
    long	*cmp_cminfo;		/* pointer to this lists CMINFO */
    short	cmp_pid;
    dev_t	cmp_dev;
    long	cmp_events;		/* Mask of events waiting for */
    int		cmp_timer;		/* count down timer */
    FIFOQUEUE	cmp_ofifo_data;
    FIFOQUEUE	cmp_ififo_data;		
    CM_UDATA    cmp_udata;
    struct buf	cmp_buf;
    CM_KACCT	*cmp_kacct;
    int		cmp_openflags;		/* a copy of the mode option to open */
    struct segcm_data	*cmp_sdp;	/* Segment where FIFO is mapped */
    int		cmp_nseg;		/* Number of segments we have mapped */
    CM_ACCT	*cmp_childs_cmacct;	/* Last child to disconnect's accounting info */
} CM_PROC;

/*
 * The queue of waiting processes...
 */
typedef struct q_for_cm {
  struct q_for_cm *prev;
  struct q_for_cm *next;
  CM_WAITING_USER wuser;
  struct proc *proc;
} Q_FOR_CM;

/*
 * cms_flags:
 */
#define CMS_AVAIL	0x001	/* device is available (i.e., it exists) */
#define CMS_OPEN	0x002	/* device is currently open --- there is */
				/* some process that is connected */
				/* (US_CONNECTED) to this interface) */
/*
 * an interface may be marked exclusive mode and shared at the same time!
 * The CMS_SHARED may serve as a warning that there is a suspended
 * timesharing job lurking in the background....
 */
#define	CMS_EXCL	0x004	/* device is in exclusive mode (there is a */
				/* process that is connected US_DIRECT to */
				/* it) */
#define CMS_SHARED	0x008	/* device is in shared mode (there is some */
				/* process US_SHARED, or cms->cms_daemon */
				/* still exists) */
#define	CMS_XFER	0x010	/* transfer in progress on device */
#define CMS_TIMER	0x020	/* timer has been started */
#define CMS_DIAGNOSTIC_OPEN 0x040 /* someone has opened the diagnostic */
				  /* device */

typedef struct cm_state {
    CM_REGS	*cms_regs;	/* pointer to hardware registers */
#ifdef vax
    int		cms_binumber;	/* BI bus number */
    int		cms_binode;	/* BI node id */
    struct pte	*cms_ptep;	/* Pointer to PTEs for registers. */
    int		cms_bibi_rev;	/* BIBI rev level */
#endif
    int		cms_switch;	/* dummy for context switch sleeps */
    int		cms_flags;	/* flags describing current state etc */
    short	cms_interface;	/* number of this interface */
    short	cms_seqn;	/* sequncers in use */
    int		cms_intpri;	/* hardware interrupt priority */
    int		cms_host;	/* ID of our host port */
    int		cms_iwords;	/* number of words in ififo */
    struct proc *cms_intr_proc;	/* process to send h/w ints to */
    CM_PROC	*cms_daemon;	/* current timeshare daemon process  */
    /*
     * cms_active plays two roles, depending on whether we're timesharing
     * or not:
     *
     *  if timesharing, it is the client process that is currently
     *     controlling the CM.
     *  if exclusive mode, it is the process which is getting charged for
     *     CM activity.  See the explanation of cm.c:FindActive() for more
     *     on this.
     */
    CM_PROC	*cms_active;	/* currently active client process */
				/* (timesharing only) */
    CM_STAT	cms_stats;	/* driver statistics */
    /*
     * the folowing two get reset when the active process changes:
     */
    int 	cms_ififo_busy_ticks;
    int 	cms_ucc_busy_ticks;
    long 	cms_modtime;	/* last time an ioctl or open done to this */
				/* interface */
    long	cms_touchtime;	/* last time the interface's regs were */
				/* written */
    /*
     * The time the interface's sequencer set went from non-zero to zero.
     * For this value to be meaningful, it must be non-zero (that is, zero
     * is used to indicate that this time should be ignored, e.g., during
     * an attach, before the sequencers have been grabbed.)
     */
    long	cms_seqn_to_zero;
    CM_TSINFO	cms_tsinfo;	/* some shared info between driver and ts daemon */
    Q_FOR_CM	*cms_reservation;
    struct proc *cms_proc_locking_nexus;
} CM_STATE;


struct segcm_data {
    dev_t	dev;			/* Device mapped */
    CM_PROC	*cmproc;		/* CM_PROC doing mapping */
    u_int	off;
    u_int	len;
    u_int	prot;
    struct segcm_data *next;
    struct segcm_data *prev;
    struct seg	*seg;
};

#define segcm_crargs segcm_data

/*
 * usage quota structures.
 *
 * this is an array hashed by UID/GID.  When there are hash conflicts, the
 * items are sorted by increasing UID.
 *
 *			It's a big machine:
 *		 Gold and greenbacks turn to brown.
 *			      SIGXCPU.
 */
typedef struct CM_LIMIT_LIST {
    /*
     * linkage pointers for the hash-chain:
     *
     * items that are chained into the same bucket are sorted by
     * decreasing uid.
     */
    struct CM_LIMIT_LIST *prev;
    struct CM_LIMIT_LIST *next;
    /*
     * All CM_LIMIT_LIST elements are linked in a single unordered chain
     * (permits a ready examination of all of them).
     */
    struct CM_LIMIT_LIST *chain_prev;
    struct CM_LIMIT_LIST *chain_next;
    CM_LIMIT limit;
    /*
     * the following are used to accumulate the time for currently
     * existing processes.
     *
     * When a process exits, its accumulated charges will be deducted from
     * the quotas in the limit structure.
     *
     * Every time SLOWTIMER fires, we add all the runtime charges of
     * existing processes into the active_* fields for those processes'
     * quotas.  This lets us know the currently accumulating balance
     * against the quota.
     */
    int active_exclusive_access_time;
} CM_LIMIT_LIST;

#endif

