/*****************************************************************************
* 	  Copyright (c) 1988 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#include <stdio.h>
#include "cm/paris.h"
#include "cm/display.h"
#include "cm/cmsr.h"
#include "cm/cm_file.h"
#include "cm/cm_stat.h"


#define FIELD_LENGTH	32

main(argc, argv)
int argc;
char *argv[];
{
	char *dv_filename;
	char error_buf[100];
	int dv_fd;
	int x_image_size;
	int y_image_size;
	int bits_per_pixel;
	int images;
	int i;
	struct cm_stat cm_stat;
	int dim_array[2];
	CM_geometry_id_t geometry_id;
	CM_vp_set_id_t vp_set_id;
	CM_field_id_t dest_field;
	int x_offset;
	int flags;
	int ret;
	int x_zoom;
	int y_zoom;
	int preshuffled;

	if (argc != 6)	{
		fprintf(stderr, "Usage: %s file_name x_image_size y_image_size bits_per_pixel preshuffled\n",
					argv[0]);
		exit(1);
	}
	
    /* Deallocate the old display if it exists */
    if (CMSR_selected_display())
      CMSR_deallocate_display(CMSR_selected_display());


	CM_init();

	dv_filename = argv[1];
	x_image_size = atoi(argv[2]);
	y_image_size = atoi(argv[3]);
	bits_per_pixel = atoi(argv[4]);
	preshuffled = atoi(argv[5]);

	dim_array[0] = x_image_size;
	dim_array[1] = y_image_size;
	geometry_id = CM_create_geometry(dim_array, 2);
	vp_set_id = CM_allocate_vp_set(geometry_id);
	CM_set_vp_set(vp_set_id);
	CM_set_context();
	dest_field = CM_allocate_heap_field(FIELD_LENGTH);


	if ((dv_fd = CMFS_open(dv_filename, CMFS_O_RDONLY)) < 0)	{
		sprintf(error_buf, "Cannot open %s", dv_filename);
		CMFS_perror(error_buf);
		exit(2);
	}

	if (CMFS_fstat(dv_fd, &cm_stat) < 0)	{
		sprintf(error_buf, "fstat failed on %s", dv_filename);
		CMFS_perror(error_buf);
		exit(3);
	}

	/* compute the number of images in the file */
	images = CMFS_bits_per_processor(cm_stat.cmst_cmwords, cm_stat.cmst_bits_per_cmword, 
				         CM_user_cube_address_limit)/bits_per_pixel;
	x_zoom = (1024/x_image_size) - 1;
	y_zoom = (1024/y_image_size) - 1;


	if ((flags = CMFS_fcntl(dv_fd, CMFS_F_GETFL, 0)) < 0)	{
		sprintf(error_buf, "Cannot get flag info about %s", dv_filename); 
                CMFS_perror(error_buf);
                exit(4);
        }

	/* Turn on streaming mode */
	if (CMFS_fcntl(dv_fd, CMFS_F_SETFL, flags | CMFS_FSTREAMING) < 0)	{
		sprintf(error_buf, "Cannot set flag info about %s", dv_filename); 
                CMFS_perror(error_buf);
                exit(4);
        }

    /* Set up the Display */
    CMSR_select_display(CMSR_create_display_menu (bits_per_pixel, x_image_size,
						  y_image_size));
    CMSR_image_ordering = (preshuffled) ? CMSR_preshuffled : CMSR_normal;
    
	/* Set up to read the entire file */
	if (CMFS_read_file_always(dv_fd, dest_field, bits_per_pixel * images) < 0)	{
		sprintf(error_buf, "Cannot read %s", dv_filename); 
                CMFS_perror(error_buf);
                exit(4);
        }
 
	/* Check initial return to be sure all is OK */
	if ((ret = CMFS_streaming_iostat(dv_fd)) != bits_per_pixel * images)	{
		printf("CMFS_streaming_iostat returned %d instead of %d", 
				ret, bits_per_pixel * images); 
		if (ret < 0)
                	CMFS_perror("CMFS_streaming_iostat failed");
                exit(4);
        }
 
	/* Center the image */
	x_offset = ((1280/(x_zoom + 1)) - x_image_size)/2;

	for (i=0;  i<images;  i++)	{
		if (CMFS_partial_read_file_always(dv_fd, dest_field, bits_per_pixel) < 0) {
			sprintf(error_buf, "Cannot partial read %s", dv_filename); 
                	CMFS_perror(error_buf);
                	exit(5);
        	}

		if (preshuffled)	
			/* do something */;
		else {
		    int bpp = CMSR_display_bits_per_pixel();

		    if (bpp == 1) 
			dither(dest_field, 8);
		    CMSR_write_to_display(dest_field);
		}
			
	}

	if (CMFS_streaming_iostat(dv_fd) < 0)	{
               	CMFS_perror("CMFS_streaming_iostat finishing call failed");
                exit(4);
        }
 
	CMFS_close(dv_fd);
}
 

