/* $Id: vmeio-ioctl.h,v 1.10 1991/07/15 15:24:04 sharakan Exp $ */
/*****************************************************************************
*       Copyright (c) 1988, 1990 Thinking Machines Corporation, Inc.
*	      of Cambridge, Mass. All rights reserved.
*									     
*  This notice is intended as a precaution against inadvertent publication
*  and does not constitute an admission or acknowledgement that publication
*  has occurred or constitute a waiver of confidentiality.
*									     
*  Connection Machine software is the proprietary and confidential property  
*  of Thinking Machines Corporation.
*****************************************************************************/

#include <sys/ioctl.h>
#include <sys/uio.h>

/*
 * VMEIO target structure 
 */
struct vmeio_target_set {
	int		ts_ntargets;			/* total number of targets */
	int		ts_blocksize;			/* How many bytes/target */
	short	ts_target_id[16];			/* target ID list */
};

/*
 * VMEIO configuration structure
 */
struct vmeio_config {
	int		cf_sta_id;			/* Station ID of the VMEIO */
	int		cf_flags;			/* see below */
	int		cf_busid;			/* bus within system */
	int		cf_bus_speed;			/* bus speed code */
	int		cf_rev;				/* board revision */
	int		cf_dram_size;			/* amt DRAM avail. */
	int		spare[10];
};

/*
 * Definitions for the cf_flags field:
 */
#define VMEIO_CF_ARBITER	0x1		/* Enable this board as an arbiter */

struct vmeio_stride_rw {
  struct iovec *rw_iov;			/* iovec struct for read or write */
  u_int		rw_iovcnt;		/* length of iovec struct array */
  u_int		rw_stride;		/* length of each stride */
  u_int		rw_stripe;		/* which stride we're working on */
  u_int		rw_nstrides;		/* # of strides (striping factor) */
  u_long	rw_result;		/* amount actually transferred */
};

/*
 * driver ioctl calls
 */
/*
 * Grot.  We have to define our own versions of these
 * since Ultrix and SunOS are no longer compatable.
 * Use the version from Ultrix, which is independant of C compiler
 * oddities, and is the smaller of the two.
 */


#define _CMIOCPARM_MASK   0x7f            /* Parameters are < 128 bytes   */
#define _CMIOC_VOID       (int)0x20000000 /* No parameters                */
#define _CMIOC_OUT        (int)0x40000000 /* Copy out parameters          */
#define _CMIOC_IN         (int)0x80000000 /* Copy in parameters           */
#define _CMIOC_INOUT      (int)(_CMIOC_IN|_CMIOC_OUT)
#define _CMIO(x,y)        (int)(_CMIOC_VOID|(x<<8)|y)
#define _CMIOR(x,y,t)     (int)(_CMIOC_OUT|((sizeof(t)&_CMIOCPARM_MASK)<<16)|(x<<8)|y)
#define _CMIOW(x,y,t)     (int)(_CMIOC_IN|((sizeof(t)&_CMIOCPARM_MASK)<<16)|(x<<8)|y)
#define _CMIOWR(x,y,t)    (int)(_CMIOC_INOUT|((sizeof(t)&_CMIOCPARM_MASK)<<16)|(x<<8)|y)

/* user calls */

#define VMEIO_SET_TARGETS		_CMIOW('i', 1, struct vmeio_target_set)
#define VMEIO_GET_TARGETS		_CMIOR('i', 2, struct vmeio_target_set)
#define VMEIO_SET_CONFIGURATION		_CMIOW('i', 3, struct vmeio_config)
#define VMEIO_GET_CONFIGURATION 	_CMIOR('i', 4, struct vmeio_config)
#define VMEIO_RESET			_CMIO('i',5)
#define VMEIO_SET_SOURCES		_CMIOW('i', 6, struct vmeio_target_set)
#define VMEIO_GET_SOURCES		_CMIOR('i', 7, struct vmeio_target_set)
#define VMEIO_RECEIVE_ENABLE		_CMIO('i', 8)

#define VMEIO_SET_RAM_PTR		_CMIOW('i', 9, int)
#define VMEIO_GET_RAM_PTR		_CMIOR('i', 10, int)

#define VMEIO_ALLOCATE_DRAM		_CMIOWR('i', 11, int)
#define VMEIO_FREE_DRAM			_CMIOW('i', 12, int)

#define VMEIO_IS_DRAM			_CMIOW('i', 13, unsigned)
#define VMEIO_SOFT_RESET		_CMIO('i', 14)

#define VMEIO_READ_STRIDE		_CMIOWR('i', 15, struct vmeio_stride_rw)
#define VMEIO_WRITE_STRIDE		_CMIOWR('i', 16, struct vmeio_stride_rw)

/* diagnostic calls */

#define VMEIO_DIAG_SETUP_DMA		_CMIOR('i', 18, int)
#define VMEIO_DIAG_RELEASE_DMA		_CMIO('i', 19)
#define VMEIO_DIAG_SET_LOOP		_CMIO('i', 20)
#define VMEIO_DIAG_CLEAR_LOOP		_CMIO('i', 21)
#define VMEIO_DIAG_INTR			_CMIO('i', 22)
#define VMEIO_DIAG_SET_SIG		_CMIOW('i', 23, int)
#define VMEIO_DIAG_GET_SIG		_CMIOR('i', 24, int)

/* calls for DMA diagnostics */
    /* Allocate a kernel buffer for DMA (arg buffer size) */
#define VMEIO_DIAG_ALLOC		_CMIOW('i', 25, int)
    /* Free previously allocated kernel DMA buffer */
#define VMEIO_DIAG_FREE			_CMIO('i',26)
    /* Copy in data to kernel DMA buffer */
#define VMEIO_DIAG_CPYIN		_CMIOW('i', 27, struct iovec)
    /* Copy out data from kernel to user DMA buffer */
#define VMEIO_DIAG_CPYOUT		_CMIOW('i', 28, struct iovec)

/*
 * ioctls for diagnostic register access
 */
struct vmeio_reg_acc {
    int		offset;
    int		mode;
    u_long	value;
};

#define MODE_BYTE 1
#define MODE_WORD 2
#define MODE_LONG 4

#define	VMEIO_DIAG_READ_REG	_CMIOWR('i', 29, struct vmeio_reg_acc)
#define VMEIO_DIAG_WRITE_REG	_CMIOWR('i', 30, struct vmeio_reg_acc)


