/*****************************************************************************
* 	  Copyright (c) 1988 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#ifndef _CM_FS_
#define _CM_FS_

#if !defined(lint) && !defined(__SABER__)
static char rcsid_cm_fs[] = "$Id: cm_fs.h,v 1.21 91/11/19 16:56:06 dvtmc Rel $";
#endif

/*
 * Parameters for the CM file system 
 * These are things that are not dependant on
 * the particular file server implementing the file system.
 */

#define CMBLOCKSIZE	512	/* bytes per disk block on datavault */
#define BITSPERBYTE	8	/* number of bits per byte */
#define MAXPATH		256	/* max pathname length as passed from CM */
#define MAXCMWRITECMWORDS	(1<<30)	/*  maximum cmwords written at once */
#define MAXSERIALDISKIO	(64 * 1024)		/* max size of a local datavault I/O */

#define OLDBITSPERCMWORD		4096
#endif /* _CM_FS_ */
