/* -*- Base: 10; Mode: C; Package: cmfs-i; -*- */
/*****************************************************************************
 * 	  Copyright (c) 1992 Thinking Machines Corporation, Inc.,	     *
 *		of Cambridge, Mass.   All rights reserved.		     *
 *									     *
 *  This notice is intended as a precaution against inadvertent publication  *
 *  and does not constitute an admission or acknowledgement that publication *
 *  has occurred or constitute a waiver of confidentiality.		     *
 *									     *
 *  Connection Machine software is the proprietary and confidential property *
 *  of Thinking Machines Corporation.					     *
 *****************************************************************************/

#ifndef _CMT_H_INCLUDED_
#define _CMT_H_INCLUDED_

#if !defined(lint) && !defined(__SABER__)
static char rcsid_cmt_h[] = "$Id: cmt.h,v 1.3 1992/06/03 14:31:09 sean Exp $";
#endif

/* flags for CMT_open() */
#define CMT_O_RDONLY	0x00000000	/* same as O_RDONLY */
#define CMT_O_WRONLY	0x00000001	/* same as O_WRONLY */
#define CMT_O_RDWR	0x00000002	/* same as O_RDWR */
/* skip other values used by POSIX */
#define CMT_O_NL	0x00010000	/* NL processing, verify no labels */
#define CMT_O_SL	0x00020000	/* IBM Standard Labels */
#define CMT_O_AL	0x00040000	/* ANSI labels */
#define CMT_O_BL	0x00080000	/* Bypass labels, but still do multiple
					   volumes, use file_count, etc */
#define CMT_O_FBM	0x00100000	/* Use FBM on STC tape drives */
#define CMT_O_AIO	0x00200000	/* Allow for asynchronous I/O */
#define CMT_O_NO_HDR2	0x00400000	/* Ignore all HDR2 fields */
#define	CMT_O_ICRC	0x00800000	/* Use ICRC compression if avail. */

#define CMT_ACCESS_FLAGS (CMT_O_RDONLY|CMT_O_WRONLY|CMT_O_RDWR)
#define CMT_LABEL_FLAGS (CMT_O_NL|CMT_O_SL|CMT_O_AL|CMT_O_BL)

/* flags for CMT_{read,write}[_labels] */
#define CMT_USR_LABELS		0x1	/* Expect/write USR labels */
#define CMT_EOF_LABELS		0x2	/* Process EOF labels */
#define CMT_EOV_LABELS		0x4	/* Process EOV labels */
#define CMT_NEW_DATASET		0x8	/* check HDR2 label, open new control
					   file - done automatically on first
					   volume */
#define CMT_NEW_LABELS		0x10	/* Virgin tape, verify and write new
					   header labels */
#define CMT_NO_VOL1		0x20	/* No VOL1 label (not first dataset) */
#define CMT_RETUSR		0x40	/* Return error to user, instead of
					   going through CMTI_bad_volume() */
#define CMT_ASYNCHIO		0x80	/* Use asynchronous I/O */
#define CMT_NOSCAN		0x100	/* Don't do post-processing of buffer */
/* DO NOT USE 0x100 FOR A FLAG; IT IS USED INTERNALLY */

/* MISC DEFINES */
#define CMT_MAX_VSN_COUNT 1024
#define CMT_MAX_DSN_COUNT 1024
#define CMT_MAX_FILES 8
#define CMT_MAX_BLKSIZE 65536
#define CMT_FLUSH 1
#define CMT_NO_FLUSH 0
#define CMT_INPUT 0
#define CMT_OUTPUT 1
#define CMT_DSN_SIZE 17
#define CMT_VSN_SIZE 6
/* string of 40 spaces */
#define CMT_SPACE_STRING "                                        "
#define CMT_DONE -2
#define DVBASEBLOCKSIZE 16384
#define VMEIO_ALIGNMENT 8
#define AIO_INIT (AIO_INPROGRESS-1)

#endif /* _CMT_H_INCLUDED_ */
