#
#include <stdio.h>

#define	ROOT	0
#define	MAXUID	256
char users[MAXUID][8];
#define	MAXGID	256
char groups[MAXGID][8];
char ans[4+1];
char mtsid[4+1];

char *passwd "/etc/passwd";
char *groupfile "/etc/group";
int statb[18];
FILE *logf;

char dir[32];
char id[8+1];
char group[8+1];
char mail[32];
char shell[32];
char grant[8];
char office[16];
char homephone[12];
char lim[7];
int limit;
char name[64];
char supervisor[32];
char phone[9];
char pw[16];
char *cpw;		/* pointer to encrypted password */
int uid, gid;
int maxgrp;
int ruid;
int rgid;
int tvec[2];
char *accfile;		/* the name of the accounting file */

main(argc,argv) char **argv;
{
register int i;
register FILE *f;

ruid = getuid()&0377;
rgid = getgid()&0377;
if (setuid(ROOT) < 0)			/* make us root */
	err("nice try");
loop:
maxgrp = rdtab(groups,MAXGID,groupfile);
if (maxgrp <= 0)
	err("cannot read %s",groupfile);
i = rdtab(users,MAXUID,passwd);
if (i < 0)
	err("cannot read %s",passwd);
printf("maximum id = %d\n",i);
if (++i >= MAXUID)
	for (i=4; i<MAXUID; ++i)
		if (users[i][0] == 0)
			break;
if (i >= MAXUID)
	err("no more UID's available");
ask("user id",&id,8);
if (id[0] == 0)
	err("a user id must be specified");
if ((uid = lookup(id,users)) >= 0)
	err("ID '%s' already in use as UID %d",id,uid);
uid = i;
printf("User '%s' will be UID %d\n",id,uid);
ask("password",&pw,(sizeof pw)-1);
if (pw[0])
	cpw = crypt(pw);
else
	cpw = "";
clear(group,sizeof group);
while (group[0] == 0)
	ask("group",&group,(sizeof group)-1);
if ((gid = lookup(group,groups)) <= 0)
	{
	if (yes("No such group. Create it?"))
		{
		if ((f = fopen(groupfile,"a")) == NULL)
			err("cannot open %s",group);
		fprintf(f,"%s::%d:\n",group,gid = ++maxgrp);
		fclose(f);
		}
	else
		exit(0);
	}

#ifdef UBC
ask("MTS ID (if outside user)",&mtsid,4);
#else
ask("GCOS ID",&mtsid,4);
#endif

ask("shell (if not default)",&shell,(sizeof shell)-1);
ask("directory (if not default)",&dir,(sizeof dir)-1);
ask("Name (in full)",&name,(sizeof name)-1);
ask("Supervisor's Last name",&supervisor,(sizeof supervisor)-1);
clear(grant,sizeof grant);
#ifdef UBC
if (mtsid[0] == 0)
	ask("Charge code",&grant,(sizeof grant)-1);
#endif
ask("Phone number (complete)",&phone,(sizeof phone)-1);
ask("Office number",&office,(sizeof office)-1);
ask("Home phone",&homephone,(sizeof homephone)-1);
ask("$C monthly limit?",&lim,(sizeof lim)-1);
limit = atoi(lim);
if (dir[0] == 0)
	{
#ifdef UBC
	if (mtsid[0])
		sprintf(dir,"/u/%s",id);
	else
		sprintf(dir,"/mnt/%s",id);
#else
	sprintf(dir,"/usr/%s",id);
#endif
	}
if (stat(dir,&statb) >= 0)
	{
	printf("%s already exists\n",dir);
	if (!yes("Continue?"))
		exit(1);
	}
else
	mkdir(dir);
if (stat(dir,&statb) < 0 || chdir(dir) < 0)
	err("could not create directory %s",dir);
chown(dir,(gid<<8)+uid);
/*
 * test if using v6 mail by testing for  a /.mail file.
 * if it exists then create a .mail file for the user; otherwise
 * not.
 */
if (stat("/.mail",&statb) >= 0)
	{
	sprintf(mail,"%s/.mail",dir);
	if (close(creat(mail,0666)) < 0)
		err("could not creat mail file %s",mail);
	chmod(mail,0666);		/* insure correct mode */
	chown(mail,(gid<<8)+uid);
	}
if ((f = fopen(passwd,"a")) == NULL)
	err("cannot open %s",passwd);
fprintf(f,"%s:%s:%d:%d:%s:%s:%s\n",
	id,cpw,uid,gid,mtsid,dir,shell);	/* write /etc/passwd */
fclose(f);
if (f = fopen("/etc/phonelist","a"))
	{
	fprintf(f,"%s|%s|%s|%s|%s|%s|%s|%s|\n",id,group,name,supervisor,phone,grant,office,homephone);
	fclose(f);
	}
#ifdef UBC
setlimit(uid,limit);
clrsh(uid);
#endif
logf = fopen("/etc/mkuser.log","a");
if (logf != NULL)
	{
	time(tvec);
	fprintf(logf,"By %s at %s",users[ruid],ctime(tvec));
	log(logf);
	fclose(logf);
	}
log(stdout);
if (stat(accfile) >= 0)
	clracc(uid);
if (yes("more?"))
	goto loop;
}

log(f) FILE *f;
{
fprintf(f,"User '%s' created: UID=%d directory='%s' group='%s'",
	id,uid,dir,group);
if (mtsid[0])
	fprintf(f," mtsid='%s'",mtsid);
if (shell[0])
	fprintf(f," shell=%s",shell);
fprintf(f,"\n");
}

ask(msg,str,len) char *msg, *str;
{
char buff[128];

str[0] = 0;		/* clear it first */
loop:
printf("%s ",msg);
if (gets(buff) == NULL)
	exit(0);
if (length(buff) > len)
	{
	printf("string too long\n");
	goto loop;
	}
copy(str,buff);
}

lookup(name,table) char *name; char table[MAXUID][8];
{
register int j;
register char *n;
register char *p;
int i;

for (i=0; i<MAXUID; ++i)
	{
	for (n = name, j=0, p=table[i]; j < 8; j++ )
		if (*n++ != *p++)
			goto next;
	return(i);
next:	;
	}
return(-1);
}

setlimit(i,n)
{
register int f;

if ((f = open("/usr/adm/cpu-stats.l",2)) >= 0)
	{
	seek(f,i * sizeof n,0);
	write(f,&n,sizeof n);
	close(f);
	}
}

yes(msg) char *msg;
{
ask(msg,ans,(sizeof ans)-1);
return(ans[0] == 'y' || ans[0] == 'o');
}

#ifdef UBC
char defsh = 0;
clrsh(uid)
{
/*
 * seek into the shell index table and reset this user's 
 * entry to the default shell.
 */
register int f = open("/etc/shelltable",2);

if (f < 0)
	return;
lseek(f,(long) uid,0);
write(f,&defsh,1);
close(f);
}
#endif
