#
#include <stdio.h>

#define	STATFILE	"/usr/adm/cpu-stats.s"

/*
 * scheck - check space usage for each user on a particular filesystem.
 * if -u specified then update cummulative usage.
 * if -ans specified then select only those inodes that have not been
 *	accessed in "n" "s"'s (s=s,m,d)
 */

char	*dargv[]
{
	0,
	"/dev/rhm1",
	"/dev/rhm2",
	0
};
#define	NINODE	16*16
#define	NB	10
/*
 * Inode structure as it appears on
 * the disk. Not used by the system,
 * but by things like check, df, dump.
 */
struct	inode
{
	int	i_mode;
	char	i_nlink;
	char	i_uid;
	char	i_gid;
	char	i_size0;
	char	*i_size1;
	int	i_addr[8];
	long	i_atime;
	long	i_mtime;
};

/* modes */
#define	IALLOC	0100000
#define	IFMT	060000
#define		IFDIR	040000
#define		IFCHR	020000
#define		IFBLK	060000
#define	ILARG	010000
#define	ISUID	04000
#define	ISGID	02000
#define ISVTX	01000
#define	IREAD	0400
#define	IWRITE	0200
#define	IEXEC	0100
#include <filsys.h>
#include <pwd.h>
#include <stat.h>
#include <debug.h>

struct	inode	inode[NINODE];
struct	filsys	sblock;

int	sflg;
int	Aflg;		/* all users */
int	vflg;		/* verbose */
int	uflg;		/* update the cummulative statistics */
int	aflg;		/* only those files not accessed in x period */
int	debug;		/* debug mode */
long	atime;
int	fi;
int	nifiles;
int	ino;

#define	MAXUID	256
float used[MAXUID];	/* # of blocks used */
double cused[MAXUID];	/* cumulative space used */
int icount[MAXUID];	/* number of inodes per uid */
struct { char name[8]; } users[MAXUID];
int nerror;

/*
 * in-line version of chk1 to improve efficiency
 */
#define	chk1(uid,b,s) (((unsigned) (b))<sblock.s_isize+2 || ((unsigned) (b))>=sblock.s_fsize) ? oldchk1(uid,b,s) : ((used[(uid)&0377] =+ 1) , 0) /* */

long gettime();

main(argc, argv)
char **argv;
{
	register char **p;
	register int n, *lp;
	int i;

	if (argc == 1) {
		for (argc = 1; dargv[argc]; ++argc)
			;
		argv = dargv;
	}
	setout();
	while (--argc) {
		argv++;
		if (**argv=='-') switch ((*argv)[1]) {
		case 'd':
			++debug;
			break;
		case 'A':
			++Aflg;
			break;
		case 'u':
			++uflg;
			break;
		case 'v':
			++vflg;
			break;
		case 'a':	/* select files by access time */
			++aflg;
			time(&atime);
			TRACEF(("now=%D\n",atime));
			atime -= gettime(*argv+2);
			TRACEF(("atime=%D\n",atime));
			break;
		default:
			printf("Bad flag\n");
		}
		else
			check(*argv);
	}
	putstats();
	return(nerror);
}

long gettime(argp) char *argp;
{
long n;

n = cvtint(&argp);
TRACEF(("n = %D\n",n));
switch(*argp)
	{
case 's':
case 0:
	break;
case 'm':
	n *= 60;
	break;
case 'h':
	n *= 60 * 60;
	break;
case 'd':
	n *= 60 * 60 * 24L;
	break;
default:
	err("invalid scale factor %s",argp);
	}
TRACEF(("gettime = %D\n",n));
return(n);
}

putstats()
{
register int i, u;
register char *p;
struct stat statb;
long now;
double elt;
float nu;
struct passwd *pw;

u = 0;
if (uflg)
	{
	stat(STATFILE,&statb);
	u = open(STATFILE,2);
	read(u,&cused,sizeof cused);
	time(&now);
	elt = now-statb.s_mtime;
	}
if (vflg)
	getusers();
for (i=0; i<MAXUID; ++i)
	{
	if ((nu = used[i]) || (Aflg && users[i].name[0]))
		{
		if (vflg)
			{
			p = &users[i].name;
			if (*p)
				printf("%-8.8s",p);
			else
				printf("%8d",i);
			printf(" %6.0f %5u\n",nu,icount[i]);
			}
		cused[i] =+ elt * nu;
		}
	}
if (u > 0)
	{
	seek(u,0,0);
	write(u,cused,sizeof cused);
	}
}

check(file)
char *file;
{
	register *ip, i, j;

	fi = open(file, sflg?2:0);
	if (fi < 0) {
		printf("cannot open %s\n", file);
		nerror =| 04;
		return;
	}
	printf("%s:\n", file);
	bread(1, &sblock, 512);
	nifiles = sblock.s_isize*16;
	for(i=ino=0; ino < nifiles; i =+ NINODE/16) {
		bread(i+2, inode, sizeof inode);
		for(j=0; j<NINODE && ino<nifiles; j++) {
			ino++;
			pass1(&inode[j]);
		}
	}
	close(fi);
}

pass1(aip)
struct inode *aip;
{
	int buf[256], vbuf[256];
	register i, j, *ip;

	ip = aip;
	if ((ip->i_mode&IALLOC) == 0)
		return;
	if ((ip->i_mode&IFCHR&IFBLK) != 0) {
		return;
	}
	TTRACEF(("i_atime = %D, atime = %D\n",ip->i_atime,atime));
	if (aflg && ip->i_atime >= atime)
		return;
	icount[ip->i_uid&0377]++;	/* count number of inodes */
	if ((ip->i_mode&ILARG) != 0) {
		for(i=0; i<7; i++)
		if (ip->i_addr[i] != 0) {
			if (chk1(ip->i_uid,ip->i_addr[i], "indirect"))
				continue;
			bread(ip->i_addr[i], buf, 512);
			for(j=0; j<256; j++)
			if (buf[j] != 0)
				chk1(ip->i_uid,buf[j], "data (large)");
		}
		if (ip->i_addr[7]) {
			if (chk1(ip->i_uid,ip->i_addr[7], "indirect"))
				return;
			bread(ip->i_addr[7], buf, 512);
			for(i=0; i<256; i++)
			if (buf[i] != 0) {
				if (chk1(ip->i_uid,buf[i], "2nd indirect"))
					continue;
				bread(buf[i], vbuf, 512);
				for(j=0; j<256; j++)
				if (vbuf[j])
					chk1(ip->i_uid,vbuf[j], "data (very large)");
			}
		}
		return;
	}
	for(i=0; i<8; i++) {
		if (ip->i_addr[i] != 0)
			chk1(ip->i_uid,ip->i_addr[i], "data (small)");
	}
}

oldchk1(uid, ab, s)
char *ab;
{
	register char *b;

	b = ab;
	if (b<sblock.s_isize+2 || b>=sblock.s_fsize) {
		printf("%5l bad; inode=%5l, class=%s\n", b, ino, s);
		return(1);
	}
	used[uid&0377] =+ 1;
	return(0);
}

bread(bno, buf, cnt)
int *buf;
{
	register *ip;

	seek(fi, bno, 3);
	if (read(fi, buf, cnt) != cnt) {
		printf("read error %d\n", bno);
		if (sflg) {
			printf("No update\n");
			sflg = 0;
		}
		for (ip = buf; ip < &buf[256];)
			*ip++ = 0;
	}
}

number(as)
char *as;
{
	register n, c;
	register char *s;

	s = as;
	n = 0;
	while ((c = *s++) >= '0' && c <= '9') {
		n = n*10+c-'0';
	}
	return(n);
}

getusers()
{
register struct passwd *pw;
register char *p;

for (setpwent(); pw = getpwent(); )
	{
	p = &users[pw->pw_uid].name;
	if (*p == 0)
		strncpy(p,pw->pw_name,8);
	}
}
	
