#include "basic.h"
/*			Copyright 1980 by Bill Webb.	 		*/
#include "stack.h"
#include "tokens.h"

#define	NOOP	0
#define	TYPEMASK	07

double cvtnumber();
double exp();
double log();
double popfloat();

#define	min(a,b) a < b ? a : b
#define	prio(x)	priority[-x]
#define	between(a,b,c) (a <= b && b <= c)
#define	FIRSTOP	OR
#define	LASTOP	PLUS

char priodefs[] IS
{
EXP, 20,
MUL, 11, DIV, 11,
PLUS, 10, MINUS, 10,
EQ, 9, NE, 9, GE, 9, LE, 9, LT, 9, GT, 9,
AND, 7,
OR, 6,
NOOP, 0 };

#define	OPCOUNT	20
char priority[OPCOUNT] INITZERO;

initprio()
{
register int i;

for (i=0; i<sizeof priodefs; i += 2)
	prio(priodefs[i]) = priodefs[i+1];
}


expr()
{
register int op;
register int evop;
#define	MAXOP	10
char opstk[MAXOP];
register char *opptr;
int c;
#define	getitem() c = *inptr; selectitem
#define selectitem if (alpha(c)) pushvar(); else if (isdigit(c)) pushfloat(cvtnumber(&inptr,MAXINT)); else item()
#define	getop()	(between(FIRSTOP,*inptr,LASTOP) ? *inptr++ : 0)

getitem();
if ((op = getop()) == 0)
	return;
opptr = opstk;
*opptr++ = NOOP;		/* nothing */
for (;;)
	{
	if (prio(opptr[-1]) >= prio(op))
		{			/* op stack higher, so evaluate it */
		evop = *--opptr;
		if (evop == NOOP)
			return;
		eval(evop);
		}
	else
		{			/* lower, so stack operator and opand */
		getitem();
		*opptr++ = op;
		if (opptr > opstk+MAXOP)
			err("expression too complex");
		op = getop();
		}
	
	}
}

eval(op)
{
/*
 * Evaluate the operator "op" on the operands on the top of the
 * stack.
 * either two strings or two floating point numbers should be on
 * the stack.
 */
double fp1, fp2;
register struct floatexpr *s;

s = (struct floatexpr *) stkptr;
if (s->k_type == STRINGEXPR)
	{
	streval(op);
	return;
	}
fp2 = popfloat();
s = (struct floatexpr *) stkptr;
if (s->k_type != FLOATEXPR)
	badstk(FLOATEXPR);
fp1 = s->k_float;

switch(op)
	{
case PLUS:
	fp1 += fp2;
	break;
case MINUS:
	fp1 -= fp2;
	break;
case MUL:
	fp1 *= fp2;
	break;
case DIV:
	fp1 /= fp2;
	break;
case EXP:
	fp1 = exp(log(fp1)*fp2);
	break;
case GT:
	fp1 = fp1 > fp2;
	break;
case LT:
	fp1 = fp1 < fp2;
	break;
case LE:
	fp1 = fp1 <= fp2;
	break;
case GE:
	fp1 = fp1 >= fp2;
	break;
case EQ:
	fp1 = fp1 == fp2;
	break;
case NE:
	fp1 = fp1 != fp2;
	break;
case OR:
	fp1 = (fp1 != 0) || (fp2 != 0);
	break;
case AND:
	fp1 = (fp1 != 0) && (fp2 != 0);
	break;
default:
	err("bad operator");
	}
s->k_float = fp1;	/* replace with the result */
}

streval(op)
{
/*
 * string operation on the two strings on top of the stack.
 */
char *ptr1, *ptr2;
int len1, len2;
register int i;

if (op == PLUS)
	{
	concat();
	return;
	}
popstring(&ptr2,&len2);
popstring(&ptr1,&len1);
i = strngcmp(ptr1,len1,ptr2,len2);

switch(op)
	{
case GT:
	i = i > 0;
	break;
case LT:
	i = i < 0;
	break;
case LE:
	i = i <= 0;
	break;
case GE:
	i = i >= 0;
	break;
case EQ:
	i = i == 0;
	break;
case NE:
	i = i != 0;
	break;
default:
	err("bad operator");
	}
pushint(i);
}

strngcmp(ptr1,len1,ptr2,len2) char *ptr1, *ptr2;
{
register int l;
register char *p1, *p2;

l = min(len1,len2);
len1 -= l; len2 -= l;
p1 = ptr1; p2 = ptr2;
while (l > 0 && *p1++ == *p2++)
	--l;
if (l != 0)
	return(*--p1-*--p2);
while (len1 > 0)
	{		/* string 1 longer than string 2 */
	if (*p1++ != ' ')
		return(*--p1 - ' ');
	--len1;
	}
while (len2 > 0)
	{		/* string 2 longer than string 1 */
	if (*p2++ != ' ')
		return(' ' - *--p2);
	--len2;
	}
return(0);		/* strings are equal */
}

item()
{
/*
 * get the next item.
 * an item is either
 * (1) a function invokation
 * (2) + item
 * (3) - item
 * (4) ( expr )
 * (5) "string const"
 * (6) numeric constant 
 * (7) variable
 * (8) a function
 */
register struct floatexpr *s;
register int c;

switch(c = *inptr++)
	{
case FN:
	--inptr;		/* point to fn */
	fn();
	break;
case PLUS:
	item();
	break;
case MINUS:
	item();
	s = (struct floatexpr *) stkptr;
	if (s->k_type != FLOATEXPR)
		err("float required");
	s->k_float = -s->k_float;
	break;
case LPAR:
	expr();
	expectc(RPAR);
	break;
case QUOTE:
case PRIME:
	strconst(c);
	break;
default:
	--inptr;
	if (isdigit(c) || c == '.')
		pushfloat(cvtnumber(&inptr,MAXINT));
	else if (alpha(c))
		pushvar();
	else if (function())
		;
	else
		err("bad operand");
	}
}

double cvtnumber(ptr,len) char **ptr; register int len;
{
/*
 * convert string pointed to by *ptr of length "len" into
 * a number and return it.
 */
#define	MAXDIGITS	64
char numbuff[MAXDIGITS];
double f;
double atof();
register char *n, *p;

p = *ptr;
n=numbuff;
if (*p == '+')
	{ ++p; --len; }
else if (*p == '-')
	{ *n++ = *p++; --len; }
for (; isdigit(*p) || *p == '.' || *p == 'e';)
	{
	if (n >= numbuff+MAXDIGITS-1)
		{
		*ptr = p;
		err("too many digits");
		}
	*n++ = *p++;
	if (--len <= 0)
		break;
	}
*n = 0;
f = atof(numbuff);
*ptr = p;
return(f);
}

strconst(c)
{
/*
 * pick up a quoted string constant.
 * "c" is the delimeter being used.
 */
struct stringexpr s;

s.k_sptr = inptr;
while (*inptr && *inptr != c)
	++inptr;
s.k_slen = inptr-s.k_sptr;	/* string length */
s.k_len = sizeof s;
s.k_type = STREXPR;
push(&s);
if (*inptr == c)
	++inptr;
}

badtype()
{
err("bad type");
}

pushvar()
{
register VALPTR s;
int type;

s = (VALPTR) getsvar(&type);

switch(type)
	{
case STRING:
	pushstring(ptrValue(s),lenValue(s));
	break;
case INT:
	pushint(intValue(s));
	break;
case FLOAT:
	if (SINGLE)
		pushfloat(floatValue(s));
	else
		pushfloat(doubleValue(s));
	break;
default:
	err("value expected");
	}
}

getsc(v) register struct subhdr *v;
{
/*
 * calculate the effective subscript from the previously
 * collected subscript value.
 */
register int i,j, n;

if (nsubs != v->v_nsubs)
	err("wrong number of subscripts");
for (j=0, n = 0; j<nsubs; )
	{
	i = subsc[j];
	n = n * (v->v_subsc[j]+1) + i;
	if (i > v->v_subsc[j++])
		err("subscript %d too big",j);
	if (i < 0)
		err("subscript %d less than zero",j);
	}
return(n);
}

let()
{
register STKPTR s;
register VALPTR v;
int type;
int stype;

v = (VALPTR) getsvar(&type);		/* v points to value in variable */
expectc(EQ);
expr();
s = (STKPTR) stkptr;		/* get the expression */
stype = s->k_type&TYPEMASK;
if (stype != type && (stype == STRING || type == STRING))
	mixed();
switch(type)
	{
case FLOAT:
	if (SINGLE)
		floatValue(v) = popfloat();
	else
		doubleValue(v) = popfloat();
	break;
case INT:
	intValue(v) = popint();
	break;
case STRING:
	storestring((struct string *) v);
	break;
default:
	err("invalid variable");
	}
}

#ifdef NEEDCVT		/* never gets called, so don't compile it */
cvt(type)
{
/*
 * convert top of stack to type "type"
 */
register STKPTR s;
register int i;
register int stype;

s = (STKPTR) stkptr;
type &= TYPEMASK;
stype = s->k_type & TYPEMASK;
if (stype == type)
	return;
switch(type)
	{
case FLOAT:
	if (stype == INT)
		{
		pushfloat(popint()+0.0);
		return;
		}
	break;
case INT:
	if (stype == FLOAT)
		{
		i = popfloat();
		pushint(i);
		return;
		}
	}
err("invalid type conversion");
}
#endif

concat()
{
/*
 * concatenate the strings found on the top of the stack.
 * note that the strings are not popped off the stack until
 * after being copied into their new home. this is in case
 * there is a garbage collection during the string allocation
 * which must not scratch either string until it has been copied
 * into the proper place.
 */
register struct stringexpr *s;
register struct stringexpr *p;
register char *q;
int slen, plen;

s = (struct stringexpr *) stkptr;
slen = s->k_slen;
p = (struct stringexpr *) NEXTSTK(s);
plen = p->k_slen;
if (p->k_type != STRINGEXPR)
	mixed();
if (slen + plen > MAXSTRING)
	err("string too long");
q = allocstring((char *) NULL,slen+plen,0);
move(plen,p->k_sptr,q);
move(slen,s->k_sptr,q+plen);
pop(STRINGEXPR);		/* get rid of one of them */
p->k_sptr = q;			/* replace the other */
p->k_slen += slen;
}

VALPTR getsvar(type) int *type;
{
/*
 * return a pointer to a value for a variable.
 * return its type in "type".
 */
register VALPTR p;
register SYMPTR v;
register int i;

v = getvar(type,NO);
if (nsubs == 0)
	{
	/* NOSTRICT */
	p = (VALPTR) &((struct intsym *)v)->v_int;		/* not subscripted variable */
	return(p);
	}
i = getsc(v);				/* get and check subscript */
switch(*type)
	{
case FLOAT:
	if (SINGLE)
		/* NOSTRICT */
		p = (VALPTR) &((struct fltvec *)v)->v_fltvec[i];
	else
		/* NOSTRICT */
		p = (VALPTR) &((struct dblvec *)v)->v_dblvec[i];
	break;
case INT:
	/* NOSTRICT */
	p = (VALPTR) &((struct intvec *)v)->v_intvec[i];
	break;
case STRING:
	/* NOSTRICT */
	p = (VALPTR) &((struct strvec *) v)->v_strvec[i];
	break;
default:
	badtype();
	}
/* NOSTRICT */
return(p);
}

mixed()
{
err("mixed modes");
}
