#
#include <stdio.h>
/*			Copyright 1980 by Bill Webb.	 		*/
#include "basic.h"
#include "stack.h"
#include "tokens.h"

/*  EVAX   jnl821123  allow tracing if -o specified for old             */
/*  EVAX   jnl921123  allow old program name if none specified          */

FILE *xopen();

#ifndef UNIX
#define	ttyn(x) '8'
#define	sbrk	sbreak
#endif

#define	SEEK_EOF	2
char *prompt IS "^";		/* the prompt charcter */
int symsize IS MAXSYMSPACE;	/* size of symbol table */
int col IS 1;			/* current output column */
int attn();
int fpterr();
FILE *infile;

initsys()
{
char *sbrk();

infile = stdin;
istty = ISTTY(0);
#ifdef UNIX
if (!xflg)
	setout();
signal(SIG_FPT,&fpterr);
signal(SIG_ATTN,&attn);
getusername();
#ifdef FPU
ldfps(05600);				/* double overflow intcvt */
#endif	/* FPU */
#endif	/* UNIX */
lines = sbrk(MAXLINES+MAXSYMSPACE);	/* base of line buffers */
endlines = lines+MAXSYMSPACE;
symspace = endlines;			/* start of symbol table */
symend = sbrk(0);
if ((int) lines == -1)
	error("unable to allocate initial space");
initio();
}

attn()
{
#ifdef UNIX
signal(SIG_ATTN,&attn);
#endif
if (attnflg++)
	err(ATTNMSG);
}

readline(linep,infile) char *linep; FILE *infile;
{
/*
 * get a line from the specified input file "infile".
 * the line is terminated with a NL character.
 * if infile == stdin then update the column pointer for it
 * as well.
 */
register int c;
register char *p;

for (p=linep; (c = getc(infile)) >= 0 ; )
	{
#ifdef EVAX
	if (oldtrflg)
		putchar(c);
#endif
	if (c == '\r' || c == 0)
		;
	else if (c == '\n')
		{
		*p = 0;
		if (infile == stdin)
			col = 1;
		return(p-linep);
		}
	else
		{
		if (infile == stdin)
			++col;
		if (p >= linep+MAXLINELEN)
			err("line length >= %d characters",MAXLINELEN);
		*p++ = c;
		}
	}
TESTATTN();
return(-1);
}

syserr()
{
/*
 * perform system dependent operations upon an error
 */

fseek(infile,0l,SEEK_EOF);	/* in case input is a file */
if (infile != stdin)
	{			/* reset input to stdin */
	xclose(infile);
	infile = stdin;
	}
flush();
#ifdef UNIX
if (aflg)
	abort();
#endif
}

/* VARARGS 1 */
error(fmt,d1,d2,d3)
char *fmt;
{
/*
 * something fatal happened ... print message and exit.
 */
extern errno;
printf(fmt,d1,d2,d3);
if (errno)
	perror("");
printf("\n");
exit(-1);
}

/* VARARGS1 */
err(fmt,d1,d2,d3)
char *fmt;
{

printf(fmt,d1,d2,d3);
if (curline != NULL && curline != &immed)
	printf(" at line %d",curline->l_lnr);
printf("\n");
attnflg = 0;
syserr();			/* handle system dependent stuff */
leave(fmt);
exit(1);
}

fpterr()
{
signal(SIG_FPT,&fpterr);
#ifdef FPU
switch(fec())
	{
case 04:
	err("division by zero");
	break;
case 06:
	err("integer range error");
	break;
case 8:
	err("floating point number too large");
	break;
	}
#endif
err("floating point error");
}

char *fprint(f) double f;
{
double e;
double fabs();
static char fpbuff[30];
#define	MINF	0.00000001
#define	MAXF	10000000.0
#define	NDIGITS	7

e = fabs(f);
if (e > MAXF || (e != 0.0 && e < MINF))
	ftoa(f,fpbuff,NDIGITS,'e');
else
	{
	ftoa(f,fpbuff,NDIGITS,'f');
	}
return(fpbuff);
}

#ifdef UNIX
ftoa(f,ptr,ndig,format) double f; char *ptr;
{
register char *s;

if (format == 'e')
	pscien(f,ptr,ndig,ndig);
else
	{
	pfloat(f,ptr,ndig,ndig);
	s = endstr(ptr);
	while (*--s == '0')
		;
	if (*s == '.')
		--s;
	s[1] = 0;
	}
}
#endif

morelines()
{
register char *p;

p = endlines+EXPANDLINES;
if ((int) sbrk(EXPANDLINES) == -1)
	return(NO);
endlines = p;
symspace = endlines;
symend = symspace + symsize;
clrsym();			/* must clear symbol table */
return(YES);
}

moresym(p) char *p;
{
register int n;

n = p-symend;
n = (n+EXPANDSYM-1) & ~(EXPANDSYM-1);	/* make it an even request */
if (p < symend || (int) sbrk(n) == -1)
	return(NO);
symend += n;
symsize = symend-symspace;
return(YES);
}

old(file,flag) char *file;
{
/*
 * open "file" for input and then read the source lines from it.
 * if flag=YES then clear existing program, otherwise just clear
 * the symbol table and stack.
 */
register FILE *i;
register FILE *oldfile;
extern char tempfile[];

if (*file == 0)
	err(OLDMSG);
if ((i = xopen(file,"r")) == NULL)
	err("can't open %s",file);
if (flag == YES)
	{
	if (file != tempfile && file != curfile)
		copy(curfile,file);		/* save current file name */
	init();
	}
else
	{ clrsym(); clrstk(); }		/* clear non-program area */
oldfile = infile;
infile = i;
while (readline(line,infile) >= 0)	/* EVAX change */
	compile();
xclose(infile);
infile = oldfile;
}

save(file) char *file;
{
/*
 * open "file" for output and then list the program onto it.
 */
register FILE *f;

flush();
if (file[0] == 0 || (f = xopen(file,"w")) == NULL)
	err("can't create file %s",file);
if (file != tempfile && file != curfile)
	copy(curfile,file);		/* save current file name */
inptr = endstr(inptr);
list(MINLNR,MAXLNR,f);
xclose(f);
}

#ifdef VAX
fmod(f,r) double f, r;
{
err("no fmod fn");
}

pfloat(f,ptr,ndig,xdig) double f; char *ptr;
{
sprintf(ptr,"%.*f",ndig,f);
}

pscien(f,ptr,ndig,xdig) double f; char *ptr;
{
sprintf(ptr,"%.*e",ndig,f);
}

#endif

#ifdef UNIXV6
char *getlogin()	/* fake getlogin() for UBC system */
{
#include <pwd.h>
struct passwd *getpwuid();

return(getpwuid(getuid())->pw_name);
}
#endif

getusername()
{
/*
 * set up "username" from wherever system keeps it.
 * this is done once at the begining so that the I/O buffers
 * don't get screwed by our space allocation.
 */
#ifdef PRINTHEADERS
char *getlogin();
strcpy(username, getlogin());
#endif
}
