keypunch is lc
width 70
title
)m UNIX for MTS users )ml2e
set p = ' )w5p '
indents (3,0) (6,0) (9,0) 
set u = 'UNIX' 
set m 'MTS' 
set bdc = 'Biology Data Centre'
define head  1
 )w5l2r !par.1 !count(pt,1,1,integer) )ip 
set ex = ')w3l2ri2o1 !par.1 )i1 '
paragraph indent 0 
set pt = ' )w5l2ri1 !count(pt) )i2o1 '
set i = ' )w5l2ri1o1 !par.1 )i2 '
call count(pt,1,1,integer)
set longex = ' )w5l2i2a '
no listing
go
!count(pt,1,1,integer)
!head('Intoduction')
UNIX is a sophisticated time sharing system running on the PDP 11/45
computer in the Biology Data Center. this document attempts to introduce
the MTS user to UNIX.
!head('Compiling Fortran programs under UNIX')
assuming that the Fortran source is stored in a file on the disk, the FTN 
command may be used to compile it.
!p in order that a file be compiled its name must end in either ".f" or ".ftn".
if the file name does not end in the proper suffix it must be renamed.
for example, if the file name is "prog", then the following command will 
rename it to "prog.f": !ex('mv prog prog.f')
!p to compile a program in "prog.f":
!ex('ftn prog.f')
!p if a listing is required one can use: !ex('ftn --l1 prog.f')
!p where the "--" indicates a compiler parameter, and the "l1" is used to
request a level 1 listing (source only). 
more information on compiler options may be obtained by the "help ftn" command.
!head('Running Fortran programs')
to run the load module resulting from the FTN command (in the file a.out 
(like "-load")), with the input file "data", and the output file "output",
one could use: !ex('a.out 5=data 6=output')
!p it is assumed that no carriage control is required on the output. if it
is to be processed with carriage control then a "+" is put before the file
name and then the first character of the line is converted to standard 
ASCII carriage control characters. for example: !ex('a.out 5=data 6=+output')
!head('Logging in to UNIX')
if you have a UNIX account you may log onto the system when the terminal
has the following message: !ex('Login:')
!p at that point you should type your account name and enter the line. 
don't worry if the system doesn't echo characters as you start typing, this
can happen if the system is very busy, it will remember them and echo them
when it gets around to you. 
!p if you have a password set then the system will prompt for your password
and turn off the echo so that no-one can read it. the system will then log
you in and prompt for commands with a %. the entire login might look like 
(with computer output in upper case and user in lower): 
!longex
LOGIN:                       -- asks for your account name
myname                       .. you enter your account
PASSWORD:                    -- asks for your password
pw                           .. you enter it (but computer 
                                  doesn't echo) 
%                            -- asks for a command
files                        .. you list names of your files
PROG.F                       -- the names are listed
PROG.OBJ
A.OUT
DATA3
%                            -- command prompt
bye                          .. you log off the system
 
LOGIN:                       -- asks for next login
) 
!p if you make a mistake in loging in UNIX will respond with "LOGIN INCORRECT"
and prompt with "NAME:" to get the proper user name. 
!head('UNIX file structure')
!u files are quite different from MTS files:
!pt rather than accepting a concatenation of files ("a+b+c..."), most !u
commands will take a list of files, separated by blanks. if the command
only accepts one file, then the "cat" command may be used to concatenate
files together. 
!pt outputing to a !u file causes it to be created if not already existing, 
and emptied if it did exist.
!pt !u files behave like sequential files, i.e.~there are no line numbers, 
and the editor must be used to pick up parts of a file. 
!pt rather than the peudo devices *SOURCE* and *SINK* there are two !u 
logical units STANDARD INPUT and STANDARD OUTPUT that most commands default
input and output to. 
!pt rather than the peudo devices *MSOURCE* and *MSINK* the terminal may
be refered to by the generic name "/dev/tty". 
!pt the line printer itself is "/dev/lp", but is probably best used by
the line printer spooler program "lpr". it is usually invoked by a pipe
from standard output. for example, to direct the output of the command
a.out to the line printer:
!ex(' a.out 6=+ | lpr ')
!head('UNIX commands')
there is no major distinction between commands and programs in UNIX. when
a command line is given to the !u command processor (the "shell"), it is 
parsed into separate arguments and the requested command (or program) is 
first searched for in the user's directory, then in the various system 
command directories. when found it is invoked with the given parameters. 
!p note that commands that take a list of file names (almost all do)
will accept a "pattern match" operand as well. in the pattern the 
following special characters are recognized: 
!i(*) matches any string of characters (including none).
!i('!50') matches any one character.
!p this, together with convenient file naming conventions gives a very 
powerful facility. some examples are:
!longex
rm *                         -- destroyes all files
list *.f                     -- lists all fortran sources
files *.obj                  -- list names of all objects
ftn --l1 *.f                 -- compile all ftn sources
pr data* | lpr               -- print files beginning "data"
grep "subroutine" *.f        -- find all subroutines 
tp u0v plot?.f               -- store files with name plotx.f
                             -- where x is one letter.
)
!head('Normal operating procedure')
normally, since there are very severe limits on the amount of disk space
available, a user should restore the files needed for a session at the
beginning and save them back on tape, delete them and log off. 
!p to save files on tape (tapes are obtained from Shirley) one uses the 
following command: !ex('tp u0v *')
!p whenever writing on a tape the WRITE switch MUST be in the WRITE ENABLE
position or numerous errors will occur. 
 !p the first time that one saves the
files (or if the old files on the tape are not needed) one uses:
!ex('tp u0cv *') 
!p to restore files after loggin onto the system one uses: 
!ex('tp x0v')
!head('redirecting input/output')
normally standard input and standard output are the user's terminal, but
these may be changed for one command by means of the input/output 
redirection operators "<" and ">". "<" causes the program to take its 
input from the file to the right of the "<" operator. for example: 
!ex('list < prog.f')
!p will list the file "prog.f". the output may be re-directed via ">"
to a file: !ex('list < prog.f > /dev/lp') !p in this case the output
is sent directly to the line printer. the ">>" operator may be used to 
direct output to the end of a file (similar to "file(last+1)" or a sequential
file in MTS. 
!head('pipes and filters')
!p !u has the unique feature of allowing the output from one program to be
passed directly to the input of another. this is done thru a "pipe". 
a program that takes its input from standard input and places its output 
on standard output is called a "filter". 
!p a pipe may be created between two commands by means of the "|" operator
(also represented by the carret or up-arrow). for example: 
!ex('pr prog.f | lpr ') !p will print a listing of "prog.f" onto the line
printer via the line printer spooler, which is a filter. 
!head('using UNIX terminals')
!u uses different terminal control characters than MTS, however, in most cases
this should not be a problem as equivalent functions exist. 
!pt to delete a line use control-u or NAK.
!pt to delete a character use control-h (backspace) on a CRT and rubout
on a teletype. 
!pt to enter a line use "return" (or CR on some terminals).
!pt to enter an end-of-file use control-d.
!pt to interrupt a program use control-c (or break).
!pt to reprint the current input line use control-r.
!pt on an upper case only terminal use the backslash to shift the 
following character to upper case (normally all input is in lower case).
!pt to get "{", "}", "!34", and "|" use a backslash and "(", ")", "^",
 "!" respectively. 
to get a backslash, use two backslashes.
!head('sample commands')
some of the common MTS command sequences are given below with their UNIX 
equivalents: 
!longex
 MTS command                           UNIX command
 
$SIGNON id                             LOGIN:id
$RUN *FTN PAR=S=prog.f                 ftn prog.f 
$CREATE output                         ...
$EMPTY output                          ...
$RUN -LOAD 5=data 6=output             a.out 5=data 6=output
$LIST OUTPUT                           list output
$LIST OUTPUT ON *PRINT*                lpr output
$DESTROY output ok                     rm output
$CREATE ndata                          ... 
$EMPTY ndata ok                        ...
$NUMBER                                cat > ndata
line 1                                 line1
line 2                                 line 2
line 3                                 line 3
$UNNUMBER                              (control-d character)
$RELEASE
$RUN -LOAD 5=ndata 6=*PRINT*           a.out 5=ndata 6=+ | lpr
$SIGNOFF                               bye
) 
!p more information about !u commands my be obtained from the UNIX reference
manual available (for reference) from the !bdc!.
!head('file Editor')
!u has a convenient file editor. it is invoked by the "ed file" command.
the editor command syntax is generally: !ex('line1,line2 cmd s1 s2')
!p "line1" and "line2" are line numbers that indicate a range 
of lines that the command operates upon. each "line number" may be one
of the following:
!pt an integer giving the line number from the start of the file (1 is the 
first line, 2 the second etc.)
!pt "." which is the current line (the current line is the last line operated
upon)
!pt "$" which is the last line of the file.
!pt "/string/" which is the next line containing "string". the search will
rap around to the beginning of the file if necessary.
!pt "?string?" which is the previous line containing "string". the search will
rap around to the end of the file if necessary.
!pt "//" the same as  "/string/" with the last string mentioned.
!pt "??" the same as  "?string?" with the last string mentioned.
!pt "line1+line2" is the value of "line1" + the value of "line2".
!pt "line1-line2" is the value of "line1" - the value of "line2".
!p "cmd" is a single letter that gives the command to be executed:
!i(l1a) append after l1. 
!i('l1,l2c') change (same as MTS replace = delete l1,...,l2 then append)
!i('l1,l2c') delete 
!i('e file') edit a new file
!i('f file') change name of file
!i('l1i') insert before l1
!i('l1k') mark given line 
!i('l1,l2l') list l1,...,l2 (displays unprintable characters in octal)
!i('l1,l2ml3') move l1,...,l2 to l3.
!i('l1,l2p') print l1,...,l2
note that a "p" may be appended onto most commands to cause the results to be
automatically printed.
!i(q) quit, leave the editor. the editor will come back with "write?" unless
the file is unchanged or a "w" command has been given. another "q" will cause
the editor to exit without writing the file. 
!i('l1r file') read the given file into the current file at line "l1".
!i('l1,l2s/s1/s2/g') substitute string "s2" for string "s1" in the given lines.
the "g" is optional and causes the substitution to be done for all occurrances
of "s1" (globally).
!i('l1,l2tl3') copies lines l1,...,l2 to l3.
!i('l1,l2w file') writes lines l1,...,l2 to file. just "w" writes the current
file back onto the disc. 
!head('comparitable MTS and UNIX editor commands')
the following commands are more or less equivalent:
!longex
$edit file                        edit file
print /file                       1,$p
scan /file 'subroutine'           /subroutine/ 
change 'subroutine'function'      s/subroutine/function/p
delete 1 10 ok                    1,10d
change!43a /file 'intger' !43nv       1,$s/intger/integer/g
scan /file '10    format'         /10   format/i
insert '       stop'                     stop
                                  .
line *f                           1 
line *l                           $
stop                              w
                                  q
) 
