#
/*			Copyright 1976 by Bill Webb.	 		*/

#include "user.h"
#include "file.h"

#define	maxbuff	128
#define rubout	0177
#define nul	00
#define	vt	013
#define ff	014
#define cr	015
#define	nl	012
#define lf	012

#ifdef	debug
char *modes[]
{
"/fa","/fb","/ua","/ub" };
#endif


/*
 * dosread ... read file in normal dos fashion (i.e. make it 
 * complex and useless!).
 */

dosread()
{
register int code;

code = rwinit(f_openi);


#ifdef	debug
if(tflg)
	printf(" %s (0%o,#0%o) %d",
		modes[code],info.d_buffp,bh->b_maxcnt,info.d_fildes);
#endif
switch(code)
{
case m_fa:
	faread();
	break;

case m_fb:
	fbread();
	break;

case m_ua:
	uaread();
	break;

case m_ub:
	ubread();
	break;

default:
	err("bad read mode");
}
}

rwinit(how)
int how;
{
register struct buffhdr* b;
register int mode;

/* allow for automatic open on non-file structured devices */ 
if(ddb->d_state==closed)
	{
	clear(&info,sizeof info);
	copylink();
	info.d_howopen = how;
	cvtfile(1);	/* get unix path name */ 
	doopen();
	}

bh = b = *u.sp++;
mode = b->b_mode;
b->b_status = 0;

if (mode & m_dump)
	info.d_buffp = b->b_buffp;
else
	info.d_buffp = &(b->b_buffp);

info.d_ptr = info.d_buffp;

if(how==f_openi)
	b->b_cnt = 0;
info.d_cnt = b->b_cnt;
return(mode&03);
}


/*
 * normal dos write ... see dosread comments.
 */

doswrite()
{
register int code;

code = rwinit(f_openo);

#ifdef	debug
if(tflg)
	printf("%s (0%o,#0%o,#0%o)",
		modes[code],info.d_buffp,bh->b_cnt,bh->b_maxcnt);
#endif
switch(code)
{
case m_fa:
	fawrite();
	break;

case m_fb:
	fbwrite();
	break;

case m_ua:
	uawrite();
	break;

case m_ub:
	ubwrite();
	break;
default:
	err("bad write mode");
}
}

/*
 * formatted binary write ... write the header, data, and 
 * checksum. 
 */

fbwrite()
{
putwd(1);		/* fmt binary mode */
putwd(bh->b_cnt+4);	/* actual record length */
write(info.d_fildes,info.d_buffp,bh->b_cnt);
putch(-chksum());
}



/*
 * calculate checksum for formatted binary reads and writes. 
 * complication is that the record written has its length
 * 4 bytes longer than user thought. 
 */


chksum()
{
register int sum;
register char *p;
register int w;
int temp;	/* for buffer length checksum */

sum = 1;
w = bh->b_cnt ;
temp = w + 4;
sum =+ temp.lo;
sum =+ temp.hi;
p = info.d_buffp;

do
	sum =+ *p++;
while	(--w);
return(sum&0377);
}


/*
 * formatted ascii write ... translate to lower case and remove 
 * cr's (assuming they will be followed by lf's). 
 */

fawrite()
{
register int c;
char buff[maxbuff];
register int l;
register char* p;

l = 0;
p = buff;

while ((c=cpass())>=0)
switch(c)
{
case vt:
	if(bh->b_mode & m_spec)
		goto done;
case rubout:
case nul:
	break;

case lf:
	if(bh->b_mode & m_spec)
		{
		*p++ = c;
		++l;
		goto done;
		}
	goto normal;

case cr:
	if(!cflg)
		break;

default:
normal:
	if(!uflg && c>='A' && c<='Z')
		c =- ('A'-'a');
	*p++ = c;
	if(++l >= maxbuff)
		{
		if(write(info.d_fildes,buff,l)<0)
			uerr("fawrite");
		p = buff;
		l = 0;
		}
}	/* of switch */

done:
if(l>0)
	{
	if(write(info.d_fildes,buff,l)<0)
		uerr("fawrite");
	}
}



/* 
 * unformatted ascii - just write to the file. 
 */

uawrite()
{
writebf(bh->b_cnt);
}



/* 
 * unformatted binary - just write to the file. 
 */ 

ubwrite()
{
writebf(bh->b_cnt);
}

writebf(length)
int length;
{
if(write(info.d_fildes,info.d_buffp,length)<0)
	uerr("writebf");
}

putch(c)
char c;
{
if(write(info.d_fildes,&c,1)!=1)
	uerr("putch");
}


/* 
 * formatted binary input. main thing is to check all the format
 * restrictions and insure that the checksum is right. 
 */ 

fbread()
{
register struct buffhdr *b;
register int w;
register int c;
int i;

info.d_ptr = info.d_buffp;
b = bh;

/* ignore leading 0 bytes if any */
while ((c=getc())==0);

if(c<0)
	return;

if(c!=1 || getc()!=0)
	err("bad fb fmt");

i.lo = getc();
i.hi = getc();
w = i - 4;	/* adjust length for header */

b->b_cnt = w;
if(w > b->b_maxcnt)
	err("too long %d > %d",w,b->b_maxcnt);

i = w;
do
	{
	if((c=getc())<0)
		err("too short (%d)",w);
	*info.d_ptr++ = c;
	}
while (--i);

c = getc();
if( (chksum()+c) & 0377)
	err("chksum: %o vrs %o",c,chksum());
}

readbf(length)
{
register int l;

if ((l=read(info.d_fildes,info.d_buffp,length))<0)
	uerr("readbf");
return(l);
}




/*
 * formatted ascii input ... translate lower to upper case and
 * put in cr's before lf's. 
 */

char lastchar;			/* last character read from fildes 0 */
faread()
{
register int c;
register int echo;


info.d_ptr = info.d_buffp;

#ifndef	batch
c = getc();
#endif

echo = 0;
#ifdef	batch
if(xflg && ddb->d_maxlen==1)
	{
	if(lastchar)
		{
		c = lastchar;
		lastchar = 0;
		}
	else
		c = getc();
	switch(c)
		{
	case '\'':		/* pass on next character */
		goto getnext;

	case '*':
		if(ddb->d_dsn==r_cmi || ddb->d_dsn==r_pci)
			{
		next:
			++echo;
		getnext:
			c = getc();
			break;
			}
		goto eof;

	case '#':
		if(ddb->d_dsn==r_cmi)
			goto next;
	eof:
		bh->b_status =| e_eof;
		lastchar = c;
		return;

	case	'$':
		bh->b_status =| e_eof;
		putchar(nl);
		++echo;
		}
	}
else
	c = getc();
#endif

for (;;)
{

if(echo)
	putchar(c);

switch(c)
	{
	case rubout:
	case nul:
	case cr:
		break;
	
	case '\n':
	case ff:
		passc('\r');
		passc(c);
		return;
	
	case -1:
		return;
	default:
		if(!lflg && c>='a' && c<='z')
			c=- ('a'-'A');
		passc(c);
	}	/* of switch */
c = getc();
}	/* of for */ 
}

passc(c)
/* put c into dos buffer and check for error */ 
char c;
{
register struct buffhdr *b;

b = bh;
*info.d_ptr = c;
if(b->b_cnt >= b->b_maxcnt)
	b->b_status =| e_line;
else
	{
	b->b_cnt++;
	info.d_ptr++;
	}
}

cpass()
/* get from dos buffer */ 
{

return((info.d_cnt-- >0) ? 
	*info.d_ptr++ & 0377 : -1);
}

uaread()
{
register int l;
#ifdef	batch
if(xflg && ddb->d_maxlen==1)
	faread();
else
#endif
	{
	if((l=readbf(bh->b_maxcnt))<0)
		uerr("uaread");
	if(l==0)
		bh->b_status=| e_eof;
	bh->b_cnt = l;
	}
}

ubread()
{
uaread();
}


/*
 * routine to output a single word to the current output 
 * file. 
 */

putwd(w)
int w;
{

if(write(info.d_fildes,&w,2)<0)
	uerr("putwd");
}

getc()
{
register struct ddb *d;

d = ddb;
if(--d->d_maxcnt < 0)
	{
	d->d_bp = d->d_path;
	if((d->d_maxcnt=read(info.d_fildes,d->d_bp,d->d_maxlen))<0)
		uerr("getc");
	if(--d->d_maxcnt < 0)
		{
		bh->b_status =| e_eof;
		return(-1);
		}
	}
return( *d->d_bp++ & 0377);
}
