#
/*			Copyright 1976 by Bill Webb.	 		*/
#include "user.h"
#include "svt.h"

#define r_dk 015270
#define g_stfpu 03
#define g_core 0100
#define	g_gtclk	0113
#define g_date 0103
#define g_gtprv 0110	/* test if privilegedd user */
#define g_gtcil	0111
#define	g_gtuic	0105
#define	g_gtpla	05
#define	g_gtstk	04
#define	g_gtrdv	0112
#define	g_gtovf	0114
#define	g_gtsws	0115
#define	g_monf	0102
#define	g_monr	0101
#define	g_rstrt	02
#define	g_stpla	05
#define	g_stpfu	03
#define	g_ststk	04
#define	g_sysdv	0106
#define	g_time	0104
#define	g_trap	01

#define v_bit 02
#define c_bit 01
#define z_bit 04
#define n_bit 010
#define t_bit 020

#ifdef	debug
char *gut_names[]
{"trap","rstrt","stfpu","ststk","stpla"};

char *gut2_names[]
{"core","monr","monf","date","time","gtuic","sysdv","???",
"gtprv","gtcil","gtrdv","gtclk","gtovf","gtsws" };

#endif

dosgut()
{
int restart();
register int code;
register int *sp;
register int t;

sp = u.sp;	/* copy of stack pointer into register */ 
code = *sp++;
#ifdef	debug
if(tflg)
	{
	if(code>=0100)
		printf(" .%.10s",gut2_names[code-0100]);
	else
		printf(" .%.10s (#%o)",gut_names[code-1],*sp);
	}
#endif
t = *sp;

if(code<0100)
switch(code)
{
case g_trap:	/* 01 set trap vector */ 

	trap.trap_ps = *sp++;
	trap.trap_pc = *sp++;
	settrap();
	break;

case g_stfpu:	/* 03 set fpu trap vector */ 
	fpu.trap_ps = *sp++;
	fpu.trap_pc = *sp++;
	setfpu();
	break;

case g_stpla:	/* 05 set program load address */
	*sp = svt.s_pla;
	if(t)
		svt.s_pla = t;
	break;

case g_ststk:	/* 04 set stack base */
	*sp = svt.s_stk;
	svt.s_stk = t;
	break;

case g_rstrt:	/* 02 set restart address */
	svt.s_rsa = *sp++;
	if(!xflg)
		setint();
	break;

/*
case g_gtpla:
	*sp = svt.s_pla;
	break;
*/

default:
	goto	gutdef;
}

else

switch(code)
{
case g_sysdv:
	*--sp = r_dk;
	break;

case g_time:
	dostime();
	*--sp = svt.s_tod[0];
	*--sp = svt.s_tod[1];
	break;

case g_core:
	*--sp = svt.s_csa;
	break;

case g_date:
	dosdt();
	*--sp = svt.s_date;
	break;

case g_gtprv:	/* 110 = privileged user test */

	*--sp = 1;	/* might as well make him priv */
	break;

case g_gtcil:
	*--sp = svt.s_cil;
	break;

case g_gtclk:
	*--sp = svt.s_scw;
	break;

case g_monf:
	*--sp = svt.s_tob;
	break;

case g_monr:
	*--sp = svt.s_eom;
	break;

case g_gtuic:
	*--sp = svt.s_uic;
	break;

case g_gtrdv:
	*--sp = svt.s_rdv;
	sp[1] = svt.s_rut;
	sp[2] = svt.s_rbl;
	break;
 
case g_gtovf:
	*--sp = &svt.s_ovl;
	svt.s_ovl = 1;
	break;

case	g_gtsws:
	*--sp = getcsw();
	break;

default:
gutdef:
	err("code %o",code);

}

#ifdef	debug
if(tflg && code >= 0100)
	printf(" ==> 0%o",*sp);
#endif

u.sp = sp;
}

int radcase;

#ifdef	debug
char *cvt_names[]
{
"radpk",
"radup",
"d2bin",
"bin2d",
"o2bin",
"bin2o"
};
#endif



doscvt()
{
/* dos conversion utility */ 
extern int ldivr;
register char *addr;
register int value;
register int length;
int code;
int c;
int base;

code = *u.sp++;
addr = *u.sp++;

if(code&1)
	value = *u.sp++;

#ifdef	debug
if(tflg)
	printf(code&1 ? " .%s (0%o,#0%o) ==>" : " .%s (0%o)",
		cvt_names[code],addr,value);
#endif

switch(code)
{

case 3:	/* bin 2 d */ 
	base = 10;	/* output base */ 
	length = 5;
	goto cvt;

case 5:	/* bin 2 o */ 
	base = 8;
	length = 6;
	goto cvt;

cvt:
	addr =+ length;
	do
		{
		value = ldiv(0,value,base);
		*--addr = ldivr+'0';
		}
	while (--length);

#ifdef	debug
	if(tflg)
		printf(" %6.6s",addr);
#endif

	break;

case 2:	/* d 2 bin */ 
	base = 10;
	length = 5;
	goto incvt;

case 4: /* o 2 bin */ 
	base = 8;
	length = 6;
	goto incvt;

incvt:
#ifdef	debug
	if(tflg)
		printf(" %6.6s ==> ",addr);
#endif

	value = 0;
	do
		{
		c = *addr - '0';
		if(c<0 || c>base)
			{
			u.ps =| c_bit;
			break;
			}
		else
			{
			value = value*base + c;
			++addr;
			}
		}
	while (--length);

put:
	*--u.sp = addr;
	*--u.sp = value;

#ifdef	debug
	if(tflg)
		printf(" 0%o",value);
#endif

	break;

case 0:	/* rad50 pack 3 ascii ==> 1 word */

	radaddr = addr+3;
	value = radpk(addr);
#ifdef	debug
	if(tflg)
		printf(" %3.3s",addr);
#endif

	addr = radaddr;
	goto put;

case 1:	/* rad50 unpack 1 word ==> 3 ascii */

	radcase = 'A' - 'a';
	rad50(value,addr);
	radcase = 0;
#ifdef	debug
	if(tflg)
		printf(" %3.3s",addr);
#endif
	break;
default:
	err("code %o",code);
}
}

char days[]
{ 31,28,31,30,31,30,31,31,30,31,30,31 };

char *months
	"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC";

extern ldivr;

doscvtdt()
{
register char* addr;
register int code;
register int value;
int day,year, hrs, secs, mins;
int tm[2];

code = *u.sp++;
addr = *u.sp++;

switch(code)
{

case 0:		/* current date */
	dosdt();
	value = svt.s_date;
cvtdt:
	year = value/1000 + 70;
	day = value % 1000 + 1;
	days[1] = (year %4) == 0 ? 29 : 28;
	for (value=0; value<12; ++value)
		{
		if(day <= days[value])
			break;
		day =- days[value];
		}
	stringf(addr,"%2d-%.3s-%2d",day,months+value*3,year);
#ifdef	debug
	if(tflg)
		printf(" ==>%.9s",addr);
#endif
	break;

case 1:		/* current time */
	dostime();
	tm[0] = svt.s_tod[0];
	tm[1] = svt.s_tod[1];
cvttm:
	mins = ldiv(tm[0],tm[1]<<1,60*60*2);
	secs = ldivr/(60<<1);
	hrs = mins/60;
	mins =% 60;
	stringf(addr,"%2d:%2d:%2d",hrs,mins,secs);
#ifdef	debug
	if(tflg)
		printf(" ==>%.8s",addr);
#endif
	break;

case 2:		/* given date */ 
	value = *u.sp++;
	goto cvtdt;

case 3:		/* given time */ 
	tm[0] = *u.sp++;
	tm[1] = *u.sp++;
	goto cvttm;

}

}

dosdt()
{
int tvec[2];
int *tm;

time(tvec);

tm = localtime(tvec);

svt.s_date = tm[7] + (tm[5]-70) * 1000;

}

dostime()
{
int tvec[2];
int *tm;

time(tvec);

tm = localtime(tvec);

dostm(tm,svt.s_tod);
}

#ifdef	small
localtime()
{ static tm[8]; return(tm); }
#endif
