#
/*			Copyright 1976 by Bill Webb.	 		*/

#include "user.h"
#include "svt.h"
#include "mrt.h"

#define em_init 6
#define	emttrap	0
#define	iottrap	1
#define	fputrap 2
#define traptrap 3
#define	bustrap	4
#define	instrap	5
#define	segtrap	6


/* start up user routine and handle emts generated by
 * that program. 
 */

run()
{
register int *i;
register struct mrt *m;
register int e;
extern end;

for (i= &u.regs[0]; i< &u.regs[5];) 
	*i++ = 0;

u.pc = svt.s_psa;
setexit();
u.sp = svt.s_stk;
u.ps = 0;
setsigs();	/* initialize the signals */

for (;;)
{

	emt = 0;
	switch(transfer())
{
case	fputrap:
	*--u.sp = u.ps;
	*--u.sp = u.pc;
	u.ps = fpu.trap_ps;
	u.pc = fpu.trap_pc;
	break;

case	traptrap:
	if(u.pc < &end)
		err("bad system call at %o",u.pc);
	*--u.sp = u.ps;
	*--u.sp = u.pc;
	u.ps = trap.trap_ps;
	u.pc = trap.trap_pc;
	break;

case	emttrap:
	++emtcnt;
	u.ps = 0;
	u.oldsp = u.sp;		/* get a copy of stack pointer */
	emt = e = u.pc[-1] & 0377;
	if (e>svt.s_maxemt)
		err("bad emt: %o",e);
	m = &mrt[e];
	++m->m_cnt;
	if(m->m_rtn==0)
		err("not implemented");

	checksp;
	if(tflg)
		where();

	if(e<=svt.s_iomax && e!=em_init)
		getddb();
	(* m->m_rtn)();
	if(tflg)
		putchar('\n');
	break;

case	iottrap:
	dosiot();
	break;

case	bustrap:

	errtrp("bus err",4);
	break;

case	instrap:
	errtrp("ill instr",010);
	break;

case	segtrap:
	errtrp("ill addr",04);
	break;

default:
	err("bad trap");
}	/* of switch */
	}
}


dosiot()
{
int w;
register int value;
#ifndef	small
char msg[64];
struct
{
int code;
int posn;
int len;
} ind;
int index;
int text;
#endif
w = *u.sp++;
value = *u.sp++;
putchar('\n');
#ifndef	small
/* read through the error message index
 * looking for the given message. if found print the proper message;
 * otherwise print general message. 
 */
text = 0;
if((index=open("/dos/errors.index",0))>=0)
	{
	while (read(index,&ind,sizeof ind)>0)
		{
		if(ind.code==w)
			{
			if((text=open("/dos/errors.text",0))>=0)
				{
				seek(text,ind.posn,0);
				read(text,msg,ind.len);
				msg[ind.len] = 0;
				printf(msg,value);
				putchar('\n');
				close(text);
				break;
				}
			}
		}
	close(index);
	}
if(text==0)
#endif
printf("iot %c%3.3o %6.6o\n", "iawfs"[w.hi], w.lo&0377, value);
switch(w.hi)
	{
case	1:	/* a */
	aerror();
	break;
case	3:	/* f */
	err("fatal error");
	break;
case	4:	/* s */
	bsf(1);
	break;
	}
}

aerror()
{
register int c;

putchar('$');
if(!xflg)
	for(;;)
		{
		c=getchar();
		switch(c)
			{
			case '\n':
				return;
			case '0':
				dosexit();
			default: ;
			}
		}
}

getchar()
{
char c;
register char ch;
if(ch=lastchar)
	{
	lastchar = 0;
	return(ch);
	}
if(read(0,&c,1)<=0)
	return(0);
else
	return(c);
}

errtrp(s,vec)
char *s;
int *vec;
{

err("%s trap",s);

}

restart()
{
/* entered when the attn key is hit and the user has 
 * set the exit address 
 */

u.pc = svt.s_rsa;
if(u.pc==0)
	dosexit();
reset();
}

