#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "sym.h"
#include "tree.h"
#include "ops.h"

struct do_ *doptr;
#define	COMMA	','
#define	DOSIZE	(sizeof *doptr)
#define	DORANGE(s)	s=do_range; s; s=s->d_nest

dostmt()
{
/*
 * get label and process do statement.
 */
register int l;

l = findlabel();
if (sym_flags&F_DEFINED)
	ERR("backwards do range",E_BCKDO);
treep = dodo(l,dolevel);
++dolevel;
}

dodo(l,lvl)
{
/*
 * collect do loop arguments and lookup up in do range table.
 * if all is ok enter into the table.
 */
register char *s, *t;
char *ti;			/* tree for increment assignment */
register char *v;
char *e, *iv, *i, *c, *cv;

v = varexpr(LEFT);		/* get do loop variable */
if(!INSYM(v))
	noexpr();
for (DORANGE(s))
	{
	if (s->d_var == v)
		SERR("do variable in use",E_DOUSE);
	}
expect("=");
s = testcvt(expr(RIGHT),v->s_type);	/* starting expression */
expect(",");
e = testcvt(expr(RIGHT),v->s_type);	/* ending expression */
if (testc(COMMA))
	i = testcvt(expr(RIGHT),v->s_type);	/* increment expression */
else
	i = testcvt(one_const,v->s_type);
if(INSYM(i))		/* in symbol table ? */
	{
	ti = NULL;
	iv = i;
	}
else
	{
	iv = genvar(".di",lvl,i->t_type);
	ti = diadic(STORE_OP,i,iv);
	i = iv;
	}
/*
 * count = ((end+increment)-start)/increment
 * tree generated: (iv = ti) (cv = c) (var = start)
 */
c = diadic(DIV_OP,diadic(SUB_OP,diadic(ADD_OP,e,i),s),i);	/* count */
cv = genvar(".dc",lvl,intmode);
t = node(COMMA_OP,diadic(STORE_OP,s,v),NULL);	/* v = s */
t = node(COMMA_OP,diadic(STORE_OP,c,cv),t);	/* cv = c */
if (ti)
	t = node(COMMA_OP,ti,t);		/* iv = tv */
clear(&symbol,DOSIZE);
sym_len = DOSIZE;
sym_class = DO;
symbol.d_var = v;
symbol.d_count = cv;
symbol.d_incr = iv;
symbol.d_label = l;
symbol.d_if = iflevel;

symbol.d_nest = do_range;
enter(&symbol);
do_range = cur_sym;
t = node(DO_OP,cur_sym,t);
return(t);
}

docheck()
{
/*
 * look up current label in the do label table.
 */
register char *s;

if (sym_label == NOSYMBOL)
	return;			/* no current label */
for (DORANGE(s))
	{
	if(s->d_label != sym_label)
		continue;
	if(s != do_range)
		NOTE("incorrectly nested do",E_DONEST);
	if(s->d_if != iflevel)
		NOTE("incorrect do-if nesting",E_DOIF);
	treep = enddo();		/* end of do loop */
	--dolevel;			/* count end of do */
	putstmt();		/* output tree */
	do_range = s->d_nest;
	enddochk();		/* check if legal end do stmt */
	}
}

docleanup()
{
/*
 * clean out implied dos from i/o statements.
 */
register char *s;

for (DORANGE(s))
	{
	if(s->d_label != NOSYMBOL)
		break;
	do_range = s->d_nest;
	}
}

doend()
{
/*
 * end of program ... insure no do loops unterminated.
 */
register char *s;

for (DORANGE(s))
	{
	cur_sym = s->d_label;
	SNOTE("DO unterminated",E_DOTERM);
	}
}

enddo()
{
register char *s;
register char *t;

s = do_range;
if (s == 0)
	ERROR("bad do nesting",E_BADDO);
do_range = s->d_nest;
t = diadic(ADD_OP,s->d_incr,s->d_var);
t = diadic(STORE_OP,t,s->d_var);
return(node(DOEND_OP,s,t));
}
