#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "sym.h"

int eqptr;		/* current equivalence header */
int eqoff;		/* offset from base of equivalence list */
#define	EQUIVLEN	(sizeof *ep)

equivstmt()
{
int eqlist();
list(&eqlist);
}

eqlist()
{
int eqitem();
eqptr = 0;
eqoff = 0;
plist(&eqitem);
}

eqitem()
{
/*
 * get and add a new item to an equivalence list.
 * eqptr is the pointer to the equivalence header.
 * eqoff is the current offset from the base.
 * each equivalenced element records its initial offset from the
 * base in its "addr" location.
 */
register int off;
register char *s, *p;

#ifdef	debug
if (qflg > 1)
	dumptab();
#endif
off = eqvar();
s = cur_sym;
off =+ s->s_addr;		/* get offset from start */
if (s->s_loc == PARAM)
	SERR("can't equivalence",E_EQCANT);
if (eqptr == NOSYMBOL)
	{
	if(s->s_equiv == NOSYMBOL)
/*
 * item not equivalenced, first item on list. just create a header
 * for it and fill in the info.
 */
		{
		clear(&symbol,EQUIVLEN);
		sym_len = EQUIVLEN;
		sym_class = EQUIV;
		if (s->s_common)
			symbol.e_common = findcm(s);
		s = cur_sym;		/* remember item */
		symbol.e_last = symbol.e_start = s;
		if (ep == NOSYMBOL)
			{
			enter(&symbol);
			eqptr = p = cur_sym;	/* remember equiv list */
			}
		else
			{
			eqptr = p = ep;
			ep = p->e_last;			/* link to next one */
			move(sym_len,&symbol,p);
			}
		s->s_equiv = eqptr;
		eqoff = off;		/* offset from base */
		}
	else
/*
 * symbol already equivalenced, and first item in the list.
 * make its header the current header and its offset the current
 * offset.
 */
		{
		eqptr = findequiv(cur_sym);		/* get header */
		eqoff = off;
		}
	}
else		/* we have equivalence list */
	{
	p = eqptr ;		/* point to equivalence hdr */
	if(s->s_common && p->e_common)
		SERR("equivalences two commons",E_EQTWO);
	if (s->s_equiv == NOSYMBOL)
/*
 * non-equivalenced item, and already have an equivalence list.
 * add the new item to the existing chain.
 * if off > eqoff (i.e. (a,i(4)) then we must adjust
 * eqoff to off, and the various addr fields.
 */
		{
		if (off > eqoff)
			{
			eqadjust(eqptr,off-eqoff);	/* adjust to new base */
			eqoff = off;
			}
		else
			vadjust(s,eqoff-off);		/* adjust variable */
		if(s->s_common != NOSYMBOL)
			{
			cm = findcm(s);
			cmerge(eqptr);
			}
		else if (cm = p->e_common)
			addcm(cur_sym);
		(p->e_last)->s_equiv = cur_sym;
		p->e_last = cur_sym;
		s->s_equiv = eqptr;	/* point to lastest entry */
		}
	else
/*
 * new item is on a chain, and we already have a chain.
 * we must merge the two chains together provided that
 * they are different.
 */
		{
		p = findequiv(cur_sym);		/* get the header */
		if (p == eqptr)
			SERR("circularly equivalenced",E_EQCIRC);
		if (off > eqoff)
			{
			eqptr = eqmerge(eqptr,p,off-eqoff);
			eqoff = off;
			}
		else
			{
			eqmerge(p,eqptr,eqoff-off);	/* merge p into eqptr */
			}
		}
	}
}


findequiv(t)
{
/*
 * scan down an equivalence chain looking for the header.
 * return as a symtab offset.
 */
register char *p;

for (p=(t)->s_equiv; p; p=p->s_equiv)
	{
	if (p->s_class == EQUIV)
		return(p);		/* return equiv hdr */
	}
ERROR("no equiv hdr",E_EQHDR);
}

eqmerge(eq1,eq2,off)
{
/*
 * merge equivalence list eq1 with list eq2.
 * adjust eq1 addresses by "off".
 * put eq1 elements into common if eq2 is in common.
 * put eq2 elements into common if eq1 is in common.
 * note that caller has insured that both are not in common.
 * free up eq1 header for later re-use.
 */
register char *p1, *p2;
register char *p;

p1 = eq1;
p2 = eq2;
eqadjust(p1,off);		/* adjust to new offset */
if ((cm = p2->e_common) != NOSYMBOL)
	cmerge(p1);		/* put p1 into common if p2 in it */
else if ((cm = p1->e_common) != NOSYMBOL)
	cmerge(p2);		/* put p2 into common if p1 in it */
((p2->e_last))->s_equiv = p1->e_start;	/* link last to first */
p2->e_last = p = p1->e_last;	/* point to new last */
p->s_equiv = p2;	/* link last to new header */
p1->e_start = NOSYMBOL;
p1->e_last = ep;
ep = p1;		/* link into free equivalence chain */
return(p2);
}

subcalc()
{
/*
 * calculate offset from start of array for possibly subscripted
 * variable.
 */
register char *s;
register int len;
register int i;
int n;
int n1, n2, n3;

if (sym_nsubs == 0)
	return(0);		/* no subscripts */
s = cur_sym;		/* point to symtab entry */
if (sym_nsubs != s->s_nsubs)
	SERR("wrong number of subscripts",E_SBNUM);
varsize(cur_sym);	/* insure all subscripts available */
len = typelens[s->s_type];
n = 0;
for (i=0; i<sym_nsubs; ++i)
	{
	n1 = intvalue(sym_subs[i].upb);
	n2 = intvalue(s->s_subs[i].upb);
	n3 = intvalue(s->s_subs[i].lwb);
	if (n1 > n2 || (n1 =- n3) < 0)
		SERR("has bad subscript",E_SBBAD);
	n =+ n1*len;
	len =* n2;
	}
return(n);
}

eqadjust(p1,off)
{
/*
 * go thru the chain headed by "p1" adjusting the addresses
 * by "off".
 */
register char *p;

if (off == 0)
	return;		/* no adjustment to be made */
for (p=(p1)->e_start; (p)->s_class!=EQUIV; p=p->s_equiv)
	{
	vadjust(p,off);
	}
}

cmerge(eq) char *eq;
{
/*
 * merge equivalence list "eq" with common block associated with
 * "cm".
 */
register char *e;

e = eq;
e->e_common = cm;		/* current common block */
for (e=e->e_start; (e )->s_class != EQUIV; e=e->s_equiv)
	addcm(e);
}

findcm(sp) char *sp;
{
/*
 * scan down a common chain looking for the header.
 * return as a symtab offset.
 */
register char *p;

for (p=sp->s_common; p; p=p->s_common)
	{
	if (p->s_class == COMMON)
		return(cm = p);		/* return common hdr */
	}
ERROR("no common hdr",E_CMHDR);
}

eqvar()
{
register int off;
register char *s;

getsvar(NO);
if (lookup(NO) == NOSYMBOL)
	if (sym_nsubs == 0)
		entersym();
	else
		SERR("not dimensioned",E_NODIM);
off = subcalc();		/* calculate subscript position */
s = cur_sym;
if (s->s_class != SYMBOL)
	SERR("not a variable",E_NOTVAR);
return(off);
}

vadjust(sp,off) char *sp;
{
register char *s;

s = sp;
if (off == 0)
	return;
if (s->s_common)
	ERR("common extended backwards",E_CMBCK);
s->s_addr =+ off;
}
